/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.addressing;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.internal.stream.buffer.XMLStreamBufferSource;
import com.sun.xml.internal.stream.buffer.sax.SAXBufferProcessor;
import com.sun.xml.internal.stream.buffer.stax.StreamReaderBufferProcessor;
import com.sun.xml.internal.stream.buffer.stax.StreamWriterBufferCreator;
import com.sun.xml.internal.ws.addressing.EndpointReferenceUtil;
import com.sun.xml.internal.ws.addressing.model.InvalidAddressingHeaderException;
import com.sun.xml.internal.ws.addressing.v200408.MemberSubmissionAddressingConstants;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.EPRHeader;
import com.sun.xml.internal.ws.api.addressing.OutboundReferenceParameterHeader;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.resources.AddressingMessages;
import com.sun.xml.internal.ws.resources.ClientMessages;
import com.sun.xml.internal.ws.spi.ProviderImpl;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.DOMUtil;
import com.sun.xml.internal.ws.util.xml.XMLStreamWriterFilter;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import com.sun.xml.internal.ws.wsdl.parser.WSDLConstants;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSEndpointReference {
    private final XMLStreamBuffer infoset;
    private final AddressingVersion version;
    @NotNull
    private Header[] referenceParameters;
    @NotNull
    private String address;
    private static final OutboundReferenceParameterHeader[] EMPTY_ARRAY = new OutboundReferenceParameterHeader[0];

    public WSEndpointReference(EndpointReference endpointReference, AddressingVersion addressingVersion) {
        try {
            MutableXMLStreamBuffer mutableXMLStreamBuffer = new MutableXMLStreamBuffer();
            endpointReference.writeTo(new XMLStreamBufferResult(mutableXMLStreamBuffer));
            this.infoset = mutableXMLStreamBuffer;
            this.version = addressingVersion;
            this.parse();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(ClientMessages.FAILED_TO_PARSE_EPR(endpointReference), xMLStreamException);
        }
    }

    public WSEndpointReference(EndpointReference endpointReference) {
        this(endpointReference, AddressingVersion.fromSpecClass(endpointReference.getClass()));
    }

    public WSEndpointReference(XMLStreamBuffer xMLStreamBuffer, AddressingVersion addressingVersion) {
        try {
            this.infoset = xMLStreamBuffer;
            this.version = addressingVersion;
            this.parse();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new AssertionError((Object)xMLStreamException);
        }
    }

    public WSEndpointReference(InputStream inputStream, AddressingVersion addressingVersion) throws XMLStreamException {
        this(XMLStreamReaderFactory.create(null, inputStream, false), addressingVersion);
    }

    public WSEndpointReference(XMLStreamReader xMLStreamReader, AddressingVersion addressingVersion) throws XMLStreamException {
        this(XMLStreamBuffer.createNewBufferFromXMLStreamReader(xMLStreamReader), addressingVersion);
    }

    public WSEndpointReference(URL uRL, AddressingVersion addressingVersion) {
        this(uRL.toExternalForm(), addressingVersion);
    }

    public WSEndpointReference(URI uRI, AddressingVersion addressingVersion) {
        this(uRI.toString(), addressingVersion);
    }

    public WSEndpointReference(String string, AddressingVersion addressingVersion) {
        this.infoset = WSEndpointReference.createBufferFromAddress(string, addressingVersion);
        this.version = addressingVersion;
        this.address = string;
        this.referenceParameters = EMPTY_ARRAY;
    }

    private static XMLStreamBuffer createBufferFromAddress(String string, AddressingVersion addressingVersion) {
        try {
            MutableXMLStreamBuffer mutableXMLStreamBuffer = new MutableXMLStreamBuffer();
            StreamWriterBufferCreator streamWriterBufferCreator = new StreamWriterBufferCreator(mutableXMLStreamBuffer);
            streamWriterBufferCreator.writeStartDocument();
            streamWriterBufferCreator.writeStartElement(addressingVersion.getPrefix(), "EndpointReference", addressingVersion.nsUri);
            streamWriterBufferCreator.writeNamespace(addressingVersion.getPrefix(), addressingVersion.nsUri);
            streamWriterBufferCreator.writeStartElement(addressingVersion.getPrefix(), "Address", addressingVersion.nsUri);
            streamWriterBufferCreator.writeCharacters(string);
            streamWriterBufferCreator.writeEndElement();
            streamWriterBufferCreator.writeEndElement();
            streamWriterBufferCreator.writeEndDocument();
            streamWriterBufferCreator.close();
            return mutableXMLStreamBuffer;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new AssertionError((Object)xMLStreamException);
        }
    }

    public WSEndpointReference(@NotNull AddressingVersion addressingVersion, @NotNull String string, @Nullable QName qName, @Nullable QName qName2, @Nullable QName qName3, @Nullable List<Element> list, @Nullable String string2, @Nullable List<Element> list2) {
        this(WSEndpointReference.createBufferFromData(addressingVersion, string, list2, qName, qName2, qName3, list, string2), addressingVersion);
    }

    private static XMLStreamBuffer createBufferFromData(AddressingVersion addressingVersion, String string, List<Element> list, QName qName, QName qName2, QName qName3, List<Element> list2, String string2) {
        StreamWriterBufferCreator streamWriterBufferCreator = new StreamWriterBufferCreator();
        try {
            streamWriterBufferCreator.writeStartDocument();
            streamWriterBufferCreator.writeStartElement(addressingVersion.getPrefix(), "EndpointReference", addressingVersion.nsUri);
            streamWriterBufferCreator.writeNamespace(addressingVersion.getPrefix(), addressingVersion.nsUri);
            streamWriterBufferCreator.writeStartElement(addressingVersion.getPrefix(), "Address", addressingVersion.nsUri);
            streamWriterBufferCreator.writeCharacters(string);
            streamWriterBufferCreator.writeEndElement();
            if (list != null) {
                streamWriterBufferCreator.writeStartElement(addressingVersion.getPrefix(), "ReferenceParameters", addressingVersion.nsUri);
                for (Element element : list) {
                    DOMUtil.serializeNode(element, streamWriterBufferCreator);
                }
                streamWriterBufferCreator.writeEndElement();
            }
            switch (addressingVersion) {
                case W3C: {
                    WSEndpointReference.writeW3CMetaData(streamWriterBufferCreator, qName, qName2, qName3, list2, string2);
                    break;
                }
                case MEMBER: {
                    WSEndpointReference.writeMSMetaData(streamWriterBufferCreator, qName, qName2, qName3, list2);
                    if (string2 == null) break;
                    streamWriterBufferCreator.writeStartElement(MemberSubmissionAddressingConstants.MEX_METADATA.getPrefix(), MemberSubmissionAddressingConstants.MEX_METADATA.getLocalPart(), MemberSubmissionAddressingConstants.MEX_METADATA.getNamespaceURI());
                    streamWriterBufferCreator.writeStartElement(MemberSubmissionAddressingConstants.MEX_METADATA_SECTION.getPrefix(), MemberSubmissionAddressingConstants.MEX_METADATA_SECTION.getLocalPart(), MemberSubmissionAddressingConstants.MEX_METADATA_SECTION.getNamespaceURI());
                    streamWriterBufferCreator.writeAttribute("Dialect", "http://schemas.xmlsoap.org/wsdl/");
                    WSEndpointReference.writeWsdl(streamWriterBufferCreator, qName, string2);
                    streamWriterBufferCreator.writeEndElement();
                    streamWriterBufferCreator.writeEndElement();
                }
            }
            streamWriterBufferCreator.writeEndElement();
            streamWriterBufferCreator.writeEndDocument();
            streamWriterBufferCreator.flush();
            return streamWriterBufferCreator.getXMLStreamBuffer();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    private static void writeW3CMetaData(StreamWriterBufferCreator streamWriterBufferCreator, QName qName, QName qName2, QName qName3, List<Element> list, String string) throws XMLStreamException {
        Object object;
        streamWriterBufferCreator.writeStartElement(AddressingVersion.W3C.getPrefix(), "Metadata", AddressingVersion.W3C.nsUri);
        streamWriterBufferCreator.writeNamespace(AddressingVersion.W3C.getWsdlPrefix(), AddressingVersion.W3C.wsdlNsUri);
        if (qName3 != null) {
            streamWriterBufferCreator.writeStartElement(AddressingVersion.W3C.getWsdlPrefix(), "InterfaceName", AddressingVersion.W3C.wsdlNsUri);
            object = qName3.getPrefix();
            if (object == null || ((String)object).equals("")) {
                object = "wsns";
            }
            streamWriterBufferCreator.writeNamespace((String)object, qName3.getNamespaceURI());
            streamWriterBufferCreator.writeCharacters((String)object + ":" + qName3.getLocalPart());
            streamWriterBufferCreator.writeEndElement();
        }
        if (qName != null && !qName.getNamespaceURI().equals("") && !qName.getLocalPart().equals("")) {
            streamWriterBufferCreator.writeStartElement(AddressingVersion.W3C.getWsdlPrefix(), "ServiceName", AddressingVersion.W3C.wsdlNsUri);
            object = qName.getPrefix();
            if (object == null || ((String)object).equals("")) {
                object = "wsns";
            }
            streamWriterBufferCreator.writeNamespace((String)object, qName.getNamespaceURI());
            if (qName2 != null) {
                streamWriterBufferCreator.writeAttribute("EndpointName", qName2.getLocalPart());
            }
            streamWriterBufferCreator.writeCharacters((String)object + ":" + qName.getLocalPart());
            streamWriterBufferCreator.writeEndElement();
        }
        if (string != null) {
            WSEndpointReference.writeWsdl(streamWriterBufferCreator, qName, string);
        }
        if (list != null) {
            for (Element element : list) {
                DOMUtil.serializeNode(element, streamWriterBufferCreator);
            }
        }
        streamWriterBufferCreator.writeEndElement();
    }

    private static void writeMSMetaData(StreamWriterBufferCreator streamWriterBufferCreator, QName qName, QName qName2, QName qName3, List<Element> list) throws XMLStreamException {
        String string;
        if (qName3 != null) {
            streamWriterBufferCreator.writeStartElement(AddressingVersion.MEMBER.getPrefix(), "PortType", AddressingVersion.MEMBER.nsUri);
            string = qName3.getPrefix();
            if (string == null || string.equals("")) {
                string = "wsns";
            }
            streamWriterBufferCreator.writeNamespace(string, qName3.getNamespaceURI());
            streamWriterBufferCreator.writeCharacters(string + ":" + qName3.getLocalPart());
            streamWriterBufferCreator.writeEndElement();
        }
        if (qName != null && !qName.getNamespaceURI().equals("") && !qName.getLocalPart().equals("")) {
            streamWriterBufferCreator.writeStartElement(AddressingVersion.MEMBER.getPrefix(), "ServiceName", AddressingVersion.MEMBER.nsUri);
            string = qName.getPrefix();
            if (string == null || string.equals("")) {
                string = "wsns";
            }
            streamWriterBufferCreator.writeNamespace(string, qName.getNamespaceURI());
            if (qName2 != null) {
                streamWriterBufferCreator.writeAttribute("PortName", qName2.getLocalPart());
            }
            streamWriterBufferCreator.writeCharacters(string + ":" + qName.getLocalPart());
            streamWriterBufferCreator.writeEndElement();
        }
    }

    private static void writeWsdl(StreamWriterBufferCreator streamWriterBufferCreator, QName qName, String string) throws XMLStreamException {
        streamWriterBufferCreator.writeStartElement("wsdl", WSDLConstants.QNAME_DEFINITIONS.getLocalPart(), "http://schemas.xmlsoap.org/wsdl/");
        streamWriterBufferCreator.writeNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        streamWriterBufferCreator.writeStartElement("wsdl", WSDLConstants.QNAME_IMPORT.getLocalPart(), "http://schemas.xmlsoap.org/wsdl/");
        streamWriterBufferCreator.writeAttribute("namespace", qName.getNamespaceURI());
        streamWriterBufferCreator.writeAttribute("location", string);
        streamWriterBufferCreator.writeEndElement();
        streamWriterBufferCreator.writeEndElement();
    }

    @Nullable
    public static WSEndpointReference create(@Nullable EndpointReference endpointReference) {
        if (endpointReference != null) {
            return new WSEndpointReference(endpointReference);
        }
        return null;
    }

    @NotNull
    public WSEndpointReference createWithAddress(@NotNull URI uRI) {
        return this.createWithAddress(uRI.toString());
    }

    @NotNull
    public WSEndpointReference createWithAddress(@NotNull URL uRL) {
        return this.createWithAddress(uRL.toString());
    }

    @NotNull
    public WSEndpointReference createWithAddress(final @NotNull String string) {
        MutableXMLStreamBuffer mutableXMLStreamBuffer = new MutableXMLStreamBuffer();
        XMLFilterImpl xMLFilterImpl = new XMLFilterImpl(){
            private boolean inAddress = false;

            public void startElement(String string4, String string2, String string3, Attributes attributes) throws SAXException {
                if (string2.equals("Address") && string4.equals(((WSEndpointReference)WSEndpointReference.this).version.nsUri)) {
                    this.inAddress = true;
                }
                super.startElement(string4, string2, string3, attributes);
            }

            public void characters(char[] cArray, int n, int n2) throws SAXException {
                if (!this.inAddress) {
                    super.characters(cArray, n, n2);
                }
            }

            public void endElement(String string4, String string2, String string3) throws SAXException {
                if (this.inAddress) {
                    super.characters(string.toCharArray(), 0, string.length());
                }
                this.inAddress = false;
                super.endElement(string4, string2, string3);
            }
        };
        xMLFilterImpl.setContentHandler(mutableXMLStreamBuffer.createFromSAXBufferCreator());
        try {
            this.infoset.writeTo((ContentHandler)xMLFilterImpl, false);
        }
        catch (SAXException sAXException) {
            throw new AssertionError((Object)sAXException);
        }
        return new WSEndpointReference(mutableXMLStreamBuffer, this.version);
    }

    @NotNull
    public EndpointReference toSpec() {
        return ProviderImpl.INSTANCE.readEndpointReference(this.asSource("EndpointReference"));
    }

    @NotNull
    public <T extends EndpointReference> T toSpec(Class<T> clazz) {
        return EndpointReferenceUtil.transform(clazz, this.toSpec());
    }

    @NotNull
    public <T> T getPort(@NotNull Service service, @NotNull Class<T> clazz, WebServiceFeature ... webServiceFeatureArray) {
        return service.getPort(this.toSpec(), clazz, webServiceFeatureArray);
    }

    @NotNull
    public <T> Dispatch<T> createDispatch(@NotNull Service service, @NotNull Class<T> clazz, @NotNull Service.Mode mode, WebServiceFeature ... webServiceFeatureArray) {
        return service.createDispatch(this.toSpec(), clazz, mode, webServiceFeatureArray);
    }

    @NotNull
    public Dispatch<Object> createDispatch(@NotNull Service service, @NotNull JAXBContext jAXBContext, @NotNull Service.Mode mode, WebServiceFeature ... webServiceFeatureArray) {
        return service.createDispatch(this.toSpec(), jAXBContext, mode, webServiceFeatureArray);
    }

    @NotNull
    public AddressingVersion getVersion() {
        return this.version;
    }

    @NotNull
    public String getAddress() {
        return this.address;
    }

    public boolean isAnonymous() {
        return this.address.equals(this.version.anonymousUri);
    }

    public boolean isNone() {
        return this.address.equals(this.version.noneUri);
    }

    private void parse() throws XMLStreamException {
        StreamReaderBufferProcessor streamReaderBufferProcessor = this.infoset.readAsXMLStreamReader();
        if (streamReaderBufferProcessor.getEventType() == 7) {
            streamReaderBufferProcessor.nextTag();
        }
        assert (streamReaderBufferProcessor.getEventType() == 1);
        String string = streamReaderBufferProcessor.getLocalName();
        if (!streamReaderBufferProcessor.getNamespaceURI().equals(this.version.nsUri)) {
            throw new WebServiceException(AddressingMessages.WRONG_ADDRESSING_VERSION(this.version.nsUri, streamReaderBufferProcessor.getNamespaceURI()));
        }
        ArrayList<Header> arrayList = null;
        while (streamReaderBufferProcessor.nextTag() == 1) {
            String string2 = streamReaderBufferProcessor.getLocalName();
            if (this.version.isReferenceParameter(string2)) {
                XMLStreamBuffer xMLStreamBuffer;
                while ((xMLStreamBuffer = streamReaderBufferProcessor.nextTagAndMark()) != null) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Header>();
                    }
                    arrayList.add(this.version.createReferenceParameterHeader(xMLStreamBuffer, streamReaderBufferProcessor.getNamespaceURI(), streamReaderBufferProcessor.getLocalName()));
                    XMLStreamReaderUtil.skipElement(streamReaderBufferProcessor);
                }
                continue;
            }
            if (string2.equals("Address")) {
                if (this.address != null) {
                    throw new InvalidAddressingHeaderException(new QName(this.version.nsUri, string), AddressingVersion.fault_duplicateAddressInEpr);
                }
                this.address = streamReaderBufferProcessor.getElementText().trim();
                continue;
            }
            XMLStreamReaderUtil.skipElement(streamReaderBufferProcessor);
        }
        this.referenceParameters = arrayList == null ? EMPTY_ARRAY : arrayList.toArray(new Header[arrayList.size()]);
        if (this.address == null) {
            throw new InvalidAddressingHeaderException(new QName(this.version.nsUri, string), this.version.fault_missingAddressInEpr);
        }
    }

    public XMLStreamReader read(final @NotNull String string) throws XMLStreamException {
        return new StreamReaderBufferProcessor(this.infoset){

            protected void processElement(String string4, String string2, String string3) {
                if (this._depth == 0) {
                    string3 = string;
                }
                super.processElement(string4, string2, string3);
            }
        };
    }

    public Source asSource(@NotNull String string) {
        return new SAXSource(new SAXBufferProcessorImpl(string), new InputSource());
    }

    public void writeTo(@NotNull String string, ContentHandler contentHandler, ErrorHandler errorHandler, boolean bl) throws SAXException {
        SAXBufferProcessorImpl sAXBufferProcessorImpl = new SAXBufferProcessorImpl(string);
        sAXBufferProcessorImpl.setContentHandler(contentHandler);
        sAXBufferProcessorImpl.setErrorHandler(errorHandler);
        sAXBufferProcessorImpl.process(this.infoset, bl);
    }

    public void writeTo(final @NotNull String string, @NotNull XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        this.infoset.writeToXMLStreamWriter(new XMLStreamWriterFilter(xMLStreamWriter){
            private boolean root;
            {
                super(xMLStreamWriter);
                this.root = true;
            }

            public void writeStartDocument() throws XMLStreamException {
            }

            public void writeStartDocument(String string3, String string2) throws XMLStreamException {
            }

            public void writeStartDocument(String string2) throws XMLStreamException {
            }

            public void writeEndDocument() throws XMLStreamException {
            }

            private String override(String string2) {
                if (this.root) {
                    this.root = false;
                    return string;
                }
                return string2;
            }

            public void writeStartElement(String string2) throws XMLStreamException {
                super.writeStartElement(this.override(string2));
            }

            public void writeStartElement(String string3, String string2) throws XMLStreamException {
                super.writeStartElement(string3, this.override(string2));
            }

            public void writeStartElement(String string4, String string2, String string3) throws XMLStreamException {
                super.writeStartElement(string4, this.override(string2), string3);
            }
        }, true);
    }

    public Header createHeader(QName qName) {
        return new EPRHeader(qName, this);
    }

    public void addReferenceParameters(HeaderList headerList) {
        for (Header header : this.referenceParameters) {
            headerList.add(header);
        }
    }

    public String toString() {
        try {
            StringWriter stringWriter = new StringWriter();
            XmlUtil.newTransformer().transform(this.asSource("EndpointReference"), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            return transformerException.toString();
        }
    }

    @NotNull
    public Metadata getMetaData() {
        return new Metadata();
    }

    public class Metadata {
        @Nullable
        private QName serviceName;
        @Nullable
        private QName portName;
        @Nullable
        private QName portTypeName;
        @Nullable
        private Source wsdlSource;
        @Nullable
        private String wsdliLocation;

        @Nullable
        public QName getServiceName() {
            return this.serviceName;
        }

        @Nullable
        public QName getPortName() {
            return this.portName;
        }

        @Nullable
        public QName getPortTypeName() {
            return this.portTypeName;
        }

        @Nullable
        public Source getWsdlSource() {
            return this.wsdlSource;
        }

        @Nullable
        public String getWsdliLocation() {
            return this.wsdliLocation;
        }

        private Metadata() {
            try {
                this.parseMetaData();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(xMLStreamException);
            }
        }

        private void parseMetaData() throws XMLStreamException {
            StreamReaderBufferProcessor streamReaderBufferProcessor = WSEndpointReference.this.infoset.readAsXMLStreamReader();
            if (streamReaderBufferProcessor.getEventType() == 7) {
                streamReaderBufferProcessor.nextTag();
            }
            assert (streamReaderBufferProcessor.getEventType() == 1);
            String string = streamReaderBufferProcessor.getLocalName();
            if (!streamReaderBufferProcessor.getNamespaceURI().equals(((WSEndpointReference)WSEndpointReference.this).version.nsUri)) {
                throw new WebServiceException(AddressingMessages.WRONG_ADDRESSING_VERSION(((WSEndpointReference)WSEndpointReference.this).version.nsUri, streamReaderBufferProcessor.getNamespaceURI()));
            }
            if (WSEndpointReference.this.version == AddressingVersion.W3C) {
                do {
                    if (streamReaderBufferProcessor.getLocalName().equals(((WSEndpointReference)WSEndpointReference.this).version.eprType.wsdlMetadata.getLocalPart())) {
                        XMLStreamBuffer xMLStreamBuffer;
                        String string2 = streamReaderBufferProcessor.getAttributeValue("http://www.w3.org/ns/wsdl-instance", "wsdlLocation");
                        if (string2 != null) {
                            this.wsdliLocation = string2.trim();
                        }
                        while ((xMLStreamBuffer = streamReaderBufferProcessor.nextTagAndMark()) != null) {
                            String string3 = streamReaderBufferProcessor.getLocalName();
                            String string4 = streamReaderBufferProcessor.getNamespaceURI();
                            if (string3.equals(((WSEndpointReference)WSEndpointReference.this).version.eprType.serviceName)) {
                                String string5 = streamReaderBufferProcessor.getAttributeValue(null, ((WSEndpointReference)WSEndpointReference.this).version.eprType.portName);
                                if (this.serviceName != null) {
                                    throw new RuntimeException("More than one " + ((WSEndpointReference)WSEndpointReference.this).version.eprType.serviceName + " element in EPR Metadata");
                                }
                                this.serviceName = this.getElementTextAsQName(streamReaderBufferProcessor);
                                if (this.serviceName == null || string5 == null) continue;
                                this.portName = new QName(this.serviceName.getNamespaceURI(), string5);
                                continue;
                            }
                            if (string3.equals(((WSEndpointReference)WSEndpointReference.this).version.eprType.portTypeName)) {
                                if (this.portTypeName != null) {
                                    throw new RuntimeException("More than one " + ((WSEndpointReference)WSEndpointReference.this).version.eprType.portTypeName + " element in EPR Metadata");
                                }
                                this.portTypeName = this.getElementTextAsQName(streamReaderBufferProcessor);
                                continue;
                            }
                            if (string4.equals("http://schemas.xmlsoap.org/wsdl/") && string3.equals(WSDLConstants.QNAME_DEFINITIONS.getLocalPart())) {
                                this.wsdlSource = new XMLStreamBufferSource(xMLStreamBuffer);
                                continue;
                            }
                            XMLStreamReaderUtil.skipElement(streamReaderBufferProcessor);
                        }
                    } else {
                        if (streamReaderBufferProcessor.getLocalName().equals(string)) continue;
                        XMLStreamReaderUtil.skipElement(streamReaderBufferProcessor);
                    }
                } while (XMLStreamReaderUtil.nextElementContent(streamReaderBufferProcessor) == 1);
            } else if (WSEndpointReference.this.version == AddressingVersion.MEMBER) {
                do {
                    Object object;
                    String string6 = streamReaderBufferProcessor.getLocalName();
                    String string7 = streamReaderBufferProcessor.getNamespaceURI();
                    if (string6.equals(((WSEndpointReference)WSEndpointReference.this).version.eprType.wsdlMetadata.getLocalPart()) && string7.equals(((WSEndpointReference)WSEndpointReference.this).version.eprType.wsdlMetadata.getNamespaceURI())) {
                        while (streamReaderBufferProcessor.nextTag() == 1) {
                            while ((object = streamReaderBufferProcessor.nextTagAndMark()) != null) {
                                string6 = streamReaderBufferProcessor.getLocalName();
                                string7 = streamReaderBufferProcessor.getNamespaceURI();
                                if (string7.equals("http://schemas.xmlsoap.org/wsdl/") && string6.equals(WSDLConstants.QNAME_DEFINITIONS.getLocalPart())) {
                                    this.wsdlSource = new XMLStreamBufferSource((XMLStreamBuffer)object);
                                    continue;
                                }
                                XMLStreamReaderUtil.skipElement(streamReaderBufferProcessor);
                            }
                        }
                    } else {
                        if (string6.equals(((WSEndpointReference)WSEndpointReference.this).version.eprType.serviceName)) {
                            object = streamReaderBufferProcessor.getAttributeValue(null, ((WSEndpointReference)WSEndpointReference.this).version.eprType.portName);
                            this.serviceName = this.getElementTextAsQName(streamReaderBufferProcessor);
                            if (this.serviceName == null || object == null) continue;
                            this.portName = new QName(this.serviceName.getNamespaceURI(), (String)object);
                            continue;
                        }
                        if (string6.equals(((WSEndpointReference)WSEndpointReference.this).version.eprType.portTypeName)) {
                            this.portTypeName = this.getElementTextAsQName(streamReaderBufferProcessor);
                            continue;
                        }
                        if (streamReaderBufferProcessor.getLocalName().equals(string)) continue;
                        XMLStreamReaderUtil.skipElement(streamReaderBufferProcessor);
                    }
                } while (XMLStreamReaderUtil.nextElementContent(streamReaderBufferProcessor) == 1);
            }
        }

        private QName getElementTextAsQName(StreamReaderBufferProcessor streamReaderBufferProcessor) throws XMLStreamException {
            String string = streamReaderBufferProcessor.getElementText().trim();
            String string2 = XmlUtil.getPrefix(string);
            String string3 = XmlUtil.getLocalPart(string);
            if (string3 != null) {
                if (string2 != null) {
                    String string4 = streamReaderBufferProcessor.getNamespaceURI(string2);
                    if (string4 != null) {
                        return new QName(string4, string3, string2);
                    }
                } else {
                    return new QName(null, string3);
                }
            }
            return null;
        }
    }

    class SAXBufferProcessorImpl
    extends SAXBufferProcessor {
        private final String rootLocalName;
        private boolean root;

        public SAXBufferProcessorImpl(String string) {
            super(WSEndpointReference.this.infoset, false);
            this.root = true;
            this.rootLocalName = string;
        }

        protected void processElement(String string, String string2, String string3) throws SAXException {
            if (this.root) {
                this.root = false;
                if (string3.equals(string2)) {
                    string3 = string2 = this.rootLocalName;
                } else {
                    string2 = this.rootLocalName;
                    int n = string3.indexOf(58);
                    string3 = string3.substring(0, n + 1) + this.rootLocalName;
                }
            }
            super.processElement(string, string2, string3);
        }
    }
}

