/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.utils;

import java.text.CollationElementIterator;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Locale;

public class StringComparable
implements Comparable {
    public static final int UNKNOWN_CASE = -1;
    public static final int UPPER_CASE = 1;
    public static final int LOWER_CASE = 2;
    private String m_text;
    private Locale m_locale;
    private RuleBasedCollator m_collator;
    private String m_caseOrder;
    private int m_mask = -1;

    public StringComparable(String string, Locale locale, Collator collator, String string2) {
        this.m_text = string;
        this.m_locale = locale;
        this.m_collator = (RuleBasedCollator)collator;
        this.m_caseOrder = string2;
        this.m_mask = StringComparable.getMask(this.m_collator.getStrength());
    }

    public static final Comparable getComparator(String string, Locale locale, Collator collator, String string2) {
        if (string2 == null || string2.length() == 0) {
            return ((RuleBasedCollator)collator).getCollationKey(string);
        }
        return new StringComparable(string, locale, collator, string2);
    }

    public final String toString() {
        return this.m_text;
    }

    public int compareTo(Object object) {
        String string = ((StringComparable)object).toString();
        if (this.m_text.equals(string)) {
            return 0;
        }
        int n = this.m_collator.getStrength();
        int n2 = 0;
        if (n == 0 || n == 1) {
            n2 = this.m_collator.compare(this.m_text, string);
        } else {
            this.m_collator.setStrength(1);
            n2 = this.m_collator.compare(this.m_text, string);
            this.m_collator.setStrength(n);
        }
        if (n2 != 0) {
            return n2;
        }
        n2 = this.getCaseDiff(this.m_text, string);
        if (n2 != 0) {
            return n2;
        }
        return this.m_collator.compare(this.m_text, string);
    }

    private final int getCaseDiff(String string, String string2) {
        int n = this.m_collator.getStrength();
        int n2 = this.m_collator.getDecomposition();
        this.m_collator.setStrength(2);
        this.m_collator.setDecomposition(1);
        int[] nArray = this.getFirstCaseDiff(string, string2, this.m_locale);
        this.m_collator.setStrength(n);
        this.m_collator.setDecomposition(n2);
        if (nArray != null) {
            if (this.m_caseOrder.equals("upper-first")) {
                if (nArray[0] == 1) {
                    return -1;
                }
                return 1;
            }
            if (nArray[0] == 2) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    private final int[] getFirstCaseDiff(String string, String string2, Locale locale) {
        int[] nArray;
        CollationElementIterator collationElementIterator = this.m_collator.getCollationElementIterator(string);
        CollationElementIterator collationElementIterator2 = this.m_collator.getCollationElementIterator(string2);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = this.getElement(-1);
        int n6 = 0;
        int n7 = 0;
        boolean bl = true;
        boolean bl2 = true;
        while (true) {
            String string3;
            if (bl) {
                n3 = collationElementIterator2.getOffset();
                n6 = this.getElement(collationElementIterator2.next());
                n4 = collationElementIterator2.getOffset();
            }
            if (bl2) {
                n = collationElementIterator.getOffset();
                n7 = this.getElement(collationElementIterator.next());
                n2 = collationElementIterator.getOffset();
            }
            bl = true;
            bl2 = true;
            if (n6 == n5 || n7 == n5) {
                return null;
            }
            if (n7 == 0) {
                bl = false;
                continue;
            }
            if (n6 == 0) {
                bl2 = false;
                continue;
            }
            if (n7 == n6 || n3 >= n4 || n >= n2) continue;
            String string4 = string.substring(n, n2);
            String string5 = string2.substring(n3, n4);
            String string6 = string4.toUpperCase(locale);
            if (this.m_collator.compare(string6, string3 = string5.toUpperCase(locale)) != 0) continue;
            nArray = new int[]{-1, -1};
            if (this.m_collator.compare(string4, string6) == 0) {
                nArray[0] = 1;
            } else if (this.m_collator.compare(string4, string4.toLowerCase(locale)) == 0) {
                nArray[0] = 2;
            }
            if (this.m_collator.compare(string5, string3) == 0) {
                nArray[1] = 1;
            } else if (this.m_collator.compare(string5, string5.toLowerCase(locale)) == 0) {
                nArray[1] = 2;
            }
            if (nArray[0] == 1 && nArray[1] == 2 || nArray[0] == 2 && nArray[1] == 1) break;
        }
        return nArray;
    }

    private static final int getMask(int n) {
        switch (n) {
            case 0: {
                return -65536;
            }
            case 1: {
                return -256;
            }
        }
        return -1;
    }

    private final int getElement(int n) {
        return n & this.m_mask;
    }
}

