/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.content;

import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.latex.Context;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.util.Config;
import writer2latex.util.ExportNameCollection;
import writer2latex.util.Misc;

public class NoteConverter
extends ConverterHelper {
    private ExportNameCollection footnotenames = new ExportNameCollection(true);
    private ExportNameCollection endnotenames = new ExportNameCollection(true);
    private boolean bContainsEndnotes = false;
    private boolean bContainsFootnotes = false;
    private LinkedList postponedFootnotes = new LinkedList();

    public NoteConverter(Config config, ConverterPalette converterPalette) {
        super(config, converterPalette);
    }

    public void appendDeclarations(LaTeXDocumentPortion laTeXDocumentPortion, LaTeXDocumentPortion laTeXDocumentPortion2) {
        if (this.bContainsEndnotes) {
            laTeXDocumentPortion.append("\\usepackage{endnotes}").nl();
        }
        if (this.bContainsFootnotes) {
            this.palette.getNoteCc().convertFootnotesConfiguration(laTeXDocumentPortion2);
        }
        if (this.bContainsEndnotes) {
            this.palette.getNoteCc().convertEndnotesConfiguration(laTeXDocumentPortion2);
        }
    }

    public void handleFootnote(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        Context context2 = (Context)context.clone();
        context2.setInFootnote(true);
        String string = element.getAttribute("text:id");
        Element element2 = Misc.getChildByTagName(element, "text:footnote-body");
        if (element2 != null) {
            this.bContainsFootnotes = true;
            if (context2.isNoFootnotes()) {
                laTeXDocumentPortion.append("\\footnotemark{}");
                this.postponedFootnotes.add(element2);
            } else {
                laTeXDocumentPortion.append("\\footnote");
                laTeXDocumentPortion.append("{");
                if (string != null && this.footnotenames.containsName(string)) {
                    laTeXDocumentPortion.append("\\label{fnt:" + this.footnotenames.getExportName(string) + "}");
                }
                this.traverseNoteBody(element2, laTeXDocumentPortion, context2);
                laTeXDocumentPortion.append("}");
            }
        }
    }

    public void flushFootnotes(LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        if (context.isNoFootnotes()) {
            return;
        }
        Context context2 = (Context)context.clone();
        context2.setInFootnote(true);
        int n = this.postponedFootnotes.size();
        if (n == 1) {
            laTeXDocumentPortion.append("\\footnotetext{");
            this.traverseNoteBody((Element)this.postponedFootnotes.get(0), laTeXDocumentPortion, context2);
            laTeXDocumentPortion.append("}").nl();
            this.postponedFootnotes.clear();
        } else if (n > 1) {
            laTeXDocumentPortion.append("\\addtocounter{footnote}{-" + n + "}").nl();
            for (int i = 0; i < n; ++i) {
                laTeXDocumentPortion.append("\\stepcounter{footnote}\\footnotetext{");
                this.traverseNoteBody((Element)this.postponedFootnotes.get(i), laTeXDocumentPortion, context2);
                laTeXDocumentPortion.append("}").nl();
            }
            this.postponedFootnotes.clear();
        }
    }

    public void handleEndnote(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        Context context2 = (Context)context.clone();
        context2.setInFootnote(true);
        String string = element.getAttribute("text:id");
        Element element2 = Misc.getChildByTagName(element, "text:endnote-body");
        if (element2 != null) {
            if (context2.isNoFootnotes() && !this.config.useEndnotes()) {
                laTeXDocumentPortion.append("\\footnotemark()");
                this.postponedFootnotes.add(element2);
            } else {
                if (this.config.useEndnotes()) {
                    laTeXDocumentPortion.append("\\endnote");
                    this.bContainsEndnotes = true;
                } else {
                    laTeXDocumentPortion.append("\\footnote");
                    this.bContainsFootnotes = true;
                }
                laTeXDocumentPortion.append("{");
                if (string != null && this.endnotenames.containsName(string)) {
                    laTeXDocumentPortion.append("\\label{ent:" + this.endnotenames.getExportName(string) + "}");
                }
                this.traverseNoteBody(element2, laTeXDocumentPortion, context2);
                laTeXDocumentPortion.append("}");
            }
        }
    }

    public void insertEndnotes(LaTeXDocumentPortion laTeXDocumentPortion) {
        if (this.bContainsEndnotes) {
            laTeXDocumentPortion.append("\\clearpage").nl().append("\\theendnotes").nl();
        }
    }

    public void handleFootnoteRef(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        String string = element.getAttribute("text:reference-format");
        String string2 = element.getAttribute("text:ref-name");
        if ("page".equals(string) && string2 != null) {
            laTeXDocumentPortion.append("\\pageref{fnt:" + this.footnotenames.getExportName(string2) + "}");
        } else if ("text".equals(string) && string2 != null) {
            laTeXDocumentPortion.append("\\ref{fnt:" + this.footnotenames.getExportName(string2) + "}");
        } else {
            this.palette.getInlineCv().traversePCDATA(element, laTeXDocumentPortion, context);
        }
    }

    public void handleEndnoteRef(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        String string = element.getAttribute("text:reference-format");
        String string2 = element.getAttribute("text:ref-name");
        if ("page".equals(string) && string2 != null) {
            laTeXDocumentPortion.append("\\pageref{ent:" + this.endnotenames.getExportName(string2) + "}");
        } else if ("text".equals(string) && string2 != null) {
            laTeXDocumentPortion.append("\\ref{ent:" + this.endnotenames.getExportName(string2) + "}");
        } else {
            this.palette.getInlineCv().traversePCDATA(element, laTeXDocumentPortion, context);
        }
    }

    public void addFootnoteName(String string) {
        this.footnotenames.addName(string);
    }

    public void addEndnoteName(String string) {
        this.endnotenames.addName(string);
    }

    private void traverseNoteBody(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        if (element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element2 = (Element)node;
                String string = element2.getTagName();
                this.palette.getInfo().addDebugInfo(element2, laTeXDocumentPortion);
                if (string.equals("text:h")) {
                    this.palette.getBlockCv().handleHeading(element2, laTeXDocumentPortion, context);
                }
                if (string.equals("text:p")) {
                    this.palette.getInlineCv().traverseInlineText(element2, laTeXDocumentPortion, context, false);
                    if (i < n - 1) {
                        if (nodeList.item(i + 1).getNodeName().startsWith("text:")) {
                            laTeXDocumentPortion.append("\\par ");
                        } else {
                            laTeXDocumentPortion.nl();
                        }
                    }
                }
                if (string.equals("text:ordered-list")) {
                    this.palette.getBlockCv().handleList(element2, laTeXDocumentPortion, context, true);
                }
                if (!string.equals("text:unordered-list")) continue;
                this.palette.getBlockCv().handleList(element2, laTeXDocumentPortion, context, false);
            }
        }
    }
}

