/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.AwtGraphicsConfigData;
import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class AwtScreenData
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 24;
    }

    public int getDataSize() {
        return AwtScreenData.getSize();
    }

    public long getPData() {
        return this.pData;
    }

    AwtScreenData(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    AwtScreenData() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(AwtScreenData.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_numConfigs() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_numConfigs(int n) {
        log.finest("");
        Native.putInt(this.pData + 0L, n);
    }

    public long get_root() {
        log.finest("");
        return Native.getLong(this.pData + 4L);
    }

    public void set_root(long l) {
        log.finest("");
        Native.putLong(this.pData + 4L, l);
    }

    public long get_whitepixel() {
        log.finest("");
        return Native.getLong(this.pData + 8L);
    }

    public void set_whitepixel(long l) {
        log.finest("");
        Native.putLong(this.pData + 8L, l);
    }

    public long get_blackpixel() {
        log.finest("");
        return Native.getLong(this.pData + 12L);
    }

    public void set_blackpixel(long l) {
        log.finest("");
        Native.putLong(this.pData + 12L, l);
    }

    public AwtGraphicsConfigData get_defaultConfig(int n) {
        log.finest("");
        return Native.getLong(this.pData + 16L) != 0L ? new AwtGraphicsConfigData(Native.getLong(this.pData + 16L) + (long)(n * 96)) : null;
    }

    public long get_defaultConfig() {
        log.finest("");
        return Native.getLong(this.pData + 16L);
    }

    public void set_defaultConfig(long l) {
        log.finest("");
        Native.putLong(this.pData + 16L, l);
    }

    public long get_configs(int n) {
        log.finest("");
        return Native.getLong(this.pData + 20L) + (long)(n * Native.getLongSize());
    }

    public long get_configs() {
        log.finest("");
        return Native.getLong(this.pData + 20L);
    }

    public void set_configs(long l) {
        log.finest("");
        Native.putLong(this.pData + 20L, l);
    }

    String getName() {
        return "AwtScreenData";
    }

    String getFieldsAsString() {
        String string = "";
        string = string + "numConfigs = " + this.get_numConfigs() + ", ";
        string = string + "root = " + this.get_root() + ", ";
        string = string + "whitepixel = " + this.get_whitepixel() + ", ";
        string = string + "blackpixel = " + this.get_blackpixel() + ", ";
        string = string + "defaultConfig = " + this.get_defaultConfig() + ", ";
        string = string + "configs = " + this.get_configs() + ", ";
        return string;
    }
}

