/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.internal;

import com.sun.istack.internal.XMLStreamException2;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLStreamReaderToContentHandler {
    private final XMLStreamReader staxStreamReader;
    private final ContentHandler saxHandler;
    private boolean eagerQuit;
    private boolean fragment;

    public XMLStreamReaderToContentHandler(XMLStreamReader xMLStreamReader, ContentHandler contentHandler, boolean bl, boolean bl2) {
        this.staxStreamReader = xMLStreamReader;
        this.saxHandler = contentHandler;
        this.eagerQuit = bl;
        this.fragment = bl2;
    }

    public void bridge() throws XMLStreamException {
        try {
            int n = 0;
            int n2 = this.staxStreamReader.getEventType();
            if (n2 == 7) {
                while (!this.staxStreamReader.isStartElement()) {
                    n2 = this.staxStreamReader.next();
                }
            }
            if (n2 != 1) {
                throw new IllegalStateException("The current event is not START_ELEMENT\n but " + n2);
            }
            this.handleStartDocument();
            block18: do {
                switch (n2) {
                    case 1: {
                        ++n;
                        this.handleStartElement();
                        break;
                    }
                    case 2: {
                        this.handleEndElement();
                        if (--n != 0 || !this.eagerQuit) break;
                        break block18;
                    }
                    case 4: {
                        this.handleCharacters();
                        break;
                    }
                    case 9: {
                        this.handleEntityReference();
                        break;
                    }
                    case 3: {
                        this.handlePI();
                        break;
                    }
                    case 5: {
                        this.handleComment();
                        break;
                    }
                    case 11: {
                        this.handleDTD();
                        break;
                    }
                    case 10: {
                        this.handleAttribute();
                        break;
                    }
                    case 13: {
                        this.handleNamespace();
                        break;
                    }
                    case 12: {
                        this.handleCDATA();
                        break;
                    }
                    case 15: {
                        this.handleEntityDecl();
                        break;
                    }
                    case 14: {
                        this.handleNotationDecl();
                        break;
                    }
                    case 6: {
                        this.handleSpace();
                        break;
                    }
                    default: {
                        throw new InternalError("processing event: " + n2);
                    }
                }
                n2 = this.staxStreamReader.next();
            } while (n != 0);
            this.handleEndDocument();
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException2(sAXException);
        }
    }

    private void handleEndDocument() throws SAXException {
        if (this.fragment) {
            return;
        }
        this.saxHandler.endDocument();
    }

    private void handleStartDocument() throws SAXException {
        if (this.fragment) {
            return;
        }
        this.saxHandler.setDocumentLocator(new Locator(){

            public int getColumnNumber() {
                return XMLStreamReaderToContentHandler.this.staxStreamReader.getLocation().getColumnNumber();
            }

            public int getLineNumber() {
                return XMLStreamReaderToContentHandler.this.staxStreamReader.getLocation().getLineNumber();
            }

            public String getPublicId() {
                return XMLStreamReaderToContentHandler.this.staxStreamReader.getLocation().getPublicId();
            }

            public String getSystemId() {
                return XMLStreamReaderToContentHandler.this.staxStreamReader.getLocation().getSystemId();
            }
        });
        this.saxHandler.startDocument();
    }

    private void handlePI() throws XMLStreamException {
        try {
            this.saxHandler.processingInstruction(this.staxStreamReader.getPITarget(), this.staxStreamReader.getPIData());
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException2(sAXException);
        }
    }

    private void handleCharacters() throws XMLStreamException {
        try {
            this.saxHandler.characters(this.staxStreamReader.getTextCharacters(), this.staxStreamReader.getTextStart(), this.staxStreamReader.getTextLength());
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException2(sAXException);
        }
    }

    private void handleEndElement() throws XMLStreamException {
        QName qName = this.staxStreamReader.getName();
        try {
            String string = qName.getPrefix();
            String string2 = string == null || string.length() == 0 ? qName.getLocalPart() : string + ':' + qName.getLocalPart();
            this.saxHandler.endElement(qName.getNamespaceURI(), qName.getLocalPart(), string2);
            int n = this.staxStreamReader.getNamespaceCount();
            for (int i = n - 1; i >= 0; --i) {
                String string3 = this.staxStreamReader.getNamespacePrefix(i);
                if (string3 == null) {
                    string3 = "";
                }
                this.saxHandler.endPrefixMapping(string3);
            }
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException2(sAXException);
        }
    }

    private void handleStartElement() throws XMLStreamException {
        try {
            int n = this.staxStreamReader.getNamespaceCount();
            for (int i = 0; i < n; ++i) {
                this.saxHandler.startPrefixMapping(XMLStreamReaderToContentHandler.fixNull(this.staxStreamReader.getNamespacePrefix(i)), XMLStreamReaderToContentHandler.fixNull(this.staxStreamReader.getNamespaceURI(i)));
            }
            QName qName = this.staxStreamReader.getName();
            String string = qName.getPrefix();
            String string2 = string == null || string.length() == 0 ? qName.getLocalPart() : string + ':' + qName.getLocalPart();
            Attributes attributes = this.getAttributes();
            this.saxHandler.startElement(qName.getNamespaceURI(), qName.getLocalPart(), string2, attributes);
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException2(sAXException);
        }
    }

    private static String fixNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private Attributes getAttributes() {
        AttributesImpl attributesImpl = new AttributesImpl();
        int n = this.staxStreamReader.getEventType();
        if (n != 10 && n != 1) {
            throw new InternalError("getAttributes() attempting to process: " + n);
        }
        for (int i = 0; i < this.staxStreamReader.getAttributeCount(); ++i) {
            String string = this.staxStreamReader.getAttributeNamespace(i);
            if (string == null) {
                string = "";
            }
            String string2 = this.staxStreamReader.getAttributeLocalName(i);
            String string3 = this.staxStreamReader.getAttributePrefix(i);
            String string4 = string3 == null || string3.length() == 0 ? string2 : string3 + ':' + string2;
            String string5 = this.staxStreamReader.getAttributeType(i);
            String string6 = this.staxStreamReader.getAttributeValue(i);
            attributesImpl.addAttribute(string, string2, string4, string5, string6);
        }
        return attributesImpl;
    }

    private void handleNamespace() {
    }

    private void handleAttribute() {
    }

    private void handleDTD() {
    }

    private void handleComment() {
    }

    private void handleEntityReference() {
    }

    private void handleSpace() {
    }

    private void handleNotationDecl() {
    }

    private void handleEntityDecl() {
    }

    private void handleCDATA() {
    }
}

