<?php
require_once 'System.php';
require_once 'PHPUnit.php';
require_once 'File/Passwd/Smb.php';

function hash_nt($txt)
{
    return strToUpper(bin2hex($GLOBALS['msc']->ntPasswordHash($txt)));
}
function hash_lm($txt)
{
    return strToUpper(bin2hex($GLOBALS['msc']->lmPasswordHash($txt)));
}

$GLOBALS['tmpfile'] = System::mktemp();
$GLOBALS['msc']     = &new Crypt_CHAP_MSv1();
$GLOBALS['user']    = array(
    'mike' => array(
        'userid' => 501,
        'nthash' => hash_nt('123'),
        'lmhash' => hash_lm('123'),
        'flags'  => '[U           ]',
        'lct'    => 'LCT-3FA7AE9B',
        'comment'=> 'Michael Wallner'
    )
);

/**
 * TestCase for File_Passwd_SmbTest class
 * Generated by PHPEdit.XUnit Plugin
 * 
 */
class File_Passwd_SmbTest extends PHPUnit_TestCase{

    var $pw;
    
    /**
     * Constructor
     * @param string $name The name of the test.
     * @access protected
     */
    function File_Passwd_SmbTest($name){
        $this->PHPUnit_TestCase($name);
    }
    
    /**
     * Called before the test functions will be executed this function is defined in PHPUnit_TestCase and overwritten here
     * @access protected
     */
    function setUp(){
        $this->pw = &new File_Passwd_Smb();
    }
    
    /**
     * Called after the test functions are executed this function is defined in PHPUnit_TestCase and overwritten here
     * @access protected
     */
    function tearDown(){
        $this->pw = null;
        unset($this->pw);
    }
    
    /**
     * Regression test for File_Passwd_Smb.File_Passwd_Smb method
     * @access public
     */
    function testFile_Passwd_Smb(){
        $this->assertTrue(is_a($this->pw, 'File_Passwd_Smb'));
    }
    
    /**
     * Regression test for File_Passwd_Smb.staticAuth method
     * @access public
     */
    function teststaticAuth(){
        $rs = File_Passwd_Smb::staticAuth('passwd.smb.txt', 'mike', 123);
        $this->assertTrue($rs);
        $this->assertTrue(!PEAR::isError($rs));
    }
    
    /**
     * Regression test for File_Passwd_Smb.parse method
     * @access public
     */
    function testparse(){
        $this->pw->setFile('passwd.smb.txt');
        $rs = $this->pw->load();
        $this->assertTrue($rs);
        $this->assertTrue(!PEAR::isError($rs));
        $u = asort($GLOBALS['user']);
        $s = asort($this->pw->listUser());
        $this->assertEquals($u, $s);
    }
    
    /**
     * Regression test for File_Passwd_Smb.addUser method
     * @access public
     */
    function testaddUser(){
        $rs = $this->pw->addUser('mike2', 123, array('userid' => 502));
        $this->assertTrue($rs);
        $this->assertTrue(!PEAR::isError($rs));
    }
    
    /**
     * Regression test for File_Passwd_Smb.modUser method
     * @access public
     */
    function testmodUser(){
        $this->pw->addUser('mike3', 123, array('userid' => 503));
        $rs = $this->pw->modUser('mike3', array('userid' => 599));
        $this->assertTrue($rs);
        $this->assertTrue(!PEAR::isError($rs));
    }
    
    /**
     * Regression test for File_Passwd_Smb.changePasswd method
     * @access public
     */
    function testchangePasswd(){
        $abc = 'E0FBA38268D0EC66EF1CB452D5885E53';
        $abc = hash_nt('abc');
        $this->pw->addUser('mike4', 123, array('userid' => 504));
        $rs = $this->pw->changePasswd('mike4', 'abc');
        $this->assertTrue($rs);
        $this->assertTrue(!PEAR::isError($rs));
        $this->assertEquals($abc, $this->pw->_users['mike4']['nthash']);
    }
    
    /**
     * Regression test for File_Passwd_Smb.verifyEncryptedPasswd method
     * @access public
     */
    function testverifyEncryptedPasswd(){
        $this->pw->addUser('mike5', 'abc', array('userid' => 505));
        $pass = hash_nt('abc');
        $rs = $this->pw->verifyEncryptedPasswd('mike5', $pass);
        $this->assertTrue($rs);
        $this->assertTrue(!PEAR::isError($rs));
    }
    
    /**
     * Regression test for File_Passwd_Smb.verifyPasswd method
     * @access public
     */
    function testverifyPasswd(){
        $this->pw->addUser('mike6', 'abc', array('userid' => 506));
        $rs = $this->pw->verifyPasswd('mike6', 'abc');
        $this->assertTrue($rs);
        $this->assertTrue(!PEAR::isError($rs));
    }
    
    /**
     * Regression test for File_Passwd_Smb.save method
     * @access public
     */
    function testsave(){
        $this->pw->setFile($GLOBALS['tmpfile']);
        $this->pw->addUser('mike', 123, array('userid' => 501, 'comment' => 'Michael Wallner'));
        $_lct = $this->pw->_users['mike']['lct'];
        $rs = $this->pw->save();
        $this->assertTrue($rs);
        $this->assertTrue(!PEAR::isError($rs));

        list($line) = file($GLOBALS['tmpfile']);
        $test = explode(':', trim(array_shift(file($GLOBALS['tmpfile']))));
        $array= array(
            'mike',
            '501',
            hash_lm(123),
            hash_nt(123),
            '[U           ]',
            $_lct,
            'Michael Wallner'
        );
        $this->assertEquals($array, $test);
    }
    
}

?>