/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.office.OfficeStyle;
import writer2latex.office.PropertySet;
import writer2latex.util.Misc;

public class ListStyle
extends OfficeStyle {
    private static final int MAX_LEVEL = 10;
    private PropertySet[] level = new PropertySet[11];
    private PropertySet[] levelStyle = new PropertySet[11];

    public ListStyle() {
        for (int i = 1; i <= 10; ++i) {
            this.level[i] = new PropertySet();
            this.levelStyle[i] = new PropertySet();
        }
    }

    public String getLevelType(int n) {
        if (n >= 1 && n <= 10) {
            return this.level[n].getName();
        }
        return null;
    }

    public boolean isNumber(int n) {
        return "text:list-level-style-number".equals(this.level[n].getName());
    }

    public boolean isBullet(int n) {
        return "text:list-level-style-bullet".equals(this.level[n].getName());
    }

    public boolean isImage(int n) {
        return "text:list-level-style-image".equals(this.level[n].getName());
    }

    public String getLevelProperty(int n, String string) {
        if (n >= 1 && n <= 10) {
            return this.level[n].getProperty(string);
        }
        return null;
    }

    public String getLevelStyleProperty(int n, String string) {
        if (n >= 1 && n <= 10) {
            return this.levelStyle[n].getProperty(string);
        }
        return null;
    }

    public void loadStyleFromDOM(Node node) {
        super.loadStyleFromDOM(node);
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                int n2;
                String string;
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1 || (string = Misc.getAttribute(node2, "text:level")) == null || (n2 = Misc.getPosInteger(string, 1)) < 1 || n2 > 10) continue;
                this.level[n2].loadFromDOM(node2);
                if (!node2.hasChildNodes()) continue;
                NodeList nodeList2 = node2.getChildNodes();
                int n3 = nodeList2.getLength();
                for (int j = 0; j < n3; ++j) {
                    Node node3 = nodeList2.item(j);
                    if (node3.getNodeType() != 1 || !node3.getNodeName().equals("style:properties")) continue;
                    this.levelStyle[n2].loadFromDOM(node3);
                }
            }
        }
    }
}

