#!/bin/sh
#
# rc.M: Initialize for multi-user mode.
#
# ޥ桼⡼ɤνԤ
#
# :
# 饤֥ꡦCD-ROMޥȡͥåȥHotPlug(ǥХưǧ)PCMCIA
# ALSAߥsyslogd/klogdrc.inet2NFSautofslpdapmdcrondatd
# ܸϥƥ(CannaWnnSKKservATOKx2)ndtpdPostgreSQLApache
# netatalkSambaxfsgpminit.dʲѥårc.local
#

# Tell the viewers what's going to happen...
echo "Going multiuser..."

# Remove stale locks and junk files (must be done after mount -a!).
rm -f /var/lock/* /var/spool/uucp/LCK..* /core > /dev/null 2>&1
for d in /var/lock/* ; do
  rm -f $d/* $d/.* > /dev/null 2>&1
done

# Ensure basic filesystem permissions sanity.
chmod 755 /
chmod 1777 /tmp /var/tmp

# Update all the shared library links automatically.
#echo "Updating shared library links..."
#ldconfig

# Screen blanks after 15 minutes idle time.
setterm -blank 15

# Look for a CD-ROM and mount it on /cdrom if any.
if [ -x /etc/rc.d/rc.cdrom ] ; then
  . /etc/rc.d/rc.cdrom
fi

chk_link () {
  [ "`ls -l $1 | sed 's/.*-> *//'`" = $2 ]
}

# Only for Planet.
if chk_link /etc/rc.d/rc.inet1 rc.inet1.planet ; then
  # Initialize Planet related work files.
  sed "/# .* begin/,/# .* end/d" /etc/resolv.conf > /etc/resolv.INI
  mv -f /etc/resolv.INI /etc/resolv.conf
  rm -f /var/lib/net/*[-.]* /var/lib/net/plugins/*
  # Initialize network interfaces.
  if [ -x /etc/rc.d/rc.inet1 ] ; then
    # Temporary enable HotPlug to handle some (i.e. firmware) events.
    if [ -x /etc/rc.d/rc.murasaki -a \
        -z "`grep 'hotplug=off' /proc/cmdline`" ] ; then
      ln -sf /sbin/hotplug.murasaki /dev/.hotplug.agent
      . /etc/rc.d/rc.inet1
      ln -sf /bin/true /dev/.hotplug.agent
    else
      . /etc/rc.d/rc.inet1
    fi
  fi
fi

# Initialize HotPlug and autoprobe devices.
#if [ -x /etc/rc.d/rc.murasaki ] ; then
#  echo "Initializing HotPlug stuff and autoprobe devices..."
#  . /etc/rc.d/rc.murasaki start
#fi
#if grep -q usbfs /proc/filesystems && ! grep -q usbfs /etc/mtab ; then
#  mount -t usbfs usbfs /proc/bus/usb
#fi
#sleep 3

# Initialize PCMCIA devices.
#if [ -x /etc/rc.d/rc.pcmcia -a -n "`lspci -n | grep 'Class 060[57]'`" ] ; then
#  . /etc/rc.d/rc.pcmcia start
#fi
#sleep 3

# Only for tradnet.
if chk_link /etc/rc.d/rc.inet1 rc.inet1.tradnet ; then
  # Initialize network interfaces.
  if [ -x /etc/rc.d/rc.inet1 ] ; then
    . /etc/rc.d/rc.inet1
  fi
fi

# Initialize ALSA sound mixer.
look_mod () {
  [ -n "`modprobe -l $1`" -o -n "`modprobe -l $1.o`" ]
}
if [ -d /proc/asound ] ; then
  echo "Initializing ALSA sound mixer..."
  if look_mod snd-pcm-oss ; then
    modprobe snd-pcm-oss
  fi
  if look_mod snd-seq-oss ; then
    modprobe snd-seq-oss
  fi
  if [ -x /usr/sbin/alsactl -a -f /etc/asound.state ] ; then
    alsactl restore
  else
    aumix -q -v75 -w75 -c75
  fi
fi

echo "Starting services:"

# Start the syslogd/klogd daemons.
if [ -r /syslogd.pid ] ; then
  kill `cat /syslogd.pid` `cat /klogd.pid`
  sleep 1
  rm -f /syslogd.pid /klogd.pid /bootlog.conf
fi
if [ -f /bootlog ] ; then
  if [ -f /var/adm/bootlog ] ; then
    rm -f /var/adm/bootlog.last.gz
    mv -f /var/adm/bootlog /var/adm/bootlog.last
    gzip /var/adm/bootlog.last
  fi
  mv -f /bootlog /var/adm
fi
if [ -x /usr/sbin/syslogd -a -x /usr/sbin/klogd ] ; then
  echo "Starting syslogd..."
  syslogd -m 0
  # Prevents a race condition with SMP kernels.
  sleep 1
  echo "Starting klogd..."
  klogd -c 4
fi

# Initialize the NET subsystem.
if [ -x /etc/rc.d/rc.inet1 -a -x /etc/rc.d/rc.inet2 ] ; then
  . /etc/rc.d/rc.inet2
fi

# Mount NFS filesystems in fstab.
if [ -n "`mount -anfv -t nfs 2> /dev/null`" ] ; then
  echo "Mounting NFS file systems..."
  mount -a -t nfs
fi

# Mount CIFS filesystems in fstab
if [ -n "`mount -anfv -t cifs 2> /dev/null`" ] ; then
  echo "Mounting cifs file systems..."
  mount -a -t cifs,smbfs
fi

# Start automounter.
if [ -x /etc/rc.d/rc.autofs ] ; then
  /etc/rc.d/rc.autofs start
fi

# Start the lpd daemon.
if [ -x /usr/sbin/lpd ] ; then
  echo "Starting lpd..."
  lpd
fi

# Start the APM daemon if APM is enabled in the kernel.
#if [ -x /usr/sbin/apmd -a -r /proc/apm ] ; then
#  echo "Starting apmd..."
#  apmd
#fi

# Start crond (Dillon's crond).
# If you want cron to actually log activity to /var/adm/cron, then change
# -l10 to -l8 to increase the logging level.
if [ -x /usr/sbin/crond ] ; then
  echo "Starting crond..."
  crond -l8 >> /var/adm/cron 2>&1
fi

# Start at daemon (atd).
if [ -x /usr/sbin/atd ] ; then
  echo "Starting atd..."
  atd
fi

# Start Japanese conversion servers.
if [ -x /etc/rc.d/rc.sj3 ] ; then
  /etc/rc.d/rc.sj3 start
fi
if [ -x /opt/atokx2/sbin/atokx2mngdaemon ] ; then
  echo "Starting ATOKx2..."
  /opt/atokx2/sbin/atokx2mngdaemon
fi
if [ -x /usr/lib/im/htt ] ; then
  echo "Starting htt..."
  /usr/lib/im/htt &
fi

# Start ndtpd.
if [ -x /usr/sbin/ndtpd -a -r /usr/etc/ndtpd.conf ] ; then
  echo "Starting ndtpd..."
  ndtpd
fi

# Start netatalk (a file/print server for Macintosh Appletalk).
if [ -x /etc/rc.d/rc.atalk ] ; then
  echo "Starting atalk..."
  /etc/rc.d/rc.atalk
fi

# Start X font server.
if [ -x /etc/rc.d/rc.xfs ] ; then
  echo "Starting xfs..."
  /etc/rc.d/rc.xfs start
fi

# Run the startup scripts in /etc/rc.d/init.d.
INITDANY=""
if [ -d /etc/rc.d/init.d ] ; then
  EXCLUDELIST=""
  for i in /etc/rc.d/rc.* ; do
    if [ -h $i -a -f $i ] ; then
      EXCLUDE=`ls -l $i | sed -n 's@.*init\.d/@@p'`
      [ -n "$EXCLUDE" ] && EXCLUDELIST="$EXCLUDELIST -e $EXCLUDE"
    fi
  done
  INITDLIST=`ls /etc/rc.d/init.d`
  [ -n "$EXCLUDELIST" ] && INITDLIST=`grep <<< "$INITDLIST" -v $EXCLUDELIST`
  for i in $INITDLIST ; do
    if [ -x /etc/rc.d/init.d/$i ] ; then
      if [ -z "$INITDANY" ] ; then
        echo "Starting services in /etc/rc.d/init.d:"
        INITDANY=y
      fi
      MESSAGES=`/etc/rc.d/init.d/$i start 2>&1`
      if [ -z "$MESSAGES" ] ; then
        echo "Starting $i..."
      else
        echo "$MESSAGES"
      fi
    fi
  done
fi

if [ -x /etc/rc.d/rc.once -o -n "`ls /var/log/initpkg`" ] ; then
  echo "Initializing system..."
  # Initialize system only once.
  if [ -x /etc/rc.d/rc.once ] ; then
    . /etc/rc.d/rc.once
    mv /etc/rc.d/rc.once /var/adm/rc.once
  fi
  # Run the initpkg scripts if any still.
  if [ -x /etc/rc.d/rc.initpkg ] ; then
    . /etc/rc.d/rc.initpkg
  fi
fi

#if [ -x /usr/X11R7/bin/Xorg -a ! -f /etc/X11/xorg.conf ] ; then
#  echo "Making /etc/X11/xorg.conf..."
#  /usr/X11R7/bin/make_xorg.conf.sh > /dev/null 2>&1
#  echo "done."
#fi

if [ -n "`find /usr/share/info -cnewer /usr/share/info/dir`" ] ; then
  echo "Some info files are newer than dir file."
  echo "Wait for a while to recreate dir file..."
  mkinfodir
  echo "done."
fi

if [ -x /usr/bin/update-mime-database ] ; then
  update-mime-database /usr/share/mime > /dev/null 2>&1
  if [ -d /opt/kde/share/mime ] ; then
    update-mime-database /opt/kde/share/mime > /dev/null 2>&1
  fi
fi

if [ -x /usr/bin/update-desktop-database ] ; then
  update-desktop-database /usr/share/applications
  if [ -d /opt/kde/share/applications/kde4 ] ; then
    update-desktop-database /opt/kde/share/applications/kde4
  fi
fi

# Start the local setup procedure.
if [ -x /etc/rc.d/rc.local ] ; then
  . /etc/rc.d/rc.local
fi

# Tell the viewers the system is ready.
echo
echo -n "The system is ready."

sync

# All done.
