/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.java.lang.CPStringBuilder;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CompatibilityFocusTraversalPolicy;
import javax.swing.ComponentInputMap;
import javax.swing.DebugGraphics;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.ComponentUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JComponent
extends Container
implements Serializable {
    private static final long serialVersionUID = -7908749299918704233L;
    protected AccessibleContext accessibleContext;
    float alignmentX = -1.0f;
    float alignmentY = -1.0f;
    Border border;
    JPopupMenu componentPopupMenu;
    boolean inheritsPopupMenu;
    boolean doubleBuffered = true;
    int debugGraphicsOptions;
    boolean opaque = false;
    protected ComponentUI ui;
    boolean requestFocusEnabled;
    boolean autoscrolls = false;
    static boolean paintingDoubleBuffered = false;
    static boolean isRepainting = false;
    protected EventListenerList listenerList = new EventListenerList();
    private VetoableChangeSupport vetoableChangeSupport;
    private Hashtable clientProperties;
    private InputMap inputMap_whenFocused;
    private InputMap inputMap_whenAncestorOfFocused;
    private ComponentInputMap inputMap_whenInFocusedWindow;
    private ActionMap actionMap;
    private boolean verifyInputWhenFocusTarget = true;
    private InputVerifier inputVerifier;
    private TransferHandler transferHandler;
    private boolean paintingTile;
    private Image dragBuffer;
    private boolean dragBufferInitialized;
    private static transient Rectangle rectCache;
    private static Locale defaultLocale;
    public static final String TOOL_TIP_TEXT_KEY = "ToolTipText";
    public static final int UNDEFINED_CONDITION = -1;
    public static final int WHEN_FOCUSED = 0;
    public static final int WHEN_ANCESTOR_OF_FOCUSED_COMPONENT = 1;
    public static final int WHEN_IN_FOCUSED_WINDOW = 2;
    Component paintChild;
    private boolean clientOpaqueSet = false;
    private boolean clientAutoscrollsSet = false;

    public JComponent() {
        this.setDropTarget(new DropTarget());
        this.setLocale(JComponent.getDefaultLocale());
        this.debugGraphicsOptions = -1;
        this.setRequestFocusEnabled(true);
    }

    private Hashtable getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable();
        }
        return this.clientProperties;
    }

    public final Object getClientProperty(Object key) {
        return this.getClientProperties().get(key);
    }

    public final void putClientProperty(Object key, Object value) {
        Hashtable t = this.getClientProperties();
        Object old = t.get(key);
        if (value != null) {
            t.put(key, value);
        } else {
            t.remove(key);
        }
        if (old != null || value != null) {
            this.firePropertyChange(key.toString(), old, value);
        }
    }

    public void removeAncestorListener(AncestorListener listener) {
        this.listenerList.remove(AncestorListener.class, listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (this.vetoableChangeSupport != null) {
            this.vetoableChangeSupport.removeVetoableChangeListener(listener);
        }
    }

    public void addAncestorListener(AncestorListener listener) {
        this.listenerList.add(AncestorListener.class, listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (this.vetoableChangeSupport == null) {
            this.vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this.vetoableChangeSupport.addVetoableChangeListener(listener);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        if (listenerType == PropertyChangeListener.class) {
            return this.getPropertyChangeListeners();
        }
        if (listenerType == VetoableChangeListener.class) {
            return this.getVetoableChangeListeners();
        }
        return this.listenerList.getListeners(listenerType);
    }

    public AncestorListener[] getAncestorListeners() {
        return (AncestorListener[])this.getListeners(AncestorListener.class);
    }

    public VetoableChangeListener[] getVetoableChangeListeners() {
        return this.vetoableChangeSupport == null ? new VetoableChangeListener[]{} : this.vetoableChangeSupport.getVetoableChangeListeners();
    }

    protected void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        if (this.vetoableChangeSupport != null) {
            this.vetoableChangeSupport.fireVetoableChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String property, int oldValue, int newValue) {
        super.firePropertyChange(property, oldValue, newValue);
    }

    @Override
    public void firePropertyChange(String property, boolean oldValue, boolean newValue) {
        super.firePropertyChange(property, oldValue, newValue);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return null;
    }

    @Override
    public float getAlignmentX() {
        float ret = this.alignmentX;
        if (this.alignmentX < 0.0f) {
            ret = super.getAlignmentX();
        }
        return ret;
    }

    @Override
    public float getAlignmentY() {
        float ret = this.alignmentY;
        if (this.alignmentY < 0.0f) {
            ret = super.getAlignmentY();
        }
        return ret;
    }

    public boolean getAutoscrolls() {
        return this.autoscrolls;
    }

    public void setBorder(Border newBorder) {
        Border oldBorder = this.getBorder();
        if (oldBorder == newBorder) {
            return;
        }
        this.border = newBorder;
        this.firePropertyChange("border", oldBorder, newBorder);
        this.repaint();
    }

    public Border getBorder() {
        return this.border;
    }

    @Override
    public Rectangle getBounds(Rectangle rv) {
        if (rv == null) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        rv.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rv;
    }

    protected Graphics getComponentGraphics(Graphics g) {
        Graphics g2 = g;
        int options = this.getDebugGraphicsOptions();
        if (options != -1) {
            if (!(g2 instanceof DebugGraphics)) {
                g2 = new DebugGraphics(g);
            }
            DebugGraphics dg = (DebugGraphics)g2;
            dg.setDebugOptions(dg.getDebugOptions() | options);
        }
        g2.setFont(this.getFont());
        g2.setColor(this.getForeground());
        return g2;
    }

    public int getDebugGraphicsOptions() {
        String option = System.getProperty("gnu.javax.swing.DebugGraphics");
        int options = this.debugGraphicsOptions;
        if (option != null && option.length() != 0) {
            if (options < 0) {
                options = 0;
            }
            if (option.equals("LOG")) {
                options |= 1;
            } else if (option.equals("FLASH")) {
                options |= 2;
            }
        }
        return options;
    }

    @Override
    public Insets getInsets() {
        if (this.border == null) {
            return super.getInsets();
        }
        return this.getBorder().getBorderInsets(this);
    }

    public Insets getInsets(Insets insets) {
        Insets t = this.getInsets();
        if (insets == null) {
            return t;
        }
        insets.left = t.left;
        insets.right = t.right;
        insets.top = t.top;
        insets.bottom = t.bottom;
        return insets;
    }

    @Override
    public Point getLocation(Point rv) {
        if (rv == null) {
            return new Point(this.getX(), this.getY());
        }
        rv.setLocation(this.getX(), this.getY());
        return rv;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension size = null;
        if (this.isMaximumSizeSet()) {
            size = super.getMaximumSize();
        } else {
            if (this.ui != null) {
                size = this.ui.getMaximumSize(this);
            }
            if (size == null) {
                size = super.getMaximumSize();
            }
        }
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = null;
        if (this.isMinimumSizeSet()) {
            size = super.getMinimumSize();
        } else {
            if (this.ui != null) {
                size = this.ui.getMinimumSize(this);
            }
            if (size == null) {
                size = super.getMinimumSize();
            }
        }
        return size;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = null;
        if (this.isPreferredSizeSet()) {
            size = super.getPreferredSize();
        } else {
            if (this.ui != null) {
                size = this.ui.getPreferredSize(this);
            }
            if (size == null) {
                size = super.getPreferredSize();
            }
        }
        return size;
    }

    public Component getNextFocusableComponent() {
        Container focusRoot = this;
        if (!this.isFocusCycleRoot()) {
            focusRoot = this.getFocusCycleRootAncestor();
        }
        FocusTraversalPolicy policy = focusRoot.getFocusTraversalPolicy();
        return policy.getComponentAfter(focusRoot, this);
    }

    public KeyStroke[] getRegisteredKeyStrokes() {
        KeyStroke[] ks0 = this.inputMap_whenFocused != null ? this.inputMap_whenFocused.keys() : new KeyStroke[]{};
        KeyStroke[] ks1 = this.inputMap_whenAncestorOfFocused != null ? this.inputMap_whenAncestorOfFocused.keys() : new KeyStroke[]{};
        KeyStroke[] ks2 = this.inputMap_whenInFocusedWindow != null ? this.inputMap_whenInFocusedWindow.keys() : new KeyStroke[]{};
        int count = ks0.length + ks1.length + ks2.length;
        KeyStroke[] result = new KeyStroke[count];
        System.arraycopy(ks0, 0, result, 0, ks0.length);
        System.arraycopy(ks1, 0, result, ks0.length, ks1.length);
        System.arraycopy(ks2, 0, result, ks0.length + ks1.length, ks2.length);
        return result;
    }

    public JRootPane getRootPane() {
        JRootPane p = SwingUtilities.getRootPane(this);
        return p;
    }

    @Override
    public Dimension getSize(Dimension rv) {
        if (rv == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        rv.setSize(this.getWidth(), this.getHeight());
        return rv;
    }

    public JToolTip createToolTip() {
        JToolTip toolTip = new JToolTip();
        toolTip.setComponent(this);
        return toolTip;
    }

    public Point getToolTipLocation(MouseEvent event) {
        return null;
    }

    public void setToolTipText(String text) {
        String old = this.getToolTipText();
        this.putClientProperty(TOOL_TIP_TEXT_KEY, text);
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        if (text == null) {
            ttm.unregisterComponent(this);
        } else if (old == null) {
            ttm.registerComponent(this);
        }
    }

    public String getToolTipText() {
        return (String)this.getClientProperty(TOOL_TIP_TEXT_KEY);
    }

    public String getToolTipText(MouseEvent event) {
        return this.getToolTipText();
    }

    public boolean getInheritsPopupMenu() {
        return this.inheritsPopupMenu;
    }

    public void setInheritsPopupMenu(boolean inherit) {
        if (this.inheritsPopupMenu != inherit) {
            this.inheritsPopupMenu = inherit;
            this.firePropertyChange("inheritsPopupMenu", !inherit, inherit);
        }
    }

    public JPopupMenu getComponentPopupMenu() {
        if (this.componentPopupMenu == null && this.getInheritsPopupMenu()) {
            Container parent = this.getParent();
            if (parent instanceof JComponent) {
                return ((JComponent)parent).getComponentPopupMenu();
            }
            return null;
        }
        return this.componentPopupMenu;
    }

    public void setComponentPopupMenu(JPopupMenu popup) {
        if (this.componentPopupMenu != popup) {
            JPopupMenu old = this.componentPopupMenu;
            this.componentPopupMenu = popup;
            this.firePropertyChange("componentPopupMenu", old, popup);
        }
    }

    public Container getTopLevelAncestor() {
        Container c;
        Container peek = c = this.getParent();
        while (peek != null) {
            c = peek;
            peek = peek.getParent();
        }
        return c;
    }

    public void computeVisibleRect(Rectangle rect) {
        Container c = this.getParent();
        if (c != null && c instanceof JComponent) {
            ((JComponent)c).computeVisibleRect(rect);
            rect.translate(-this.getX(), -this.getY());
            rect = SwingUtilities.computeIntersection(0, 0, this.getWidth(), this.getHeight(), rect);
        } else {
            rect.setRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    public Rectangle getVisibleRect() {
        Rectangle r = new Rectangle();
        this.computeVisibleRect(r);
        return r;
    }

    public void grabFocus() {
        this.requestFocus();
    }

    @Override
    public boolean isDoubleBuffered() {
        return this.doubleBuffered;
    }

    public static boolean isLightweightComponent(Component c) {
        return c.getPeer() instanceof LightweightPeer;
    }

    public boolean isManagingFocus() {
        return false;
    }

    @Override
    public boolean isOpaque() {
        return this.opaque;
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public boolean isPaintingTile() {
        return this.paintingTile;
    }

    public boolean isRequestFocusEnabled() {
        return this.requestFocusEnabled;
    }

    public boolean isValidateRoot() {
        return false;
    }

    @Override
    public void paint(Graphics g) {
        RepaintManager rm = RepaintManager.currentManager(this);
        if (!paintingDoubleBuffered && this.isDoubleBuffered() && rm.isDoubleBufferingEnabled()) {
            Rectangle clip = g.getClipBounds();
            this.paintDoubleBuffered(clip.x, clip.y, clip.width, clip.height);
        } else {
            int clipH;
            int clipW;
            int clipY;
            int clipX;
            if (this.getClientProperty("bufferedDragging") != null && this.dragBuffer == null) {
                this.initializeDragBuffer();
            } else if (this.getClientProperty("bufferedDragging") == null && this.dragBuffer != null) {
                this.dragBuffer = null;
            }
            Rectangle clip = g.getClipBounds();
            if (clip == null) {
                clipX = 0;
                clipY = 0;
                clipW = this.getWidth();
                clipH = this.getHeight();
            } else {
                clipX = clip.x;
                clipY = clip.y;
                clipW = clip.width;
                clipH = clip.height;
            }
            if (this.dragBuffer != null && this.dragBufferInitialized) {
                g.drawImage(this.dragBuffer, 0, 0, this);
            } else {
                Graphics g2 = this.getComponentGraphics(g);
                if (!this.isOccupiedByChild(clipX, clipY, clipW, clipH)) {
                    this.paintComponent(g2);
                    this.paintBorder(g2);
                }
                this.paintChildren(g2);
            }
        }
    }

    private boolean isOccupiedByChild(int x, int y, int w, int h) {
        boolean occupied = false;
        int count = this.getComponentCount();
        int i = 0;
        while (i < count) {
            Component child = this.getComponent(i);
            int cx = child.getX();
            int cy = child.getY();
            int cw = child.getWidth();
            int ch = child.getHeight();
            if (child.isVisible() && x >= cx && x + w <= cx + cw && y >= cy && y + h <= cy + ch) {
                occupied = child.isOpaque();
                break;
            }
            ++i;
        }
        return occupied;
    }

    private void initializeDragBuffer() {
        this.dragBufferInitialized = false;
        if (this.dragBuffer == null || this.dragBuffer.getWidth(this) < this.getWidth() || this.dragBuffer.getHeight(this) < this.getHeight()) {
            this.dragBuffer = this.createImage(this.getWidth(), this.getHeight());
        }
        Graphics g = this.dragBuffer.getGraphics();
        this.paint(g);
        g.dispose();
        this.dragBufferInitialized = true;
    }

    protected void paintBorder(Graphics g) {
        if (this.getBorder() != null) {
            this.getBorder().paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintChildren(Graphics g) {
        block13: {
            if (this.getComponentCount() <= 0) break block13;
            Object object = this.getTreeLock();
            synchronized (object) {
                int i = this.getComponentCount() - 1;
                if (this.paintChild != null && this.paintChild.isOpaque()) {
                    while (i >= 0 && this.getComponent(i) != this.paintChild) {
                        --i;
                    }
                }
                while (i >= 0) {
                    block12: {
                        int ch;
                        int cw;
                        int cy;
                        int cx;
                        Component child;
                        block14: {
                            child = this.getComponent(i);
                            if (child == null || !child.isLightweight() || !child.isVisible() || !g.hitClip(cx = child.getX(), cy = child.getY(), cw = child.getWidth(), ch = child.getHeight())) break block12;
                            if (this.isOptimizedDrawingEnabled() || i <= 0) break block14;
                            Rectangle clip = g.getClipBounds();
                            SwingUtilities.computeIntersection(cx, cy, cw, ch, clip);
                            if (this.isCompletelyObscured(i, clip.x, clip.y, clip.width, clip.height)) break block12;
                        }
                        Graphics cg = g.create(cx, cy, cw, ch);
                        cg.setColor(child.getForeground());
                        cg.setFont(child.getFont());
                        try {
                            child.paint(cg);
                        }
                        finally {
                            cg.dispose();
                        }
                    }
                    --i;
                }
            }
        }
    }

    private boolean isCompletelyObscured(int index, int x, int y, int w, int h) {
        boolean obscured = false;
        int i = index - 1;
        while (i >= 0 && !obscured) {
            Component sib = this.getComponent(i);
            if (sib.isVisible()) {
                Rectangle sibRect = sib.getBounds(rectCache);
                if (sib.isOpaque() && x >= sibRect.x && x + w <= sibRect.x + sibRect.width && y >= sibRect.y && y + h <= sibRect.y + sibRect.height) {
                    obscured = true;
                }
            }
            --i;
        }
        return obscured;
    }

    private boolean isPartiallyObscured(int i, int x, int y, int w, int h) {
        boolean obscured = false;
        int j = i - 1;
        while (j >= 0 && !obscured) {
            Component sibl = this.getComponent(j);
            if (sibl.isVisible()) {
                Rectangle rect = sibl.getBounds(rectCache);
                if (x + w > rect.x || y + h <= rect.y || x >= rect.x + rect.width || y >= rect.y + rect.height) {
                    obscured = true;
                }
            }
            --j;
        }
        return obscured;
    }

    protected void paintComponent(Graphics g) {
        if (this.ui != null) {
            Graphics g2 = g.create();
            try {
                this.ui.update(g2, this);
            }
            finally {
                g2.dispose();
            }
        }
    }

    public void paintImmediately(int x, int y, int w, int h) {
        if (this.isShowing()) {
            Container c = this;
            while (c != null && !((Component)c).isOpaque()) {
                Container p = c.getParent();
                if (p == null) continue;
                x += ((Component)c).getX();
                y += ((Component)c).getY();
                c = p;
            }
            if (c instanceof JComponent) {
                c.paintImmediately2(x, y, w, h);
            } else {
                c.repaint(x, y, w, h);
            }
        }
    }

    public void paintImmediately(Rectangle r) {
        this.paintImmediately(r.x, r.y, r.width, r.height);
    }

    void paintImmediately2(int x, int y, int w, int h) {
        boolean onTop = this.onTop() && this.isOpaque();
        RepaintManager rm = RepaintManager.currentManager(this);
        int paintX = x;
        int paintY = y;
        int paintW = w;
        int paintH = h;
        boolean haveBuffer = false;
        JComponent paintRoot = this;
        int pIndex = -1;
        int pCount = 0;
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        int offsX = 0;
        int offsY = 0;
        Container c = this;
        JComponent child = null;
        while (c != null && !(c instanceof Window) && !(c instanceof Applet)) {
            JComponent jc = c instanceof JComponent ? c : null;
            components.add((JComponent)c);
            if (!onTop && jc != null && !jc.isOptimizedDrawingEnabled()) {
                boolean updatePaintRoot = false;
                if (c != this) {
                    if (jc.isPaintRoot()) {
                        updatePaintRoot = true;
                    } else {
                        int count = c.getComponentCount();
                        int i = 0;
                        while (i < count && c.getComponent(i) != child) {
                            ++i;
                        }
                        if (jc.isCompletelyObscured(i, paintX, paintY, paintW, paintH)) {
                            return;
                        }
                        if (jc.isPartiallyObscured(i, paintX, paintY, paintW, paintH)) {
                            updatePaintRoot = true;
                        }
                    }
                }
                if (updatePaintRoot) {
                    paintRoot = jc;
                    pIndex = pCount;
                    offsX = 0;
                    offsY = 0;
                    haveBuffer = false;
                }
            }
            ++pCount;
            if (rm.isDoubleBufferingEnabled() && jc != null && jc.isDoubleBuffered()) {
                haveBuffer = true;
            }
            if (!onTop) {
                paintX = Math.max(0, paintX);
                paintY = Math.max(0, paintY);
                paintW = Math.min(c.getWidth(), paintW + paintX) - paintX;
                paintH = Math.min(c.getHeight(), paintH + paintY) - paintY;
                int dx = c.getX();
                int dy = c.getY();
                paintX += dx;
                paintY += dy;
                offsX += dx;
                offsY += dy;
            }
            child = c;
            c = c.getParent();
        }
        if (c != null && c.getPeer() != null && paintW > 0 && paintH > 0) {
            isRepainting = true;
            paintX -= offsX;
            paintY -= offsY;
            if (paintRoot != this) {
                int i = pIndex;
                while (i > 0) {
                    Component paintParent = (Component)components.get(i);
                    if (paintParent instanceof JComponent) {
                        ((JComponent)paintParent).paintChild = (Component)components.get(i - 1);
                    }
                    --i;
                }
            }
            if (haveBuffer) {
                paintRoot.paintDoubleBuffered(paintX, paintY, paintW, paintH);
            } else {
                Graphics g = paintRoot.getGraphics();
                try {
                    g.setClip(paintX, paintY, paintW, paintH);
                    paintRoot.paint(g);
                }
                finally {
                    g.dispose();
                }
            }
            if (paintRoot != this) {
                int i = pIndex;
                while (i > 0) {
                    Component paintParent = (Component)components.get(i);
                    if (paintParent instanceof JComponent) {
                        ((JComponent)paintParent).paintChild = null;
                    }
                    --i;
                }
            }
            isRepainting = false;
        }
    }

    boolean onTop() {
        return false;
    }

    boolean isPaintRoot() {
        return false;
    }

    private void paintDoubleBuffered(int x, int y, int w, int h) {
        Component root;
        RepaintManager rm = RepaintManager.currentManager(this);
        Image buffer = rm.getVolatileOffscreenBuffer(this, (root = SwingUtilities.getRoot(this)).getWidth(), root.getHeight());
        if (buffer == null) {
            buffer = rm.getOffscreenBuffer(this, root.getWidth(), root.getHeight());
        }
        Graphics g2 = buffer.getGraphics();
        this.clipAndTranslateGraphics(root, this, g2);
        g2.clipRect(x, y, w, h);
        g2 = this.getComponentGraphics(g2);
        paintingDoubleBuffered = true;
        try {
            if (isRepainting) {
                this.paint(g2);
            } else {
                this.paintComponent(g2);
                this.paintBorder(g2);
                this.paintChildren(g2);
            }
        }
        finally {
            paintingDoubleBuffered = false;
            g2.dispose();
        }
        rm.commitBuffer(this, x, y, w, h);
    }

    private void clipAndTranslateGraphics(Component root, Component target, Graphics g) {
        Component parent = target;
        int deltaX = 0;
        int deltaY = 0;
        while (parent != root) {
            deltaX += parent.getX();
            deltaY += parent.getY();
            parent = parent.getParent();
        }
        g.translate(deltaX, deltaY);
        g.clipRect(0, 0, target.getWidth(), target.getHeight());
    }

    void paintSimple(Rectangle r) {
        Graphics g = this.getGraphics();
        Graphics g2 = this.getComponentGraphics(g);
        g2.setClip(r);
        this.paint(g2);
        g2.dispose();
        if (g != g2) {
            g.dispose();
        }
    }

    @Override
    protected String paramString() {
        CPStringBuilder sb = new CPStringBuilder();
        sb.append(super.paramString());
        sb.append(",alignmentX=").append(this.getAlignmentX());
        sb.append(",alignmentY=").append(this.getAlignmentY());
        sb.append(",border=");
        if (this.getBorder() != null) {
            sb.append(this.getBorder());
        }
        sb.append(",maximumSize=");
        if (this.getMaximumSize() != null) {
            sb.append(this.getMaximumSize());
        }
        sb.append(",minimumSize=");
        if (this.getMinimumSize() != null) {
            sb.append(this.getMinimumSize());
        }
        sb.append(",preferredSize=");
        if (this.getPreferredSize() != null) {
            sb.append(this.getPreferredSize());
        }
        return sb.toString();
    }

    public void registerKeyboardAction(ActionListener act, KeyStroke stroke, int cond) {
        this.registerKeyboardAction(act, null, stroke, cond);
    }

    public void registerKeyboardAction(ActionListener act, String cmd, KeyStroke stroke, int cond) {
        ActionListenerProxy proxy = new ActionListenerProxy(act, cmd);
        this.getInputMap(cond).put(stroke, proxy);
        this.getActionMap().put(proxy, proxy);
    }

    public final void setInputMap(int condition, InputMap map) {
        this.enableEvents(8L);
        switch (condition) {
            case 0: {
                this.inputMap_whenFocused = map;
                break;
            }
            case 1: {
                this.inputMap_whenAncestorOfFocused = map;
                break;
            }
            case 2: {
                if (map != null && !(map instanceof ComponentInputMap)) {
                    throw new IllegalArgumentException("WHEN_IN_FOCUSED_WINDOW InputMap must be a ComponentInputMap");
                }
                this.inputMap_whenInFocusedWindow = (ComponentInputMap)map;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public final InputMap getInputMap(int condition) {
        this.enableEvents(8L);
        switch (condition) {
            case 0: {
                if (this.inputMap_whenFocused == null) {
                    this.inputMap_whenFocused = new InputMap();
                }
                return this.inputMap_whenFocused;
            }
            case 1: {
                if (this.inputMap_whenAncestorOfFocused == null) {
                    this.inputMap_whenAncestorOfFocused = new InputMap();
                }
                return this.inputMap_whenAncestorOfFocused;
            }
            case 2: {
                if (this.inputMap_whenInFocusedWindow == null) {
                    this.inputMap_whenInFocusedWindow = new ComponentInputMap(this);
                }
                return this.inputMap_whenInFocusedWindow;
            }
        }
        throw new IllegalArgumentException("Invalid 'condition' argument: " + condition);
    }

    public final InputMap getInputMap() {
        return this.getInputMap(0);
    }

    public final ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = new ActionMap();
        }
        return this.actionMap;
    }

    public final void setActionMap(ActionMap map) {
        this.actionMap = map;
    }

    public int getConditionForKeyStroke(KeyStroke ks) {
        if (this.inputMap_whenFocused != null && this.inputMap_whenFocused.get(ks) != null) {
            return 0;
        }
        if (this.inputMap_whenAncestorOfFocused != null && this.inputMap_whenAncestorOfFocused.get(ks) != null) {
            return 1;
        }
        if (this.inputMap_whenInFocusedWindow != null && this.inputMap_whenInFocusedWindow.get(ks) != null) {
            return 2;
        }
        return -1;
    }

    public ActionListener getActionForKeyStroke(KeyStroke ks) {
        Object key = this.getInputMap(0).get(ks);
        if (key == null) {
            key = this.getInputMap(1).get(ks);
        }
        if (key == null) {
            key = this.getInputMap(2).get(ks);
        }
        if (key != null) {
            if (key instanceof ActionListenerProxy) {
                return ((ActionListenerProxy)key).target;
            }
            return this.getActionMap().get(key);
        }
        return null;
    }

    protected void processComponentKeyEvent(KeyEvent e) {
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        boolean pressed;
        super.processKeyEvent(e);
        this.processComponentKeyEvent(e);
        if (e.isConsumed()) {
            return;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
        boolean bl = pressed = e.getID() == 401;
        if (this.processKeyBinding(keyStroke, e, 0, pressed)) {
            e.consume();
            return;
        }
        if (this.processKeyBinding(keyStroke, e, 1, pressed)) {
            e.consume();
            return;
        }
        Container current = this.getParent();
        while (current != null) {
            if (current instanceof JComponent && ((JComponent)current).processKeyBinding(keyStroke, e, 1, pressed)) {
                e.consume();
                return;
            }
            if (current instanceof Window || current instanceof Applet) break;
            current = current.getParent();
        }
        if (current == null || e.isConsumed()) {
            return;
        }
        if (KeyboardManager.getManager().processKeyStroke(current, keyStroke, e)) {
            e.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (this.isEnabled()) {
            Action act = null;
            Object cmd = null;
            InputMap map = this.getInputMap(condition);
            if (map != null && (cmd = map.get(ks)) != null) {
                act = cmd instanceof ActionListenerProxy ? (Action)cmd : this.getActionMap().get(cmd);
            }
            if (act != null && act.isEnabled()) {
                Action action = act;
                synchronized (action) {
                    act.putValue("__command__", cmd);
                    return SwingUtilities.notifyAction(act, ks, e, this, e.getModifiers());
                }
            }
        }
        return false;
    }

    public void unregisterKeyboardAction(KeyStroke aKeyStroke) {
        ActionMap am = this.getActionMap();
        int cond = 0;
        while (cond < 3) {
            InputMap im = this.getInputMap(cond);
            if (im != null) {
                Object action = im.get(aKeyStroke);
                if (action != null && am != null) {
                    am.remove(action);
                }
                im.remove(aKeyStroke);
            }
            ++cond;
        }
    }

    public void resetKeyboardActions() {
        if (this.inputMap_whenFocused != null) {
            this.inputMap_whenFocused.clear();
        }
        if (this.inputMap_whenAncestorOfFocused != null) {
            this.inputMap_whenAncestorOfFocused.clear();
        }
        if (this.inputMap_whenInFocusedWindow != null) {
            this.inputMap_whenInFocusedWindow.clear();
        }
        if (this.actionMap != null) {
            this.actionMap.clear();
        }
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
        RepaintManager.currentManager(this).addDirtyRegion(this, x, y, width, height);
    }

    public void repaint(Rectangle r) {
        RepaintManager.currentManager(this).addDirtyRegion(this, r.x, r.y, r.width, r.height);
    }

    public boolean requestDefaultFocus() {
        return false;
    }

    public void revalidate() {
        if (this.getParent() == null) {
            return;
        }
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JComponent.this.revalidate();
                }
            });
        } else {
            this.invalidate();
            RepaintManager.currentManager(this).addInvalidComponent(this);
        }
    }

    public void scrollRectToVisible(Rectangle r) {
        int xOffs = this.getX();
        int yOffs = this.getY();
        Container p = this.getParent();
        while (p != null && !(p instanceof JComponent)) {
            xOffs += p.getX();
            yOffs += p.getY();
            p = p.getParent();
        }
        if (p != null) {
            r.x += xOffs;
            r.y += yOffs;
            JComponent jParent = (JComponent)p;
            jParent.scrollRectToVisible(r);
            r.x -= xOffs;
            r.y -= yOffs;
        }
    }

    public void setAlignmentX(float a) {
        this.alignmentX = a < 0.0f ? 0.0f : ((double)a > 1.0 ? 1.0f : a);
    }

    public void setAlignmentY(float a) {
        this.alignmentY = a < 0.0f ? 0.0f : ((double)a > 1.0 ? 1.0f : a);
    }

    public void setAutoscrolls(boolean a) {
        this.autoscrolls = a;
        this.clientAutoscrollsSet = true;
    }

    public void setDebugGraphicsOptions(int debugOptions) {
        this.debugGraphicsOptions = debugOptions;
    }

    public void setDoubleBuffered(boolean db) {
        this.doubleBuffered = db;
    }

    @Override
    public void setEnabled(boolean enable) {
        if (enable == this.isEnabled()) {
            return;
        }
        super.setEnabled(enable);
        this.firePropertyChange("enabled", !enable, enable);
        this.repaint();
    }

    @Override
    public void setFont(Font f) {
        if (f == this.getFont()) {
            return;
        }
        super.setFont(f);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setBackground(Color bg) {
        if (bg == this.getBackground()) {
            return;
        }
        super.setBackground(bg);
        this.repaint();
    }

    @Override
    public void setForeground(Color fg) {
        if (fg == this.getForeground()) {
            return;
        }
        super.setForeground(fg);
        this.repaint();
    }

    public void setNextFocusableComponent(Component aComponent) {
        FocusTraversalPolicy policy;
        Container focusRoot = this;
        if (!this.isFocusCycleRoot()) {
            focusRoot = this.getFocusCycleRootAncestor();
        }
        if ((policy = focusRoot.getFocusTraversalPolicy()) instanceof CompatibilityFocusTraversalPolicy) {
            policy = new CompatibilityFocusTraversalPolicy(policy);
            focusRoot.setFocusTraversalPolicy(policy);
        }
        CompatibilityFocusTraversalPolicy p = (CompatibilityFocusTraversalPolicy)policy;
        Component old = this.getNextFocusableComponent();
        if (old != null) {
            p.removeNextFocusableComponent(this, old);
        }
        if (aComponent != null) {
            p.addNextFocusableComponent(this, aComponent);
        }
    }

    public void setRequestFocusEnabled(boolean e) {
        this.requestFocusEnabled = e;
    }

    public TransferHandler getTransferHandler() {
        return this.transferHandler;
    }

    public void setTransferHandler(TransferHandler newHandler) {
        if (this.transferHandler == newHandler) {
            return;
        }
        TransferHandler oldHandler = this.transferHandler;
        this.transferHandler = newHandler;
        this.firePropertyChange("transferHandler", oldHandler, newHandler);
    }

    public void setOpaque(boolean isOpaque) {
        boolean oldOpaque = this.opaque;
        this.opaque = isOpaque;
        this.clientOpaqueSet = true;
        this.firePropertyChange("opaque", oldOpaque, this.opaque);
    }

    @Override
    public void setVisible(boolean v) {
        if (this.isVisible() == v) {
            return;
        }
        super.setVisible(v);
        if (v) {
            this.fireAncestorEvent(this, 1);
        } else {
            this.fireAncestorEvent(this, 2);
        }
        Container parent = this.getParent();
        if (parent != null) {
            parent.repaint(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        this.revalidate();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public String getUIClassID() {
        return "ComponentUI";
    }

    protected void setUI(ComponentUI newUI) {
        if (this.ui != null) {
            this.ui.uninstallUI(this);
        }
        ComponentUI oldUI = this.ui;
        this.ui = newUI;
        if (this.ui != null) {
            this.ui.installUI(this);
        }
        this.firePropertyChange("UI", oldUI, newUI);
        this.revalidate();
        this.repaint();
    }

    public void updateUI() {
    }

    public static Locale getDefaultLocale() {
        if (defaultLocale == null) {
            defaultLocale = Locale.getDefault();
        }
        return defaultLocale;
    }

    public static void setDefaultLocale(Locale l) {
        defaultLocale = l;
    }

    public InputVerifier getInputVerifier() {
        return this.inputVerifier;
    }

    public void setInputVerifier(InputVerifier verifier) {
        InputVerifier oldVerifier = this.inputVerifier;
        this.inputVerifier = verifier;
        this.firePropertyChange("inputVerifier", oldVerifier, verifier);
    }

    public boolean getVerifyInputWhenFocusTarget() {
        return this.verifyInputWhenFocusTarget;
    }

    public void setVerifyInputWhenFocusTarget(boolean verifyInputWhenFocusTarget) {
        if (this.verifyInputWhenFocusTarget == verifyInputWhenFocusTarget) {
            return;
        }
        this.verifyInputWhenFocusTarget = verifyInputWhenFocusTarget;
        this.firePropertyChange("verifyInputWhenFocusTarget", !verifyInputWhenFocusTarget, verifyInputWhenFocusTarget);
    }

    @Override
    public void requestFocus() {
        if (this.isRequestFocusEnabled()) {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        return super.requestFocus(temporary);
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.isRequestFocusEnabled()) {
            return super.requestFocusInWindow();
        }
        return false;
    }

    @Override
    protected boolean requestFocusInWindow(boolean temporary) {
        return super.requestFocusInWindow(temporary);
    }

    @Override
    public void addNotify() {
        KeyboardManager km = KeyboardManager.getManager();
        km.clearBindingsForComp(this);
        km.registerEntireMap((ComponentInputMap)this.getInputMap(2));
        super.addNotify();
        this.fireAncestorEvent(this, 1);
        this.firePropertyChange("ancestor", null, this.getParent());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        KeyboardManager.getManager().clearBindingsForComp(this);
        this.fireAncestorEvent(this, 2);
        this.firePropertyChange("ancestor", this.getParent(), null);
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.ui == null) {
            return super.contains(x, y);
        }
        return this.ui.contains(this, x, y);
    }

    @Override
    public void disable() {
        super.disable();
    }

    @Override
    public void enable() {
        super.enable();
    }

    @Override
    public Graphics getGraphics() {
        return super.getGraphics();
    }

    @Override
    public int getX() {
        return super.getX();
    }

    @Override
    public int getY() {
        return super.getY();
    }

    @Override
    public int getHeight() {
        return super.getHeight();
    }

    @Override
    public int getWidth() {
        return super.getWidth();
    }

    @Override
    public void print(Graphics g) {
        boolean doubleBufferState = this.isDoubleBuffered();
        this.setDoubleBuffered(false);
        this.printComponent(g);
        this.printBorder(g);
        this.printChildren(g);
        this.setDoubleBuffered(doubleBufferState);
    }

    @Override
    public void printAll(Graphics g) {
        this.print(g);
    }

    protected void printComponent(Graphics g) {
        this.paintComponent(g);
    }

    protected void printChildren(Graphics g) {
        this.paintChildren(g);
    }

    protected void printBorder(Graphics g) {
        this.paintBorder(g);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent ev) {
        super.processMouseMotionEvent(ev);
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        int oldX = this.getX();
        int oldY = this.getY();
        super.reshape(x, y, w, h);
        if (oldX != this.getX() || oldY != this.getY()) {
            this.fireAncestorEvent(this, 3);
        }
    }

    void fireAncestorEvent(JComponent ancestor, int id) {
        int i;
        AncestorListener[] listeners = this.getAncestorListeners();
        if (listeners.length > 0) {
            AncestorEvent ev = new AncestorEvent(this, id, ancestor, ancestor.getParent());
            i = 0;
            while (i < listeners.length) {
                switch (id) {
                    case 3: {
                        listeners[i].ancestorMoved(ev);
                        break;
                    }
                    case 1: {
                        listeners[i].ancestorAdded(ev);
                        break;
                    }
                    case 2: {
                        listeners[i].ancestorRemoved(ev);
                    }
                }
                ++i;
            }
        }
        int numChildren = this.getComponentCount();
        i = 0;
        while (i < numChildren) {
            Component child = this.getComponent(i);
            if (child instanceof JComponent) {
                JComponent jc = (JComponent)child;
                jc.fireAncestorEvent(ancestor, id);
            }
            ++i;
        }
    }

    void updateComponentInputMap(ComponentInputMap changed) {
        InputMap curr = this.getInputMap(2);
        while (curr != null && curr != changed) {
            curr = curr.getParent();
        }
        if (curr == null) {
            return;
        }
        KeyboardManager km = KeyboardManager.getManager();
        km.clearBindingsForComp(changed.getComponent());
        km.registerEntireMap((ComponentInputMap)this.getInputMap(2));
    }

    void setUIProperty(String propertyName, Object value) {
        if (propertyName.equals("opaque")) {
            if (!this.clientOpaqueSet) {
                this.setOpaque((Boolean)value);
                this.clientOpaqueSet = false;
            }
        } else if (propertyName.equals("autoscrolls")) {
            if (!this.clientAutoscrollsSet) {
                this.setAutoscrolls((Boolean)value);
                this.clientAutoscrollsSet = false;
            }
        } else {
            throw new IllegalArgumentException("Unsupported property for LookAndFeel.installProperty(): " + propertyName);
        }
    }

    public abstract class AccessibleJComponent
    extends Container.AccessibleAWTContainer
    implements AccessibleExtendedComponent {
        private static final long serialVersionUID = -7047089700479897799L;
        protected ContainerListener accessibleContainerHandler;
        protected FocusListener accessibleFocusHandler;

        protected AccessibleJComponent() {
            super(JComponent.this);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            if (this.accessibleContainerHandler == null) {
                this.accessibleContainerHandler = new AccessibleContainerHandler();
                JComponent.this.addContainerListener(this.accessibleContainerHandler);
            }
            if (this.accessibleFocusHandler == null) {
                this.accessibleFocusHandler = new AccessibleFocusHandler();
                this.addFocusListener(this.accessibleFocusHandler);
            }
            super.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            if (this.accessibleContainerHandler != null) {
                JComponent.this.removeContainerListener(this.accessibleContainerHandler);
                this.accessibleContainerHandler = null;
            }
            if (this.accessibleFocusHandler != null) {
                this.removeFocusListener(this.accessibleFocusHandler);
                this.accessibleFocusHandler = null;
            }
            super.removePropertyChangeListener(listener);
        }

        public int getAccessibleChildrenCount() {
            return super.getAccessibleChildrenCount();
        }

        public Accessible getAccessibleChild(int i) {
            return super.getAccessibleChild(i);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet state = super.getAccessibleStateSet();
            if (JComponent.this.isOpaque()) {
                state.add(AccessibleState.OPAQUE);
            }
            return state;
        }

        public String getAccessibleName() {
            Object l;
            String name = super.getAccessibleName();
            if (name == null) {
                name = this.getTitledBorderText();
            }
            if (name == null && (l = JComponent.this.getClientProperty("labeledBy")) instanceof Accessible) {
                AccessibleContext labelCtx = ((Accessible)l).getAccessibleContext();
                name = labelCtx.getAccessibleName();
            }
            return name;
        }

        public String getAccessibleDescription() {
            Object l;
            String descr = super.getAccessibleDescription();
            if (descr == null) {
                descr = this.getToolTipText();
            }
            if (descr == null && (l = JComponent.this.getClientProperty("labeledBy")) instanceof Accessible) {
                AccessibleContext labelCtx = ((Accessible)l).getAccessibleContext();
                descr = labelCtx.getAccessibleName();
            }
            return descr;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        protected String getBorderTitle(Border border) {
            String title = null;
            if (border instanceof CompoundBorder) {
                CompoundBorder compound = (CompoundBorder)border;
                Border inner = compound.getInsideBorder();
                title = this.getBorderTitle(inner);
                if (title == null) {
                    Border outer = compound.getOutsideBorder();
                    title = this.getBorderTitle(outer);
                }
            } else if (border instanceof TitledBorder) {
                TitledBorder titled = (TitledBorder)border;
                title = titled.getTitle();
            }
            return title;
        }

        public String getToolTipText() {
            return JComponent.this.getToolTipText();
        }

        public String getTitledBorderText() {
            return this.getBorderTitle(JComponent.this.getBorder());
        }

        public AccessibleKeyBinding getAccessibleKeyBinding() {
            return null;
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            public void componentAdded(ContainerEvent event) {
                Component c = event.getChild();
                if (c != null && c instanceof Accessible) {
                    AccessibleContext childCtx = c.getAccessibleContext();
                    AccessibleJComponent.this.firePropertyChange("AccessibleChild", null, childCtx);
                }
            }

            public void componentRemoved(ContainerEvent event) {
                Component c = event.getChild();
                if (c != null && c instanceof Accessible) {
                    AccessibleContext childCtx = c.getAccessibleContext();
                    AccessibleJComponent.this.firePropertyChange("AccessibleChild", childCtx, null);
                }
            }
        }

        protected class AccessibleFocusHandler
        implements FocusListener {
            protected AccessibleFocusHandler() {
            }

            public void focusGained(FocusEvent event) {
                AccessibleJComponent.this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }

            public void focusLost(FocusEvent valevent) {
                AccessibleJComponent.this.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
        }
    }

    private static class ActionListenerProxy
    extends AbstractAction {
        ActionListener target;
        String bindingCommandName;

        public ActionListenerProxy(ActionListener li, String cmd) {
            this.target = li;
            this.bindingCommandName = cmd;
        }

        public void actionPerformed(ActionEvent e) {
            ActionEvent derivedEvent = new ActionEvent(e.getSource(), e.getID(), this.bindingCommandName, e.getModifiers());
            this.target.actionPerformed(derivedEvent);
        }
    }
}

