/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.dom.DomDocument;
import gnu.xml.transform.SAXTemplatesHandler;
import gnu.xml.transform.SAXTransformerHandler;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplatesImpl;
import gnu.xml.transform.TransformerImpl;
import gnu.xml.transform.TransformerOutputProperties;
import gnu.xml.transform.XSLURIResolver;
import gnu.xml.xpath.XPathFactoryImpl;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.XMLFilter;

public class TransformerFactoryImpl
extends SAXTransformerFactory {
    final XPathFactory xpathFactory = new XPathFactoryImpl();
    final XSLURIResolver resolver = new XSLURIResolver();
    ErrorListener userListener;
    URIResolver userResolver;

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        TransformerImpl transformer2;
        Stylesheet stylesheet = this.newStylesheet(source, 0, null);
        TransformerOutputProperties outputProperties = new TransformerOutputProperties(stylesheet);
        stylesheet.transformer = transformer2 = new TransformerImpl(this, stylesheet, outputProperties);
        return transformer2;
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new TransformerImpl(this, null, new Properties());
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        Stylesheet stylesheet = this.newStylesheet(source, 0, null);
        return new TemplatesImpl(this, stylesheet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Stylesheet newStylesheet(Source source, int precedence, Stylesheet parent) throws TransformerConfigurationException {
        Document doc = null;
        String systemId = null;
        if (source != null) {
            try {
                DOMSource ds;
                XSLURIResolver xSLURIResolver = this.resolver;
                synchronized (xSLURIResolver) {
                    this.resolver.setUserResolver(this.userResolver);
                    this.resolver.setUserListener(this.userListener);
                    ds = this.resolver.resolveDOM(source, null, null);
                }
                Node node2 = ds.getNode();
                if (node2 == null) {
                    throw new TransformerConfigurationException("no source document");
                }
                doc = node2 instanceof Document ? (Document)node2 : node2.getOwnerDocument();
                systemId = ds.getSystemId();
            }
            catch (TransformerException e) {
                throw new TransformerConfigurationException(e);
            }
        }
        return new Stylesheet(this, parent, doc, systemId, precedence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Source getAssociatedStylesheet(Source source, String media, String title, String charset) throws TransformerConfigurationException {
        try {
            DOMSource ds;
            XSLURIResolver xSLURIResolver = this.resolver;
            synchronized (xSLURIResolver) {
                this.resolver.setUserResolver(this.userResolver);
                this.resolver.setUserListener(this.userListener);
                ds = this.resolver.resolveDOM(source, null, null);
            }
            Node node2 = ds.getNode();
            if (node2 == null) {
                throw new TransformerConfigurationException("no source document");
            }
            Document doc = node2 instanceof Document ? (Document)node2 : node2.getOwnerDocument();
            LinkedList<URL> matches = new LinkedList<URL>();
            node2 = doc.getFirstChild();
            while (node2 != null) {
                if (node2.getNodeType() == 7 && "xml-stylesheet".equals(node2.getNodeName())) {
                    Map params = this.parseParameters(node2.getNodeValue());
                    if (!(media != null && !media.equals(params.get("media")) || title != null && !title.equals(params.get("title")) || charset != null && !charset.equals(params.get("charset")))) {
                        String href = (String)params.get("href");
                        URL url = this.resolver.resolveURL(null, node2.getBaseURI(), href);
                        matches.add(url);
                    }
                }
                node2 = node2.getNextSibling();
            }
            switch (matches.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return new StreamSource(((URL)matches.getFirst()).toString());
                }
            }
            DomDocument ssDoc = new DomDocument();
            ssDoc.setBuilding(true);
            Element root = ssDoc.createElementNS("http://www.w3.org/1999/XSL/Transform", "stylesheet");
            Attr version = ssDoc.createAttributeNS(null, "version");
            version.setNodeValue("1.0");
            root.getAttributes().setNamedItemNS(version);
            ssDoc.appendChild(root);
            for (URL url : matches) {
                Element imp = ssDoc.createElementNS("http://www.w3.org/1999/XSL/Transform", "import");
                Attr href = ssDoc.createAttributeNS(null, "href");
                href.setNodeValue(url.toString());
                imp.getAttributes().setNamedItemNS(href);
                root.appendChild(imp);
            }
            ssDoc.setBuilding(false);
            return new DOMSource(ssDoc);
        }
        catch (IOException e) {
            throw new TransformerConfigurationException(e);
        }
        catch (TransformerException e) {
            throw new TransformerConfigurationException(e);
        }
    }

    Map parseParameters(String data) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        int len = data.length();
        String key = null;
        int start = 0;
        char quoteChar = '\u0000';
        int i = 0;
        while (i < len) {
            char c = data.charAt(i);
            if (quoteChar == '\u0000' && c == ' ') {
                if (key == null && start < i) {
                    key = data.substring(start, i);
                } else {
                    String val = this.unquote(data.substring(start, i).trim());
                    ret.put(key, val);
                    key = null;
                }
                start = i + 1;
            } else if (c == '\"') {
                quoteChar = quoteChar == c ? (char)'\u0000' : c;
            } else if (c == '\'') {
                quoteChar = quoteChar == c ? (char)'\u0000' : c;
            }
            ++i;
        }
        if (start < len && key != null) {
            String val = this.unquote(data.substring(start, len).trim());
            ret.put(key, val);
        }
        return ret;
    }

    String unquote(String text) {
        int end = text.length() - 1;
        if (text.charAt(0) == '\'' && text.charAt(end) == '\'') {
            return text.substring(1, end);
        }
        if (text.charAt(0) == '\"' && text.charAt(end) == '\"') {
            return text.substring(1, end);
        }
        return text;
    }

    public void setURIResolver(URIResolver resolver) {
        this.userResolver = resolver;
    }

    public URIResolver getURIResolver() {
        return this.userResolver;
    }

    public void setFeature(String name, boolean value) throws TransformerConfigurationException {
        throw new TransformerConfigurationException("not supported");
    }

    public boolean getFeature(String name) {
        return "http://javax.xml.transform.sax.SAXSource/feature".equals(name) || "http://javax.xml.transform.sax.SAXResult/feature".equals(name) || "http://javax.xml.transform.stream.StreamSource/feature".equals(name) || "http://javax.xml.transform.stream.StreamResult/feature".equals(name) || "http://javax.xml.transform.dom.DOMSource/feature".equals(name) || "http://javax.xml.transform.dom.DOMResult/feature".equals(name) || "http://javax.xml.transform.sax.SAXTransformerFactory/feature".equals(name);
    }

    public void setAttribute(String name, Object value) throws IllegalArgumentException {
        throw new IllegalArgumentException("not supported");
    }

    public Object getAttribute(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException("not supported");
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        this.userListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.userListener;
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new SAXTemplatesHandler(this);
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        Transformer transformer2 = this.newTransformer();
        return new SAXTransformerHandler(this, transformer2);
    }

    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        Transformer transformer2 = this.newTransformer(source);
        return new SAXTransformerHandler(this, transformer2);
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        Transformer transformer2 = templates.newTransformer();
        return new SAXTransformerHandler(this, transformer2);
    }

    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        throw new UnsupportedOperationException();
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) throws Exception {
        InputStream stylesheet = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            if (args.length > 0) {
                stylesheet = new FileInputStream(args[0]);
                if (args.length > 1) {
                    in = new FileInputStream(args[1]);
                    if (args.length > 2) {
                        out = new FileOutputStream(args[2]);
                    }
                }
            }
            if (in == null) {
                in = System.in;
            }
            if (out == null) {
                out = System.out;
            }
            TransformerFactoryImpl f = new TransformerFactoryImpl();
            Transformer t = stylesheet != null ? ((TransformerFactory)f).newTransformer(new StreamSource(stylesheet)) : ((TransformerFactory)f).newTransformer();
            t.transform(new StreamSource(in), new StreamResult(out));
        }
        finally {
            if (stylesheet != null) {
                stylesheet.close();
            }
            if (in != null && in instanceof FileInputStream) {
                in.close();
            }
            if (out != null && out instanceof FileOutputStream) {
                out.close();
            }
        }
    }
}

