/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.print.ipp;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.javax.print.ipp.IppDelimiterTag;
import gnu.javax.print.ipp.IppException;
import gnu.javax.print.ipp.IppUtilities;
import gnu.javax.print.ipp.attribute.UnknownAttribute;
import gnu.javax.print.ipp.attribute.defaults.DocumentFormatDefault;
import gnu.javax.print.ipp.attribute.defaults.JobHoldUntilDefault;
import gnu.javax.print.ipp.attribute.defaults.JobSheetsDefault;
import gnu.javax.print.ipp.attribute.defaults.MediaDefault;
import gnu.javax.print.ipp.attribute.defaults.PrinterResolutionDefault;
import gnu.javax.print.ipp.attribute.job.AttributesCharset;
import gnu.javax.print.ipp.attribute.job.AttributesNaturalLanguage;
import gnu.javax.print.ipp.attribute.job.JobMoreInfo;
import gnu.javax.print.ipp.attribute.job.JobPrinterUri;
import gnu.javax.print.ipp.attribute.job.JobUri;
import gnu.javax.print.ipp.attribute.printer.CharsetConfigured;
import gnu.javax.print.ipp.attribute.printer.DocumentFormat;
import gnu.javax.print.ipp.attribute.printer.NaturalLanguageConfigured;
import gnu.javax.print.ipp.attribute.printer.PrinterCurrentTime;
import gnu.javax.print.ipp.attribute.printer.PrinterDriverInstaller;
import gnu.javax.print.ipp.attribute.supported.CharsetSupported;
import gnu.javax.print.ipp.attribute.supported.DocumentFormatSupported;
import gnu.javax.print.ipp.attribute.supported.GeneratedNaturalLanguageSupported;
import gnu.javax.print.ipp.attribute.supported.JobHoldUntilSupported;
import gnu.javax.print.ipp.attribute.supported.JobSheetsSupported;
import gnu.javax.print.ipp.attribute.supported.MediaSupported;
import gnu.javax.print.ipp.attribute.supported.PrinterResolutionSupported;
import gnu.javax.print.ipp.attribute.supported.PrinterUriSupported;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.print.attribute.Attribute;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.DateTimeAtCompleted;
import javax.print.attribute.standard.DateTimeAtCreation;
import javax.print.attribute.standard.DateTimeAtProcessing;
import javax.print.attribute.standard.JobImpressionsSupported;
import javax.print.attribute.standard.JobKOctetsSupported;
import javax.print.attribute.standard.JobMediaSheetsSupported;
import javax.print.attribute.standard.JobStateReason;
import javax.print.attribute.standard.JobStateReasons;
import javax.print.attribute.standard.NumberUpSupported;
import javax.print.attribute.standard.PrinterMoreInfo;
import javax.print.attribute.standard.PrinterMoreInfoManufacturer;
import javax.print.attribute.standard.PrinterStateReason;
import javax.print.attribute.standard.PrinterStateReasons;
import javax.print.attribute.standard.Severity;

public class IppResponse {
    static final Logger logger = SystemLogger.SYSTEM;
    URI uri;
    short operation_id;
    short status_code;
    int request_id;
    List operationAttributes;
    List printerAttributes;
    List jobAttributes;
    List unsupportedAttributes;
    byte[] data;

    public IppResponse(URI uri, short operation_id) {
        this.uri = uri;
        this.operation_id = operation_id;
        this.operationAttributes = new ArrayList();
        this.jobAttributes = new ArrayList();
        this.printerAttributes = new ArrayList();
        this.unsupportedAttributes = new ArrayList();
    }

    protected void setResponseData(InputStream input) throws IppException {
        ResponseReader reader = new ResponseReader();
        try {
            reader.parseResponse(input);
        }
        catch (IOException e) {
            throw new IppException("Exception during response parsing caused by IOException", e);
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public int getOperationID() {
        return this.operation_id;
    }

    public List getJobAttributes() {
        return this.jobAttributes;
    }

    public List getOperationAttributes() {
        return this.operationAttributes;
    }

    public List getPrinterAttributes() {
        return this.printerAttributes;
    }

    public int getRequestID() {
        return this.request_id;
    }

    public short getStatusCode() {
        return this.status_code;
    }

    public List getUnsupportedAttributes() {
        return this.unsupportedAttributes;
    }

    public byte[] getData() {
        return this.data;
    }

    class ResponseReader {
        private static final short VERSION = 257;

        ResponseReader() {
        }

        public void parseResponse(InputStream input) throws IppException, IOException {
            DataInputStream stream = new DataInputStream(input);
            short version = stream.readShort();
            IppResponse.this.status_code = stream.readShort();
            IppResponse.this.request_id = stream.readInt();
            if (257 != version) {
                throw new IppException("Version mismatch - implementation does not support other versions than IPP 1.1");
            }
            logger.log(Component.IPP, "Statuscode: " + Integer.toHexString(IppResponse.this.status_code) + " Request-ID: " + IppResponse.this.request_id);
            byte tag = 0;
            boolean proceed = true;
            while (proceed) {
                if (tag == 0) {
                    tag = stream.readByte();
                }
                logger.log(Component.IPP, "DelimiterTag: " + Integer.toHexString(tag));
                switch (tag) {
                    case 3: {
                        proceed = false;
                        break;
                    }
                    case 1: {
                        HashMap tmp = new HashMap();
                        tag = this.parseAttributes(tmp, stream);
                        IppResponse.this.operationAttributes.add(tmp);
                        break;
                    }
                    case 2: {
                        HashMap tmp = new HashMap();
                        tag = this.parseAttributes(tmp, stream);
                        IppResponse.this.jobAttributes.add(tmp);
                        break;
                    }
                    case 4: {
                        HashMap tmp = new HashMap();
                        tag = this.parseAttributes(tmp, stream);
                        IppResponse.this.printerAttributes.add(tmp);
                        break;
                    }
                    case 5: {
                        System.out.println("Called");
                        HashMap tmp = new HashMap();
                        tag = this.parseAttributes(tmp, stream);
                        IppResponse.this.unsupportedAttributes.add(tmp);
                        break;
                    }
                    default: {
                        throw new IppException("Unknown tag with value " + Integer.toHexString(tag) + " occured.");
                    }
                }
            }
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            byte[] readbuf = new byte[2048];
            int len = 0;
            while ((len = stream.read(readbuf)) > 0) {
                byteStream.write(readbuf, 0, len);
            }
            byteStream.flush();
            IppResponse.this.data = byteStream.toByteArray();
        }

        private byte parseAttributes(Map attributes, DataInputStream stream) throws IppException, IOException {
            Attribute lastAttribute = null;
            Attribute attribute = null;
            byte tag;
            while (!IppDelimiterTag.isDelimiterTag(tag = stream.readByte())) {
                String name;
                short nameLength = stream.readShort();
                if (nameLength == 0) {
                    name = lastAttribute.getName();
                } else {
                    byte[] nameBytes = new byte[nameLength];
                    stream.read(nameBytes);
                    name = new String(nameBytes);
                }
                short valueLength = stream.readShort();
                byte[] value = new byte[valueLength];
                stream.read(value);
                switch (tag) {
                    case 16: 
                    case 18: 
                    case 19: {
                        throw new IppException("Unexpected name value for out-of-band value tag");
                    }
                    case 33: {
                        int intValue = IppUtilities.convertToInt(value);
                        attribute = IppUtilities.getIntegerAttribute(name, intValue);
                        break;
                    }
                    case 34: {
                        attribute = IppUtilities.getEnumAttribute(name, new Integer(value[0]));
                        break;
                    }
                    case 35: {
                        int intVal = IppUtilities.convertToInt(value);
                        attribute = IppUtilities.getEnumAttribute(name, new Integer(intVal));
                        break;
                    }
                    case 48: {
                        throw new IppException("Unspecified octet string occured.");
                    }
                    case 49: {
                        Date date = this.parseDate(value);
                        if (name.equals("printer-current-time")) {
                            attribute = new PrinterCurrentTime(date);
                            break;
                        }
                        if (name.equals("date-time-at-creation")) {
                            attribute = new DateTimeAtCreation(date);
                            break;
                        }
                        if (name.equals("date-time-at-processing")) {
                            attribute = new DateTimeAtProcessing(date);
                            break;
                        }
                        if (!name.equals("date-time-at-completed")) break;
                        attribute = new DateTimeAtCompleted(date);
                        break;
                    }
                    case 50: {
                        int crossFeed = IppUtilities.convertToInt(value[0], value[1], value[2], value[3]);
                        int feed = IppUtilities.convertToInt(value[4], value[5], value[6], value[7]);
                        byte units = value[8];
                        if (name.equals("printer-resolution-default")) {
                            attribute = new PrinterResolutionDefault(crossFeed, feed, units);
                            break;
                        }
                        if (!name.equals("printer-resolution-supported")) break;
                        attribute = new PrinterResolutionSupported(crossFeed, feed, units);
                        break;
                    }
                    case 51: {
                        int lower = IppUtilities.convertToInt(value[0], value[1], value[2], value[3]);
                        int upper = IppUtilities.convertToInt(value[4], value[5], value[6], value[7]);
                        if (name.equals("copies-supported")) {
                            attribute = new CopiesSupported(lower, upper);
                            break;
                        }
                        if (name.equals("number-up-supported")) {
                            attribute = new NumberUpSupported(lower, upper);
                            break;
                        }
                        if (name.equals("job-k-octets-supported")) {
                            attribute = new JobKOctetsSupported(lower, upper);
                            break;
                        }
                        if (name.equals("job-impressions-supported")) {
                            attribute = new JobImpressionsSupported(lower, upper);
                            break;
                        }
                        if (!name.equals("job-media-sheets-supported")) break;
                        attribute = new JobMediaSheetsSupported(lower, upper);
                        break;
                    }
                    case 53: 
                    case 54: 
                    case 65: 
                    case 66: {
                        attribute = IppUtilities.getTextAttribute(name, tag, value);
                        break;
                    }
                    case 68: {
                        String str = new String(value);
                        if (name.equals("job-hold-until-supported")) {
                            attribute = new JobHoldUntilSupported(str, null);
                            break;
                        }
                        if (name.equals("job-hold-until-default")) {
                            attribute = new JobHoldUntilDefault(str, null);
                            break;
                        }
                        if (name.equals("media-supported")) {
                            attribute = new MediaSupported(str, null);
                            break;
                        }
                        if (name.equals("media-default")) {
                            attribute = new MediaDefault(str, null);
                            break;
                        }
                        if (name.equals("job-sheets-default")) {
                            attribute = new JobSheetsDefault(str, null);
                            break;
                        }
                        if (name.equals("job-sheets-supported")) {
                            attribute = new JobSheetsSupported(str, null);
                            break;
                        }
                        if (name.equals("job-state-reasons")) {
                            attribute = this.parseJobStateReasons(value, lastAttribute);
                            break;
                        }
                        if (name.equals("printer-state-reasons")) {
                            attribute = this.parsePrinterStateReasons(value, lastAttribute);
                            break;
                        }
                        attribute = IppUtilities.getEnumAttribute(name, str);
                        break;
                    }
                    case 69: {
                        URI uri;
                        try {
                            uri = new URI(new String(value));
                        }
                        catch (URISyntaxException e) {
                            throw new IppException("Wrong URI syntax encountered.", e);
                        }
                        if (name.equals("job-uri")) {
                            attribute = new JobUri(uri);
                            break;
                        }
                        if (name.equals("job-printer-uri")) {
                            attribute = new JobPrinterUri(uri);
                            break;
                        }
                        if (name.equals("job-more-info")) {
                            attribute = new JobMoreInfo(uri);
                            break;
                        }
                        if (name.equals("printer-uri-supported")) {
                            attribute = new PrinterUriSupported(uri);
                            break;
                        }
                        if (name.equals("printer-more-info")) {
                            attribute = new PrinterMoreInfo(uri);
                            break;
                        }
                        if (name.equals("printer-driver-installer")) {
                            attribute = new PrinterDriverInstaller(uri);
                            break;
                        }
                        if (!name.equals("printer-more-info-manufacturer")) break;
                        attribute = new PrinterMoreInfoManufacturer(uri);
                        break;
                    }
                    case 70: {
                        if (!name.equals("reference-uri-schemes-supported")) break;
                        attribute = IppUtilities.getEnumAttribute(name, new String(value));
                        break;
                    }
                    case 71: {
                        String str = new String(value);
                        if (name.equals("attributes-charset")) {
                            attribute = new AttributesCharset(str);
                            break;
                        }
                        if (name.equals("charset-configured")) {
                            attribute = new CharsetConfigured(str);
                            break;
                        }
                        if (!name.equals("charset-supported")) break;
                        attribute = new CharsetSupported(str);
                        break;
                    }
                    case 72: {
                        String str = new String(value);
                        if (name.equals("attributes-natural-language")) {
                            attribute = new AttributesNaturalLanguage(str);
                            break;
                        }
                        if (name.equals("natural-language-configured")) {
                            attribute = new NaturalLanguageConfigured(str);
                            break;
                        }
                        if (!name.equals("generated-natural-language-supported")) break;
                        attribute = new GeneratedNaturalLanguageSupported(str);
                        break;
                    }
                    case 73: {
                        String str = new String(value);
                        if (name.equals("document-format-default")) {
                            attribute = new DocumentFormatDefault(str, null);
                            break;
                        }
                        if (name.equals("document-format-supported")) {
                            attribute = new DocumentFormatSupported(str, null);
                            break;
                        }
                        if (!name.equals("document-format")) break;
                        attribute = new DocumentFormat(str, null);
                        break;
                    }
                    default: {
                        throw new IppException("Unknown tag with value " + Integer.toHexString(tag) + " found.");
                    }
                }
                if (attribute == null) {
                    attribute = new UnknownAttribute(tag, name, value);
                }
                this.addAttribute(attributes, attribute);
                lastAttribute = attribute;
                logger.log(Component.IPP, "Attribute: " + name + " Value: " + attribute.toString());
            }
            return tag;
        }

        private void addAttribute(Map attributeGroup, Attribute attribute) {
            Class<? extends Attribute> clazz = attribute.getCategory();
            HashSet attributeValues = (HashSet)attributeGroup.get(clazz);
            if (attributeValues == null) {
                attributeValues = new HashSet();
                attributeGroup.put(clazz, attributeValues);
            }
            attributeValues.add(attribute);
        }

        private PrinterStateReasons parsePrinterStateReasons(byte[] value, Attribute lastAttr) {
            String str = new String(value);
            PrinterStateReasons attribute = lastAttr instanceof PrinterStateReasons ? (PrinterStateReasons)lastAttr : new PrinterStateReasons();
            if (str.equals("none")) {
                return attribute;
            }
            Severity severity = null;
            PrinterStateReason reason = null;
            if (str.endsWith(Severity.WARNING.toString())) {
                severity = Severity.WARNING;
            } else if (str.endsWith(Severity.REPORT.toString())) {
                severity = Severity.REPORT;
            } else if (str.endsWith(Severity.ERROR.toString())) {
                severity = Severity.ERROR;
            }
            if (severity != null) {
                str = str.substring(0, str.lastIndexOf(45));
            } else {
                severity = Severity.REPORT;
            }
            reason = (PrinterStateReason)IppUtilities.getEnumAttribute("printer-state-reason", str);
            attribute.put(reason, severity);
            return attribute;
        }

        private JobStateReasons parseJobStateReasons(byte[] value, Attribute lastAttr) {
            String str = new String(value);
            JobStateReasons attribute = lastAttr instanceof JobStateReasons ? (JobStateReasons)lastAttr : new JobStateReasons();
            if (str.equals("none")) {
                return attribute;
            }
            JobStateReason reason = (JobStateReason)IppUtilities.getEnumAttribute("job-state-reason", str);
            attribute.add(reason);
            return attribute;
        }

        private Date parseDate(byte[] value) {
            short year = IppUtilities.convertToShort(value[0], value[1]);
            Calendar cal = Calendar.getInstance();
            cal.set(1, year);
            cal.set(2, value[2]);
            cal.set(5, value[3]);
            cal.set(11, value[4]);
            cal.set(12, value[5]);
            cal.set(13, value[6]);
            cal.set(14, value[7] * 100);
            int offsetMilli = value[9] * 3600000;
            offsetMilli += value[10] * 60000;
            if ((char)value[8] == '-') {
                offsetMilli *= -1;
            }
            cal.set(15, offsetMilli);
            return cal.getTime();
        }
    }
}

