/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.ServerKeyExchange;
import java.nio.ByteBuffer;

public class ServerKeyExchangeBuilder
extends ServerKeyExchange
implements Builder {
    public ServerKeyExchangeBuilder(CipherSuite suite) {
        super(ByteBuffer.allocate(1024), suite);
    }

    public ByteBuffer buffer() {
        return ((ByteBuffer)this.buffer.duplicate().position(0).limit(this.length())).slice();
    }

    public void setParams(ByteBuffer params) {
        if (this.suite.keyExchangeAlgorithm() == KeyExchangeAlgorithm.NONE) {
            throw new IllegalArgumentException("key exchange algorithm is none");
        }
        this.ensureCapacity(params.remaining());
        this.buffer.duplicate().put(params);
    }

    public void setSignature(ByteBuffer signature) {
        if (this.suite.keyExchangeAlgorithm() == KeyExchangeAlgorithm.NONE) {
            throw new IllegalArgumentException("key exchange algorithm is none");
        }
        int paramsLen = this.params().length();
        this.ensureCapacity(paramsLen + signature.remaining());
        ((ByteBuffer)this.buffer.duplicate().position(paramsLen)).put(signature);
    }

    public void ensureCapacity(int capacity) {
        if (this.buffer.capacity() >= capacity) {
            return;
        }
        ByteBuffer newBuffer = ByteBuffer.allocate(capacity);
        newBuffer.duplicate().put(this.buffer);
        this.buffer = newBuffer;
    }
}

