/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.java.security.util.ByteBufferOutputStream;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ContentType;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Record;
import gnu.javax.net.ssl.provider.SessionImpl;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;

public class OutputSecurityParameters {
    private static final SystemLogger logger = SystemLogger.SYSTEM;
    private final Cipher cipher;
    private final Mac mac;
    private final Deflater deflater;
    private final SessionImpl session;
    private final CipherSuite suite;
    private long sequence;

    public OutputSecurityParameters(Cipher cipher, Mac mac, Deflater deflater, SessionImpl session, CipherSuite suite) {
        this.cipher = cipher;
        this.mac = mac;
        this.deflater = deflater;
        this.session = session;
        this.suite = suite;
        this.sequence = 0L;
    }

    public int[] encrypt(ByteBuffer[] input, int offset, int length, ContentType contentType, ByteBuffer output) throws DataFormatException, IllegalBlockSizeException, ShortBufferException {
        int i;
        int l;
        int i2;
        if (offset < 0 || offset >= input.length || length <= 0 || offset + length > input.length) {
            throw new IndexOutOfBoundsException();
        }
        int i3 = offset;
        while (i3 < offset + length) {
            logger.logv(Component.SSL_RECORD_LAYER, "encrypting record [{0}]: {1}", i3 - offset, input[i3]);
            ++i3;
        }
        int maclen = 0;
        if (this.mac != null) {
            maclen = this.session.isTruncatedMac() ? 10 : this.mac.getMacLength();
        }
        int ivlen = 0;
        byte[] iv = null;
        if (this.session.version.compareTo(ProtocolVersion.TLS_1_1) >= 0 && !this.suite.isStreamCipher()) {
            ivlen = this.cipher.getBlockSize();
            iv = new byte[ivlen];
            this.session.random().nextBytes(iv);
        }
        int padaddlen = 0;
        if (!this.suite.isStreamCipher() && this.session.version.compareTo(ProtocolVersion.TLS_1) >= 0) {
            padaddlen = this.session.random().nextInt(255 / this.cipher.getBlockSize()) * this.cipher.getBlockSize();
        }
        int fragmentLength = 0;
        ByteBuffer[] fragments = null;
        if (this.deflater != null) {
            ByteBufferOutputStream deflated = new ByteBufferOutputStream();
            byte[] inbuf = new byte[1024];
            byte[] outbuf = new byte[1024];
            int written = 0;
            int limit = output.remaining() - (maclen + ivlen + padaddlen) - 1024;
            i2 = offset;
            while (i2 < length && written < limit) {
                ByteBuffer in = input[i2];
                while (in.hasRemaining() && written < limit) {
                    l = Math.min(in.remaining(), inbuf.length);
                    l = Math.min(limit - written, l);
                    in.get(inbuf, 0, l);
                    this.deflater.setInput(inbuf, 0, l);
                    l = this.deflater.deflate(outbuf);
                    deflated.write(outbuf, 0, l);
                    written += l;
                }
                ++i2;
            }
            this.deflater.finish();
            while (!this.deflater.finished()) {
                int l2 = this.deflater.deflate(outbuf);
                deflated.write(outbuf, 0, l2);
                written += l2;
            }
            fragments = new ByteBuffer[]{deflated.buffer()};
            fragmentLength = (int)this.deflater.getBytesWritten() + maclen + ivlen;
            this.deflater.reset();
            offset = 0;
            length = 1;
        } else {
            int limit = output.remaining() - (maclen + ivlen + padaddlen);
            fragments = input;
            int i4 = offset;
            while (i4 < length && fragmentLength < limit) {
                int l3 = Math.min(limit - fragmentLength, fragments[i4].remaining());
                fragmentLength += l3;
                ++i4;
            }
            fragmentLength += maclen + ivlen;
        }
        int padlen = 0;
        byte[] pad = null;
        if (!this.suite.isStreamCipher()) {
            int bs = this.cipher.getBlockSize();
            padlen = bs - fragmentLength % bs;
            logger.logv(Component.SSL_RECORD_LAYER, "framentLen:{0} padlen:{1} blocksize:{2}", fragmentLength, padlen, bs);
            if (this.session.version.compareTo(ProtocolVersion.TLS_1) >= 0) {
                padlen += padaddlen;
                while (padlen > 255) {
                    padlen -= bs;
                }
                pad = new byte[padlen];
                int i5 = 0;
                while (i5 < padlen) {
                    pad[i5] = (byte)(padlen - 1);
                    ++i5;
                }
            } else {
                pad = new byte[padlen];
                this.session.random().nextBytes(pad);
                pad[padlen - 1] = (byte)(padlen - 1);
            }
            fragmentLength += pad.length;
        }
        byte[] macValue = null;
        if (this.mac != null) {
            this.mac.update((byte)(this.sequence >>> 56));
            this.mac.update((byte)(this.sequence >>> 48));
            this.mac.update((byte)(this.sequence >>> 40));
            this.mac.update((byte)(this.sequence >>> 32));
            this.mac.update((byte)(this.sequence >>> 24));
            this.mac.update((byte)(this.sequence >>> 16));
            this.mac.update((byte)(this.sequence >>> 8));
            this.mac.update((byte)this.sequence);
            this.mac.update((byte)contentType.getValue());
            if (this.session.version != ProtocolVersion.SSL_3) {
                this.mac.update((byte)this.session.version.major());
                this.mac.update((byte)this.session.version.minor());
            }
            int toWrite = fragmentLength - maclen - ivlen - padlen;
            this.mac.update((byte)(toWrite >>> 8));
            this.mac.update((byte)toWrite);
            int written = 0;
            i2 = offset;
            while (i2 < length && written < toWrite) {
                ByteBuffer fragment = fragments[i2].duplicate();
                l = Math.min(fragment.remaining(), toWrite - written);
                fragment.limit(fragment.position() + l);
                this.mac.update(fragment);
                ++i2;
            }
            macValue = this.mac.doFinal();
        }
        Record outrecord = new Record(output);
        outrecord.setContentType(contentType);
        outrecord.setVersion(this.session.version);
        outrecord.setLength(fragmentLength);
        int consumed = 0;
        ByteBuffer outfragment = outrecord.fragment();
        if (this.cipher != null) {
            if (iv != null) {
                this.cipher.update(ByteBuffer.wrap(iv), outfragment);
            }
            int toWrite = fragmentLength - maclen - ivlen - padlen;
            i = offset;
            while (i < offset + length && consumed < toWrite) {
                ByteBuffer fragment = fragments[i].slice();
                int l4 = Math.min(fragment.remaining(), toWrite - consumed);
                fragment.limit(fragment.position() + l4);
                this.cipher.update(fragment, outfragment);
                fragments[i].position(fragments[i].position() + l4);
                consumed += l4;
                ++i;
            }
            if (macValue != null) {
                this.cipher.update(ByteBuffer.wrap(macValue), outfragment);
            }
            if (pad != null) {
                this.cipher.update(ByteBuffer.wrap(pad), outfragment);
            }
        } else {
            int toWrite = fragmentLength - maclen;
            i = offset;
            while (i < offset + length && consumed < toWrite) {
                ByteBuffer fragment = fragments[i];
                int l5 = Math.min(fragment.remaining(), toWrite - consumed);
                fragment.limit(fragment.position() + l5);
                outfragment.put(fragment);
                consumed += l5;
                ++i;
            }
            if (macValue != null) {
                outfragment.put(macValue);
            }
        }
        output.position(output.position() + outrecord.length() + 5);
        ++this.sequence;
        return new int[]{consumed, fragmentLength + 5};
    }

    CipherSuite suite() {
        return this.suite;
    }
}

