/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.locale;

import gnu.java.locale.LocaleData;
import java.util.Locale;

public class LocaleHelper {
    public static Locale getFallbackLocale(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        int uscore = variant.indexOf(95);
        if (uscore != -1) {
            return new Locale(language, country, variant.substring(0, uscore));
        }
        if (!variant.isEmpty()) {
            return new Locale(language, country, "");
        }
        if (!country.isEmpty()) {
            return new Locale(language, "", "");
        }
        return Locale.ROOT;
    }

    public static Locale[] getCollatorLocales() {
        if (LocaleData.collatorLocaleNames.length == 0) {
            return new Locale[]{Locale.US};
        }
        Locale[] result = new Locale[LocaleData.collatorLocaleNames.length];
        int i = 0;
        while (i < result.length) {
            int index;
            String region = "";
            String variant = "";
            String name = LocaleData.collatorLocaleNames[i];
            String language = name.substring(0, 2);
            if (name.length() > 2) {
                region = name.substring(3);
            }
            if ((index = region.indexOf("_")) > 0) {
                variant = region.substring(index + 1);
                region = region.substring(0, index - 1);
            }
            result[i] = new Locale(language, region, variant);
            ++i;
        }
        return result;
    }

    public static int getLocaleCount() {
        return LocaleData.localeNames.length;
    }

    public static String getLocaleName(int n) {
        return LocaleData.localeNames[n];
    }
}

