/*
 * linux/include/linux/fb_widechar.h
 *
 * Copyright (C) 1999		Christopher Li, Jim Chen
 *				GNU/Linux Research Center
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file COPYING in the main directory of this archive
 * for more details.
 *
 *
 */

#ifndef _LINUX_FB_DOUBLEBYTE_H
#define _LINUX_FB_DOUBLEBYTE_H

#include <linux/proc_fs.h>
#include <linux/tty.h>
#include <linux/vt_kern.h>

#define DB_VALIDATE	0x8000
#define DB_RIGHT_MASK 	0x4000
#define DB_HALF_MASK	0x2000
#define DB_SYMBOL       0x1000
#define DB_ASCII	0

#define DB_RIGHT 	(DB_VALIDATE|DB_RIGHT_MASK)
#define DB_LEFT		(DB_VALIDATE)
#define DB_NUM		8

#define DB_INDEX_ERROR -512
struct double_byte
{
	unsigned int	num;
	char 		name[16];
	int 		(*is_left)(int );
	int 		(*is_right)(int );
	int 		(*font_index)(int left,int right);
	unsigned int   	width,height;	/* right now only support 16x16 */
	int		charcount;
	unsigned char * font_data;
};

extern void fbcon_putc (struct vc_data *conp, int c, int ypos, int xpos);

#define MAX_TTY        6
#define MAX_FONT       7

/* font_type */
#define XL_DB_GB       0
#define XL_DB_BIG5     1
#define XL_DB_JIS      2
#define XL_DB_KSCM     3
#define XL_DB_GBK      4
#define XL_DB_EUCJP    5
#define XL_DB_SJIS     6

// typedef void *         double_byte;
// typedef unsigned char  UCHAR;

typedef struct DBFontManager_T
{
    void          (*init) (void);

    /* Font Register Manager */
    int           (*registerfont) (int font_type, struct double_byte *p);
    int           (*unregisterfont) (int font_type);
    int           (*isinstalled) (int font_type);

    /* Tty Font Manager */
    struct double_byte * (*getfont) (int tty);
    int           (*setfont) (int tty, int font_type);

} DBFontManager;

extern DBFontManager *UniconFontManager;

#endif

