/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.Globals;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SigningInfo {
    private CacheEntry ce = null;
    private URL location = null;
    private String version = null;
    private boolean canBeSkipped;
    private String jarFilePath = null;

    public static Certificate[] toCertificateArray(List list) {
        Object object;
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object instanceof CertChain) {
                n += ((CertChain)object).getLength();
                continue;
            }
            return null;
        }
        object = new Certificate[n];
        iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Certificate[] certificateArray = ((CertChain)iterator.next()).getCertificates();
            System.arraycopy(certificateArray, 0, object, n2, certificateArray.length);
            n2 += certificateArray.length;
        }
        return object;
    }

    private static boolean setContains(List list, Object object) {
        if (list == null || object == null) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!object.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static List overlapChainLists(List list, List list2) {
        if (list == null || list2 == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!SigningInfo.setContains(list2, e)) continue;
            arrayList.add(e);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public static List overlapSigners(List list, CodeSigner[] codeSignerArray) {
        ArrayList<CodeSigner> arrayList = new ArrayList<CodeSigner>();
        for (int i = 0; i < codeSignerArray.length; ++i) {
            if (list != null && !SigningInfo.setContains(list, codeSignerArray[i])) continue;
            arrayList.add(codeSignerArray[i]);
        }
        return arrayList;
    }

    public static List overlapCertificateChains(List list, Certificate[] certificateArray) {
        CertChain certChain;
        ArrayList<CertChain> arrayList = new ArrayList<CertChain>();
        int n = 0;
        while ((certChain = SigningInfo.getAChain(certificateArray, n)) != null) {
            if (list == null || list.contains(certChain)) {
                arrayList.add(certChain);
            }
            n += certChain.getLength();
        }
        return arrayList;
    }

    private static CertChain getAChain(Certificate[] certificateArray, int n) {
        if (n > certificateArray.length - 1) {
            return null;
        }
        int n2 = 0;
        for (n2 = n; n2 < certificateArray.length - 1 && ((Object)((X509Certificate)certificateArray[n2 + 1]).getSubjectDN()).equals(((X509Certificate)certificateArray[n2]).getIssuerDN()); ++n2) {
        }
        return new CertChain(certificateArray, n, n2);
    }

    public SigningInfo(URL uRL, String string) {
        this.location = uRL;
        this.version = string;
        boolean bl = false;
        try {
            this.jarFilePath = DownloadEngine.getCachedResourceFilePath((URL)uRL, (String)string);
            this.canBeSkipped = false;
        }
        catch (IOException iOException) {
            if (string != null) {
                try {
                    this.jarFilePath = DownloadEngine.getCachedResourceFilePath((URL)uRL, null);
                    bl = true;
                }
                catch (IOException iOException2) {
                    this.canBeSkipped = true;
                }
            }
            this.canBeSkipped = true;
        }
        if (!this.canBeSkipped && Cache.isCacheEnabled()) {
            this.ce = Cache.getCacheEntry((URL)uRL, null, (String)(bl ? null : string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List check() throws IOException, JARSigningException {
        List list;
        block8: {
            block9: {
                list = null;
                if (this.ce == null) break block9;
                try {
                    JarFile jarFile = this.ce.getJarFile();
                    Trace.println((String)("Validating cached jar url=" + this.ce.getURL() + " ffile=" + this.ce.getResourceFilename() + " " + jarFile), (TraceLevel)TraceLevel.SECURITY);
                    list = this.getCommonCodeSignersForJar(jarFile);
                    if (list != null && list.isEmpty()) {
                        list = null;
                        throw new JARSigningException(this.location, this.version, 1);
                    }
                    this.ce.updateValidationResults(list != null, null, System.currentTimeMillis());
                }
                catch (Throwable throwable) {
                    this.ce.updateValidationResults(list != null, null, System.currentTimeMillis());
                    throw throwable;
                }
                break block8;
            }
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(this.jarFilePath);
                list = this.getCommonCodeSignersForJar(jarFile);
                if (list != null && list.isEmpty()) {
                    list = null;
                    throw new JARSigningException(this.location, this.version, 1);
                }
            }
            finally {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
        }
        return list;
    }

    public long getCachedVerificationTimestampt() {
        if (this.ce != null) {
            return this.ce.getValidationTimestampt();
        }
        return 0L;
    }

    public List getCertificates() {
        if (this.ce != null) {
            if (Globals.isJavaVersionAtLeast15()) {
                return SigningInfo.overlapSigners(null, this.ce.getCodeSigners());
            }
            return SigningInfo.overlapCertificateChains(null, this.ce.getCertificates());
        }
        return null;
    }

    public boolean canBeSkipped() {
        return this.canBeSkipped;
    }

    public boolean isKnownToBeValidated() {
        return this.ce != null && this.ce.getValidationTimestampt() != 0L;
    }

    public boolean isKnownToBeSigned() {
        if (this.ce != null) {
            return this.ce.isKnownToBeSigned();
        }
        return false;
    }

    public Map getTrustedEntries() {
        if (this.ce != null) {
            return this.ce.getCachedTrustedEntries();
        }
        return null;
    }

    public void updateCache(boolean bl, Map map, long l) {
        if (this.ce != null) {
            this.ce.updateValidationResults(bl, map, l);
        }
    }

    List getCommonCodeSignersForJar(JarFile jarFile) throws IOException {
        List list = null;
        try {
            Enumeration<JarEntry> enumeration = jarFile.entries();
            boolean bl = Globals.isJavaVersionAtLeast15();
            while (enumeration.hasMoreElements() && (list == null || !list.isEmpty())) {
                Serializable[] serializableArray;
                byte[] byArray = new byte[8192];
                JarEntry jarEntry = enumeration.nextElement();
                String string = jarEntry.getName();
                if (string.startsWith("META-INF/") || string.endsWith("/") || jarEntry.getSize() == 0L) continue;
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                while (inputStream.read(byArray, 0, byArray.length) != -1) {
                }
                inputStream.close();
                if (bl) {
                    serializableArray = jarEntry.getCodeSigners();
                    if (serializableArray == null) {
                        throw new JARSigningException(this.location, this.version, 3);
                    }
                    list = SigningInfo.overlapSigners(list, (CodeSigner[])serializableArray);
                    continue;
                }
                serializableArray = jarEntry.getCertificates();
                if (serializableArray == null) {
                    throw new JARSigningException(this.location, this.version, 3);
                }
                list = SigningInfo.overlapCertificateChains(list, (Certificate[])serializableArray);
            }
        }
        catch (JARSigningException jARSigningException) {
            throw jARSigningException;
        }
        catch (IOException iOException) {
            throw new JARSigningException(this.location, this.version, 2, (Exception)iOException);
        }
        catch (SecurityException securityException) {
            throw new JARSigningException(this.location, this.version, 2, (Exception)securityException);
        }
        return list;
    }

    static class CertChain {
        Certificate[] certs;

        CertChain(Certificate[] certificateArray, int n, int n2) {
            this.certs = new Certificate[n2 - n + 1];
            for (int i = 0; i < this.certs.length; ++i) {
                this.certs[i] = certificateArray[n + i];
            }
        }

        Certificate[] getCertificates() {
            return this.certs;
        }

        int getLength() {
            return this.certs.length;
        }

        public int hashCode() {
            if (this.certs.length == 0) {
                return 0;
            }
            return this.certs[0].hashCode();
        }

        public boolean equals(Object object) {
            CertChain certChain = (CertChain)object;
            if (certChain == null || certChain.getLength() != this.getLength()) {
                return false;
            }
            for (int i = 0; i < this.certs.length; ++i) {
                if (certChain.certs[i].equals(this.certs[i])) continue;
                return false;
            }
            return true;
        }
    }
}

