/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import sun.jdbc.odbc.JdbcOdbcObject;

public class JdbcOdbcBoundArrayOfParams
extends JdbcOdbcObject {
    protected int numParams;
    protected Hashtable hashedLenIdx;
    protected Object[] storedParams;
    protected int[] paramLenIdx;
    protected Object[][] storedInputStreams;
    protected Object[][] paramSets;
    protected int[][] paramLenIdxSets;
    protected int batchSize;

    public JdbcOdbcBoundArrayOfParams(int n) {
        this.numParams = n;
        this.initialize();
    }

    public void initialize() {
        this.storedParams = new Object[this.numParams];
        this.paramLenIdx = new int[this.numParams];
        this.hashedLenIdx = new Hashtable();
        this.batchSize = 0;
        for (int i = 0; i < this.numParams; ++i) {
            this.paramLenIdx[i] = -5;
        }
    }

    public void storeValue(int n, Object object, int n2) {
        this.storedParams[n] = object;
        this.paramLenIdx[n] = n2;
    }

    public void clearParameterSet() {
        if (this.storedParams != null) {
            for (int i = 0; i < this.numParams; ++i) {
                this.storedParams[i] = new Object();
                this.paramLenIdx[i] = -5;
            }
        }
    }

    public Object[] getStoredParameterSet() {
        Object[] objectArray = new Object[]{};
        if (this.storedParams != null) {
            objectArray = new Object[this.numParams];
            try {
                for (int i = 0; i < this.numParams; ++i) {
                    objectArray[i] = this.storedParams[i];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("exception: " + arrayIndexOutOfBoundsException.getMessage());
                arrayIndexOutOfBoundsException.printStackTrace();
            }
        }
        return objectArray;
    }

    public void storeRowIndex(int n, int[] nArray) {
        this.hashedLenIdx.put(new Integer(n), nArray);
    }

    public int[] getStoredRowIndex(int n) {
        return (int[])this.hashedLenIdx.get(new Integer(n));
    }

    public void clearStoredRowIndexs() {
        if (!this.hashedLenIdx.isEmpty()) {
            this.hashedLenIdx.clear();
        }
    }

    public int[] getStoredIndexSet() {
        int[] nArray = new int[]{};
        if (this.paramLenIdx != null) {
            nArray = new int[this.numParams];
            try {
                for (int i = 0; i < this.numParams; ++i) {
                    nArray[i] = this.paramLenIdx[i];
                    if (nArray[i] != -5) continue;
                    nArray = new int[]{};
                    return nArray;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("exception: " + arrayIndexOutOfBoundsException.getMessage());
                arrayIndexOutOfBoundsException.printStackTrace();
            }
        }
        return nArray;
    }

    public void builtColumWiseParameteSets(int n, Vector vector) {
        int[] nArray = new int[]{};
        Object[] objectArray = new Object[]{};
        this.batchSize = n;
        if (vector.size() == this.batchSize) {
            this.storedInputStreams = new Object[this.batchSize][this.numParams];
            this.paramSets = new Object[this.batchSize][this.numParams];
            this.paramLenIdxSets = new int[this.batchSize][this.numParams];
            for (int i = 0; i < this.batchSize; ++i) {
                nArray = this.getStoredRowIndex(i);
                objectArray = (Object[])vector.elementAt(i);
                for (int j = 0; j < this.numParams; ++j) {
                    this.paramSets[i][j] = objectArray[j];
                    this.paramLenIdxSets[i][j] = nArray[j];
                }
            }
        }
    }

    public Object[] getColumnWiseParamSet(int n) {
        Object[] objectArray = new Object[this.batchSize];
        if (this.paramSets != null) {
            for (int i = 0; i < this.batchSize; ++i) {
                objectArray[i] = this.paramSets[i][n - 1];
            }
        }
        return objectArray;
    }

    public int[] getColumnWiseIndexArray(int n) {
        int[] nArray = new int[this.batchSize];
        if (this.paramLenIdxSets != null) {
            for (int i = 0; i < this.batchSize; ++i) {
                nArray[i] = this.paramLenIdxSets[i][n - 1];
            }
        }
        return nArray;
    }

    public void setInputStreamElements(int n, Object[] objectArray) {
        if (n >= 1 && n <= this.numParams && this.storedInputStreams != null && objectArray != null) {
            for (int i = 0; i < this.batchSize; ++i) {
                this.storedInputStreams[i][n - 1] = objectArray[i];
            }
        }
    }

    public InputStream getInputStreamElement(int n, int n2) {
        InputStream inputStream = null;
        if (n >= 1 && n <= this.numParams && n2 >= 1 && n2 <= this.batchSize) {
            inputStream = (InputStream)this.storedInputStreams[n2 - 1][n - 1];
        }
        return inputStream;
    }

    public int getElementLength(int n, int n2) {
        return this.paramLenIdxSets[n2 - 1][n - 1];
    }
}

