/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model.wsdl;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.model.ParameterBinding;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLMessage;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPortType;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLService;
import com.sun.xml.internal.ws.model.wsdl.AbstractExtensibleImpl;
import com.sun.xml.internal.ws.model.wsdl.AbstractObjectImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLBoundOperationImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLBoundPortTypeImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLMessageImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPartImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortTypeImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLServiceImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jws.WebParam;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSDLModelImpl
extends AbstractExtensibleImpl
implements WSDLModel {
    private final Map<QName, WSDLMessageImpl> messages = new HashMap<QName, WSDLMessageImpl>();
    private final Map<QName, WSDLPortTypeImpl> portTypes = new HashMap<QName, WSDLPortTypeImpl>();
    private final Map<QName, WSDLBoundPortTypeImpl> bindings = new HashMap<QName, WSDLBoundPortTypeImpl>();
    private final Map<QName, WSDLServiceImpl> services = new LinkedHashMap<QName, WSDLServiceImpl>();
    private final Map<QName, WSDLBoundPortType> unmBindings = Collections.unmodifiableMap(this.bindings);

    public WSDLModelImpl(@NotNull String string) {
        super(string, -1);
    }

    public WSDLModelImpl() {
        super(null, -1);
    }

    public void addMessage(WSDLMessageImpl wSDLMessageImpl) {
        this.messages.put(wSDLMessageImpl.getName(), wSDLMessageImpl);
    }

    public WSDLMessageImpl getMessage(QName qName) {
        return this.messages.get(qName);
    }

    public void addPortType(WSDLPortTypeImpl wSDLPortTypeImpl) {
        this.portTypes.put(wSDLPortTypeImpl.getName(), wSDLPortTypeImpl);
    }

    @Override
    public WSDLPortTypeImpl getPortType(QName qName) {
        return this.portTypes.get(qName);
    }

    public void addBinding(WSDLBoundPortTypeImpl wSDLBoundPortTypeImpl) {
        assert (!this.bindings.containsValue(wSDLBoundPortTypeImpl));
        this.bindings.put(wSDLBoundPortTypeImpl.getName(), wSDLBoundPortTypeImpl);
    }

    @Override
    public WSDLBoundPortTypeImpl getBinding(QName qName) {
        return this.bindings.get(qName);
    }

    public void addService(WSDLServiceImpl wSDLServiceImpl) {
        this.services.put(wSDLServiceImpl.getName(), wSDLServiceImpl);
    }

    @Override
    public WSDLServiceImpl getService(QName qName) {
        return this.services.get(qName);
    }

    public Map<QName, WSDLMessageImpl> getMessages() {
        return this.messages;
    }

    @NotNull
    public Map<QName, WSDLPortTypeImpl> getPortTypes() {
        return this.portTypes;
    }

    @Override
    @NotNull
    public Map<QName, WSDLBoundPortType> getBindings() {
        return this.unmBindings;
    }

    @NotNull
    public Map<QName, WSDLServiceImpl> getServices() {
        return this.services;
    }

    public QName getFirstServiceName() {
        if (this.services.isEmpty()) {
            return null;
        }
        return this.services.values().iterator().next().getName();
    }

    public QName getFirstPortName() {
        WSDLPort wSDLPort = this.getFirstPort();
        if (wSDLPort == null) {
            return null;
        }
        return wSDLPort.getName();
    }

    private WSDLPort getFirstPort() {
        if (this.services.isEmpty()) {
            return null;
        }
        WSDLService wSDLService = this.services.values().iterator().next();
        Iterator<? extends WSDLPort> iterator = wSDLService.getPorts().iterator();
        WSDLPort wSDLPort = iterator.hasNext() ? iterator.next() : null;
        return wSDLPort;
    }

    public WSDLPortImpl getMatchingPort(QName qName, QName qName2) {
        return this.getService(qName).getMatchingPort(qName2);
    }

    @Override
    public WSDLBoundPortTypeImpl getBinding(QName qName, QName qName2) {
        WSDLPortImpl wSDLPortImpl;
        WSDLServiceImpl wSDLServiceImpl = this.services.get(qName);
        if (wSDLServiceImpl != null && (wSDLPortImpl = wSDLServiceImpl.get(qName2)) != null) {
            return wSDLPortImpl.getBinding();
        }
        return null;
    }

    void finalizeRpcLitBinding(WSDLBoundPortTypeImpl wSDLBoundPortTypeImpl) {
        assert (wSDLBoundPortTypeImpl != null);
        QName qName = wSDLBoundPortTypeImpl.getPortTypeName();
        if (qName == null) {
            return;
        }
        WSDLPortType wSDLPortType = this.portTypes.get(qName);
        if (wSDLPortType == null) {
            return;
        }
        for (WSDLBoundOperationImpl wSDLBoundOperationImpl : wSDLBoundPortTypeImpl.getBindingOperations()) {
            AbstractObjectImpl abstractObjectImpl;
            Object object;
            WSDLOperation wSDLOperation = wSDLPortType.get(wSDLBoundOperationImpl.getName().getLocalPart());
            WSDLMessage wSDLMessage = wSDLOperation.getInput().getMessage();
            if (wSDLMessage == null) continue;
            WSDLMessageImpl wSDLMessageImpl = this.messages.get(wSDLMessage.getName());
            int n = 0;
            if (wSDLMessageImpl != null) {
                object = wSDLMessageImpl.parts().iterator();
                while (object.hasNext()) {
                    abstractObjectImpl = object.next();
                    String string = ((WSDLPartImpl)abstractObjectImpl).getName();
                    ParameterBinding parameterBinding = wSDLBoundOperationImpl.getInputBinding(string);
                    if (!parameterBinding.isBody()) continue;
                    ((WSDLPartImpl)abstractObjectImpl).setIndex(n++);
                    ((WSDLPartImpl)abstractObjectImpl).setBinding(parameterBinding);
                    wSDLBoundOperationImpl.addPart((WSDLPartImpl)abstractObjectImpl, WebParam.Mode.IN);
                }
            }
            n = 0;
            if (wSDLOperation.isOneWay() || (object = wSDLOperation.getOutput().getMessage()) == null || (abstractObjectImpl = this.messages.get(object.getName())) == null) continue;
            for (WSDLPartImpl wSDLPartImpl : ((WSDLMessageImpl)abstractObjectImpl).parts()) {
                String string = wSDLPartImpl.getName();
                ParameterBinding parameterBinding = wSDLBoundOperationImpl.getOutputBinding(string);
                if (!parameterBinding.isBody()) continue;
                wSDLPartImpl.setIndex(n++);
                wSDLPartImpl.setBinding(parameterBinding);
                wSDLBoundOperationImpl.addPart(wSDLPartImpl, WebParam.Mode.OUT);
            }
        }
    }

    public void freeze() {
        for (WSDLServiceImpl abstractExtensibleImpl : this.services.values()) {
            abstractExtensibleImpl.freeze(this);
        }
        for (WSDLBoundPortTypeImpl wSDLBoundPortTypeImpl : this.bindings.values()) {
            wSDLBoundPortTypeImpl.freeze();
        }
    }
}

