/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.buffer.stax;

import com.sun.xml.internal.org.jvnet.staxex.NamespaceContextEx;
import com.sun.xml.internal.org.jvnet.staxex.XMLStreamReaderEx;
import com.sun.xml.internal.stream.buffer.AbstractProcessor;
import com.sun.xml.internal.stream.buffer.AttributesHolder;
import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.XMLStreamBufferMark;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public class StreamReaderBufferProcessor
extends AbstractProcessor
implements XMLStreamReaderEx {
    private static final int CACHE_SIZE = 16;
    protected ElementStackEntry[] _stack = new ElementStackEntry[16];
    protected ElementStackEntry _stackTop;
    protected int _depth;
    protected String[] _namespaceAIIsPrefix = new String[16];
    protected String[] _namespaceAIIsNamespaceName = new String[16];
    protected int _namespaceAIIsEnd;
    protected InternalNamespaceContext _nsCtx = new InternalNamespaceContext();
    protected int _eventType;
    protected AttributesHolder _attributeCache;
    protected CharSequence _charSequence;
    protected char[] _characters;
    protected int _textOffset;
    protected int _textLen;
    protected String _piTarget;
    protected String _piData;
    private static final int PARSING = 1;
    private static final int PENDING_END_DOCUMENT = 2;
    private static final int COMPLETED = 3;
    private int _completionState;

    public StreamReaderBufferProcessor() {
        for (int i = 0; i < this._stack.length; ++i) {
            this._stack[i] = new ElementStackEntry();
        }
        this._attributeCache = new AttributesHolder();
    }

    public StreamReaderBufferProcessor(XMLStreamBuffer xMLStreamBuffer) throws XMLStreamException {
        this();
        this.setXMLStreamBuffer(xMLStreamBuffer);
    }

    public void setXMLStreamBuffer(XMLStreamBuffer xMLStreamBuffer) throws XMLStreamException {
        this.setBuffer(xMLStreamBuffer, xMLStreamBuffer.isFragment());
        this._completionState = 1;
        this._namespaceAIIsEnd = 0;
        this._characters = null;
        this._charSequence = null;
        this._eventType = 7;
    }

    public XMLStreamBuffer nextTagAndMark() throws XMLStreamException {
        do {
            int n;
            if (((n = this.peekStructure()) & 0xF0) != 32) continue;
            HashMap<String, String> hashMap = new HashMap<String, String>(this._namespaceAIIsEnd);
            for (int i = 0; i < this._namespaceAIIsEnd; ++i) {
                hashMap.put(this._namespaceAIIsPrefix[i], this._namespaceAIIsNamespaceName[i]);
            }
            XMLStreamBufferMark xMLStreamBufferMark = new XMLStreamBufferMark(hashMap, this);
            this.next();
            return xMLStreamBufferMark;
        } while (this.next() != 2);
        return null;
    }

    public Object getProperty(String string) {
        return null;
    }

    public int next() throws XMLStreamException {
        int n;
        switch (this._completionState) {
            case 3: {
                throw new XMLStreamException("Invalid State");
            }
            case 2: {
                this._namespaceAIIsEnd = 0;
                this._completionState = 3;
                this._eventType = 8;
                return 8;
            }
        }
        switch (this._eventType) {
            case 2: {
                if (this._depth > 1) {
                    --this._depth;
                    this.popElementStack(this._depth);
                    break;
                }
                if (this._depth != 1) break;
                --this._depth;
            }
        }
        this._characters = null;
        this._charSequence = null;
        block25: while (true) {
            n = this.readEiiState();
            switch (n) {
                case 1: {
                    continue block25;
                }
                case 3: {
                    String string = this.readStructureString();
                    String string2 = this.readStructureString();
                    String string3 = this.getPrefixFromQName(this.readStructureString());
                    this.processElement(string3, string, string2);
                    this._eventType = 1;
                    return 1;
                }
                case 4: {
                    this.processElement(this.readStructureString(), this.readStructureString(), this.readStructureString());
                    this._eventType = 1;
                    return 1;
                }
                case 5: {
                    this.processElement(null, this.readStructureString(), this.readStructureString());
                    this._eventType = 1;
                    return 1;
                }
                case 6: {
                    this.processElement(null, null, this.readStructureString());
                    this._eventType = 1;
                    return 1;
                }
                case 7: {
                    this._textLen = this.readStructure();
                    this._textOffset = this.readContentCharactersBuffer(this._textLen);
                    this._characters = this._contentCharactersBuffer;
                    this._eventType = 4;
                    return 4;
                }
                case 8: {
                    this._textLen = this.readStructure16();
                    this._textOffset = this.readContentCharactersBuffer(this._textLen);
                    this._characters = this._contentCharactersBuffer;
                    this._eventType = 4;
                    return 4;
                }
                case 9: {
                    this._characters = this.readContentCharactersCopy();
                    this._textLen = this._characters.length;
                    this._textOffset = 0;
                    this._eventType = 4;
                    return 4;
                }
                case 10: {
                    this._eventType = 4;
                    this._charSequence = this.readContentString();
                    this._eventType = 4;
                    return 4;
                }
                case 11: {
                    this._eventType = 4;
                    this._charSequence = (CharSequence)this.readContentObject();
                    this._eventType = 4;
                    return 4;
                }
                case 12: {
                    this._textLen = this.readStructure();
                    this._textOffset = this.readContentCharactersBuffer(this._textLen);
                    this._characters = this._contentCharactersBuffer;
                    this._eventType = 5;
                    return 5;
                }
                case 13: {
                    this._textLen = this.readStructure16();
                    this._textOffset = this.readContentCharactersBuffer(this._textLen);
                    this._characters = this._contentCharactersBuffer;
                    this._eventType = 5;
                    return 5;
                }
                case 14: {
                    this._characters = this.readContentCharactersCopy();
                    this._textLen = this._characters.length;
                    this._textOffset = 0;
                    this._eventType = 5;
                    return 5;
                }
                case 15: {
                    this._charSequence = this.readContentString();
                    this._eventType = 5;
                    return 5;
                }
                case 16: {
                    this._piTarget = this.readStructureString();
                    this._piData = this.readStructureString();
                    this._eventType = 3;
                    return 3;
                }
                case 17: {
                    if (this._depth > 1) {
                        this._eventType = 2;
                        return 2;
                    }
                    if (this._depth == 1) {
                        if (this._fragmentMode && --this._treeCount == 0) {
                            this._completionState = 2;
                        }
                        this._eventType = 2;
                        return 2;
                    }
                    this._namespaceAIIsEnd = 0;
                    this._completionState = 3;
                    this._eventType = 8;
                    return 8;
                }
            }
            break;
        }
        throw new XMLStreamException("Internal XSB error: Invalid State=" + n);
    }

    public final void require(int n, String string, String string2) throws XMLStreamException {
        if (n != this._eventType) {
            throw new XMLStreamException("");
        }
        if (string != null && !string.equals(this.getNamespaceURI())) {
            throw new XMLStreamException("");
        }
        if (string2 != null && !string2.equals(this.getLocalName())) {
            throw new XMLStreamException("");
        }
    }

    public final String getElementTextTrim() throws XMLStreamException {
        return this.getElementText().trim();
    }

    public final String getElementText() throws XMLStreamException {
        if (this._eventType != 1) {
            throw new XMLStreamException("");
        }
        this.next();
        return this.getElementText(true);
    }

    public final String getElementText(boolean bl) throws XMLStreamException {
        if (!bl) {
            throw new XMLStreamException("");
        }
        int n = this.getEventType();
        StringBuffer stringBuffer = new StringBuffer();
        while (n != 2) {
            if (n == 4 || n == 12 || n == 6 || n == 9) {
                stringBuffer.append(this.getText());
            } else if (n != 3 && n != 5) {
                if (n == 8) {
                    throw new XMLStreamException("");
                }
                if (n == 1) {
                    throw new XMLStreamException("");
                }
                throw new XMLStreamException("");
            }
            n = this.next();
        }
        return stringBuffer.toString();
    }

    public final int nextTag() throws XMLStreamException {
        this.next();
        return this.nextTag(true);
    }

    public final int nextTag(boolean bl) throws XMLStreamException {
        int n = this.getEventType();
        if (!bl) {
            n = this.next();
        }
        while (n == 4 && this.isWhiteSpace() || n == 12 && this.isWhiteSpace() || n == 6 || n == 3 || n == 5) {
            n = this.next();
        }
        if (n != 1 && n != 2) {
            throw new XMLStreamException("");
        }
        return n;
    }

    public final boolean hasNext() {
        return this._eventType != 8;
    }

    public void close() throws XMLStreamException {
    }

    public final boolean isStartElement() {
        return this._eventType == 1;
    }

    public final boolean isEndElement() {
        return this._eventType == 2;
    }

    public final boolean isCharacters() {
        return this._eventType == 4;
    }

    public final boolean isWhiteSpace() {
        if (this.isCharacters() || this._eventType == 12) {
            char[] cArray = this.getTextCharacters();
            int n = this.getTextStart();
            int n2 = this.getTextLength();
            for (int i = n; i < n2; ++i) {
                char c = cArray[i];
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final String getAttributeValue(String string, String string2) {
        if (this._eventType != 1) {
            throw new IllegalStateException("");
        }
        if (string == null) {
            string = "";
        }
        return this._attributeCache.getValue(string, string2);
    }

    public final int getAttributeCount() {
        if (this._eventType != 1) {
            throw new IllegalStateException("");
        }
        return this._attributeCache.getLength();
    }

    public final QName getAttributeName(int n) {
        if (this._eventType != 1) {
            throw new IllegalStateException("");
        }
        String string = this._attributeCache.getPrefix(n);
        String string2 = this._attributeCache.getLocalName(n);
        String string3 = this._attributeCache.getURI(n);
        return new QName(string3, string2, string);
    }

    public final String getAttributeNamespace(int n) {
        if (this._eventType != 1) {
            throw new IllegalStateException("");
        }
        return StreamReaderBufferProcessor.fixEmptyString(this._attributeCache.getURI(n));
    }

    public final String getAttributeLocalName(int n) {
        if (this._eventType != 1) {
            throw new IllegalStateException("");
        }
        return this._attributeCache.getLocalName(n);
    }

    public final String getAttributePrefix(int n) {
        if (this._eventType != 1) {
            throw new IllegalStateException("");
        }
        return StreamReaderBufferProcessor.fixEmptyString(this._attributeCache.getPrefix(n));
    }

    public final String getAttributeType(int n) {
        if (this._eventType != 1) {
            throw new IllegalStateException("");
        }
        return this._attributeCache.getType(n);
    }

    public final String getAttributeValue(int n) {
        if (this._eventType != 1) {
            throw new IllegalStateException("");
        }
        return this._attributeCache.getValue(n);
    }

    public final boolean isAttributeSpecified(int n) {
        return false;
    }

    public final int getNamespaceCount() {
        if (this._eventType == 1 || this._eventType == 2) {
            return this._stackTop.namespaceAIIsEnd - this._stackTop.namespaceAIIsStart;
        }
        throw new IllegalStateException("");
    }

    public final String getNamespacePrefix(int n) {
        if (this._eventType == 1 || this._eventType == 2) {
            return this._namespaceAIIsPrefix[this._stackTop.namespaceAIIsStart + n];
        }
        throw new IllegalStateException("");
    }

    public final String getNamespaceURI(int n) {
        if (this._eventType == 1 || this._eventType == 2) {
            return this._namespaceAIIsNamespaceName[this._stackTop.namespaceAIIsStart + n];
        }
        throw new IllegalStateException("");
    }

    public final String getNamespaceURI(String string) {
        return this._nsCtx.getNamespaceURI(string);
    }

    public final NamespaceContextEx getNamespaceContext() {
        return this._nsCtx;
    }

    public final int getEventType() {
        return this._eventType;
    }

    public final String getText() {
        if (this._characters != null) {
            String string = new String(this._characters, this._textOffset, this._textLen);
            this._charSequence = string;
            return string;
        }
        if (this._charSequence != null) {
            return ((Object)this._charSequence).toString();
        }
        throw new IllegalStateException();
    }

    public final char[] getTextCharacters() {
        if (this._characters != null) {
            return this._characters;
        }
        if (this._charSequence != null) {
            this._characters = ((Object)this._charSequence).toString().toCharArray();
            this._textLen = this._characters.length;
            this._textOffset = 0;
            return this._characters;
        }
        throw new IllegalStateException();
    }

    public final int getTextStart() {
        if (this._characters != null) {
            return this._textOffset;
        }
        if (this._charSequence != null) {
            return 0;
        }
        throw new IllegalStateException();
    }

    public final int getTextLength() {
        if (this._characters != null) {
            return this._textLen;
        }
        if (this._charSequence != null) {
            return this._charSequence.length();
        }
        throw new IllegalStateException();
    }

    public final int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        if (this._characters == null) {
            if (this._charSequence != null) {
                this._characters = ((Object)this._charSequence).toString().toCharArray();
                this._textLen = this._characters.length;
                this._textOffset = 0;
            } else {
                throw new IllegalStateException("");
            }
        }
        try {
            int n4 = this._textLen - n;
            int n5 = n4 > n3 ? n3 : n4;
            System.arraycopy(this._characters, n += this._textOffset, cArray, n2, n5);
            return n5;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new XMLStreamException(indexOutOfBoundsException);
        }
    }

    public final CharSequence getPCDATA() {
        if (this._characters != null) {
            return new CharSequenceImpl(this._textOffset, this._textLen);
        }
        if (this._charSequence != null) {
            return this._charSequence;
        }
        throw new IllegalStateException();
    }

    public final String getEncoding() {
        return "UTF-8";
    }

    public final boolean hasText() {
        return this._characters != null || this._charSequence != null;
    }

    public final Location getLocation() {
        return new DummyLocation();
    }

    public final boolean hasName() {
        return this._eventType == 1 || this._eventType == 2;
    }

    public final QName getName() {
        return this._stackTop.getQName();
    }

    public final String getLocalName() {
        return this._stackTop.localName;
    }

    public final String getNamespaceURI() {
        return this._stackTop.uri;
    }

    public final String getPrefix() {
        return this._stackTop.prefix;
    }

    public final String getVersion() {
        return "1.0";
    }

    public final boolean isStandalone() {
        return false;
    }

    public final boolean standaloneSet() {
        return false;
    }

    public final String getCharacterEncodingScheme() {
        return "UTF-8";
    }

    public final String getPITarget() {
        if (this._eventType == 3) {
            return this._piTarget;
        }
        throw new IllegalStateException("");
    }

    public final String getPIData() {
        if (this._eventType == 3) {
            return this._piData;
        }
        throw new IllegalStateException("");
    }

    protected void processElement(String string, String string2, String string3) {
        this.pushElementStack();
        this._stackTop.set(string, string2, string3);
        this._attributeCache.clear();
        int n = this.peekStructure();
        if ((n & 0xF0) == 64) {
            n = this.processNamespaceAttributes(n);
        }
        if ((n & 0xF0) == 48) {
            this.processAttributes(n);
        }
    }

    private void resizeNamespaceAttributes() {
        String[] stringArray = new String[this._namespaceAIIsEnd * 2];
        System.arraycopy(this._namespaceAIIsPrefix, 0, stringArray, 0, this._namespaceAIIsEnd);
        this._namespaceAIIsPrefix = stringArray;
        String[] stringArray2 = new String[this._namespaceAIIsEnd * 2];
        System.arraycopy(this._namespaceAIIsNamespaceName, 0, stringArray2, 0, this._namespaceAIIsEnd);
        this._namespaceAIIsNamespaceName = stringArray2;
    }

    private int processNamespaceAttributes(int n) {
        this._stackTop.namespaceAIIsStart = this._namespaceAIIsEnd;
        do {
            if (this._namespaceAIIsEnd == this._namespaceAIIsPrefix.length) {
                this.resizeNamespaceAttributes();
            }
            switch (_niiStateTable[n]) {
                case 1: {
                    this._namespaceAIIsNamespaceName[this._namespaceAIIsEnd++] = "";
                    this._namespaceAIIsPrefix[this._namespaceAIIsEnd] = "";
                    break;
                }
                case 2: {
                    this._namespaceAIIsPrefix[this._namespaceAIIsEnd] = this.readStructureString();
                    this._namespaceAIIsNamespaceName[this._namespaceAIIsEnd++] = "";
                    break;
                }
                case 3: {
                    this._namespaceAIIsPrefix[this._namespaceAIIsEnd] = this.readStructureString();
                    this._namespaceAIIsNamespaceName[this._namespaceAIIsEnd++] = this.readStructureString();
                    break;
                }
                case 4: {
                    this._namespaceAIIsPrefix[this._namespaceAIIsEnd] = "";
                    this._namespaceAIIsNamespaceName[this._namespaceAIIsEnd++] = this.readStructureString();
                }
            }
            this.readStructure();
        } while (((n = this.peekStructure()) & 0xF0) == 64);
        this._stackTop.namespaceAIIsEnd = this._namespaceAIIsEnd;
        return n;
    }

    private void processAttributes(int n) {
        do {
            switch (_aiiStateTable[n]) {
                case 1: {
                    String string = this.readStructureString();
                    String string2 = this.readStructureString();
                    String string3 = this.getPrefixFromQName(this.readStructureString());
                    this._attributeCache.addAttributeWithPrefix(string3, string, string2, this.readStructureString(), this.readContentString());
                    break;
                }
                case 2: {
                    this._attributeCache.addAttributeWithPrefix(this.readStructureString(), this.readStructureString(), this.readStructureString(), this.readStructureString(), this.readContentString());
                    break;
                }
                case 3: {
                    this._attributeCache.addAttributeWithPrefix("", this.readStructureString(), this.readStructureString(), this.readStructureString(), this.readContentString());
                    break;
                }
                case 4: {
                    this._attributeCache.addAttributeWithPrefix("", "", this.readStructureString(), this.readStructureString(), this.readContentString());
                    break;
                }
                default: {
                    assert (false) : "Internal XSB Error: wrong attribute state, Item=" + n;
                    break;
                }
            }
            this.readStructure();
        } while (((n = this.peekStructure()) & 0xF0) == 48);
    }

    private void pushElementStack() {
        if (this._depth == this._stack.length) {
            ElementStackEntry[] elementStackEntryArray = this._stack;
            this._stack = new ElementStackEntry[this._stack.length * 3 / 2 + 1];
            System.arraycopy(elementStackEntryArray, 0, this._stack, 0, elementStackEntryArray.length);
            for (int i = elementStackEntryArray.length; i < this._stack.length; ++i) {
                this._stack[i] = new ElementStackEntry();
            }
        }
        this._stackTop = this._stack[this._depth++];
    }

    private void popElementStack(int n) {
        this._stackTop = this._stack[n - 1];
        this._namespaceAIIsEnd = this._stack[n].namespaceAIIsStart;
    }

    private static String fixEmptyString(String string) {
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    private class CharSequenceImpl
    implements CharSequence {
        private final int _offset;
        private final int _length;

        CharSequenceImpl(int n, int n2) {
            this._offset = n;
            this._length = n2;
        }

        public int length() {
            return this._length;
        }

        public char charAt(int n) {
            if (n >= 0 && n < StreamReaderBufferProcessor.this._textLen) {
                return StreamReaderBufferProcessor.this._characters[StreamReaderBufferProcessor.this._textOffset + n];
            }
            throw new IndexOutOfBoundsException();
        }

        public CharSequence subSequence(int n, int n2) {
            int n3 = n2 - n;
            if (n2 < 0 || n < 0 || n2 > n3 || n > n2) {
                throw new IndexOutOfBoundsException();
            }
            return new CharSequenceImpl(this._offset + n, n3);
        }

        public String toString() {
            return new String(StreamReaderBufferProcessor.this._characters, this._offset, this._length);
        }
    }

    private class DummyLocation
    implements Location {
        private DummyLocation() {
        }

        public int getLineNumber() {
            return -1;
        }

        public int getColumnNumber() {
            return -1;
        }

        public int getCharacterOffset() {
            return -1;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return StreamReaderBufferProcessor.this._buffer.getSystemId();
        }
    }

    private final class ElementStackEntry {
        String prefix;
        String uri;
        String localName;
        QName qname;
        int namespaceAIIsStart;
        int namespaceAIIsEnd;

        private ElementStackEntry() {
        }

        public void set(String string, String string2, String string3) {
            this.prefix = string;
            this.uri = string2;
            this.localName = string3;
            this.qname = null;
            this.namespaceAIIsStart = this.namespaceAIIsEnd = StreamReaderBufferProcessor.this._namespaceAIIsEnd;
        }

        public QName getQName() {
            if (this.qname == null) {
                this.qname = new QName(this.fixNull(this.uri), this.localName, this.fixNull(this.prefix));
            }
            return this.qname;
        }

        private String fixNull(String string) {
            return string == null ? "" : string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InternalNamespaceContext
    implements NamespaceContextEx {
        private InternalNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String string) {
            if (string == null) {
                throw new IllegalArgumentException("Prefix cannot be null");
            }
            if (StreamReaderBufferProcessor.this._stringInterningFeature) {
                string = string.intern();
                for (int i = StreamReaderBufferProcessor.this._namespaceAIIsEnd - 1; i >= 0; --i) {
                    if (string != StreamReaderBufferProcessor.this._namespaceAIIsPrefix[i]) continue;
                    return StreamReaderBufferProcessor.this._namespaceAIIsNamespaceName[i];
                }
            } else {
                for (int i = StreamReaderBufferProcessor.this._namespaceAIIsEnd - 1; i >= 0; --i) {
                    if (!string.equals(StreamReaderBufferProcessor.this._namespaceAIIsPrefix[i])) continue;
                    return StreamReaderBufferProcessor.this._namespaceAIIsNamespaceName[i];
                }
            }
            if (string.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            if (string.equals("xmlns")) {
                return "http://www.w3.org/2000/xmlns/";
            }
            return null;
        }

        @Override
        public String getPrefix(String string) {
            Iterator iterator = this.getPrefixes(string);
            if (iterator.hasNext()) {
                return (String)iterator.next();
            }
            return null;
        }

        @Override
        public Iterator getPrefixes(final String string) {
            if (string == null) {
                throw new IllegalArgumentException("NamespaceURI cannot be null");
            }
            if (string.equals("http://www.w3.org/XML/1998/namespace")) {
                return Collections.singletonList("xml").iterator();
            }
            if (string.equals("http://www.w3.org/2000/xmlns/")) {
                return Collections.singletonList("xmlns").iterator();
            }
            return new Iterator(){
                private int i;
                private boolean requireFindNext;
                private String p;
                {
                    this.i = StreamReaderBufferProcessor.this._namespaceAIIsEnd - 1;
                    this.requireFindNext = true;
                }

                private String findNext() {
                    while (this.i >= 0) {
                        if (string.equals(StreamReaderBufferProcessor.this._namespaceAIIsNamespaceName[this.i]) && InternalNamespaceContext.this.getNamespaceURI(StreamReaderBufferProcessor.this._namespaceAIIsPrefix[this.i]).equals(StreamReaderBufferProcessor.this._namespaceAIIsNamespaceName[this.i])) {
                            this.p = StreamReaderBufferProcessor.this._namespaceAIIsPrefix[this.i];
                            return this.p;
                        }
                        --this.i;
                    }
                    this.p = null;
                    return null;
                }

                public boolean hasNext() {
                    if (this.requireFindNext) {
                        this.findNext();
                        this.requireFindNext = false;
                    }
                    return this.p != null;
                }

                public Object next() {
                    if (this.requireFindNext) {
                        this.findNext();
                    }
                    this.requireFindNext = true;
                    if (this.p == null) {
                        throw new NoSuchElementException();
                    }
                    return this.p;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Iterator<NamespaceContextEx.Binding> iterator() {
            return new Iterator<NamespaceContextEx.Binding>(){
                private final int end;
                private int current;
                private boolean requireFindNext;
                private NamespaceContextEx.Binding namespace;
                {
                    this.current = this.end = StreamReaderBufferProcessor.this._namespaceAIIsEnd - 1;
                    this.requireFindNext = true;
                }

                private NamespaceContextEx.Binding findNext() {
                    while (this.current >= 0) {
                        int n;
                        String string = StreamReaderBufferProcessor.this._namespaceAIIsPrefix[this.current];
                        for (n = this.end; n > this.current && !string.equals(StreamReaderBufferProcessor.this._namespaceAIIsPrefix[n]); --n) {
                        }
                        if (n != this.current--) continue;
                        this.namespace = new BindingImpl(string, StreamReaderBufferProcessor.this._namespaceAIIsNamespaceName[this.current]);
                        return this.namespace;
                    }
                    this.namespace = null;
                    return null;
                }

                @Override
                public boolean hasNext() {
                    if (this.requireFindNext) {
                        this.findNext();
                        this.requireFindNext = false;
                    }
                    return this.namespace != null;
                }

                @Override
                public NamespaceContextEx.Binding next() {
                    if (this.requireFindNext) {
                        this.findNext();
                    }
                    this.requireFindNext = true;
                    if (this.namespace == null) {
                        throw new NoSuchElementException();
                    }
                    return this.namespace;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private class BindingImpl
        implements NamespaceContextEx.Binding {
            final String _prefix;
            final String _namespaceURI;

            BindingImpl(String string, String string2) {
                this._prefix = string;
                this._namespaceURI = string2;
            }

            public String getPrefix() {
                return this._prefix;
            }

            public String getNamespaceURI() {
                return this._namespaceURI;
            }
        }
    }
}

