// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGNOMEVFSMM_ENUMS_H
#define _LIBGNOMEVFSMM_ENUMS_H


#include <glibmm.h>

/* $Id: enums.hg,v 1.10 2004/07/17 11:41:50 murrayc Exp $ */
// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* Copyright 2003 gnome-vfsmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomevfs/gnome-vfs-file-info.h>
#include <libgnomevfs/gnome-vfs-result.h>
#include <libgnomevfs/gnome-vfs-mime-handlers.h>
 

namespace Gnome
{

namespace Vfs
{


/** @addtogroup libgnomevfsmmEnums Enums and Flags */

/**
 * @ingroup libgnomevfsmmEnums
 * @par Bitwise operators:
 * <tt>%FileInfoOptions operator|(FileInfoOptions, FileInfoOptions)</tt><br>
 * <tt>%FileInfoOptions operator&(FileInfoOptions, FileInfoOptions)</tt><br>
 * <tt>%FileInfoOptions operator^(FileInfoOptions, FileInfoOptions)</tt><br>
 * <tt>%FileInfoOptions operator~(FileInfoOptions)</tt><br>
 * <tt>%FileInfoOptions& operator|=(FileInfoOptions&, FileInfoOptions)</tt><br>
 * <tt>%FileInfoOptions& operator&=(FileInfoOptions&, FileInfoOptions)</tt><br>
 * <tt>%FileInfoOptions& operator^=(FileInfoOptions&, FileInfoOptions)</tt><br>
 */
enum FileInfoOptions
{
  FILE_INFO_DEFAULT = 0,
  FILE_INFO_GET_MIME_TYPE = 1 << 0,
  FILE_INFO_FORCE_FAST_MIME_TYPE = 1 << 1,
  FILE_INFO_FORCE_SLOW_MIME_TYPE = 1 << 2,
  FILE_INFO_FOLLOW_LINKS = 1 << 3,
  FILE_INFO_GET_ACCESS_RIGHTS = 1 << 4
};

/** @ingroup libgnomevfsmmEnums */
inline FileInfoOptions operator|(FileInfoOptions lhs, FileInfoOptions rhs)
  { return static_cast<FileInfoOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline FileInfoOptions operator&(FileInfoOptions lhs, FileInfoOptions rhs)
  { return static_cast<FileInfoOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline FileInfoOptions operator^(FileInfoOptions lhs, FileInfoOptions rhs)
  { return static_cast<FileInfoOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline FileInfoOptions operator~(FileInfoOptions flags)
  { return static_cast<FileInfoOptions>(~static_cast<unsigned>(flags)); }

/** @ingroup libgnomevfsmmEnums */
inline FileInfoOptions& operator|=(FileInfoOptions& lhs, FileInfoOptions rhs)
  { return (lhs = static_cast<FileInfoOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline FileInfoOptions& operator&=(FileInfoOptions& lhs, FileInfoOptions rhs)
  { return (lhs = static_cast<FileInfoOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline FileInfoOptions& operator^=(FileInfoOptions& lhs, FileInfoOptions rhs)
  { return (lhs = static_cast<FileInfoOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup libgnomevfsmmEnums
 */
enum Result
{
  OK,
  ERR_NOT_FOUND,
  ERR_GENERIC,
  ERR_INTERNAL,
  ERR_BAD_PARAMETERS,
  ERR_NOT_SUPPORTED,
  ERR_IO,
  ERR_CORRUPTED_DATA,
  ERR_WRONG_FORMAT,
  ERR_BAD_FILE,
  ERR_TOO_BIG,
  ERR_NO_SPACE,
  ERR_READ_ONLY,
  ERR_INVALID_URI,
  ERR_NOT_OPEN,
  ERR_INVALID_OPEN_MODE,
  ERR_ACCESS_DENIED,
  ERR_TOO_MANY_OPEN_FILES,
  ERR_EOF,
  ERR_NOT_A_DIRECTORY,
  ERR_IN_PROGRESS,
  ERR_INTERRUPTED,
  ERR_FILE_EXISTS,
  ERR_LOOP,
  ERR_NOT_PERMITTED,
  ERR_IS_DIRECTORY,
  ERR_NO_MEMORY,
  ERR_HOST_NOT_FOUND,
  ERR_INVALID_HOST_NAME,
  ERR_HOST_HAS_NO_ADDRESS,
  ERR_LOGIN_FAILED,
  ERR_CANCELLED,
  ERR_DIRECTORY_BUSY,
  ERR_DIRECTORY_NOT_EMPTY,
  ERR_TOO_MANY_LINKS,
  ERR_READ_ONLY_FILE_SYSTEM,
  ERR_NOT_SAME_FILE_SYSTEM,
  ERR_NAME_TOO_LONG,
  ERR_SERVICE_NOT_AVAILABLE,
  ERR_SERVICE_OBSOLETE,
  ERR_PROTOCOL_ERROR,
  ERR_NO_MASTER_BROWSER,
  ERR_NO_DEFAULT,
  ERR_NO_HANDLER,
  ERR_PARSE,
  ERR_LAUNCH,
  ERR_TIMEOUT,
  ERR_NAMESERVER,
  NUM_ERRORS
};


// These conflict with defines in some windows headers. Please use the
// enumerators beginning with ERR_ instead. These are only provided for
// backwards compatibility
#ifndef G_OS_WIN32
// We can't autogenerate these, but people shouldn't use them anymore anyway.
// If enumerators are added in gnome-vfs, we only wrap them as ERR_*.
const Result ERROR_NOT_FOUND = ERR_NOT_FOUND;
const Result ERROR_GENERIC = ERR_GENERIC;
const Result ERROR_INTERNAL = ERR_INTERNAL;
const Result ERROR_BAD_PARAMETERS = ERR_BAD_PARAMETERS;
const Result ERROR_NOT_SUPPORTED = ERR_NOT_SUPPORTED;
const Result ERROR_IO = ERR_IO;
const Result ERROR_CORRUPTED_DATA = ERR_CORRUPTED_DATA;
const Result ERROR_WRONG_FORMAT = ERR_WRONG_FORMAT;
const Result ERROR_BAD_FILE = ERR_BAD_FILE;
const Result ERROR_TOO_BIG = ERR_TOO_BIG;
const Result ERROR_NO_SPACE = ERR_NO_SPACE;
const Result ERROR_READ_ONLY = ERR_READ_ONLY;
const Result ERROR_INVALID_URI = ERR_INVALID_URI;
const Result ERROR_NOT_OPEN = ERR_NOT_OPEN;
const Result ERROR_INVALID_OPEN_MODE = ERR_INVALID_OPEN_MODE;
const Result ERROR_ACCESS_DENIED = ERR_ACCESS_DENIED;
const Result ERROR_TOO_MANY_OPEN_FILES = ERR_TOO_MANY_OPEN_FILES;
const Result ERROR_EOF = ERR_EOF;
const Result ERROR_NOT_A_DIRECTORY = ERR_NOT_A_DIRECTORY;
const Result ERROR_IN_PROGRESS = ERR_IN_PROGRESS;
const Result ERROR_INTERRUPTED = ERR_INTERRUPTED;
const Result ERROR_FILE_EXISTS = ERR_FILE_EXISTS;
const Result ERROR_LOOP = ERR_LOOP;
const Result ERROR_NOT_PERMITTED = ERR_NOT_PERMITTED;
const Result ERROR_IS_DIRECTORY = ERR_IS_DIRECTORY;
const Result ERROR_NO_MEMORY = ERR_NO_MEMORY;
const Result ERROR_HOST_NOT_FOUND = ERR_HOST_NOT_FOUND;
const Result ERROR_INVALID_HOST_NAME = ERR_INVALID_HOST_NAME;
const Result ERROR_HOST_HAS_NO_ADDRESS = ERR_HOST_HAS_NO_ADDRESS;
const Result ERROR_LOGIN_FAILED = ERR_LOGIN_FAILED;
const Result ERROR_CANCELLED = ERR_CANCELLED;
const Result ERROR_DIRECTORY_BUSY = ERR_DIRECTORY_BUSY;
const Result ERROR_DIRECTORY_NOT_EMPTY = ERR_DIRECTORY_NOT_EMPTY;
const Result ERROR_TOO_MANY_LINKS = ERR_TOO_MANY_LINKS;
const Result ERROR_READ_ONLY_FILE_SYSTEM = ERR_READ_ONLY_FILE_SYSTEM;
const Result ERROR_NOT_SAME_FILE_SYSTEM = ERR_NOT_SAME_FILE_SYSTEM;
const Result ERROR_NAME_TOO_LONG = ERR_NAME_TOO_LONG;
const Result ERROR_SERVICE_NOT_AVAILABLE = ERR_SERVICE_NOT_AVAILABLE;
const Result ERROR_SERVICE_OBSOLETE = ERR_SERVICE_OBSOLETE;
const Result ERROR_PROTOCOL_ERROR = ERR_PROTOCOL_ERROR;
const Result ERROR_NO_MASTER_BROWSER = ERR_NO_MASTER_BROWSER;
const Result ERROR_NO_DEFAULT = ERR_NO_DEFAULT;
const Result ERROR_NO_HANDLER = ERR_NO_HANDLER;
const Result ERROR_PARSE = ERR_PARSE;
const Result ERROR_LAUNCH = ERR_LAUNCH;
const Result ERROR_TIMEOUT = ERR_TIMEOUT;
const Result ERROR_NAMESERVER = ERR_NAMESERVER;
#endif

/**
 * @ingroup libgnomevfsmmEnums
 * @par Bitwise operators:
 * <tt>%URIHideOptions operator|(URIHideOptions, URIHideOptions)</tt><br>
 * <tt>%URIHideOptions operator&(URIHideOptions, URIHideOptions)</tt><br>
 * <tt>%URIHideOptions operator^(URIHideOptions, URIHideOptions)</tt><br>
 * <tt>%URIHideOptions operator~(URIHideOptions)</tt><br>
 * <tt>%URIHideOptions& operator|=(URIHideOptions&, URIHideOptions)</tt><br>
 * <tt>%URIHideOptions& operator&=(URIHideOptions&, URIHideOptions)</tt><br>
 * <tt>%URIHideOptions& operator^=(URIHideOptions&, URIHideOptions)</tt><br>
 */
enum URIHideOptions
{
  URI_HIDE_NONE = 0,
  URI_HIDE_USER_NAME = 1 << 0,
  URI_HIDE_PASSWORD = 1 << 1,
  URI_HIDE_HOST_NAME = 1 << 2,
  URI_HIDE_HOST_PORT = 1 << 3,
  URI_HIDE_TOPLEVEL_METHOD = 1 << 4,
  URI_HIDE_FRAGMENT_IDENTIFIER = 1 << 8
};

/** @ingroup libgnomevfsmmEnums */
inline URIHideOptions operator|(URIHideOptions lhs, URIHideOptions rhs)
  { return static_cast<URIHideOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline URIHideOptions operator&(URIHideOptions lhs, URIHideOptions rhs)
  { return static_cast<URIHideOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline URIHideOptions operator^(URIHideOptions lhs, URIHideOptions rhs)
  { return static_cast<URIHideOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline URIHideOptions operator~(URIHideOptions flags)
  { return static_cast<URIHideOptions>(~static_cast<unsigned>(flags)); }

/** @ingroup libgnomevfsmmEnums */
inline URIHideOptions& operator|=(URIHideOptions& lhs, URIHideOptions rhs)
  { return (lhs = static_cast<URIHideOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline URIHideOptions& operator&=(URIHideOptions& lhs, URIHideOptions rhs)
  { return (lhs = static_cast<URIHideOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline URIHideOptions& operator^=(URIHideOptions& lhs, URIHideOptions rhs)
  { return (lhs = static_cast<URIHideOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup libgnomevfsmmEnums
 * @par Bitwise operators:
 * <tt>%DirectoryVisitOptions operator|(DirectoryVisitOptions, DirectoryVisitOptions)</tt><br>
 * <tt>%DirectoryVisitOptions operator&(DirectoryVisitOptions, DirectoryVisitOptions)</tt><br>
 * <tt>%DirectoryVisitOptions operator^(DirectoryVisitOptions, DirectoryVisitOptions)</tt><br>
 * <tt>%DirectoryVisitOptions operator~(DirectoryVisitOptions)</tt><br>
 * <tt>%DirectoryVisitOptions& operator|=(DirectoryVisitOptions&, DirectoryVisitOptions)</tt><br>
 * <tt>%DirectoryVisitOptions& operator&=(DirectoryVisitOptions&, DirectoryVisitOptions)</tt><br>
 * <tt>%DirectoryVisitOptions& operator^=(DirectoryVisitOptions&, DirectoryVisitOptions)</tt><br>
 */
enum DirectoryVisitOptions
{
  DIRECTORY_VISIT_DEFAULT = 0,
  DIRECTORY_VISIT_SAMEFS = 1 << 0,
  DIRECTORY_VISIT_LOOPCHECK = 1 << 1
};

/** @ingroup libgnomevfsmmEnums */
inline DirectoryVisitOptions operator|(DirectoryVisitOptions lhs, DirectoryVisitOptions rhs)
  { return static_cast<DirectoryVisitOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline DirectoryVisitOptions operator&(DirectoryVisitOptions lhs, DirectoryVisitOptions rhs)
  { return static_cast<DirectoryVisitOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline DirectoryVisitOptions operator^(DirectoryVisitOptions lhs, DirectoryVisitOptions rhs)
  { return static_cast<DirectoryVisitOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline DirectoryVisitOptions operator~(DirectoryVisitOptions flags)
  { return static_cast<DirectoryVisitOptions>(~static_cast<unsigned>(flags)); }

/** @ingroup libgnomevfsmmEnums */
inline DirectoryVisitOptions& operator|=(DirectoryVisitOptions& lhs, DirectoryVisitOptions rhs)
  { return (lhs = static_cast<DirectoryVisitOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline DirectoryVisitOptions& operator&=(DirectoryVisitOptions& lhs, DirectoryVisitOptions rhs)
  { return (lhs = static_cast<DirectoryVisitOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline DirectoryVisitOptions& operator^=(DirectoryVisitOptions& lhs, DirectoryVisitOptions rhs)
  { return (lhs = static_cast<DirectoryVisitOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup libgnomevfsmmEnums
 * @par Bitwise operators:
 * <tt>%OpenMode operator|(OpenMode, OpenMode)</tt><br>
 * <tt>%OpenMode operator&(OpenMode, OpenMode)</tt><br>
 * <tt>%OpenMode operator^(OpenMode, OpenMode)</tt><br>
 * <tt>%OpenMode operator~(OpenMode)</tt><br>
 * <tt>%OpenMode& operator|=(OpenMode&, OpenMode)</tt><br>
 * <tt>%OpenMode& operator&=(OpenMode&, OpenMode)</tt><br>
 * <tt>%OpenMode& operator^=(OpenMode&, OpenMode)</tt><br>
 */
enum OpenMode
{
  OPEN_NONE = 0,
  OPEN_READ = 1 << 0,
  OPEN_WRITE = 1 << 1,
  OPEN_RANDOM = 1 << 2
};

/** @ingroup libgnomevfsmmEnums */
inline OpenMode operator|(OpenMode lhs, OpenMode rhs)
  { return static_cast<OpenMode>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline OpenMode operator&(OpenMode lhs, OpenMode rhs)
  { return static_cast<OpenMode>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline OpenMode operator^(OpenMode lhs, OpenMode rhs)
  { return static_cast<OpenMode>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline OpenMode operator~(OpenMode flags)
  { return static_cast<OpenMode>(~static_cast<unsigned>(flags)); }

/** @ingroup libgnomevfsmmEnums */
inline OpenMode& operator|=(OpenMode& lhs, OpenMode rhs)
  { return (lhs = static_cast<OpenMode>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline OpenMode& operator&=(OpenMode& lhs, OpenMode rhs)
  { return (lhs = static_cast<OpenMode>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline OpenMode& operator^=(OpenMode& lhs, OpenMode rhs)
  { return (lhs = static_cast<OpenMode>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup libgnomevfsmmEnums
 */
enum SeekPosition
{
  SEEK_POS_START,
  SEEK_POS_CURRENT,
  SEEK_POS_END
};


/**
 * @ingroup libgnomevfsmmEnums
 * @par Bitwise operators:
 * <tt>%FileFlags operator|(FileFlags, FileFlags)</tt><br>
 * <tt>%FileFlags operator&(FileFlags, FileFlags)</tt><br>
 * <tt>%FileFlags operator^(FileFlags, FileFlags)</tt><br>
 * <tt>%FileFlags operator~(FileFlags)</tt><br>
 * <tt>%FileFlags& operator|=(FileFlags&, FileFlags)</tt><br>
 * <tt>%FileFlags& operator&=(FileFlags&, FileFlags)</tt><br>
 * <tt>%FileFlags& operator^=(FileFlags&, FileFlags)</tt><br>
 */
enum FileFlags
{
  FILE_FLAGS_NONE = 0,
  FILE_FLAGS_SYMLINK = 1 << 0,
  FILE_FLAGS_LOCAL = 1 << 1
};

/** @ingroup libgnomevfsmmEnums */
inline FileFlags operator|(FileFlags lhs, FileFlags rhs)
  { return static_cast<FileFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline FileFlags operator&(FileFlags lhs, FileFlags rhs)
  { return static_cast<FileFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline FileFlags operator^(FileFlags lhs, FileFlags rhs)
  { return static_cast<FileFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline FileFlags operator~(FileFlags flags)
  { return static_cast<FileFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup libgnomevfsmmEnums */
inline FileFlags& operator|=(FileFlags& lhs, FileFlags rhs)
  { return (lhs = static_cast<FileFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline FileFlags& operator&=(FileFlags& lhs, FileFlags rhs)
  { return (lhs = static_cast<FileFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline FileFlags& operator^=(FileFlags& lhs, FileFlags rhs)
  { return (lhs = static_cast<FileFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


// FILE_TYPE_UNKNOWN is a define in winbase.h
/**
 * @ingroup libgnomevfsmmEnums
 */
enum FileType
{
  FILE_TYPE_UNKNOWN_TYPE,
  FILE_TYPE_REGULAR,
  FILE_TYPE_DIRECTORY,
  FILE_TYPE_FIFO,
  FILE_TYPE_SOCKET,
  FILE_TYPE_CHARACTER_DEVICE,
  FILE_TYPE_BLOCK_DEVICE,
  FILE_TYPE_SYMBOLIC_LINK
};


#ifndef G_OS_WIN32
const FileType FILE_TYPE_UNKNOWN = FILE_TYPE_UNKNOWN_TYPE;
#endif

/**
 * @ingroup libgnomevfsmmEnums
 * @par Bitwise operators:
 * <tt>%FilePermissions operator|(FilePermissions, FilePermissions)</tt><br>
 * <tt>%FilePermissions operator&(FilePermissions, FilePermissions)</tt><br>
 * <tt>%FilePermissions operator^(FilePermissions, FilePermissions)</tt><br>
 * <tt>%FilePermissions operator~(FilePermissions)</tt><br>
 * <tt>%FilePermissions& operator|=(FilePermissions&, FilePermissions)</tt><br>
 * <tt>%FilePermissions& operator&=(FilePermissions&, FilePermissions)</tt><br>
 * <tt>%FilePermissions& operator^=(FilePermissions&, FilePermissions)</tt><br>
 */
enum FilePermissions
{
  PERM_SUID = S_ISUID,
  PERM_SGID = S_ISGID,
  PERM_STICKY = 01000,
  PERM_USER_READ = S_IRUSR,
  PERM_USER_WRITE = S_IWUSR,
  PERM_USER_EXEC = S_IXUSR,
  PERM_USER_ALL = S_IRUSR | S_IWUSR | S_IXUSR,
  PERM_GROUP_READ = S_IRGRP,
  PERM_GROUP_WRITE = S_IWGRP,
  PERM_GROUP_EXEC = S_IXGRP,
  PERM_GROUP_ALL = S_IRGRP | S_IWGRP | S_IXGRP,
  PERM_OTHER_READ = S_IROTH,
  PERM_OTHER_WRITE = S_IWOTH,
  PERM_OTHER_EXEC = S_IXOTH,
  PERM_OTHER_ALL = S_IROTH | S_IWOTH | S_IXOTH,
  PERM_ACCESS_READABLE = 1 << 16,
  PERM_ACCESS_WRITABLE = 1 << 17,
  PERM_ACCESS_EXECUTABLE = 1 << 18
};

/** @ingroup libgnomevfsmmEnums */
inline FilePermissions operator|(FilePermissions lhs, FilePermissions rhs)
  { return static_cast<FilePermissions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline FilePermissions operator&(FilePermissions lhs, FilePermissions rhs)
  { return static_cast<FilePermissions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline FilePermissions operator^(FilePermissions lhs, FilePermissions rhs)
  { return static_cast<FilePermissions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline FilePermissions operator~(FilePermissions flags)
  { return static_cast<FilePermissions>(~static_cast<unsigned>(flags)); }

/** @ingroup libgnomevfsmmEnums */
inline FilePermissions& operator|=(FilePermissions& lhs, FilePermissions rhs)
  { return (lhs = static_cast<FilePermissions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline FilePermissions& operator&=(FilePermissions& lhs, FilePermissions rhs)
  { return (lhs = static_cast<FilePermissions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline FilePermissions& operator^=(FilePermissions& lhs, FilePermissions rhs)
  { return (lhs = static_cast<FilePermissions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup libgnomevfsmmEnums
 * @par Bitwise operators:
 * <tt>%SetFileInfoMask operator|(SetFileInfoMask, SetFileInfoMask)</tt><br>
 * <tt>%SetFileInfoMask operator&(SetFileInfoMask, SetFileInfoMask)</tt><br>
 * <tt>%SetFileInfoMask operator^(SetFileInfoMask, SetFileInfoMask)</tt><br>
 * <tt>%SetFileInfoMask operator~(SetFileInfoMask)</tt><br>
 * <tt>%SetFileInfoMask& operator|=(SetFileInfoMask&, SetFileInfoMask)</tt><br>
 * <tt>%SetFileInfoMask& operator&=(SetFileInfoMask&, SetFileInfoMask)</tt><br>
 * <tt>%SetFileInfoMask& operator^=(SetFileInfoMask&, SetFileInfoMask)</tt><br>
 */
enum SetFileInfoMask
{
  SET_FILE_INFO_NONE = 0,
  SET_FILE_INFO_NAME = 1 << 0,
  SET_FILE_INFO_PERMISSIONS = 1 << 1,
  SET_FILE_INFO_OWNER = 1 << 2,
  SET_FILE_INFO_TIME = 1 << 3
};

/** @ingroup libgnomevfsmmEnums */
inline SetFileInfoMask operator|(SetFileInfoMask lhs, SetFileInfoMask rhs)
  { return static_cast<SetFileInfoMask>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline SetFileInfoMask operator&(SetFileInfoMask lhs, SetFileInfoMask rhs)
  { return static_cast<SetFileInfoMask>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline SetFileInfoMask operator^(SetFileInfoMask lhs, SetFileInfoMask rhs)
  { return static_cast<SetFileInfoMask>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline SetFileInfoMask operator~(SetFileInfoMask flags)
  { return static_cast<SetFileInfoMask>(~static_cast<unsigned>(flags)); }

/** @ingroup libgnomevfsmmEnums */
inline SetFileInfoMask& operator|=(SetFileInfoMask& lhs, SetFileInfoMask rhs)
  { return (lhs = static_cast<SetFileInfoMask>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline SetFileInfoMask& operator&=(SetFileInfoMask& lhs, SetFileInfoMask rhs)
  { return (lhs = static_cast<SetFileInfoMask>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline SetFileInfoMask& operator^=(SetFileInfoMask& lhs, SetFileInfoMask rhs)
  { return (lhs = static_cast<SetFileInfoMask>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup libgnomevfsmmEnums
 */
enum MonitorType
{
  MONITOR_FILE,
  MONITOR_DIRECTORY
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum MonitorEventType
{
  MONITOR_EVENT_CHANGED,
  MONITOR_EVENT_DELETED,
  MONITOR_EVENT_STARTEXECUTING,
  MONITOR_EVENT_STOPEXECUTING,
  MONITOR_EVENT_CREATED,
  MONITOR_EVENT_METADATA_CHANGED
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum MimeApplicationArgumentType
{
  MIME_APPLICATION_ARGUMENT_TYPE_URIS,
  MIME_APPLICATION_ARGUMENT_TYPE_PATHS,
  MIME_APPLICATION_ARGUMENT_TYPE_URIS_FOR_NON_FILES
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum MimeActionType
{
  MIME_ACTION_TYPE_NONE,
  MIME_ACTION_TYPE_APPLICATION,
  MIME_ACTION_TYPE_COMPONENT
};


/**
 * @ingroup libgnomevfsmmEnums
 * @par Bitwise operators:
 * <tt>%TransferOptions operator|(TransferOptions, TransferOptions)</tt><br>
 * <tt>%TransferOptions operator&(TransferOptions, TransferOptions)</tt><br>
 * <tt>%TransferOptions operator^(TransferOptions, TransferOptions)</tt><br>
 * <tt>%TransferOptions operator~(TransferOptions)</tt><br>
 * <tt>%TransferOptions& operator|=(TransferOptions&, TransferOptions)</tt><br>
 * <tt>%TransferOptions& operator&=(TransferOptions&, TransferOptions)</tt><br>
 * <tt>%TransferOptions& operator^=(TransferOptions&, TransferOptions)</tt><br>
 */
enum TransferOptions
{
  XFER_DEFAULT = 0,
  XFER_UNUSED_1 = 1 << 0,
  XFER_FOLLOW_LINKS = 1 << 1,
  XFER_UNUSED_2 = 1 << 2,
  XFER_RECURSIVE = 1 << 3,
  XFER_SAMEFS = 1 << 4,
  XFER_DELETE_ITEMS = 1 << 5,
  XFER_EMPTY_DIRECTORIES = 1 << 6,
  XFER_NEW_UNIQUE_DIRECTORY = 1 << 7,
  XFER_REMOVESOURCE = 1 << 8,
  XFER_USE_UNIQUE_NAMES = 1 << 9,
  XFER_LINK_ITEMS = 1 << 10,
  XFER_FOLLOW_LINKS_RECURSIVE = 1 << 11
};

/** @ingroup libgnomevfsmmEnums */
inline TransferOptions operator|(TransferOptions lhs, TransferOptions rhs)
  { return static_cast<TransferOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline TransferOptions operator&(TransferOptions lhs, TransferOptions rhs)
  { return static_cast<TransferOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline TransferOptions operator^(TransferOptions lhs, TransferOptions rhs)
  { return static_cast<TransferOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline TransferOptions operator~(TransferOptions flags)
  { return static_cast<TransferOptions>(~static_cast<unsigned>(flags)); }

/** @ingroup libgnomevfsmmEnums */
inline TransferOptions& operator|=(TransferOptions& lhs, TransferOptions rhs)
  { return (lhs = static_cast<TransferOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline TransferOptions& operator&=(TransferOptions& lhs, TransferOptions rhs)
  { return (lhs = static_cast<TransferOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline TransferOptions& operator^=(TransferOptions& lhs, TransferOptions rhs)
  { return (lhs = static_cast<TransferOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup libgnomevfsmmEnums
 */
enum ProgressStatus
{
  XFER_PROGRESS_STATUS_OK,
  XFER_PROGRESS_STATUS_VFSERROR,
  XFER_PROGRESS_STATUS_OVERWRITE,
  XFER_PROGRESS_STATUS_DUPLICATE
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum OverwriteMode
{
  XFER_OVERWRITE_MODE_ABORT,
  XFER_OVERWRITE_MODE_QUERY,
  XFER_OVERWRITE_MODE_REPLACE,
  XFER_OVERWRITE_MODE_SKIP
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum OverwriteAction
{
  XFER_OVERWRITE_ACTION_ABORT,
  XFER_OVERWRITE_ACTION_REPLACE,
  XFER_OVERWRITE_ACTION_REPLACE_ALL,
  XFER_OVERWRITE_ACTION_SKIP,
  XFER_OVERWRITE_ACTION_SKIP_ALL
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum ErrorMode
{
  XFER_ERROR_MODE_ABORT,
  XFER_ERROR_MODE_QUERY
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum ErrorAction
{
  XFER_ERROR_ACTION_ABORT,
  XFER_ERROR_ACTION_RETRY,
  XFER_ERROR_ACTION_SKIP
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum Phase
{
  XFER_PHASE_INITIAL,
  XFER_CHECKING_DESTINATION,
  XFER_PHASE_COLLECTING,
  XFER_PHASE_READYTOGO,
  XFER_PHASE_OPENSOURCE,
  XFER_PHASE_OPENTARGET,
  XFER_PHASE_COPYING,
  XFER_PHASE_MOVING,
  XFER_PHASE_READSOURCE,
  XFER_PHASE_WRITETARGET,
  XFER_PHASE_CLOSESOURCE,
  XFER_PHASE_CLOSETARGET,
  XFER_PHASE_DELETESOURCE,
  XFER_PHASE_SETATTRIBUTES,
  XFER_PHASE_FILECOMPLETED,
  XFER_PHASE_CLEANUP,
  XFER_PHASE_COMPLETED,
  XFER_NUM_PHASES
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum VolumeType
{
  VOLUME_TYPE_MOUNTPOINT,
  VOLUME_TYPE_VFS_MOUNT,
  VOLUME_TYPE_CONNECTED_SERVER
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum DeviceType
{
  DEVICE_TYPE_UNKNOWN,
  DEVICE_TYPE_AUDIO_CD,
  DEVICE_TYPE_VIDEO_DVD,
  DEVICE_TYPE_HARDDRIVE,
  DEVICE_TYPE_CDROM,
  DEVICE_TYPE_FLOPPY,
  DEVICE_TYPE_ZIP,
  DEVICE_TYPE_JAZ,
  DEVICE_TYPE_NFS,
  DEVICE_TYPE_AUTOFS,
  DEVICE_TYPE_CAMERA,
  DEVICE_TYPE_MEMORY_STICK,
  DEVICE_TYPE_SMB,
  DEVICE_TYPE_APPLE,
  DEVICE_TYPE_MUSIC_PLAYER,
  DEVICE_TYPE_WINDOWS,
  DEVICE_TYPE_LOOPBACK,
  DEVICE_TYPE_NETWORK
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum DNSSDServiceStatus
{
  DNS_SD_SERVICE_ADDED,
  DNS_SD_SERVICE_REMOVED
};


} // namespace Vfs
} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Vfs::FileInfoOptions> : public Glib::Value_Flags<Gnome::Vfs::FileInfoOptions>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::Result> : public Glib::Value_Enum<Gnome::Vfs::Result>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::URIHideOptions> : public Glib::Value_Flags<Gnome::Vfs::URIHideOptions>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::DirectoryVisitOptions> : public Glib::Value_Flags<Gnome::Vfs::DirectoryVisitOptions>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::OpenMode> : public Glib::Value_Flags<Gnome::Vfs::OpenMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::SeekPosition> : public Glib::Value_Enum<Gnome::Vfs::SeekPosition>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::FileFlags> : public Glib::Value_Flags<Gnome::Vfs::FileFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::FileType> : public Glib::Value_Enum<Gnome::Vfs::FileType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::FilePermissions> : public Glib::Value_Flags<Gnome::Vfs::FilePermissions>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::SetFileInfoMask> : public Glib::Value_Flags<Gnome::Vfs::SetFileInfoMask>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::MonitorType> : public Glib::Value_Enum<Gnome::Vfs::MonitorType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::MonitorEventType> : public Glib::Value_Enum<Gnome::Vfs::MonitorEventType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::MimeApplicationArgumentType> : public Glib::Value_Enum<Gnome::Vfs::MimeApplicationArgumentType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::MimeActionType> : public Glib::Value_Enum<Gnome::Vfs::MimeActionType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::TransferOptions> : public Glib::Value_Flags<Gnome::Vfs::TransferOptions>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::ProgressStatus> : public Glib::Value_Enum<Gnome::Vfs::ProgressStatus>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::OverwriteMode> : public Glib::Value_Enum<Gnome::Vfs::OverwriteMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::OverwriteAction> : public Glib::Value_Enum<Gnome::Vfs::OverwriteAction>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::ErrorMode> : public Glib::Value_Enum<Gnome::Vfs::ErrorMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::ErrorAction> : public Glib::Value_Enum<Gnome::Vfs::ErrorAction>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::Phase> : public Glib::Value_Enum<Gnome::Vfs::Phase>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::VolumeType> : public Glib::Value_Enum<Gnome::Vfs::VolumeType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template <>
class Value<Gnome::Vfs::DeviceType> : public Glib::Value_Enum<Gnome::Vfs::DeviceType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#endif /* _LIBGNOMEVFSMM_ENUMS_H */

