/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import gnu.classpath.ServiceFactory;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;

public abstract class DatatypeFactory {
    public static final String DATATYPEFACTORY_PROPERTY = "javax.xml.datatype.DatatypeFactory";
    public static final String DATATYPEFACTORY_IMPLEMENTATION_CLASS = "gnu.xml.datatype.JAXPDatatypeFactory";

    protected DatatypeFactory() {
    }

    public static DatatypeFactory newInstance() throws DatatypeConfigurationException {
        try {
            Iterator i;
            String className = System.getProperty(DATATYPEFACTORY_PROPERTY);
            if (className != null) {
                return (DatatypeFactory)Class.forName(className).newInstance();
            }
            File javaHome = new File(System.getProperty("java.home"));
            File javaHomeLib = new File(javaHome, "lib");
            File jaxpProperties = new File(javaHomeLib, "jaxp.properties");
            if (jaxpProperties.exists()) {
                FileInputStream in = new FileInputStream(jaxpProperties);
                Properties p = new Properties();
                p.load(in);
                in.close();
                className = p.getProperty(DATATYPEFACTORY_PROPERTY);
                if (className != null) {
                    return (DatatypeFactory)Class.forName(className).newInstance();
                }
            }
            if ((i = ServiceFactory.lookupProviders(DatatypeFactory.class)).hasNext()) {
                return (DatatypeFactory)i.next();
            }
            Class<?> t = Class.forName(DATATYPEFACTORY_IMPLEMENTATION_CLASS);
            return (DatatypeFactory)t.newInstance();
        }
        catch (Exception e) {
            throw new DatatypeConfigurationException(e);
        }
    }

    public abstract Duration newDuration(String var1);

    public abstract Duration newDuration(long var1);

    public abstract Duration newDuration(boolean var1, BigInteger var2, BigInteger var3, BigInteger var4, BigInteger var5, BigInteger var6, BigDecimal var7);

    public Duration newDuration(boolean isPositive, int years, int months, int days, int hours, int minutes, int seconds) {
        return this.newDuration(isPositive, BigInteger.valueOf(years), BigInteger.valueOf(months), BigInteger.valueOf(days), BigInteger.valueOf(hours), BigInteger.valueOf(minutes), BigDecimal.valueOf(seconds));
    }

    public Duration newDurationDayTime(String lexicalRepresentation) {
        return this.newDuration(lexicalRepresentation);
    }

    public Duration newDurationDayTime(long durationInMilliseconds) {
        return this.newDuration(durationInMilliseconds);
    }

    public Duration newDurationDayTime(boolean isPositive, BigInteger days, BigInteger hours, BigInteger minutes, BigInteger seconds) {
        return this.newDuration(isPositive, null, null, days, hours, minutes, new BigDecimal(seconds));
    }

    public Duration newDurationDayTime(boolean isPositive, int days, int hours, int minutes, int seconds) {
        return this.newDuration(isPositive, null, null, BigInteger.valueOf(days), BigInteger.valueOf(hours), BigInteger.valueOf(minutes), BigDecimal.valueOf(seconds));
    }

    public Duration newDurationYearMonth(String lexicalRepresentation) {
        return this.newDuration(lexicalRepresentation);
    }

    public Duration newDurationYearMonth(long durationInMilliseconds) {
        return this.newDuration(durationInMilliseconds);
    }

    public Duration newDurationYearMonth(boolean isPositive, BigInteger years, BigInteger months) {
        return this.newDuration(isPositive, years, months, null, null, null, null);
    }

    public Duration newDurationYearMonth(boolean isPositive, int years, int months) {
        return this.newDuration(isPositive, BigInteger.valueOf(years), BigInteger.valueOf(months), null, null, null, null);
    }

    public abstract XMLGregorianCalendar newXMLGregorianCalendar();

    public abstract XMLGregorianCalendar newXMLGregorianCalendar(String var1);

    public abstract XMLGregorianCalendar newXMLGregorianCalendar(GregorianCalendar var1);

    public abstract XMLGregorianCalendar newXMLGregorianCalendar(BigInteger var1, int var2, int var3, int var4, int var5, int var6, BigDecimal var7, int var8);

    public XMLGregorianCalendar newXMLGregorianCalendar(int year, int month, int day, int hour, int minute, int second, int millisecond, int timezone) {
        return this.newXMLGregorianCalendar(BigInteger.valueOf(year), month, day, hour, minute, second, new BigDecimal((double)millisecond / 1000.0), timezone);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarDate(int year, int month, int day, int timezone) {
        return this.newXMLGregorianCalendar(BigInteger.valueOf(year), month, day, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, timezone);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarTime(int hours, int minutes, int seconds, int timezone) {
        return this.newXMLGregorianCalendar(null, Integer.MIN_VALUE, Integer.MIN_VALUE, hours, minutes, seconds, null, timezone);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarTime(int hours, int minutes, int seconds, BigDecimal fractionalSecond, int timezone) {
        return this.newXMLGregorianCalendar(null, Integer.MIN_VALUE, Integer.MIN_VALUE, hours, minutes, seconds, fractionalSecond, timezone);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarTime(int hours, int minutes, int seconds, int milliseconds, int timezone) {
        return this.newXMLGregorianCalendar(null, Integer.MIN_VALUE, Integer.MIN_VALUE, hours, minutes, seconds, new BigDecimal((double)milliseconds / 1000.0), timezone);
    }
}

