/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalProgressBarUI
extends BasicProgressBarUI {
    public static ComponentUI createUI(JComponent component) {
        return new MetalProgressBarUI();
    }

    public void paintDeterminate(Graphics g, JComponent c) {
        super.paintDeterminate(g, c);
        Color saved = g.getColor();
        Insets i = this.progressBar.getInsets();
        int w = this.progressBar.getWidth();
        int h = this.progressBar.getHeight();
        int orientation = this.progressBar.getOrientation();
        ColorUIResource shadow = MetalLookAndFeel.getControlShadow();
        g.setColor(shadow);
        g.drawLine(i.left, i.top, w - i.right, i.top);
        g.drawLine(i.left, i.top, i.left, h - i.bottom);
        int full = this.getAmountFull(i, w, h);
        if (full > 0) {
            ColorUIResource darkShadow = MetalLookAndFeel.getPrimaryControlDarkShadow();
            g.setColor(darkShadow);
            if (orientation == 0) {
                g.drawLine(i.left, i.top, i.left, h - i.bottom);
                g.drawLine(i.left, i.top, i.left + full - 1, i.top);
            } else {
                if (full >= h - i.top - i.bottom) {
                    g.drawLine(i.left, i.top, w - i.right, i.top);
                }
                g.drawLine(i.left, h - i.bottom, i.left, h - i.bottom - full);
            }
        }
        g.setColor(saved);
    }

    public void paintIndeterminate(Graphics g, JComponent c) {
        super.paintIndeterminate(g, c);
        Color saved = g.getColor();
        Insets i = this.progressBar.getInsets();
        int w = this.progressBar.getWidth();
        int h = this.progressBar.getHeight();
        ColorUIResource shadow = MetalLookAndFeel.getControlShadow();
        g.setColor(shadow);
        g.drawLine(i.left, i.top, w - i.right, i.top);
        g.drawLine(i.left, i.top, i.left, h - i.bottom);
        this.boxRect = this.getBox(this.boxRect);
        ColorUIResource darkShadow = MetalLookAndFeel.getPrimaryControlDarkShadow();
        g.setColor(darkShadow);
        int orientation = this.progressBar.getOrientation();
        if (orientation == 0) {
            g.drawLine(this.boxRect.x, i.top, this.boxRect.x + this.boxRect.width - 1, i.top);
        } else {
            g.drawLine(i.left, this.boxRect.y, i.left, this.boxRect.y + this.boxRect.height - 1);
        }
        g.setColor(saved);
    }
}

