/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicLabelUI
extends LabelUI
implements PropertyChangeListener {
    protected static BasicLabelUI labelUI;
    private Rectangle vr = new Rectangle();
    private Rectangle ir = new Rectangle();
    private Rectangle tr = new Rectangle();
    private Insets cachedInsets;

    public static ComponentUI createUI(JComponent c) {
        if (labelUI == null) {
            labelUI = new BasicLabelUI();
        }
        return labelUI;
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension ret;
        JLabel lab = (JLabel)c;
        Insets insets = lab.getInsets();
        int insetsX = insets.left + insets.right;
        int insetsY = insets.top + insets.bottom;
        Icon icon = lab.getIcon();
        String text = lab.getText();
        if (icon == null && text == null) {
            ret = new Dimension(insetsX, insetsY);
        } else if (icon != null && text == null) {
            ret = new Dimension(icon.getIconWidth() + insetsX, icon.getIconHeight() + insetsY);
        } else {
            FontMetrics fm = this.getFontMetrics(lab);
            this.ir.x = 0;
            this.ir.y = 0;
            this.ir.width = 0;
            this.ir.height = 0;
            this.tr.x = 0;
            this.tr.y = 0;
            this.tr.width = 0;
            this.tr.height = 0;
            this.vr.x = 0;
            this.vr.y = 0;
            this.vr.width = Short.MAX_VALUE;
            this.vr.height = Short.MAX_VALUE;
            this.layoutCL(lab, fm, text, icon, this.vr, this.ir, this.tr);
            Rectangle cr = SwingUtilities.computeUnion(this.tr.x, this.tr.y, this.tr.width, this.tr.height, this.ir);
            ret = new Dimension(cr.width + insetsX, cr.height + insetsY);
        }
        return ret;
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public void paint(Graphics g, JComponent c) {
        JLabel b = (JLabel)c;
        Icon icon = b.isEnabled() ? b.getIcon() : b.getDisabledIcon();
        String text = b.getText();
        if (icon != null || text != null && !text.equals("")) {
            FontMetrics fm = this.getFontMetrics(b);
            Insets i = c.getInsets(this.cachedInsets);
            this.vr.x = i.left;
            this.vr.y = i.right;
            this.vr.width = c.getWidth() - i.left - i.right;
            this.vr.height = c.getHeight() - i.top - i.bottom;
            this.ir.x = 0;
            this.ir.y = 0;
            this.ir.width = 0;
            this.ir.height = 0;
            this.tr.x = 0;
            this.tr.y = 0;
            this.tr.width = 0;
            this.tr.height = 0;
            text = this.layoutCL(b, fm, text, icon, this.vr, this.ir, this.tr);
            if (icon != null) {
                icon.paintIcon(b, g, this.ir.x, this.ir.y);
            }
            if (text != null && !text.equals("")) {
                Object htmlRenderer = b.getClientProperty("html");
                if (htmlRenderer == null) {
                    if (b.isEnabled()) {
                        this.paintEnabledText(b, g, text, this.tr.x, this.tr.y + fm.getAscent());
                    } else {
                        this.paintDisabledText(b, g, text, this.tr.x, this.tr.y + fm.getAscent());
                    }
                } else {
                    ((View)htmlRenderer).paint(g, this.tr);
                }
            }
        }
    }

    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        return SwingUtilities.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap());
    }

    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        g.setColor(l.getBackground().brighter());
        int mnemIndex = l.getDisplayedMnemonicIndex();
        if (mnemIndex != -1) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, s, mnemIndex, textX, textY);
        } else {
            g.drawString(s, textX, textY);
        }
        g.setColor(l.getBackground().darker());
        if (mnemIndex != -1) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, s, mnemIndex, textX + 1, textY + 1);
        } else {
            g.drawString(s, textX + 1, textY + 1);
        }
    }

    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        g.setColor(l.getForeground());
        int mnemIndex = l.getDisplayedMnemonicIndex();
        if (mnemIndex != -1) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, s, mnemIndex, textX, textY);
        } else {
            g.drawString(s, textX, textY);
        }
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JLabel) {
            JLabel l = (JLabel)c;
            this.installComponents(l);
            this.installDefaults(l);
            this.installListeners(l);
            this.installKeyboardActions(l);
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (c instanceof JLabel) {
            JLabel l = (JLabel)c;
            this.uninstallKeyboardActions(l);
            this.uninstallListeners(l);
            this.uninstallDefaults(l);
            this.uninstallComponents(l);
        }
    }

    protected void installComponents(JLabel c) {
        BasicHTML.updateRenderer(c, c.getText());
    }

    protected void uninstallComponents(JLabel c) {
        c.putClientProperty("html", null);
        c.putClientProperty("html.base", null);
    }

    protected void installDefaults(JLabel c) {
        LookAndFeel.installColorsAndFont(c, "Label.background", "Label.foreground", "Label.font");
    }

    protected void uninstallDefaults(JLabel c) {
        c.setForeground(null);
        c.setBackground(null);
        c.setFont(null);
    }

    protected void installKeyboardActions(JLabel l) {
        int mnemonic;
        Component c = l.getLabelFor();
        if (c != null && (mnemonic = l.getDisplayedMnemonic()) > 0) {
            InputMap keyMap = new InputMap();
            keyMap.put(KeyStroke.getKeyStroke(mnemonic, 18), "press");
            SwingUtilities.replaceUIInputMap(l, 2, keyMap);
            ActionMap map = new ActionMap();
            map.put("press", new AbstractAction(){

                public void actionPerformed(ActionEvent event) {
                    JLabel label = (JLabel)event.getSource();
                    Component c = label.getLabelFor();
                    if (c != null) {
                        c.requestFocus();
                    }
                }
            });
            SwingUtilities.replaceUIActionMap(l, map);
        }
    }

    protected void uninstallKeyboardActions(JLabel l) {
        SwingUtilities.replaceUIActionMap(l, null);
        SwingUtilities.replaceUIInputMap(l, 2, null);
    }

    protected void installListeners(JLabel c) {
        c.addPropertyChangeListener(this);
    }

    protected void uninstallListeners(JLabel c) {
        c.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("text")) {
            String text = (String)e.getNewValue();
            JLabel l = (JLabel)e.getSource();
            BasicHTML.updateRenderer(l, text);
        } else if (e.getPropertyName().equals("displayedMnemonic")) {
            JLabel label = (JLabel)e.getSource();
            if (label.getLabelFor() != null) {
                int oldMnemonic = (Integer)e.getOldValue();
                int newMnemonic = (Integer)e.getNewValue();
                InputMap keyMap = label.getInputMap(2);
                keyMap.put(KeyStroke.getKeyStroke(oldMnemonic, 512), null);
                keyMap.put(KeyStroke.getKeyStroke(newMnemonic, 512), "press");
            }
        } else if (e.getPropertyName().equals("labelFor")) {
            JLabel label = (JLabel)e.getSource();
            InputMap keyMap = label.getInputMap(2);
            int mnemonic = label.getDisplayedMnemonic();
            if (mnemonic > 0) {
                keyMap.put(KeyStroke.getKeyStroke(mnemonic, 512), "press");
            }
        }
    }

    private FontMetrics getFontMetrics(JLabel l) {
        Font font = l.getFont();
        FontMetrics fm = l.getFontMetrics(font);
        if (fm == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            fm = tk.getFontMetrics(font);
        }
        return fm;
    }
}

