/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleStateSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.View;

public class JTextArea
extends JTextComponent {
    private static final long serialVersionUID = -6141680179310439825L;
    private int rows;
    private int columns;
    private boolean lineWrap;
    private int tabSize = 8;
    private boolean wrapStyleWord;

    public JTextArea() {
        this(null, null, 0, 0);
    }

    public JTextArea(String text) {
        this(null, text, 0, 0);
    }

    public JTextArea(int rows, int columns) {
        this(null, null, rows, columns);
    }

    public JTextArea(String text, int rows, int columns) {
        this(null, text, rows, columns);
    }

    public JTextArea(Document doc) {
        this(doc, null, 0, 0);
    }

    public JTextArea(Document doc, String text, int rows, int columns) {
        this.setDocument(doc == null ? this.createDefaultModel() : doc);
        if (text != null) {
            this.setText(text);
        }
        this.setRows(rows);
        this.setColumns(columns);
    }

    public void append(String toAppend) {
        try {
            this.getDocument().insertString(this.getText().length(), toAppend, null);
        }
        catch (BadLocationException exception) {
            throw new RuntimeException("Unexpected exception occurred.", exception);
        }
        if (toAppend != null && toAppend.length() > 0) {
            this.revalidate();
        }
    }

    protected Document createDefaultModel() {
        return new PlainDocument();
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.lineWrap ? true : super.getScrollableTracksViewportWidth();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return this.getRowHeight();
        }
        if (orientation == 0) {
            return this.getColumnWidth();
        }
        throw new IllegalArgumentException("orientation must be either javax.swing.SwingConstants.VERTICAL or javax.swing.SwingConstants.HORIZONTAL");
    }

    public Dimension getPreferredScrollableViewportSize() {
        if (this.rows > 0 && this.columns > 0) {
            return new Dimension(this.columns * this.getColumnWidth(), this.rows * this.getRowHeight());
        }
        return super.getPreferredScrollableViewportSize();
    }

    public String getUIClassID() {
        return "TextAreaUI";
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        if (columns < 0) {
            throw new IllegalArgumentException();
        }
        if (columns != this.columns) {
            this.columns = columns;
            this.revalidate();
        }
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        if (rows < 0) {
            throw new IllegalArgumentException();
        }
        if (rows != this.rows) {
            this.rows = rows;
            this.revalidate();
        }
    }

    public boolean getLineWrap() {
        return this.lineWrap;
    }

    public void setLineWrap(boolean flag) {
        if (this.lineWrap == flag) {
            return;
        }
        boolean oldValue = this.lineWrap;
        this.lineWrap = flag;
        this.firePropertyChange("lineWrap", oldValue, this.lineWrap);
    }

    public boolean getWrapStyleWord() {
        return this.wrapStyleWord;
    }

    public void setWrapStyleWord(boolean flag) {
        if (this.wrapStyleWord == flag) {
            return;
        }
        boolean oldValue = this.wrapStyleWord;
        this.wrapStyleWord = flag;
        this.firePropertyChange("wrapStyleWord", oldValue, this.wrapStyleWord);
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int newSize) {
        if (this.tabSize == newSize) {
            return;
        }
        int oldValue = this.tabSize;
        this.tabSize = newSize;
        this.firePropertyChange("tabSize", oldValue, this.tabSize);
    }

    protected int getColumnWidth() {
        FontMetrics metrics = this.getToolkit().getFontMetrics(this.getFont());
        return metrics.charWidth('m');
    }

    public int getLineCount() {
        return this.getDocument().getDefaultRootElement().getElementCount();
    }

    public int getLineStartOffset(int line) throws BadLocationException {
        int lineCount = this.getLineCount();
        if (line < 0 || line > lineCount) {
            throw new BadLocationException("Non-existing line number", line);
        }
        Element lineElem = this.getDocument().getDefaultRootElement().getElement(line);
        return lineElem.getStartOffset();
    }

    public int getLineEndOffset(int line) throws BadLocationException {
        int lineCount = this.getLineCount();
        if (line < 0 || line > lineCount) {
            throw new BadLocationException("Non-existing line number", line);
        }
        Element lineElem = this.getDocument().getDefaultRootElement().getElement(line);
        return lineElem.getEndOffset();
    }

    public int getLineOfOffset(int offset) throws BadLocationException {
        Document doc = this.getDocument();
        if (offset < doc.getStartPosition().getOffset() || offset >= doc.getEndPosition().getOffset()) {
            throw new BadLocationException("offset outside of document", offset);
        }
        return doc.getDefaultRootElement().getElementIndex(offset);
    }

    protected int getRowHeight() {
        FontMetrics metrics = this.getToolkit().getFontMetrics(this.getFont());
        return metrics.getHeight();
    }

    public void insert(String string, int position) {
        Document doc = this.getDocument();
        if (doc == null || string == null || string.length() == 0) {
            return;
        }
        try {
            doc.insertString(position, string, null);
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalArgumentException("The supplied position, " + position + ", was invalid.");
        }
    }

    public void replaceRange(String text, int start, int end) {
        Document doc = this.getDocument();
        if (start > end || start < doc.getStartPosition().getOffset() || end >= doc.getEndPosition().getOffset()) {
            throw new IllegalArgumentException();
        }
        try {
            doc.remove(start, end - start);
            doc.insertString(start, text, null);
        }
        catch (BadLocationException badLocationException) {}
    }

    public Dimension getPreferredSize() {
        int reqWidth = this.getColumns() * this.getColumnWidth();
        int reqHeight = this.getRows() * this.getRowHeight();
        View view = this.getUI().getRootView(this);
        int neededWidth = (int)view.getPreferredSpan(0);
        int neededHeight = (int)view.getPreferredSpan(1);
        return new Dimension(Math.max(reqWidth, neededWidth), Math.max(reqHeight, neededHeight));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTextArea();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJTextArea
    extends JTextComponent.AccessibleJTextComponent {
        protected AccessibleJTextArea() {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet state = super.getAccessibleStateSet();
            return state;
        }
    }
}

