/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleTableModelChange;
import javax.swing.BorderFactory;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SizeSequence;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.TableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTable
extends JComponent
implements TableModelListener,
Scrollable,
TableColumnModelListener,
ListSelectionListener,
CellEditorListener,
Accessible {
    private static final long serialVersionUID = 3876025080382781659L;
    final JTable this_table = this;
    public static final int AUTO_RESIZE_OFF = 0;
    public static final int AUTO_RESIZE_NEXT_COLUMN = 1;
    public static final int AUTO_RESIZE_SUBSEQUENT_COLUMNS = 2;
    public static final int AUTO_RESIZE_ALL_COLUMNS = 4;
    public static final int AUTO_RESIZE_LAST_COLUMN = 3;
    protected Hashtable defaultEditorsByColumnClass = new Hashtable();
    protected Hashtable defaultRenderersByColumnClass = new Hashtable();
    protected int editingColumn;
    protected int editingRow;
    protected transient Component editorComp;
    protected boolean autoCreateColumnsFromModel;
    protected int autoResizeMode;
    protected int rowHeight;
    protected int rowMargin;
    protected boolean rowSelectionAllowed;
    protected boolean cellSelectionEnabled;
    protected TableModel dataModel;
    protected TableColumnModel columnModel;
    protected ListSelectionModel selectionModel;
    protected TableCellEditor cellEditor;
    private boolean dragEnabled;
    protected Color gridColor;
    protected Dimension preferredViewportSize;
    protected Color selectionBackground;
    private static final String SELECTION_BACKGROUND_CHANGED_PROPERTY = "selectionBackground";
    protected Color selectionForeground;
    private static final String SELECTION_FOREGROUND_CHANGED_PROPERTY = "selectionForeground";
    protected boolean showHorizontalLines;
    protected boolean showVerticalLines;
    protected JTableHeader tableHeader;
    TableColumnPropertyChangeHandler tableColumnPropertyChangeHandler = new TableColumnPropertyChangeHandler();
    private boolean surrendersFocusOnKeystroke = false;
    private Rectangle rectCache = new Rectangle();
    private boolean clientRowHeightSet = false;
    private SizeSequence rowHeights;
    private transient TableCellEditor booleanInvertingEditor;

    public JTable() {
        this(null, null, null);
    }

    public JTable(int numRows, int numColumns) {
        this(new DefaultTableModel(numRows, numColumns));
    }

    public JTable(Object[][] data, Object[] columnNames) {
        this(new DefaultTableModel(data, columnNames));
    }

    public JTable(TableModel model) {
        this(model, null, null);
    }

    public JTable(TableModel dm, TableColumnModel cm) {
        this(dm, cm, null);
    }

    public JTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        TableColumnModel columnModel;
        boolean autoCreate = false;
        if (cm != null) {
            columnModel = cm;
        } else {
            columnModel = this.createDefaultColumnModel();
            autoCreate = true;
        }
        this.rowMargin = 1;
        columnModel.setColumnMargin(1);
        this.setColumnModel(columnModel);
        this.setSelectionModel(sm == null ? this.createDefaultSelectionModel() : sm);
        this.setModel(dm == null ? this.createDefaultDataModel() : dm);
        this.setAutoCreateColumnsFromModel(autoCreate);
        this.initializeLocalVars();
        this.updateUI();
    }

    public JTable(Vector data, Vector columnNames) {
        this(new DefaultTableModel(data, columnNames));
    }

    protected void initializeLocalVars() {
        this.setTableHeader(this.createDefaultTableHeader());
        if (this.autoCreateColumnsFromModel) {
            this.createDefaultColumnsFromModel();
        }
        this.columnModel.addColumnModelListener(this);
        this.autoResizeMode = 2;
        this.setRowHeight(16);
        this.rowMargin = 1;
        this.rowSelectionAllowed = true;
        this.cellEditor = null;
        this.dragEnabled = false;
        this.preferredViewportSize = new Dimension(450, 400);
        this.showHorizontalLines = true;
        this.showVerticalLines = true;
        this.editingColumn = -1;
        this.editingRow = -1;
    }

    public void addColumn(TableColumn column) {
        if (column.getHeaderValue() == null) {
            String name = this.dataModel.getColumnName(column.getModelIndex());
            column.setHeaderValue(name);
        }
        this.columnModel.addColumn(column);
        column.addPropertyChangeListener(this.tableColumnPropertyChangeHandler);
    }

    protected void createDefaultEditors() {
        JCheckBox box = new BooleanCellRenderer().getCheckBox();
        box.setBorder(BorderFactory.createLineBorder(this.getGridColor(), 2));
        box.setBorderPainted(true);
        this.booleanInvertingEditor = new DefaultCellEditor(box);
        this.setDefaultEditor(Boolean.class, this.booleanInvertingEditor);
    }

    protected void createDefaultRenderers() {
        this.setDefaultRenderer(Boolean.class, new BooleanCellRenderer());
        this.setDefaultRenderer(Number.class, new NumberCellRenderer());
        this.setDefaultRenderer(Double.class, new DoubleCellRenderer());
        this.setDefaultRenderer(Double.class, new FloatCellRenderer());
        this.setDefaultRenderer(Date.class, new DateCellRenderer());
        this.setDefaultRenderer(Icon.class, new IconCellRenderer());
        this.setDefaultRenderer(ImageIcon.class, new IconCellRenderer());
    }

    public static JScrollPane createScrollPaneForTable(JTable table) {
        return new JScrollPane(table);
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel();
    }

    protected TableModel createDefaultDataModel() {
        return new DefaultTableModel();
    }

    protected ListSelectionModel createDefaultSelectionModel() {
        return new DefaultListSelectionModel();
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel);
    }

    @Override
    public void columnAdded(TableColumnModelEvent event) {
        this.revalidate();
        this.repaint();
    }

    @Override
    public void columnMarginChanged(ChangeEvent event) {
        this.revalidate();
        this.repaint();
    }

    @Override
    public void columnMoved(TableColumnModelEvent event) {
        if (this.isEditing()) {
            this.editingCanceled(null);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void columnRemoved(TableColumnModelEvent event) {
        this.revalidate();
        this.repaint();
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent event) {
        int idx0 = Math.max(0, Math.min(this.getColumnCount() - 1, event.getFirstIndex()));
        int idxn = Math.max(0, Math.min(this.getColumnCount() - 1, event.getLastIndex()));
        int minRow = 0;
        int maxRow = this.getRowCount() - 1;
        if (this.getRowSelectionAllowed()) {
            minRow = this.selectionModel.getMinSelectionIndex();
            maxRow = this.selectionModel.getMaxSelectionIndex();
            int leadRow = this.selectionModel.getLeadSelectionIndex();
            if (minRow == -1 && maxRow == -1) {
                minRow = leadRow;
                maxRow = leadRow;
            } else if (leadRow != -1) {
                minRow = Math.min(minRow, leadRow);
                maxRow = Math.max(maxRow, leadRow);
            }
        }
        if (minRow != -1 && maxRow != -1) {
            Rectangle first = this.getCellRect(minRow, idx0, false);
            Rectangle last = this.getCellRect(maxRow, idxn, false);
            Rectangle dirty = SwingUtilities.computeUnion(first.x, first.y, first.width, first.height, last);
            this.repaint(dirty);
        }
    }

    @Override
    public void editingCanceled(ChangeEvent event) {
        if (this.editorComp != null) {
            this.remove(this.editorComp);
            this.repaint(this.editorComp.getBounds());
            this.editorComp = null;
        }
    }

    @Override
    public void editingStopped(ChangeEvent event) {
        if (this.editorComp != null) {
            this.remove(this.editorComp);
            this.setValueAt(this.cellEditor.getCellEditorValue(), this.editingRow, this.editingColumn);
            this.repaint(this.editorComp.getBounds());
            this.editorComp = null;
        }
        this.requestFocusInWindow();
    }

    @Override
    public void tableChanged(TableModelEvent event) {
        if (event == null || event.getFirstRow() == -1) {
            this.handleCompleteChange(event);
        } else if (event.getType() == 1) {
            this.handleInsert(event);
        } else if (event.getType() == -1) {
            this.handleDelete(event);
        } else {
            this.handleUpdate(event);
        }
    }

    private void handleCompleteChange(TableModelEvent ev) {
        this.clearSelection();
        this.checkSelection();
        this.rowHeights = null;
        if (this.getAutoCreateColumnsFromModel()) {
            this.createDefaultColumnsFromModel();
        } else {
            this.resizeAndRepaint();
        }
    }

    private void handleInsert(TableModelEvent ev) {
        int last;
        int first = ev.getFirstRow();
        if (first < 0) {
            first = 0;
        }
        if ((last = ev.getLastRow()) < 0) {
            last = this.getRowCount() - 1;
        }
        this.selectionModel.insertIndexInterval(first, last - first + 1, true);
        this.checkSelection();
        if (this.rowHeights != null) {
            this.rowHeights.insertEntries(first, last - first + 1, this.rowHeight);
            this.repaint();
        } else {
            int rowHeight = this.getRowHeight();
            Rectangle dirty = new Rectangle(0, first * rowHeight, this.getColumnModel().getTotalColumnWidth(), (this.getRowCount() - first) * rowHeight);
            this.repaint(dirty);
        }
        this.revalidate();
    }

    private void handleDelete(TableModelEvent ev) {
        int last;
        int first = ev.getFirstRow();
        if (first < 0) {
            first = 0;
        }
        if ((last = ev.getLastRow()) < 0) {
            last = this.getRowCount() - 1;
        }
        this.selectionModel.removeIndexInterval(first, last);
        this.checkSelection();
        if (this.dataModel.getRowCount() == 0) {
            this.clearSelection();
        }
        if (this.rowHeights != null) {
            this.rowHeights.removeEntries(first, last - first + 1);
            this.repaint();
        } else {
            int rowHeight = this.getRowHeight();
            int oldRowCount = this.getRowCount() + last - first + 1;
            Rectangle dirty = new Rectangle(0, first * rowHeight, this.getColumnModel().getTotalColumnWidth(), (oldRowCount - first) * rowHeight);
            this.repaint(dirty);
        }
        this.revalidate();
    }

    private void handleUpdate(TableModelEvent ev) {
        if (this.rowHeights == null) {
            Rectangle dirty;
            int firstRow = ev.getFirstRow();
            int lastRow = ev.getLastRow();
            int col = ev.getColumn();
            if (col == -1) {
                dirty = new Rectangle(0, firstRow * this.getRowHeight(), this.getColumnModel().getTotalColumnWidth(), 0);
            } else {
                int column = this.convertColumnIndexToModel(col);
                dirty = this.getCellRect(firstRow, column, false);
            }
            dirty.height = (lastRow + 1) * this.getRowHeight();
            this.repaint(dirty);
        } else {
            this.repaint();
        }
    }

    private void checkSelection() {
        TableModel m = this.getModel();
        ListSelectionModel sm = this.selectionModel;
        if (m != null) {
            int lead = sm.getLeadSelectionIndex();
            int c = m.getRowCount();
            if (c == 0 && lead != -1) {
                sm.setValueIsAdjusting(true);
                sm.setAnchorSelectionIndex(-1);
                sm.setLeadSelectionIndex(-1);
                sm.setValueIsAdjusting(false);
            } else if (c != 0 && lead == -1) {
                if (sm.isSelectedIndex(0)) {
                    sm.addSelectionInterval(0, 0);
                } else {
                    sm.removeSelectionInterval(0, 0);
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (this.isEditing()) {
            this.editingStopped(null);
        }
        int first = Math.max(0, Math.min(this.getRowCount() - 1, event.getFirstIndex()));
        int last = Math.max(0, Math.min(this.getRowCount() - 1, event.getLastIndex()));
        Rectangle rect1 = this.getCellRect(first, 0, false);
        Rectangle rect2 = this.getCellRect(last, this.getColumnCount() - 1, false);
        Rectangle dirty = SwingUtilities.computeUnion(rect2.x, rect2.y, rect2.width, rect2.height, rect1);
        this.repaint(dirty);
    }

    public int columnAtPoint(Point point) {
        int ncols = this.getColumnCount();
        Dimension gap = this.getIntercellSpacing();
        TableColumnModel cols = this.getColumnModel();
        int x = point.x;
        int i = 0;
        while (i < ncols) {
            int width = cols.getColumn(i).getWidth() + (gap == null ? 0 : gap.width);
            if (x >= 0 && x < width) {
                return i;
            }
            x -= width;
            ++i;
        }
        return -1;
    }

    public int rowAtPoint(Point point) {
        if (point != null) {
            int r;
            int nrows = this.getRowCount();
            int y = point.y;
            if (this.rowHeights == null) {
                int height = this.getRowHeight();
                r = y / height;
            } else {
                r = this.rowHeights.getIndex(y);
            }
            if (r < 0 || r >= nrows) {
                return -1;
            }
            return r;
        }
        return -1;
    }

    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle cellRect = new Rectangle(0, 0, 0, 0);
        if (row >= this.getRowCount()) {
            cellRect.height = this.getHeight();
        } else if (row >= 0) {
            cellRect.height = this.getRowHeight(row);
            cellRect.y = this.rowHeights == null ? row * cellRect.height : this.rowHeights.getPosition(row);
            if (!includeSpacing) {
                int rMargin = this.getRowMargin();
                cellRect.y += rMargin / 2;
                cellRect.height -= rMargin;
            }
        }
        if (column < 0) {
            if (!this.getComponentOrientation().isLeftToRight()) {
                cellRect.x = this.getWidth();
            }
        } else if (column >= this.getColumnCount()) {
            if (this.getComponentOrientation().isLeftToRight()) {
                cellRect.x = this.getWidth();
            }
        } else {
            int i;
            TableColumnModel tcm = this.getColumnModel();
            if (this.getComponentOrientation().isLeftToRight()) {
                i = 0;
                while (i < column) {
                    cellRect.x += tcm.getColumn(i).getWidth();
                    ++i;
                }
            } else {
                i = tcm.getColumnCount() - 1;
                while (i > column) {
                    cellRect.x += tcm.getColumn(i).getWidth();
                    --i;
                }
            }
            cellRect.width = tcm.getColumn(column).getWidth();
            if (!includeSpacing) {
                int cMargin = tcm.getColumnMargin();
                cellRect.x += cMargin / 2;
                cellRect.width -= cMargin;
            }
        }
        return cellRect;
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
        this.getColumnModel().getSelectionModel().clearSelection();
    }

    public int getSelectedRow() {
        return this.selectionModel.getMinSelectionIndex();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int rowHeight;
        int block = orientation == 0 ? visibleRect.width : ((rowHeight = this.getRowHeight()) > 0 ? Math.max(rowHeight, visibleRect.height / rowHeight * rowHeight) : visibleRect.height);
        return block;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.autoResizeMode != 0;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int unit;
        if (orientation == 0) {
            unit = 100;
        } else {
            unit = this.getRowHeight();
            if (this.rowHeights == null) {
                if (direction > 0) {
                    int exposed = (visibleRect.y + visibleRect.height) % unit;
                    if (exposed > 0 && exposed < unit - 1) {
                        unit = unit - exposed - 1;
                    }
                } else {
                    int exposed = visibleRect.y % unit;
                    if (exposed > 0 && exposed < unit) {
                        unit = exposed;
                    }
                }
            }
        }
        return unit;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor editor = this.columnModel.getColumn(column).getCellEditor();
        if (editor == null) {
            int mcolumn = this.convertColumnIndexToModel(column);
            editor = this.getDefaultEditor(this.dataModel.getColumnClass(mcolumn));
        }
        return editor;
    }

    public TableCellEditor getDefaultEditor(Class<?> columnClass) {
        if (this.defaultEditorsByColumnClass.containsKey(columnClass)) {
            return (TableCellEditor)this.defaultEditorsByColumnClass.get(columnClass);
        }
        TableTextField t = new TableTextField();
        DefaultCellEditor r = new DefaultCellEditor(t);
        this.defaultEditorsByColumnClass.put(columnClass, r);
        return r;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = null;
        if (this.columnModel.getColumnCount() > 0) {
            renderer = this.columnModel.getColumn(column).getCellRenderer();
        }
        if (renderer == null) {
            int mcolumn = this.convertColumnIndexToModel(column);
            renderer = this.getDefaultRenderer(this.dataModel.getColumnClass(mcolumn));
        }
        return renderer;
    }

    public void setDefaultRenderer(Class<?> columnClass, TableCellRenderer rend) {
        this.defaultRenderersByColumnClass.put(columnClass, rend);
    }

    public TableCellRenderer getDefaultRenderer(Class<?> columnClass) {
        if (this.defaultRenderersByColumnClass.containsKey(columnClass)) {
            return (TableCellRenderer)this.defaultRenderersByColumnClass.get(columnClass);
        }
        DefaultTableCellRenderer r = new DefaultTableCellRenderer();
        this.defaultRenderersByColumnClass.put(columnClass, r);
        return r;
    }

    public int convertColumnIndexToModel(int vc) {
        if (vc < 0) {
            return vc;
        }
        return this.columnModel.getColumn(vc).getModelIndex();
    }

    public int convertColumnIndexToView(int mc) {
        if (mc < 0) {
            return mc;
        }
        int ncols = this.getColumnCount();
        int vc = 0;
        while (vc < ncols) {
            if (this.columnModel.getColumn(vc).getModelIndex() == mc) {
                return vc;
            }
            ++vc;
        }
        return -1;
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        boolean rowSelAllowed = this.getRowSelectionAllowed();
        boolean colSelAllowed = this.getColumnSelectionAllowed();
        boolean isSel = false;
        isSel = rowSelAllowed && colSelAllowed || !rowSelAllowed && !colSelAllowed ? this.isCellSelected(row, column) : this.isRowSelected(row) && this.getRowSelectionAllowed() || this.isColumnSelected(column) && this.getColumnSelectionAllowed();
        ListSelectionModel rowSel = this.getSelectionModel();
        ListSelectionModel colSel = this.getColumnModel().getSelectionModel();
        boolean hasFocus = this.hasFocus() && this.isEnabled() && rowSel.getLeadSelectionIndex() == row && colSel.getLeadSelectionIndex() == column;
        return renderer.getTableCellRendererComponent(this, this.dataModel.getValueAt(row, this.convertColumnIndexToModel(column)), isSel, hasFocus, row, column);
    }

    public boolean getAutoCreateColumnsFromModel() {
        return this.autoCreateColumnsFromModel;
    }

    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getRowHeight(int row) {
        int rh = this.rowHeight;
        if (this.rowHeights != null) {
            rh = this.rowHeights.getSize(row);
        }
        return rh;
    }

    public int getRowMargin() {
        return this.rowMargin;
    }

    public boolean getRowSelectionAllowed() {
        return this.rowSelectionAllowed;
    }

    public boolean getCellSelectionEnabled() {
        return this.getColumnSelectionAllowed() && this.getRowSelectionAllowed();
    }

    public TableModel getModel() {
        return this.dataModel;
    }

    public int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    public int getRowCount() {
        return this.dataModel.getRowCount();
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public int getSelectedColumn() {
        return this.columnModel.getSelectionModel().getMinSelectionIndex();
    }

    private static int countSelections(ListSelectionModel lsm) {
        int lo = lsm.getMinSelectionIndex();
        int hi = lsm.getMaxSelectionIndex();
        int sum = 0;
        if (lo != -1 && hi != -1) {
            switch (lsm.getSelectionMode()) {
                case 0: {
                    sum = 1;
                    break;
                }
                case 1: {
                    sum = hi - lo + 1;
                    break;
                }
                case 2: {
                    int i = lo;
                    while (i <= hi) {
                        if (lsm.isSelectedIndex(i)) {
                            ++sum;
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        return sum;
    }

    private static int[] getSelections(ListSelectionModel lsm) {
        int sz = JTable.countSelections(lsm);
        int[] ret = new int[sz];
        int lo = lsm.getMinSelectionIndex();
        int hi = lsm.getMaxSelectionIndex();
        int j = 0;
        if (lo != -1 && hi != -1) {
            switch (lsm.getSelectionMode()) {
                case 0: {
                    ret[0] = lo;
                    break;
                }
                case 1: {
                    int i = lo;
                    while (i <= hi) {
                        ret[j++] = i++;
                    }
                    break;
                }
                case 2: {
                    int i = lo;
                    while (i <= hi) {
                        if (lsm.isSelectedIndex(i)) {
                            ret[j++] = i;
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        return ret;
    }

    public int getSelectedColumnCount() {
        return JTable.countSelections(this.columnModel.getSelectionModel());
    }

    public int[] getSelectedColumns() {
        return JTable.getSelections(this.columnModel.getSelectionModel());
    }

    public boolean getColumnSelectionAllowed() {
        return this.getColumnModel().getColumnSelectionAllowed();
    }

    public int getSelectedRowCount() {
        return JTable.countSelections(this.selectionModel);
    }

    public int[] getSelectedRows() {
        return JTable.getSelections(this.selectionModel);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            AccessibleJTable ctx = new AccessibleJTable();
            this.addPropertyChangeListener(ctx);
            TableColumnModel tcm = this.getColumnModel();
            tcm.addColumnModelListener(ctx);
            tcm.getSelectionModel().addListSelectionListener(ctx);
            this.getSelectionModel().addListSelectionListener(ctx);
            this.accessibleContext = ctx;
        }
        return this.accessibleContext;
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public Dimension getIntercellSpacing() {
        return new Dimension(this.columnModel.getColumnMargin(), this.rowMargin);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.preferredViewportSize;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public boolean getShowHorizontalLines() {
        return this.showHorizontalLines;
    }

    public boolean getShowVerticalLines() {
        return this.showVerticalLines;
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void removeColumn(TableColumn column) {
        this.columnModel.removeColumn(column);
    }

    public void moveColumn(int column, int targetColumn) {
        this.columnModel.moveColumn(column, targetColumn);
    }

    public void setAutoCreateColumnsFromModel(boolean autoCreate) {
        if (this.autoCreateColumnsFromModel != autoCreate) {
            this.autoCreateColumnsFromModel = autoCreate;
            if (autoCreate) {
                this.createDefaultColumnsFromModel();
            }
        }
    }

    public void setAutoResizeMode(int a) {
        this.autoResizeMode = a;
        this.revalidate();
        this.repaint();
    }

    public void setRowHeight(int r) {
        if (r < 1) {
            throw new IllegalArgumentException();
        }
        this.clientRowHeightSet = true;
        this.rowHeight = r;
        this.rowHeights = null;
        this.revalidate();
        this.repaint();
    }

    public void setRowHeight(int row, int rh) {
        if (this.rowHeights == null) {
            this.rowHeights = new SizeSequence(this.getRowCount(), this.rowHeight);
        }
        this.rowHeights.setSize(row, rh);
    }

    public void setRowMargin(int r) {
        this.rowMargin = r;
        this.revalidate();
        this.repaint();
    }

    public void setRowSelectionAllowed(boolean r) {
        if (this.rowSelectionAllowed != r) {
            this.rowSelectionAllowed = r;
            this.firePropertyChange("rowSelectionAllowed", !r, r);
            this.repaint();
        }
    }

    public void setCellSelectionEnabled(boolean c) {
        this.setColumnSelectionAllowed(c);
        this.setRowSelectionAllowed(c);
        this.cellSelectionEnabled = true;
    }

    public void setModel(TableModel m) {
        if (m == null) {
            throw new IllegalArgumentException();
        }
        if (this.dataModel == m) {
            return;
        }
        TableModel oldModel = this.dataModel;
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
        }
        if (m != null) {
            this.dataModel = m;
            this.dataModel.addTableModelListener(this);
            this.tableChanged(new TableModelEvent(this.dataModel, -1));
            if (this.autoCreateColumnsFromModel) {
                this.createDefaultColumnsFromModel();
            }
        }
        this.firePropertyChange("model", oldModel, this.dataModel);
        this.revalidate();
        this.repaint();
    }

    public void setColumnModel(TableColumnModel c) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        TableColumnModel tmp = this.columnModel;
        if (tmp != null) {
            tmp.removeColumnModelListener(this);
        }
        if (c != null) {
            c.addColumnModelListener(this);
        }
        this.columnModel = c;
        if (this.dataModel != null && this.columnModel != null) {
            int ncols = this.getColumnCount();
            int i = 0;
            while (i < ncols) {
                TableColumn column = this.columnModel.getColumn(i);
                if (column.getHeaderValue() == null) {
                    column.setHeaderValue(this.dataModel.getColumnName(i));
                }
                ++i;
            }
        }
        if (this.tableHeader != null) {
            this.tableHeader.setColumnModel(c);
        }
        this.revalidate();
        this.repaint();
    }

    public void setColumnSelectionAllowed(boolean c) {
        if (this.columnModel.getColumnSelectionAllowed() != c) {
            this.columnModel.setColumnSelectionAllowed(c);
            this.firePropertyChange("columnSelectionAllowed", !c, c);
            this.repaint();
        }
    }

    public void setSelectionModel(ListSelectionModel s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        ListSelectionModel tmp = this.selectionModel;
        if (tmp != null) {
            tmp.removeListSelectionListener(this);
        }
        if (s != null) {
            s.addListSelectionListener(this);
        }
        this.selectionModel = s;
        this.checkSelection();
    }

    public void setSelectionMode(int s) {
        this.selectionModel.setSelectionMode(s);
        this.columnModel.getSelectionModel().setSelectionMode(s);
        this.repaint();
    }

    public void setCellEditor(TableCellEditor c) {
        TableCellEditor tmp = this.cellEditor;
        if (tmp != null) {
            tmp.removeCellEditorListener(this);
        }
        if (c != null) {
            c.addCellEditorListener(this);
        }
        this.cellEditor = c;
    }

    public void setDragEnabled(boolean d) {
        this.dragEnabled = d;
    }

    public void setGridColor(Color g) {
        this.gridColor = g;
        this.repaint();
    }

    public void setIntercellSpacing(Dimension i) {
        this.rowMargin = i.height;
        this.columnModel.setColumnMargin(i.width);
        this.repaint();
    }

    public void setPreferredScrollableViewportSize(Dimension p) {
        this.preferredViewportSize = p;
        this.revalidate();
        this.repaint();
    }

    public void setSelectionBackground(Color s) {
        Color tmp = this.selectionBackground;
        this.selectionBackground = s;
        if (tmp == null && s != null || s == null && tmp != null || tmp != null && s != null && !tmp.equals(s)) {
            this.firePropertyChange(SELECTION_BACKGROUND_CHANGED_PROPERTY, tmp, s);
        }
        this.repaint();
    }

    public void setSelectionForeground(Color s) {
        Color tmp = this.selectionForeground;
        this.selectionForeground = s;
        if (tmp == null && s != null || s == null && tmp != null || tmp != null && s != null && !tmp.equals(s)) {
            this.firePropertyChange(SELECTION_FOREGROUND_CHANGED_PROPERTY, tmp, s);
        }
        this.repaint();
    }

    public void setShowGrid(boolean s) {
        this.setShowVerticalLines(s);
        this.setShowHorizontalLines(s);
    }

    public void setShowHorizontalLines(boolean s) {
        this.showHorizontalLines = s;
        this.repaint();
    }

    public void setShowVerticalLines(boolean s) {
        this.showVerticalLines = s;
        this.repaint();
    }

    public void setTableHeader(JTableHeader t) {
        if (this.tableHeader != null) {
            this.tableHeader.setTable(null);
        }
        this.tableHeader = t;
        if (this.tableHeader != null) {
            this.tableHeader.setTable(this);
        }
        this.revalidate();
        this.repaint();
    }

    protected void configureEnclosingScrollPane() {
        JScrollPane jsp = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        if (jsp != null && this.tableHeader != null) {
            jsp.setColumnHeaderView(this.tableHeader);
        }
    }

    protected void unconfigureEnclosingScrollPane() {
        JScrollPane jsp = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        if (jsp != null) {
            jsp.setColumnHeaderView(null);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    @Override
    public void removeNotify() {
        super.addNotify();
        this.unconfigureEnclosingScrollPane();
    }

    private void distributeSpill(TableColumn[] cols, int spill) {
        int average = spill / cols.length;
        int i = 0;
        while (i < cols.length) {
            if (cols[i] != null) {
                cols[i].setWidth(cols[i].getPreferredWidth() + average);
            }
            ++i;
        }
    }

    private void distributeSpillResizing(TableColumn[] cols, int spill, TableColumn resizeIt) {
        int average = 0;
        if (cols.length != 1) {
            average = spill / (cols.length - 1);
        }
        int i = 0;
        while (i < cols.length) {
            if (cols[i] != null && !cols[i].equals(resizeIt)) {
                cols[i].setWidth(cols[i].getPreferredWidth() + average);
            }
            ++i;
        }
        resizeIt.setWidth(resizeIt.getPreferredWidth());
    }

    @Override
    public void doLayout() {
        TableColumn col;
        TableColumn resizingColumn = null;
        int ncols = this.columnModel.getColumnCount();
        if (ncols < 1) {
            return;
        }
        int prefSum = 0;
        int rCol = -1;
        if (this.tableHeader != null) {
            resizingColumn = this.tableHeader.getResizingColumn();
        }
        int i = 0;
        while (i < ncols) {
            col = this.columnModel.getColumn(i);
            int p = col.getPreferredWidth();
            prefSum += p;
            if (resizingColumn == col) {
                rCol = i;
            }
            ++i;
        }
        int spill = this.getWidth() - prefSum;
        if (resizingColumn != null) {
            switch (this.getAutoResizeMode()) {
                case 3: {
                    col = this.columnModel.getColumn(ncols - 1);
                    col.setWidth(col.getPreferredWidth() + spill);
                    break;
                }
                case 1: {
                    col = this.columnModel.getColumn(ncols - 1);
                    col.setWidth(col.getPreferredWidth() + spill);
                    break;
                }
                case 4: {
                    TableColumn[] cols = new TableColumn[ncols];
                    int i2 = 0;
                    while (i2 < ncols) {
                        cols[i2] = this.columnModel.getColumn(i2);
                        ++i2;
                    }
                    this.distributeSpillResizing(cols, spill, resizingColumn);
                    break;
                }
                case 2: {
                    TableColumn column;
                    int w = 0;
                    int wp = 0;
                    int i3 = 0;
                    while (i3 < rCol) {
                        column = this.columnModel.getColumn(i3);
                        w += column.getWidth();
                        wp += column.getPreferredWidth();
                        ++i3;
                    }
                    int n = ncols - rCol - 1;
                    if (n > 0) {
                        spill = this.getWidth() - w - (prefSum - wp);
                        int average = spill / n;
                        int i4 = rCol + 1;
                        while (i4 < ncols) {
                            column = this.columnModel.getColumn(i4);
                            column.setWidth(column.getPreferredWidth() + average);
                            ++i4;
                        }
                    }
                    resizingColumn.setWidth(resizingColumn.getPreferredWidth());
                    break;
                }
                default: {
                    int prefWidth = resizingColumn.getPreferredWidth();
                    resizingColumn.setWidth(prefWidth);
                    break;
                }
            }
        } else {
            TableColumn[] cols = new TableColumn[ncols];
            int i5 = 0;
            while (i5 < ncols) {
                cols[i5] = this.columnModel.getColumn(i5);
                ++i5;
            }
            this.distributeSpill(cols, spill);
        }
        if (this.editorComp != null) {
            this.moveToCellBeingEdited(this.editorComp);
        }
        int leftBoundary = this.getLeftResizingBoundary();
        int width = this.getWidth() - leftBoundary;
        this.repaint(leftBoundary, 0, width, this.getHeight());
        if (this.tableHeader != null) {
            this.tableHeader.repaint(leftBoundary, 0, width, this.tableHeader.getHeight());
        }
    }

    int getLeftResizingBoundary() {
        if (this.tableHeader == null || this.getAutoResizeMode() == 4) {
            return 0;
        }
        TableColumn resizingColumn = this.tableHeader.getResizingColumn();
        if (resizingColumn == null) {
            return 0;
        }
        int rc = this.convertColumnIndexToView(resizingColumn.getModelIndex());
        int p = 0;
        int i = 0;
        while (i < rc) {
            p += this.columnModel.getColumn(i).getWidth();
            ++i;
        }
        return p;
    }

    public void sizeColumnsToFit(boolean lastColumnOnly) {
        this.doLayout();
    }

    public void sizeColumnsToFit(int resizingColumn) {
        this.doLayout();
    }

    @Override
    public String getUIClassID() {
        return "TableUI";
    }

    public TableUI getUI() {
        return (TableUI)this.ui;
    }

    public void setUI(TableUI ui) {
        super.setUI(ui);
        this.createDefaultEditors();
        this.createDefaultRenderers();
    }

    @Override
    public void updateUI() {
        this.setUI((TableUI)UIManager.getUI(this));
    }

    public Class<?> getColumnClass(int column) {
        return this.getModel().getColumnClass(this.convertColumnIndexToModel(column));
    }

    public String getColumnName(int column) {
        int modelColumn = this.columnModel.getColumn(column).getModelIndex();
        return this.dataModel.getColumnName(modelColumn);
    }

    public int getEditingColumn() {
        return this.editingColumn;
    }

    public void setEditingColumn(int column) {
        this.editingColumn = column;
    }

    public int getEditingRow() {
        return this.editingRow;
    }

    public void setEditingRow(int row) {
        this.editingRow = row;
    }

    public Component getEditorComponent() {
        return this.editorComp;
    }

    public boolean isEditing() {
        return this.editorComp != null;
    }

    public void setDefaultEditor(Class<?> columnClass, TableCellEditor editor) {
        if (editor != null) {
            this.defaultEditorsByColumnClass.put(columnClass, editor);
        } else {
            this.defaultEditorsByColumnClass.remove(columnClass);
        }
    }

    public void addColumnSelectionInterval(int index0, int index1) {
        if (index0 < 0 || index0 > this.getColumnCount() - 1 || index1 < 0 || index1 > this.getColumnCount() - 1) {
            throw new IllegalArgumentException("Column index out of range.");
        }
        this.getColumnModel().getSelectionModel().addSelectionInterval(index0, index1);
    }

    public void addRowSelectionInterval(int index0, int index1) {
        if (index0 < 0 || index0 > this.getRowCount() - 1 || index1 < 0 || index1 > this.getRowCount() - 1) {
            throw new IllegalArgumentException("Row index out of range.");
        }
        this.getSelectionModel().addSelectionInterval(index0, index1);
    }

    public void setColumnSelectionInterval(int index0, int index1) {
        if (index0 < 0 || index0 > this.getColumnCount() - 1 || index1 < 0 || index1 > this.getColumnCount() - 1) {
            throw new IllegalArgumentException("Column index out of range.");
        }
        this.getColumnModel().getSelectionModel().setSelectionInterval(index0, index1);
    }

    public void setRowSelectionInterval(int index0, int index1) {
        if (index0 < 0 || index0 > this.getRowCount() - 1 || index1 < 0 || index1 > this.getRowCount() - 1) {
            throw new IllegalArgumentException("Row index out of range.");
        }
        this.getSelectionModel().setSelectionInterval(index0, index1);
    }

    public void removeColumnSelectionInterval(int index0, int index1) {
        if (index0 < 0 || index0 > this.getColumnCount() - 1 || index1 < 0 || index1 > this.getColumnCount() - 1) {
            throw new IllegalArgumentException("Column index out of range.");
        }
        this.getColumnModel().getSelectionModel().removeSelectionInterval(index0, index1);
    }

    public void removeRowSelectionInterval(int index0, int index1) {
        if (index0 < 0 || index0 > this.getRowCount() - 1 || index1 < 0 || index1 > this.getRowCount() - 1) {
            throw new IllegalArgumentException("Row index out of range.");
        }
        this.getSelectionModel().removeSelectionInterval(index0, index1);
    }

    public boolean isColumnSelected(int column) {
        return this.getColumnModel().getSelectionModel().isSelectedIndex(column);
    }

    public boolean isRowSelected(int row) {
        return this.getSelectionModel().isSelectedIndex(row);
    }

    public boolean isCellSelected(int row, int column) {
        return this.isRowSelected(row) && this.isColumnSelected(column);
    }

    public void selectAll() {
        if (this.getRowCount() == 0 || this.getColumnCount() == 0) {
            return;
        }
        int rowLead = this.selectionModel.getLeadSelectionIndex();
        int colLead = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
        this.setRowSelectionInterval(0, this.getRowCount() - 1);
        this.addColumnSelectionInterval(colLead, colLead);
        this.addRowSelectionInterval(rowLead, rowLead);
    }

    public Object getValueAt(int row, int column) {
        return this.dataModel.getValueAt(row, this.convertColumnIndexToModel(column));
    }

    public void setValueAt(Object value, int row, int column) {
        this.dataModel.setValueAt(value, row, this.convertColumnIndexToModel(column));
        this.repaint(this.getCellRect(row, column, true));
    }

    public TableColumn getColumn(Object identifier) {
        return this.columnModel.getColumn(this.columnModel.getColumnIndex(identifier));
    }

    public boolean isCellEditable(int row, int column) {
        return this.dataModel.isCellEditable(row, this.convertColumnIndexToModel(column));
    }

    public void createDefaultColumnsFromModel() {
        assert (this.columnModel != null) : "The columnModel must not be null.";
        int columnIndex = this.columnModel.getColumnCount() - 1;
        while (columnIndex >= 0) {
            this.columnModel.removeColumn(this.columnModel.getColumn(columnIndex));
            --columnIndex;
        }
        int columnCount = this.dataModel.getColumnCount();
        int c = 0;
        while (c < columnCount) {
            TableColumn column = new TableColumn(c);
            column.setIdentifier(this.dataModel.getColumnName(c));
            column.setHeaderValue(this.dataModel.getColumnName(c));
            this.columnModel.addColumn(column);
            column.addPropertyChangeListener(this.tableColumnPropertyChangeHandler);
            ++c;
        }
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (toggle && extend) {
            this.selectionModel.setAnchorSelectionIndex(rowIndex);
            this.getColumnModel().getSelectionModel().setAnchorSelectionIndex(columnIndex);
        } else if (toggle) {
            if (this.isCellSelected(rowIndex, columnIndex)) {
                this.selectionModel.removeSelectionInterval(rowIndex, rowIndex);
                this.getColumnModel().getSelectionModel().removeSelectionInterval(columnIndex, columnIndex);
            } else {
                this.selectionModel.addSelectionInterval(rowIndex, rowIndex);
                this.getColumnModel().getSelectionModel().addSelectionInterval(columnIndex, columnIndex);
            }
        } else if (extend) {
            this.selectionModel.setLeadSelectionIndex(rowIndex);
            this.getColumnModel().getSelectionModel().setLeadSelectionIndex(columnIndex);
        } else {
            this.selectionModel.clearSelection();
            this.selectionModel.setSelectionInterval(rowIndex, rowIndex);
            this.getColumnModel().getSelectionModel().clearSelection();
            this.getColumnModel().getSelectionModel().setSelectionInterval(columnIndex, columnIndex);
        }
    }

    public boolean editCellAt(int row, int column) {
        TableCellEditor editor;
        if (this.isEditing()) {
            this.editingStopped(new ChangeEvent("editingStopped"));
        }
        if ((editor = this.getCellEditor(row, column)) == this.booleanInvertingEditor && this.isCellEditable(row, column)) {
            if (Boolean.TRUE.equals(this.getValueAt(row, column))) {
                this.setValueAt(Boolean.FALSE, row, column);
            } else {
                this.setValueAt(Boolean.TRUE, row, column);
            }
            return false;
        }
        this.editingRow = row;
        this.editingColumn = column;
        this.setCellEditor(editor);
        this.editorComp = this.prepareEditor(this.cellEditor, row, column);
        this.removeAll();
        this.add(this.editorComp);
        this.moveToCellBeingEdited(this.editorComp);
        this.scrollRectToVisible(this.editorComp.getBounds());
        this.editorComp.requestFocusInWindow();
        return editor.shouldSelectCell(null);
    }

    private void moveToCellBeingEdited(Component component) {
        Rectangle r = this.getCellRect(this.editingRow, this.editingColumn, true);
        --r.x;
        --r.y;
        ++r.width;
        ++r.height;
        component.setBounds(r);
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        return this.editCellAt(row, column);
    }

    public void removeEditor() {
        this.editingStopped(new ChangeEvent(this));
    }

    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        return editor.getTableCellEditorComponent(this, this.getValueAt(row, column), this.isCellSelected(row, column), row, column);
    }

    protected void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public void setSurrendersFocusOnKeystroke(boolean value) {
        this.surrendersFocusOnKeystroke = value;
    }

    public boolean getSurrendersFocusOnKeystroke() {
        return this.surrendersFocusOnKeystroke;
    }

    @Override
    void setUIProperty(String propertyName, Object value) {
        if (propertyName.equals("rowHeight")) {
            if (!this.clientRowHeightSet) {
                this.setRowHeight((Integer)value);
                this.clientRowHeightSet = false;
            }
        } else {
            super.setUIProperty(propertyName, value);
        }
    }

    protected class AccessibleJTable
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ListSelectionListener,
    TableModelListener,
    TableColumnModelListener,
    CellEditorListener,
    PropertyChangeListener,
    AccessibleExtendedTable {
        private int lastSelectedRow;
        private int lastSelectedColumn;
        private Accessible caption;
        private Accessible summary;
        private Accessible[] rowDescriptions;
        private Accessible[] columnDescriptions;

        protected AccessibleJTable() {
            JTable.this.getModel().addTableModelListener(this);
            JTable.this.getSelectionModel().addListSelectionListener(this);
            JTable.this.getColumnModel().addColumnModelListener(this);
            this.lastSelectedRow = JTable.this.getSelectedRow();
            this.lastSelectedColumn = JTable.this.getSelectedColumn();
            TableCellEditor editor = JTable.this.getCellEditor();
            if (editor != null) {
                editor.addCellEditorListener(this);
            }
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }

        public AccessibleTable getAccessibleTable() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            return JTable.this.getSelectedColumnCount();
        }

        public Accessible getAccessibleSelection(int i) {
            Accessible found = null;
            int[] selectedRows = JTable.this.getSelectedRows();
            int[] selectedColumns = JTable.this.getSelectedColumns();
            int numCols = JTable.this.getColumnCount();
            int numRows = JTable.this.getRowCount();
            if (JTable.this.getRowSelectionAllowed() && JTable.this.getColumnSelectionAllowed()) {
                int current = -1;
                int lastSelectedRow = -1;
                int j = 0;
                while (i < selectedRows.length) {
                    int selectedRow = selectedRows[j];
                    int r = -1;
                    int ci = -1;
                    r = lastSelectedRow + 1;
                    while (r < selectedRow && current < i) {
                        ci = 0;
                        while (ci < selectedColumns.length && current < i) {
                            ++current;
                            ++ci;
                        }
                        ++r;
                    }
                    if (current == i) {
                        found = this.getAccessibleChild(r * numCols + selectedColumns[ci]);
                        break;
                    }
                    if (current < i && current + numCols >= i) {
                        found = this.getAccessibleChild(r * numCols + (i - current));
                        break;
                    }
                    current += numCols;
                    ++i;
                }
                if (found == null) {
                    int r = 0;
                    int ci = 0;
                    r = lastSelectedRow + 1;
                    while (r < numRows && current < i) {
                        ci = 0;
                        while (ci < selectedColumns.length && current < i) {
                            ++current;
                            ++ci;
                        }
                        ++r;
                    }
                    if (current == i) {
                        found = this.getAccessibleChild(r * numCols + selectedColumns[ci]);
                    }
                }
            } else if (JTable.this.getRowSelectionAllowed()) {
                int c = i % numCols;
                int r = selectedRows[i / numCols];
                found = this.getAccessibleChild(r * numCols + c);
            } else if (JTable.this.getRowSelectionAllowed()) {
                int numSelectedColumns = selectedColumns.length;
                int c = selectedColumns[i % numSelectedColumns];
                int r = i / numSelectedColumns;
                found = this.getAccessibleChild(r * numCols + c);
            }
            return found;
        }

        public boolean isAccessibleChildSelected(int i) {
            int r = this.getAccessibleRowAtIndex(i);
            int c = this.getAccessibleColumnAtIndex(i);
            return JTable.this.isCellSelected(r, c);
        }

        public void addAccessibleSelection(int i) {
            int r = this.getAccessibleRowAtIndex(i);
            int c = this.getAccessibleColumnAtIndex(i);
            JTable.this.changeSelection(r, c, true, false);
        }

        public void removeAccessibleSelection(int i) {
            if (!JTable.this.getRowSelectionAllowed() && !JTable.this.getColumnSelectionAllowed()) {
                int r = this.getAccessibleRowAtIndex(i);
                int c = this.getAccessibleColumnAtIndex(i);
                JTable.this.removeRowSelectionInterval(r, r);
                JTable.this.removeColumnSelectionInterval(c, c);
            }
        }

        public void clearAccessibleSelection() {
            JTable.this.clearSelection();
        }

        public void selectAllAccessibleSelection() {
            JTable.this.selectAll();
        }

        public void valueChanged(ListSelectionEvent event) {
            this.firePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
            int r = JTable.this.getSelectedRow();
            int c = JTable.this.getSelectedColumn();
            if (r != this.lastSelectedRow || c != this.lastSelectedColumn) {
                Accessible o = this.getAccessibleAt(this.lastSelectedRow, this.lastSelectedColumn);
                Accessible n = this.getAccessibleAt(r, c);
                this.firePropertyChange("AccessibleActiveDescendant", o, n);
                this.lastSelectedRow = r;
                this.lastSelectedColumn = c;
            }
        }

        public void tableChanged(TableModelEvent event) {
            switch (event.getType()) {
                case 1: {
                    this.tableRowsInserted(event);
                    break;
                }
                case -1: {
                    this.tableRowsDeleted(event);
                }
            }
        }

        public void tableRowsInserted(TableModelEvent event) {
            this.handleRowChange(event);
        }

        public void tableRowsDeleted(TableModelEvent event) {
            this.handleRowChange(event);
        }

        private void handleRowChange(TableModelEvent event) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int firstColumn = event.getColumn();
            int lastColumn = event.getColumn();
            if (firstColumn == -1) {
                firstColumn = 0;
                lastColumn = JTable.this.getColumnCount() - 1;
            }
            AccessibleJTableModelChange change = new AccessibleJTableModelChange(event.getType(), event.getFirstRow(), event.getLastRow(), firstColumn, lastColumn);
            this.firePropertyChange("accessibleTableModelChanged", null, change);
        }

        public void columnAdded(TableColumnModelEvent event) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            this.handleColumnChange(1, event.getFromIndex(), event.getToIndex());
        }

        public void columnRemoved(TableColumnModelEvent event) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            this.handleColumnChange(-1, event.getFromIndex(), event.getToIndex());
        }

        public void columnMoved(TableColumnModelEvent event) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            this.handleColumnChange(-1, event.getFromIndex(), event.getFromIndex());
            this.handleColumnChange(1, event.getFromIndex(), event.getToIndex());
        }

        private void handleColumnChange(int type, int from, int to) {
            AccessibleJTableModelChange change = new AccessibleJTableModelChange(type, 0, 0, from, to);
            this.firePropertyChange("accessibleTableModelChanged", null, change);
        }

        public void columnMarginChanged(ChangeEvent event) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void columnSelectionChanged(ListSelectionEvent event) {
        }

        public void editingCanceled(ChangeEvent event) {
        }

        public void editingStopped(ChangeEvent event) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propName = e.getPropertyName();
            if (propName.equals("tableModel")) {
                TableModel oldModel = (TableModel)e.getOldValue();
                oldModel.removeTableModelListener(this);
                TableModel newModel = (TableModel)e.getNewValue();
                newModel.addTableModelListener(this);
            } else if (propName.equals("columnModel")) {
                TableColumnModel oldModel = (TableColumnModel)e.getOldValue();
                oldModel.removeColumnModelListener(this);
                TableColumnModel newModel = (TableColumnModel)e.getNewValue();
                newModel.addColumnModelListener(this);
            } else if (propName.equals("selectionModel")) {
                ListSelectionModel oldModel = (ListSelectionModel)e.getOldValue();
                oldModel.removeListSelectionListener(this);
                ListSelectionModel newModel = (ListSelectionModel)e.getNewValue();
                newModel.addListSelectionListener(this);
            } else if (propName.equals("cellEditor")) {
                CellEditor oldEd = (CellEditor)e.getOldValue();
                oldEd.removeCellEditorListener(this);
                CellEditor newEd = (CellEditor)e.getNewValue();
                newEd.addCellEditorListener(this);
            }
        }

        public int getAccessibleRow(int index) {
            return this.getAccessibleRowAtIndex(index);
        }

        public int getAccessibleColumn(int index) {
            return this.getAccessibleColumnAtIndex(index);
        }

        public int getAccessibleIndex(int r, int c) {
            return this.getAccessibleIndexAt(r, c);
        }

        public Accessible getAccessibleCaption() {
            return this.caption;
        }

        public void setAccessibleCaption(Accessible c) {
            this.caption = c;
        }

        public Accessible getAccessibleSummary() {
            return this.summary;
        }

        public void setAccessibleSummary(Accessible s) {
            this.summary = s;
        }

        public int getAccessibleRowCount() {
            return JTable.this.getRowCount();
        }

        public int getAccessibleColumnCount() {
            return JTable.this.getColumnCount();
        }

        public Accessible getAccessibleChild(int index) {
            int r = this.getAccessibleRow(index);
            int c = this.getAccessibleColumn(index);
            return this.getAccessibleAt(r, c);
        }

        public Accessible getAccessibleAt(int r, int c) {
            TableCellRenderer cellRenderer = JTable.this.getCellRenderer(r, c);
            Component renderer = cellRenderer.getTableCellRendererComponent(JTable.this, JTable.this.getValueAt(r, c), JTable.this.isCellSelected(r, c), false, r, c);
            if (renderer instanceof Accessible) {
                return (Accessible)((Object)renderer);
            }
            return null;
        }

        public int getAccessibleRowExtentAt(int r, int c) {
            return 1;
        }

        public int getAccessibleColumnExtentAt(int r, int c) {
            return 1;
        }

        public AccessibleTable getAccessibleRowHeader() {
            return null;
        }

        public void setAccessibleRowHeader(AccessibleTable header) {
        }

        public AccessibleTable getAccessibleColumnHeader() {
            JTableHeader h = JTable.this.getTableHeader();
            AccessibleTableHeader header = null;
            if (h != null) {
                header = new AccessibleTableHeader(h);
            }
            return header;
        }

        public void setAccessibleColumnHeader(AccessibleTable header) {
        }

        public Accessible getAccessibleRowDescription(int r) {
            Accessible descr = null;
            if (this.rowDescriptions != null) {
                descr = this.rowDescriptions[r];
            }
            return descr;
        }

        public void setAccessibleRowDescription(int r, Accessible description) {
            if (this.rowDescriptions == null) {
                this.rowDescriptions = new Accessible[this.getAccessibleRowCount()];
            }
            this.rowDescriptions[r] = description;
        }

        public Accessible getAccessibleColumnDescription(int c) {
            Accessible descr = null;
            if (this.columnDescriptions != null) {
                descr = this.columnDescriptions[c];
            }
            return descr;
        }

        public void setAccessibleColumnDescription(int c, Accessible description) {
            if (this.columnDescriptions == null) {
                this.columnDescriptions = new Accessible[this.getAccessibleRowCount()];
            }
            this.columnDescriptions[c] = description;
        }

        public boolean isAccessibleSelected(int r, int c) {
            return JTable.this.isCellSelected(r, c);
        }

        public boolean isAccessibleRowSelected(int r) {
            return JTable.this.isRowSelected(r);
        }

        public boolean isAccessibleColumnSelected(int c) {
            return JTable.this.isColumnSelected(c);
        }

        public int[] getSelectedAccessibleRows() {
            return JTable.this.getSelectedRows();
        }

        public int[] getSelectedAccessibleColumns() {
            return JTable.this.getSelectedColumns();
        }

        public int getAccessibleRowAtIndex(int index) {
            return index / JTable.this.getColumnCount();
        }

        public int getAccessibleColumnAtIndex(int index) {
            return index % JTable.this.getColumnCount();
        }

        public int getAccessibleIndexAt(int row, int column) {
            return row * JTable.this.getColumnCount() + column;
        }

        protected class AccessibleJTableCell
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private JTable table;
            private int row;
            private int column;
            private int index;

            public AccessibleJTableCell(JTable t, int r, int c, int i) {
                this.table = t;
                this.row = r;
                this.column = c;
                this.index = i;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.UNKNOWN;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                Rectangle cellRect;
                AccessibleStateSet state = new AccessibleStateSet();
                Rectangle visibleRect = JTable.this.getVisibleRect();
                if (visibleRect.intersects(cellRect = JTable.this.getCellRect(this.row, this.column, false))) {
                    state.add(AccessibleState.SHOWING);
                }
                if (JTable.this.isCellSelected(this.row, this.column)) {
                    state.add(AccessibleState.SELECTED);
                }
                if (this.row == JTable.this.getSelectedRow() && this.column == JTable.this.getSelectedColumn()) {
                    state.add(AccessibleState.ACTIVE);
                }
                state.add(AccessibleState.TRANSIENT);
                return state;
            }

            public int getAccessibleIndexInParent() {
                return this.index;
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public Accessible getAccessibleChild(int i) {
                return null;
            }

            public Locale getLocale() {
                return Locale.ENGLISH;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public Color getBackground() {
                return this.table.getBackground();
            }

            public void setBackground(Color color) {
            }

            public Color getForeground() {
                return this.table.getForeground();
            }

            public void setForeground(Color color) {
            }

            public Cursor getCursor() {
                return this.table.getCursor();
            }

            public void setCursor(Cursor cursor) {
            }

            public Font getFont() {
                return this.table.getFont();
            }

            public void setFont(Font font) {
            }

            public FontMetrics getFontMetrics(Font font) {
                return this.table.getFontMetrics(font);
            }

            public boolean isEnabled() {
                return this.table.isEnabled();
            }

            public void setEnabled(boolean b) {
            }

            public boolean isVisible() {
                return this.table.isVisible();
            }

            public void setVisible(boolean b) {
            }

            public boolean isShowing() {
                return this.table.isShowing();
            }

            public boolean contains(Point point) {
                Rectangle cellRect = this.table.getCellRect(this.row, this.column, true);
                cellRect.x = 0;
                cellRect.y = 0;
                return cellRect.contains(point);
            }

            public Point getLocationOnScreen() {
                Point tableLoc = this.table.getLocationOnScreen();
                Rectangle cellRect = this.table.getCellRect(this.row, this.column, true);
                tableLoc.x += cellRect.x;
                tableLoc.y += cellRect.y;
                return tableLoc;
            }

            public Point getLocation() {
                Rectangle cellRect = this.table.getCellRect(this.row, this.column, true);
                return new Point(cellRect.x, cellRect.y);
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                return this.table.getCellRect(this.row, this.column, true);
            }

            public void setBounds(Rectangle rectangle) {
            }

            public Dimension getSize() {
                Rectangle cellRect = this.table.getCellRect(this.row, this.column, true);
                return new Dimension(cellRect.width, cellRect.height);
            }

            public void setSize(Dimension dimension) {
            }

            public Accessible getAccessibleAt(Point point) {
                return null;
            }

            public boolean isFocusTraversable() {
                return this.table.isFocusable();
            }

            public void requestFocus() {
                this.table.getColumnModel().getSelectionModel().setLeadSelectionIndex(this.column);
                this.table.getSelectionModel().setLeadSelectionIndex(this.row);
                this.table.requestFocus();
            }

            public void addFocusListener(FocusListener listener) {
                this.table.addFocusListener(listener);
            }

            public void removeFocusListener(FocusListener listener) {
                this.table.removeFocusListener(listener);
            }
        }

        private class AccessibleJTableHeaderCell
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            JTableHeader header;
            int columnIndex;

            private AccessibleJTableHeaderCell(JTableHeader h, Component comp, int r, int c) {
                this.header = h;
                this.columnIndex = c;
            }

            Component getColumnHeaderRenderer() {
                TableColumn tc = this.header.getColumnModel().getColumn(this.columnIndex);
                TableCellRenderer r = tc.getHeaderRenderer();
                if (r == null) {
                    r = this.header.getDefaultRenderer();
                }
                return r.getTableCellRendererComponent(this.header.getTable(), tc.getHeaderValue(), false, false, -1, this.columnIndex);
            }

            public AccessibleRole getAccessibleRole() {
                Component renderer = this.getColumnHeaderRenderer();
                if (renderer instanceof Accessible) {
                    Accessible ac = (Accessible)((Object)renderer);
                    return ac.getAccessibleContext().getAccessibleRole();
                }
                return null;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                return null;
            }

            public int getAccessibleIndexInParent() {
                return 0;
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public Accessible getAccessibleChild(int i) {
                return null;
            }

            public Locale getLocale() {
                return null;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public Color getBackground() {
                return null;
            }

            public void setBackground(Color color) {
            }

            public Color getForeground() {
                return null;
            }

            public void setForeground(Color color) {
            }

            public Cursor getCursor() {
                return null;
            }

            public void setCursor(Cursor cursor) {
            }

            public Font getFont() {
                return null;
            }

            public void setFont(Font font) {
            }

            public FontMetrics getFontMetrics(Font font) {
                return null;
            }

            public boolean isEnabled() {
                return false;
            }

            public void setEnabled(boolean b) {
            }

            public boolean isVisible() {
                return false;
            }

            public void setVisible(boolean b) {
            }

            public boolean isShowing() {
                return false;
            }

            public boolean contains(Point point) {
                return false;
            }

            public Point getLocationOnScreen() {
                return null;
            }

            public Point getLocation() {
                return null;
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                return null;
            }

            public void setBounds(Rectangle rectangle) {
            }

            public Dimension getSize() {
                return null;
            }

            public void setSize(Dimension dimension) {
            }

            public Accessible getAccessibleAt(Point point) {
                return null;
            }

            public boolean isFocusTraversable() {
                return false;
            }

            public void requestFocus() {
            }

            public void addFocusListener(FocusListener listener) {
            }

            public void removeFocusListener(FocusListener listener) {
            }
        }

        protected class AccessibleJTableModelChange
        implements AccessibleTableModelChange {
            protected int type;
            protected int firstRow;
            protected int lastRow;
            protected int firstColumn;
            protected int lastColumn;

            protected AccessibleJTableModelChange(int type, int firstRow, int lastRow, int firstColumn, int lastColumn) {
                this.type = type;
                this.firstRow = firstRow;
                this.lastRow = lastRow;
                this.firstColumn = firstColumn;
                this.lastColumn = lastColumn;
            }

            public int getType() {
                return this.type;
            }

            public int getFirstRow() {
                return this.firstRow;
            }

            public int getLastRow() {
                return this.lastRow;
            }

            public int getFirstColumn() {
                return this.firstColumn;
            }

            public int getLastColumn() {
                return this.lastColumn;
            }
        }

        private class AccessibleTableHeader
        implements AccessibleTable {
            private JTableHeader header;

            private AccessibleTableHeader(JTableHeader h) {
                this.header = h;
            }

            public Accessible getAccessibleCaption() {
                return null;
            }

            public void setAccessibleCaption(Accessible caption) {
            }

            public Accessible getAccessibleSummary() {
                return null;
            }

            public void setAccessibleSummary(Accessible summary) {
            }

            public int getAccessibleRowCount() {
                return 1;
            }

            public int getAccessibleColumnCount() {
                return this.header.getColumnModel().getColumnCount();
            }

            public Accessible getAccessibleAt(int r, int c) {
                TableColumn column = this.header.getColumnModel().getColumn(c);
                TableCellRenderer rend = column.getHeaderRenderer();
                if (rend == null) {
                    rend = this.header.getDefaultRenderer();
                }
                Component comp = rend.getTableCellRendererComponent(this.header.getTable(), column.getHeaderValue(), false, false, -1, c);
                return new AccessibleJTableHeaderCell(this.header, comp, r, c);
            }

            public int getAccessibleRowExtentAt(int r, int c) {
                return 0;
            }

            public int getAccessibleColumnExtentAt(int r, int c) {
                return 0;
            }

            public AccessibleTable getAccessibleRowHeader() {
                return null;
            }

            public void setAccessibleRowHeader(AccessibleTable header) {
            }

            public AccessibleTable getAccessibleColumnHeader() {
                return null;
            }

            public void setAccessibleColumnHeader(AccessibleTable header) {
            }

            public Accessible getAccessibleRowDescription(int r) {
                return null;
            }

            public void setAccessibleRowDescription(int r, Accessible description) {
            }

            public Accessible getAccessibleColumnDescription(int c) {
                return null;
            }

            public void setAccessibleColumnDescription(int c, Accessible description) {
            }

            public boolean isAccessibleSelected(int r, int c) {
                return false;
            }

            public boolean isAccessibleRowSelected(int r) {
                return false;
            }

            public boolean isAccessibleColumnSelected(int c) {
                return false;
            }

            public int[] getSelectedAccessibleRows() {
                return null;
            }

            public int[] getSelectedAccessibleColumns() {
                return null;
            }
        }
    }

    private class BooleanCellRenderer
    extends DefaultTableCellRenderer {
        private final JCheckBox checkBox = new JCheckBox();

        BooleanCellRenderer() {
            this.checkBox.setHorizontalAlignment(0);
        }

        JCheckBox getCheckBox() {
            return this.checkBox;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.checkBox.setBackground(table.getSelectionBackground());
                this.checkBox.setForeground(table.getSelectionForeground());
            } else {
                this.checkBox.setBackground(table.getBackground());
                this.checkBox.setForeground(table.getForeground());
            }
            if (hasFocus) {
                this.checkBox.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (table.isCellEditable(row, column)) {
                    this.checkBox.setBackground(UIManager.getColor("Table.focusCellBackground"));
                    this.checkBox.setForeground(UIManager.getColor("Table.focusCellForeground"));
                }
            } else {
                this.checkBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
            if (value == null) {
                this.checkBox.setSelected(false);
            } else {
                Boolean boolValue = (Boolean)value;
                this.checkBox.setSelected(boolValue);
            }
            return this.checkBox;
        }
    }

    private class DateCellRenderer
    extends DefaultTableCellRenderer {
        private DateCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Date) {
                Date dateValue = (Date)value;
                DateFormat df = DateFormat.getDateInstance(3);
                this.setText(df.format(dateValue));
            }
            return this;
        }
    }

    private class DoubleCellRenderer
    extends DefaultTableCellRenderer {
        public DoubleCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Double) {
                Double doubleValue = (Double)value;
                NumberFormat nf = NumberFormat.getInstance();
                this.setText(nf.format(doubleValue));
            }
            return this;
        }
    }

    private class FloatCellRenderer
    extends DefaultTableCellRenderer {
        public FloatCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Float) {
                Float floatValue = (Float)value;
                NumberFormat nf = NumberFormat.getInstance();
                this.setText(nf.format(floatValue.floatValue()));
            }
            return this;
        }
    }

    private class IconCellRenderer
    extends DefaultTableCellRenderer {
        IconCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Icon) {
                Icon iconValue = (Icon)value;
                this.setIcon(iconValue);
            } else {
                this.setIcon(null);
            }
            this.setText("");
            return this;
        }
    }

    private class NumberCellRenderer
    extends DefaultTableCellRenderer {
        public NumberCellRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    class TableColumnPropertyChangeHandler
    implements PropertyChangeListener {
        TableColumnPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            JTableHeader header;
            if (ev.getPropertyName().equals("preferredWidth") && (header = JTable.this.getTableHeader()) != null && header.getResizingColumn() == null) {
                TableColumn col = (TableColumn)ev.getSource();
                header.setResizingColumn(col);
                JTable.this.doLayout();
                header.setResizingColumn(null);
            }
        }
    }

    private class TableTextField
    extends JTextField {
        TableTextField() {
            this.setBorder(BorderFactory.createLineBorder(JTable.this.getGridColor(), 2));
        }
    }
}

