/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Graphics;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ProgressBarUI;

public class JProgressBar
extends JComponent
implements SwingConstants,
Accessible {
    private static final long serialVersionUID = 1980046021813598781L;
    private transient boolean indeterminate = false;
    protected int orientation;
    protected boolean paintBorder = true;
    protected BoundedRangeModel model;
    protected String progressString;
    protected boolean paintString = false;
    protected transient ChangeEvent changeEvent;
    protected ChangeListener changeListener;

    public JProgressBar() {
        this(0, 0, 100);
    }

    public JProgressBar(int orientation) {
        this(orientation, 0, 100);
    }

    public JProgressBar(int minimum, int maximum) {
        this(0, minimum, maximum);
    }

    public JProgressBar(int orientation, int minimum, int maximum) {
        this.model = new DefaultBoundedRangeModel(minimum, 0, minimum, maximum);
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException(String.valueOf(orientation) + " is not a legal orientation");
        }
        this.orientation = orientation;
        this.changeListener = this.createChangeListener();
        this.model.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public JProgressBar(BoundedRangeModel model) {
        this.model = model;
        this.changeListener = this.createChangeListener();
        if (model != null) {
            model.addChangeListener(this.changeListener);
        }
        this.updateUI();
    }

    public int getValue() {
        return this.model.getValue();
    }

    public void setValue(int value) {
        this.model.setValue(value);
    }

    protected void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (this.paintBorder && border != null) {
            border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 1 && orientation != 0) {
            throw new IllegalArgumentException(String.valueOf(orientation) + " is not a legal orientation");
        }
        if (this.orientation != orientation) {
            int oldOrientation = this.orientation;
            this.orientation = orientation;
            this.firePropertyChange("orientation", oldOrientation, this.orientation);
        }
    }

    public boolean isStringPainted() {
        return this.paintString;
    }

    public void setStringPainted(boolean painted) {
        if (this.paintString != painted) {
            boolean oldPainted = this.paintString;
            this.paintString = painted;
            this.firePropertyChange("stringPainted", oldPainted, this.paintString);
        }
    }

    public String getString() {
        if (this.progressString != null) {
            return this.progressString;
        }
        return String.valueOf((int)(this.getPercentComplete() * 100.0)) + "%";
    }

    public void setString(String string) {
        if ((string == null || this.progressString == null) && string != this.progressString || string != null && !string.equals(this.progressString)) {
            String oldString = this.progressString;
            this.progressString = string;
            this.firePropertyChange("string", oldString, this.progressString);
        }
    }

    public double getPercentComplete() {
        if (this.getMaximum() == this.getMinimum()) {
            return 1.0;
        }
        return (double)(this.model.getValue() - this.model.getMinimum()) / (double)(this.model.getMaximum() - this.model.getMinimum());
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean painted) {
        if (painted != this.paintBorder) {
            boolean oldPainted = this.paintBorder;
            this.paintBorder = painted;
            this.firePropertyChange("borderPainted", oldPainted, this.paintBorder);
        }
    }

    public ProgressBarUI getUI() {
        return (ProgressBarUI)this.ui;
    }

    public void setUI(ProgressBarUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((ProgressBarUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "ProgressBarUI";
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                JProgressBar.this.fireStateChanged();
            }
        };
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] changeListeners = this.listenerList.getListenerList();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        int i = changeListeners.length - 2;
        while (i >= 0) {
            if (changeListeners[i] == ChangeListener.class) {
                ((ChangeListener)changeListeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(BoundedRangeModel model) {
        if (model != this.model) {
            this.model.removeChangeListener(this.changeListener);
            this.model = model;
            this.model.addChangeListener(this.changeListener);
            this.fireStateChanged();
        }
    }

    public int getMinimum() {
        return this.model.getMinimum();
    }

    public void setMinimum(int minimum) {
        this.model.setMinimum(minimum);
    }

    public int getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(int maximum) {
        this.model.setMaximum(maximum);
    }

    protected String paramString() {
        String superParamStr = super.paramString();
        StringBuffer sb = new StringBuffer();
        sb.append(",orientation=");
        if (this.orientation == 0) {
            sb.append("HORIZONTAL");
        } else {
            sb.append("VERTICAL");
        }
        sb.append(",paintBorder=").append(this.isBorderPainted());
        sb.append(",paintString=").append(this.isStringPainted());
        sb.append(",progressString=");
        if (this.progressString != null) {
            sb.append(this.progressString);
        }
        sb.append(",indeterminateString=").append(this.isIndeterminate());
        return String.valueOf(superParamStr) + sb.toString();
    }

    public void setIndeterminate(boolean flag) {
        if (this.indeterminate != flag) {
            this.indeterminate = flag;
            this.firePropertyChange("indeterminate", !flag, this.indeterminate);
        }
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJProgressBar();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJProgressBar
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private static final long serialVersionUID = -2938130009392721813L;

        protected AccessibleJProgressBar() {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet result = super.getAccessibleStateSet();
            if (JProgressBar.this.orientation == 0) {
                result.add(AccessibleState.HORIZONTAL);
            } else if (JProgressBar.this.orientation == 1) {
                result.add(AccessibleState.VERTICAL);
            }
            return result;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_BAR;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(JProgressBar.this.getValue());
        }

        public boolean setCurrentAccessibleValue(Number value) {
            if (value == null) {
                return false;
            }
            Number oldValue = this.getCurrentAccessibleValue();
            JProgressBar.this.setValue(value.intValue());
            this.firePropertyChange("AccessibleValue", oldValue, new Integer(JProgressBar.this.getValue()));
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(JProgressBar.this.getMinimum());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(JProgressBar.this.getMaximum());
        }
    }
}

