/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMBeanParameterInfoSupport
extends MBeanParameterInfo
implements OpenMBeanParameterInfo {
    private static final long serialVersionUID = -7235016873758443122L;
    private OpenType<?> openType;
    private Object defaultValue;
    private Set<?> legalValues;
    private Comparable<Object> minValue;
    private Comparable<Object> maxValue;
    private transient Integer hashCode;
    private transient String string;

    public OpenMBeanParameterInfoSupport(String name, String desc, OpenType<?> type) {
        super(name, type == null ? null : type.getClassName(), desc);
        if (name == null) {
            throw new IllegalArgumentException("The name may not be null.");
        }
        if (desc == null) {
            throw new IllegalArgumentException("The description may not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("The type may not be null.");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("The name may not be the empty string.");
        }
        if (desc.length() == 0) {
            throw new IllegalArgumentException("The description may not be the empty string.");
        }
        this.openType = type;
    }

    public <T> OpenMBeanParameterInfoSupport(String name, String desc, OpenType<T> type, T defaultValue) throws OpenDataException {
        this(name, desc, type, defaultValue, null);
    }

    public <T> OpenMBeanParameterInfoSupport(String name, String desc, OpenType<T> type, T defaultValue, Comparable<T> minimumValue, Comparable<T> maximumValue) throws OpenDataException {
        this(name, desc, type);
        if (defaultValue != null && !type.isValue(defaultValue)) {
            throw new OpenDataException("The default value is not a member of the open type given.");
        }
        if (minimumValue != null && !type.isValue(minimumValue)) {
            throw new OpenDataException("The minimum value is not a member of the open type given.");
        }
        if (maximumValue != null && !type.isValue(maximumValue)) {
            throw new OpenDataException("The maximum value is not a member of the open type given.");
        }
        if (defaultValue != null && (type instanceof ArrayType || type instanceof TabularType)) {
            throw new OpenDataException("Default values are not applicable for array or tabular types.");
        }
        if (this.minValue != null && this.maxValue != null && this.minValue.compareTo(this.maxValue) > 0) {
            throw new OpenDataException("The minimum value is greater than the maximum.");
        }
        if (this.minValue != null && defaultValue != null && this.minValue.compareTo(defaultValue) > 0) {
            throw new OpenDataException("The minimum value is greater than the default.");
        }
        if (defaultValue != null && this.maxValue != null && this.maxValue.compareTo(defaultValue) < 0) {
            throw new OpenDataException("The default value is greater than the maximum.");
        }
        this.defaultValue = defaultValue;
        this.minValue = minimumValue;
        this.maxValue = maximumValue;
    }

    public <T> OpenMBeanParameterInfoSupport(String name, String desc, OpenType<T> type, T defaultValue, T[] legalValues) throws OpenDataException {
        this(name, desc, type);
        if (defaultValue != null && !type.isValue(defaultValue)) {
            throw new OpenDataException("The default value is not a member of the open type given.");
        }
        if (defaultValue != null && (type instanceof ArrayType || type instanceof TabularType)) {
            throw new OpenDataException("Default values are not applicable for array or tabular types.");
        }
        if (legalValues != null && (type instanceof ArrayType || type instanceof TabularType)) {
            throw new OpenDataException("Legal values are not applicable for array or tabular types.");
        }
        if (legalValues != null && legalValues.length > 0) {
            HashSet lv = new HashSet(legalValues.length);
            int a = 0;
            while (a < legalValues.length) {
                if (legalValues[a] != null && !type.isValue(legalValues[a])) {
                    throw new OpenDataException("The legal value, " + legalValues[a] + "is not a member of the " + "open type given.");
                }
                lv.add(legalValues[a]);
                ++a;
            }
            if (defaultValue != null && !lv.contains(defaultValue)) {
                throw new OpenDataException("The default value is not in the set of legal values.");
            }
            this.legalValues = Collections.unmodifiableSet(lv);
        }
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OpenMBeanParameterInfo)) {
            return false;
        }
        OpenMBeanParameterInfo o = (OpenMBeanParameterInfo)obj;
        return this.getName().equals(o.getName()) && this.openType.equals(o.getOpenType()) && (this.defaultValue == null ? o.getDefaultValue() == null : this.defaultValue.equals(o.getDefaultValue())) && (this.minValue == null ? o.getMinValue() == null : this.minValue.equals(o.getMinValue())) && (this.maxValue == null ? o.getMaxValue() == null : this.maxValue.equals(o.getMaxValue())) && (this.legalValues == null ? o.getLegalValues() == null : this.legalValues.equals(o.getLegalValues()));
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Set<?> getLegalValues() {
        return this.legalValues;
    }

    @Override
    public Comparable<?> getMaxValue() {
        return this.maxValue;
    }

    @Override
    public Comparable<?> getMinValue() {
        return this.minValue;
    }

    @Override
    public OpenType<?> getOpenType() {
        return this.openType;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.getName().hashCode() + this.openType.hashCode() + (this.defaultValue == null ? 0 : this.defaultValue.hashCode()) + (this.minValue == null ? 0 : this.minValue.hashCode()) + (this.maxValue == null ? 0 : this.maxValue.hashCode()) + (this.legalValues == null ? 0 : this.legalValues.hashCode());
        }
        return this.hashCode;
    }

    @Override
    public boolean hasLegalValues() {
        return this.legalValues != null;
    }

    @Override
    public boolean hasMaxValue() {
        return this.maxValue != null;
    }

    @Override
    public boolean hasMinValue() {
        return this.minValue != null;
    }

    @Override
    public boolean isValue(Object obj) {
        return this.openType.isValue(obj);
    }

    @Override
    public String toString() {
        if (this.string == null) {
            this.string = String.valueOf(this.getClass().getName()) + "[name=" + this.getName() + ",openType=" + this.openType + ",defaultValue=" + this.defaultValue + ",minValue=" + this.minValue + ",maxValue=" + this.maxValue + ",legalValues=" + this.legalValues + "]";
        }
        return this.string;
    }
}

