/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class XMLFormatter
extends Formatter {
    private static final String lineSep = SimpleFormatter.lineSep;
    private final SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    private static void appendTag(StringBuffer buf, int indent, String tag, String content) {
        if (content == null) {
            return;
        }
        int i = 0;
        while (i < indent * 2) {
            buf.append(' ');
            ++i;
        }
        buf.append("<");
        buf.append(tag);
        buf.append('>');
        i = 0;
        while (i < content.length()) {
            char c = content.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                default: {
                    if (c >= ' ' && c <= '~' || c == '\n' || c == '\r') {
                        buf.append(c);
                        break;
                    }
                    buf.append("&#");
                    buf.append((int)c);
                    buf.append(';');
                }
            }
            ++i;
        }
        buf.append("</");
        buf.append(tag);
        buf.append(">");
        buf.append(lineSep);
    }

    private static void appendTag(StringBuffer buf, int indent, String tag, long content) {
        XMLFormatter.appendTag(buf, indent, tag, Long.toString(content));
    }

    public String format(LogRecord record) {
        String message;
        StringBuffer buf = new StringBuffer(400);
        Level level = record.getLevel();
        long millis = record.getMillis();
        record.getParameters();
        ResourceBundle bundle = record.getResourceBundle();
        buf.append("<record>");
        buf.append(lineSep);
        XMLFormatter.appendTag(buf, 1, "date", this.iso8601.format(new Date(millis)));
        XMLFormatter.appendTag(buf, 1, "millis", millis);
        XMLFormatter.appendTag(buf, 1, "sequence", record.getSequenceNumber());
        XMLFormatter.appendTag(buf, 1, "logger", record.getLoggerName());
        if (level.isStandardLevel()) {
            XMLFormatter.appendTag(buf, 1, "level", level.toString());
        } else {
            XMLFormatter.appendTag(buf, 1, "level", level.intValue());
        }
        XMLFormatter.appendTag(buf, 1, "class", record.getSourceClassName());
        XMLFormatter.appendTag(buf, 1, "method", record.getSourceMethodName());
        XMLFormatter.appendTag(buf, 1, "thread", record.getThreadID());
        try {
            record.setResourceBundle(null);
            message = this.formatMessage(record);
        }
        finally {
            record.setResourceBundle(bundle);
        }
        XMLFormatter.appendTag(buf, 1, "message", message);
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            buf.append("  <exception>");
            buf.append(lineSep);
            XMLFormatter.appendTag(buf, 2, "message", thrown.toString());
            buf.append("  </exception>");
            buf.append(lineSep);
        }
        buf.append("</record>");
        buf.append(lineSep);
        return buf.toString();
    }

    public String getHead(Handler h) {
        StringBuffer buf = new StringBuffer(80);
        buf.append("<?xml version=\"1.0\" encoding=\"");
        String encoding = h.getEncoding();
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (encoding.length() > 2 && encoding.startsWith("Cp")) {
            encoding = "windows-" + encoding.substring(2);
        }
        buf.append(encoding);
        buf.append("\" standalone=\"no\"?>");
        buf.append(lineSep);
        buf.append("<!DOCTYPE log SYSTEM \"logger.dtd\">");
        buf.append(lineSep);
        buf.append("<log>");
        buf.append(lineSep);
        return buf.toString();
    }

    public String getTail(Handler h) {
        return "</log>" + lineSep;
    }
}

