/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicMarkableReference<V> {
    private final AtomicReference<ReferenceBooleanPair<V>> atomicRef;

    public AtomicMarkableReference(V initialRef, boolean initialMark) {
        this.atomicRef = new AtomicReference<ReferenceBooleanPair<ReferenceBooleanPair<V>>>(new ReferenceBooleanPair<V>(initialRef, initialMark));
    }

    public V getReference() {
        return (V)((ReferenceBooleanPair)this.atomicRef.get()).reference;
    }

    public boolean isMarked() {
        return ((ReferenceBooleanPair)this.atomicRef.get()).bit;
    }

    public V get(boolean[] markHolder) {
        ReferenceBooleanPair<V> p = this.atomicRef.get();
        markHolder[0] = ((ReferenceBooleanPair)p).bit;
        return (V)((ReferenceBooleanPair)p).reference;
    }

    public boolean weakCompareAndSet(V expectedReference, V newReference, boolean expectedMark, boolean newMark) {
        ReferenceBooleanPair<V> current = this.atomicRef.get();
        return expectedReference == ((ReferenceBooleanPair)current).reference && expectedMark == ((ReferenceBooleanPair)current).bit && (newReference == ((ReferenceBooleanPair)current).reference && newMark == ((ReferenceBooleanPair)current).bit || this.atomicRef.weakCompareAndSet(current, new ReferenceBooleanPair<V>(newReference, newMark)));
    }

    public boolean compareAndSet(V expectedReference, V newReference, boolean expectedMark, boolean newMark) {
        ReferenceBooleanPair<V> current = this.atomicRef.get();
        return expectedReference == ((ReferenceBooleanPair)current).reference && expectedMark == ((ReferenceBooleanPair)current).bit && (newReference == ((ReferenceBooleanPair)current).reference && newMark == ((ReferenceBooleanPair)current).bit || this.atomicRef.compareAndSet(current, new ReferenceBooleanPair<V>(newReference, newMark)));
    }

    public void set(V newReference, boolean newMark) {
        ReferenceBooleanPair<V> current = this.atomicRef.get();
        if (newReference != ((ReferenceBooleanPair)current).reference || newMark != ((ReferenceBooleanPair)current).bit) {
            this.atomicRef.set(new ReferenceBooleanPair<V>(newReference, newMark));
        }
    }

    public boolean attemptMark(V expectedReference, boolean newMark) {
        ReferenceBooleanPair<V> current = this.atomicRef.get();
        return expectedReference == ((ReferenceBooleanPair)current).reference && (newMark == ((ReferenceBooleanPair)current).bit || this.atomicRef.compareAndSet(current, new ReferenceBooleanPair<V>(expectedReference, newMark)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReferenceBooleanPair<T> {
        private final T reference;
        private final boolean bit;

        ReferenceBooleanPair(T r, boolean i) {
            this.reference = r;
            this.bit = i;
        }
    }
}

