/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public final class SignedObject
implements Serializable {
    private static final long serialVersionUID = 720502720485447167L;
    private byte[] content;
    private byte[] signature;
    private String thealgorithm;

    public SignedObject(Serializable object, PrivateKey signingKey, Signature signingEngine) throws IOException, InvalidKeyException, SignatureException {
        this.thealgorithm = signingEngine.getAlgorithm();
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        ObjectOutputStream p = new ObjectOutputStream(ostream);
        p.writeObject(object);
        p.flush();
        p.close();
        this.content = ostream.toByteArray();
        signingEngine.initSign(signingKey);
        signingEngine.update(this.content);
        this.signature = signingEngine.sign();
    }

    public Object getObject() throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.content);
        ObjectInputStream oi = new ObjectInputStream(bais);
        Object obj = oi.readObject();
        oi.close();
        bais.close();
        return obj;
    }

    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    public String getAlgorithm() {
        return this.thealgorithm;
    }

    public boolean verify(PublicKey verificationKey, Signature verificationEngine) throws InvalidKeyException, SignatureException {
        verificationEngine.initVerify(verificationKey);
        verificationEngine.update(this.content);
        return verificationEngine.verify(this.signature);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.content = (byte[])this.content.clone();
        this.signature = (byte[])this.signature.clone();
    }
}

