/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.classpath.SystemProperties;
import gnu.java.net.URLParseError;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.StringTokenizer;

public final class URL
implements Serializable {
    private static final String DEFAULT_SEARCH_PATH = "gnu.java.net.protocol|gnu.inet";
    private static ClassLoader systemClassLoader;
    private String protocol;
    private String authority;
    private String host;
    private String userInfo;
    private int port = -1;
    private String file;
    private String ref;
    private int hashCode;
    transient URLStreamHandler ph;
    private static URLStreamHandlerFactory factory;
    private static final long serialVersionUID = -7627629688361524110L;
    private static HashMap<String, URLStreamHandler> ph_cache;
    private static boolean cache_handlers;

    static {
        ph_cache = new HashMap();
        String s = SystemProperties.getProperty("gnu.java.net.nocache_protocol_handlers");
        cache_handlers = s == null;
    }

    public URL(String protocol, String host, int port, String file) throws MalformedURLException {
        this(protocol, host, port, file, null);
    }

    public URL(String protocol, String host, String file) throws MalformedURLException {
        this(protocol, host, -1, file, null);
    }

    public URL(String protocol, String host, int port, String file, URLStreamHandler ph) throws MalformedURLException {
        int hashAt;
        if (protocol == null) {
            throw new MalformedURLException("null protocol");
        }
        this.protocol = protocol = protocol.toLowerCase();
        if (ph != null) {
            SecurityManager s = System.getSecurityManager();
            if (s != null) {
                s.checkPermission(new NetPermission("specifyStreamHandler"));
            }
            this.ph = ph;
        } else {
            this.ph = URL.getURLStreamHandler(protocol);
        }
        if (this.ph == null) {
            throw new MalformedURLException("Protocol handler not found: " + protocol);
        }
        this.host = host;
        this.port = port;
        String string = this.authority = host != null ? host : "";
        if (port >= 0 && host != null) {
            this.authority = String.valueOf(this.authority) + ":" + port;
        }
        if ((hashAt = file.indexOf(35)) < 0) {
            this.file = file;
            this.ref = null;
        } else {
            this.file = file.substring(0, hashAt);
            this.ref = file.substring(hashAt + 1);
        }
        this.hashCode = this.hashCode();
    }

    public URL(String spec) throws MalformedURLException {
        this(null, spec != null ? spec : "", null, false);
    }

    public URL(URL context, String spec) throws MalformedURLException {
        this(context, spec, context == null ? null : context.ph, false);
    }

    public URL(URL context, String spec, URLStreamHandler ph) throws MalformedURLException {
        this(context, spec, ph, true);
    }

    private URL(URL context, String spec, URLStreamHandler ph, boolean phFromUser) throws MalformedURLException {
        int slash = spec.indexOf(47);
        int colon = spec.indexOf("://", 1);
        if (!(colon <= 0 || colon >= slash && slash >= 0 || spec.regionMatches(colon, "://:", 0, 4))) {
            context = null;
            if (!phFromUser) {
                ph = null;
            }
        }
        boolean protocolSpecified = false;
        colon = spec.indexOf(58);
        if (colon > 0 && (colon < slash || slash < 0)) {
            protocolSpecified = true;
            this.protocol = spec.substring(0, colon).toLowerCase();
            if (context != null) {
                if (context.protocol.equals(this.protocol)) {
                    this.host = context.host;
                    this.port = context.port;
                    this.userInfo = context.userInfo;
                    this.authority = context.authority;
                } else {
                    URLStreamHandler specPh = URL.getURLStreamHandler(this.protocol.trim());
                    if (specPh == null) {
                        protocolSpecified = false;
                    }
                }
            }
        }
        if (!protocolSpecified) {
            if (context != null) {
                colon = -1;
                this.protocol = context.protocol;
                this.host = context.host;
                this.port = context.port;
                this.userInfo = context.userInfo;
                if (spec.indexOf(":/", 1) < 0) {
                    this.file = context.file;
                    if (this.file == null || this.file.length() == 0) {
                        this.file = "/";
                    }
                }
                this.authority = context.authority;
            } else {
                throw new MalformedURLException("Absolute URL required with null context: " + spec);
            }
        }
        this.protocol = this.protocol.trim();
        if (ph != null) {
            SecurityManager s = System.getSecurityManager();
            if (s != null && phFromUser) {
                s.checkPermission(new NetPermission("specifyStreamHandler"));
            }
            this.ph = ph;
        } else {
            this.ph = URL.getURLStreamHandler(this.protocol);
        }
        if (this.ph == null) {
            throw new MalformedURLException("Protocol handler not found: " + this.protocol);
        }
        int hashAt = spec.indexOf(35, colon + 1);
        try {
            this.ph.parseURL(this, spec, colon + 1, hashAt < 0 ? spec.length() : hashAt);
        }
        catch (URLParseError e) {
            MalformedURLException mue = new MalformedURLException(e.getMessage());
            mue.initCause(e);
            throw mue;
        }
        catch (RuntimeException e) {
            MalformedURLException mue = new MalformedURLException(e.getMessage());
            mue.initCause(e);
            throw mue;
        }
        if (hashAt >= 0) {
            this.ref = spec.substring(hashAt + 1);
        }
        this.hashCode = this.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URL)) {
            return false;
        }
        return this.ph.equals(this, (URL)obj);
    }

    public Object getContent() throws IOException {
        return this.openConnection().getContent();
    }

    public Object getContent(Class[] classes) throws IOException {
        return this.openConnection().getContent(classes);
    }

    public String getFile() {
        return this.file == null ? "" : this.file;
    }

    public String getPath() {
        if (this.file == null) {
            return null;
        }
        int quest = this.file.indexOf(63);
        return quest < 0 ? this.getFile() : this.file.substring(0, quest);
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getHost() {
        int at = this.host == null ? -1 : this.host.indexOf(64);
        return at < 0 ? this.host : this.host.substring(at + 1, this.host.length());
    }

    public int getPort() {
        return this.port;
    }

    public int getDefaultPort() {
        return this.ph.getDefaultPort();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRef() {
        return this.ref;
    }

    public String getUserInfo() {
        if (this.userInfo != null) {
            return this.userInfo;
        }
        int at = this.host == null ? -1 : this.host.indexOf(64);
        return at < 0 ? null : this.host.substring(0, at);
    }

    public String getQuery() {
        int quest = this.file == null ? -1 : this.file.indexOf(63);
        return quest < 0 ? null : this.file.substring(quest + 1, this.file.length());
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        return this.ph.hashCode(this);
    }

    public URLConnection openConnection() throws IOException {
        return this.ph.openConnection(this);
    }

    public InputStream openStream() throws IOException {
        return this.openConnection().getInputStream();
    }

    public boolean sameFile(URL url) {
        return this.ph.sameFile(this, url);
    }

    protected void set(String protocol, String host, int port, String file, String ref) {
        URLStreamHandler protocolHandler = null;
        if (!this.protocol.equals(protocol = protocol.toLowerCase())) {
            protocolHandler = URL.getURLStreamHandler(protocol);
        }
        if (protocolHandler != null) {
            this.ph = protocolHandler;
            this.protocol = protocol;
        }
        this.authority = "";
        this.port = port;
        this.host = host;
        this.file = file;
        this.ref = ref;
        if (host != null) {
            this.authority = String.valueOf(this.authority) + host;
        }
        if (port >= 0) {
            this.authority = String.valueOf(this.authority) + ":" + port;
        }
        this.hashCode = this.hashCode();
    }

    protected void set(String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        URLStreamHandler protocolHandler = null;
        if (!this.protocol.equals(protocol = protocol.toLowerCase())) {
            protocolHandler = URL.getURLStreamHandler(protocol);
        }
        if (protocolHandler != null) {
            this.ph = protocolHandler;
            this.protocol = protocol;
        }
        this.host = host;
        this.userInfo = userInfo;
        this.port = port;
        this.authority = authority;
        this.file = query == null ? path : String.valueOf(path) + "?" + query;
        this.ref = ref;
        this.hashCode = this.hashCode();
    }

    public static synchronized void setURLStreamHandlerFactory(URLStreamHandlerFactory fac) {
        if (factory != null) {
            throw new Error("URLStreamHandlerFactory already set");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkSetFactory();
        }
        factory = fac;
    }

    public String toExternalForm() {
        return this.ph.toExternalForm(this);
    }

    public String toString() {
        return this.ph.toExternalForm(this);
    }

    private static synchronized URLStreamHandler getURLStreamHandler(String protocol) {
        URLStreamHandler ph = null;
        if (cache_handlers && (ph = ph_cache.get(protocol)) != null) {
            return ph;
        }
        if (factory != null) {
            ph = factory.createURLStreamHandler(protocol);
        }
        if (ph == null) {
            String ph_search_path = SystemProperties.getProperty("java.protocol.handler.pkgs");
            ph_search_path = ph_search_path != null ? String.valueOf(ph_search_path) + "|gnu.java.net.protocol|gnu.inet" : DEFAULT_SEARCH_PATH;
            StringTokenizer pkgPrefix = new StringTokenizer(ph_search_path, "|");
            if (systemClassLoader == null) {
                systemClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return ClassLoader.getSystemClassLoader();
                    }
                });
            }
            do {
                try {
                    String clsName = String.valueOf(pkgPrefix.nextToken()) + "." + protocol + ".Handler";
                    Class<?> c = Class.forName(clsName, true, systemClassLoader);
                    ph = (URLStreamHandler)c.newInstance();
                }
                catch (ThreadDeath death) {
                    throw death;
                }
                catch (Throwable throwable) {}
            } while (ph == null && pkgPrefix.hasMoreTokens());
        }
        if (ph != null && cache_handlers) {
            ph_cache.put(protocol, ph);
        } else {
            ph = null;
        }
        return ph;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.ph = URL.getURLStreamHandler(this.protocol);
        if (this.ph == null) {
            throw new IOException("Handler for protocol " + this.protocol + " not found");
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    public URI toURI() throws URISyntaxException {
        return new URI(this.toString());
    }
}

