/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.java.net.PlainSocketImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ServerSocketChannel;

public class ServerSocket {
    private static SocketImplFactory factory;
    private SocketImpl impl;
    private InetSocketAddress local;
    private int port;

    ServerSocket(PlainSocketImpl impl) throws IOException {
        if (impl == null) {
            throw new NullPointerException("impl may not be null");
        }
        this.impl = impl;
        this.impl.create(true);
        this.setReuseAddress(true);
    }

    SocketImpl getImpl() {
        return this.impl;
    }

    public ServerSocket() throws IOException {
        this.impl = factory != null ? factory.createSocketImpl() : new PlainSocketImpl();
        this.impl.create(true);
    }

    public ServerSocket(int port) throws IOException {
        this(port, 50);
    }

    public ServerSocket(int port, int backlog) throws IOException {
        this(port, backlog, null);
    }

    public ServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        this();
        this.bind(new InetSocketAddress(bindAddr, port), backlog);
    }

    public void bind(SocketAddress endpoint) throws IOException {
        this.bind(endpoint, 50);
    }

    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        int port;
        InetAddress addr;
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (endpoint == null) {
            addr = InetAddress.ANY_IF;
            port = 0;
        } else {
            if (!(endpoint instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Address type not supported");
            }
            InetSocketAddress tmp = (InetSocketAddress)endpoint;
            if (tmp.isUnresolved()) {
                throw new SocketException("Unresolved address");
            }
            addr = tmp.getAddress();
            port = tmp.getPort();
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkListen(port);
        }
        try {
            this.impl.bind(addr, port);
            this.impl.listen(backlog);
            this.port = port;
            this.local = new InetSocketAddress((InetAddress)this.impl.getOption(15), this.impl.getLocalPort());
        }
        catch (Throwable throwable) {
            try {
                if (this.local == null) {
                    this.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (this.local == null) {
                this.close();
            }
        }
        catch (IOException iOException) {}
    }

    public InetAddress getInetAddress() {
        if (this.local == null) {
            return null;
        }
        return this.local.getAddress();
    }

    public int getLocalPort() {
        if (this.local == null) {
            return -1;
        }
        return this.local.getPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.local;
    }

    public Socket accept() throws IOException {
        Socket socket = new Socket();
        try {
            this.implAccept(socket);
        }
        catch (IOException e) {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
            throw e;
        }
        catch (SecurityException e) {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
            throw e;
        }
        return socket;
    }

    protected final void implAccept(Socket socket) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        if (this.getChannel() != null && !this.getChannel().isBlocking() && !((PlainSocketImpl)this.getImpl()).isInChannelOperation()) {
            throw new IllegalBlockingModeException();
        }
        this.impl.accept(socket.impl);
        socket.bound = true;
        socket.implCreated = true;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkAccept(socket.getInetAddress().getHostAddress(), socket.getPort());
        }
    }

    public void close() throws IOException {
        if (this.impl != null) {
            this.impl.close();
            this.impl = null;
        }
    }

    public ServerSocketChannel getChannel() {
        return null;
    }

    public boolean isBound() {
        return this.local != null;
    }

    public boolean isClosed() {
        ServerSocketChannel channel = this.getChannel();
        return this.impl == null || channel != null && !channel.isOpen();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("SO_TIMEOUT value must be >= 0");
        }
        this.impl.setOption(4102, new Integer(timeout));
    }

    public int getSoTimeout() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        Object timeout = this.impl.getOption(4102);
        if (!(timeout instanceof Integer)) {
            throw new IOException("Internal Error");
        }
        return (Integer)timeout;
    }

    public void setReuseAddress(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        this.impl.setOption(4, on);
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        Object reuseaddr = this.impl.getOption(4);
        if (!(reuseaddr instanceof Boolean)) {
            throw new SocketException("Internal Error");
        }
        return (Boolean)reuseaddr;
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("SO_RCVBUF value must be > 0");
        }
        this.impl.setOption(4098, new Integer(size));
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        Object buf = this.impl.getOption(4098);
        if (!(buf instanceof Integer)) {
            throw new SocketException("Internal Error: Unexpected type");
        }
        return (Integer)buf;
    }

    public String toString() {
        if (!this.isBound()) {
            return "ServerSocket[unbound]";
        }
        return "ServerSocket[addr=" + this.getInetAddress() + ",port=" + this.port + ",localport=" + this.getLocalPort() + "]";
    }

    public static synchronized void setSocketFactory(SocketImplFactory fac) throws IOException {
        if (factory != null) {
            throw new SocketException("SocketFactory already defined");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSetFactory();
        }
        factory = fac;
    }
}

