/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

public class CharArrayWriter
extends Writer {
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 32;
    protected char[] buf;
    protected int count;

    public CharArrayWriter() {
        this(32);
    }

    public CharArrayWriter(int size) {
        this.buf = new char[size];
    }

    public void close() {
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.count = 0;
        }
    }

    public int size() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] toCharArray() {
        Object object = this.lock;
        synchronized (object) {
            char[] nc = new char[this.count];
            System.arraycopy(this.buf, 0, nc, 0, this.count);
            return nc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return new String(this.buf, 0, this.count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int oneChar) {
        Object object = this.lock;
        synchronized (object) {
            this.resize(1);
            this.buf[this.count++] = (char)oneChar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buffer, int offset, int len) {
        Object object = this.lock;
        synchronized (object) {
            if (len >= 0) {
                this.resize(len);
            }
            System.arraycopy(buffer, offset, this.buf, this.count, len);
            this.count += len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str, int offset, int len) {
        Object object = this.lock;
        synchronized (object) {
            if (len >= 0) {
                this.resize(len);
            }
            str.getChars(offset, offset + len, this.buf, this.count);
            this.count += len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Writer out) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            out.write(this.buf, 0, this.count);
        }
    }

    public CharArrayWriter append(char c) {
        this.write(c);
        return this;
    }

    public CharArrayWriter append(CharSequence cs) {
        try {
            this.write(cs == null ? "null" : cs.toString());
        }
        catch (IOException iOException) {}
        return this;
    }

    public CharArrayWriter append(CharSequence cs, int start, int end) {
        try {
            this.write(cs == null ? "null" : cs.subSequence(start, end).toString());
        }
        catch (IOException iOException) {}
        return this;
    }

    private void resize(int len) {
        if (this.count + len >= this.buf.length) {
            int newlen = this.buf.length * 2;
            if (this.count + len > newlen) {
                newlen = this.count + len;
            }
            char[] newbuf = new char[newlen];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
    }
}

