/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.stream.UnicodeReader;
import gnu.xml.stream.XMLParser;
import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class NameType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{1, 2, 3, 4, 5, 6};

    NameType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "Name"), TypeLibrary.TOKEN);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        try {
            int[] cp = UnicodeReader.toCodePointArray(value);
            if (cp.length == 0) {
                throw new DatatypeException("invalid Name value");
            }
            if (!XMLParser.isNameStartCharacter(cp[0], false)) {
                throw new DatatypeException(0, "invalid Name value");
            }
            int i = 1;
            while (i < cp.length) {
                if (!XMLParser.isNameCharacter(cp[i], false)) {
                    throw new DatatypeException(i, "invalid Name value");
                }
                ++i;
            }
        }
        catch (IOException e) {
            DatatypeException e2 = new DatatypeException("invalid Name value");
            e2.initCause(e);
            throw e2;
        }
    }
}

