/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.stream.UnicodeReader;
import gnu.xml.stream.XMLParser;
import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class NMTokensType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{1, 2, 3, 4, 5, 6};

    NMTokensType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "NMTOKENS"), TypeLibrary.NMTOKEN);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        int len = value.length();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c == ' ') {
                String token = buf.toString();
                if (token.length() > 0) {
                    this.checkNmtoken(token, i);
                }
                buf.setLength(0);
            } else {
                buf.append(c);
            }
            ++i;
        }
        this.checkNmtoken(buf.toString(), len);
    }

    private void checkNmtoken(String text, int i) throws DatatypeException {
        try {
            int[] cp = UnicodeReader.toCodePointArray(text);
            if (cp.length == 0) {
                throw new DatatypeException("invalid NMTOKEN value");
            }
            int j = 0;
            while (j < cp.length) {
                if (!XMLParser.isNameCharacter(cp[j], false)) {
                    throw new DatatypeException(i, "invalid NMTOKEN value");
                }
                ++j;
            }
        }
        catch (IOException e) {
            DatatypeException e2 = new DatatypeException("invalid NMTOKEN value");
            e2.initCause(e);
            throw e2;
        }
    }
}

