/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class FloatType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};
    static final Set SPECIAL = new TreeSet((Collection)Arrays.asList("INF", "-INF", "NaN"));

    FloatType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "float"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        if (SPECIAL.contains(value)) {
            return;
        }
        try {
            Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            DatatypeException e2 = new DatatypeException("invalid float value");
            e2.initCause(e);
            throw e2;
        }
    }

    public Object createValue(String literal, ValidationContext context) {
        try {
            return new Float(literal);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

