/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Key;
import gnu.xml.transform.SortKey;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.transform.WithParam;
import gnu.xml.transform.XSLComparator;
import gnu.xml.xpath.Expr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

final class ApplyTemplatesNode
extends TemplateNode {
    final Expr select;
    final QName mode;
    final List sortKeys;
    final List withParams;
    final boolean isDefault;

    ApplyTemplatesNode(Expr select, QName mode, List sortKeys, List withParams, boolean isDefault) {
        this.select = select;
        this.mode = mode;
        this.sortKeys = sortKeys;
        this.withParams = withParams;
        this.isDefault = isDefault;
    }

    TemplateNode clone(Stylesheet stylesheet) {
        int len = this.sortKeys != null ? this.sortKeys.size() : 0;
        ArrayList<Key> sortKeys2 = new ArrayList<Key>(len);
        int i = 0;
        while (i < len) {
            sortKeys2.add(((Key)this.sortKeys.get(i)).clone(stylesheet));
            ++i;
        }
        len = this.withParams != null ? this.withParams.size() : 0;
        ArrayList<WithParam> withParams2 = new ArrayList<WithParam>(len);
        int i2 = 0;
        while (i2 < len) {
            withParams2.add(((WithParam)this.withParams.get(i2)).clone(stylesheet));
            ++i2;
        }
        ApplyTemplatesNode ret = new ApplyTemplatesNode(this.select.clone(stylesheet), this.mode, sortKeys2, withParams2, this.isDefault);
        if (this.children != null) {
            ret.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            ret.next = this.next.clone(stylesheet);
        }
        return ret;
    }

    void doApply(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling) throws TransformerException {
        Object ret = this.select.evaluate(context, pos, len);
        if (ret != null && ret instanceof Collection) {
            if (this.withParams != null) {
                LinkedList<Object[]> values = new LinkedList<Object[]>();
                for (WithParam p : this.withParams) {
                    Object value = p.getValue(stylesheet, mode, context, pos, len);
                    Object[] pair = new Object[]{p.name, value};
                    values.add(pair);
                }
                stylesheet.bindings.push(2);
                for (Object[] pair : values) {
                    QName name = (QName)pair[0];
                    Object value = pair[1];
                    stylesheet.bindings.set(name, value, 2);
                }
            }
            Collection ns = (Collection)ret;
            ArrayList nodes = new ArrayList(ns);
            if (this.sortKeys != null) {
                for (SortKey sortKey : this.sortKeys) {
                    sortKey.init(stylesheet, mode, context, pos, len, parent, nextSibling);
                }
                Collections.sort(nodes, new XSLComparator(this.sortKeys));
            } else {
                Collections.sort(nodes, documentOrderComparator);
            }
            int l = nodes.size();
            QName effectiveMode = this.isDefault ? mode : this.mode;
            int i = 0;
            while (i < l) {
                Node node2 = (Node)nodes.get(i);
                TemplateNode t = stylesheet.getTemplate(effectiveMode, node2, false);
                if (t != null) {
                    stylesheet.current = node2;
                    t.apply(stylesheet, effectiveMode, node2, i + 1, l, parent, nextSibling);
                }
                ++i;
            }
            if (this.withParams != null) {
                stylesheet.bindings.pop(2);
            }
        }
        if (this.next != null) {
            this.next.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
        }
    }

    public boolean references(QName var) {
        Iterator i;
        if (this.select != null && this.select.references(var)) {
            return true;
        }
        if (this.withParams != null) {
            i = this.withParams.iterator();
            while (i.hasNext()) {
                if (!((WithParam)i.next()).references(var)) continue;
                return true;
            }
        }
        if (this.sortKeys != null) {
            i = this.sortKeys.iterator();
            while (i.hasNext()) {
                if (!((SortKey)i.next()).references(var)) continue;
                return true;
            }
        }
        return super.references(var);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("apply-templates");
        buf.append('[');
        boolean o = false;
        if (this.select != null) {
            buf.append("select=");
            buf.append(this.select);
            o = true;
        }
        if (this.mode != null) {
            if (o) {
                buf.append(',');
            }
            buf.append("mode=");
            buf.append(this.mode);
        }
        buf.append(']');
        return buf.toString();
    }
}

