/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.crypto.key.GnuPBEKey;
import gnu.javax.net.ssl.Session;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.MaxFragmentLength;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;
import javax.net.ssl.SSLException;

public class SessionImpl
extends Session {
    static final long serialVersionUID = 8932976607588442485L;
    CipherSuite suite;
    ProtocolVersion version;
    byte[] privateDataSalt;
    SealedObject sealedPrivateData;
    MaxFragmentLength maxLength;
    transient PrivateData privateData = new PrivateData();

    SecureRandom random() {
        return this.random;
    }

    public String getProtocol() {
        return this.version.toString();
    }

    public void prepare(char[] passwd) throws SSLException {
        try {
            this.privateDataSalt = new byte[32];
            this.random.nextBytes(this.privateDataSalt);
            GnuPBEKey key = new GnuPBEKey(passwd, this.privateDataSalt, 1000);
            Cipher cipher = Cipher.getInstance("PBEWithHMacSHA256AndAES/OFB/PKCS7Padding");
            cipher.init(1, key);
            this.sealedPrivateData = new SealedObject(this.privateData, cipher);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new SSLException(ibse);
        }
        catch (InvalidKeyException ike) {
            throw new SSLException(ike);
        }
        catch (IOException ioe) {
            throw new SSLException(ioe);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SSLException(nsae);
        }
        catch (NoSuchPaddingException nspe) {
            throw new SSLException(nspe);
        }
    }

    public void repair(char[] passwd) throws SSLException {
        try {
            GnuPBEKey key = new GnuPBEKey(passwd, this.privateDataSalt, 1000);
            this.privateData = (PrivateData)this.sealedPrivateData.getObject(key);
        }
        catch (ClassNotFoundException cnfe) {
            throw new SSLException(cnfe);
        }
        catch (InvalidKeyException ike) {
            throw new SSLException(ike);
        }
        catch (IOException ioe) {
            throw new SSLException(ioe);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SSLException(nsae);
        }
    }

    public SealedObject privateData() throws SSLException {
        if (this.privateData == null) {
            throw new SSLException("this session has not been prepared");
        }
        return this.sealedPrivateData;
    }

    public void setPrivateData(SealedObject so) throws SSLException {
        this.sealedPrivateData = so;
    }

    void setApplicationBufferSize(int size) {
        this.applicationBufferSize = size;
    }

    void setRandom(SecureRandom random) {
        this.random = random;
    }

    void setTruncatedMac(boolean truncatedMac) {
        this.truncatedMac = truncatedMac;
    }

    void setId(Session.ID id) {
        this.sessionId = id;
    }

    void setLocalCertificates(Certificate[] chain) {
        this.localCerts = chain;
    }

    void setPeerCertificates(Certificate[] chain) {
        this.peerCerts = chain;
    }

    void setPeerVerified(boolean peerVerified) {
        this.peerVerified = peerVerified;
    }

    static class PrivateData
    implements Serializable {
        static final long serialVersionUID = -8040597659545984581L;
        byte[] masterSecret;

        PrivateData() {
        }
    }
}

