/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Constructed;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProtocolVersion
implements Comparable<ProtocolVersion>,
Constructed {
    public static final ProtocolVersion SSL_3 = new ProtocolVersion(3, 0);
    public static final ProtocolVersion TLS_1 = new ProtocolVersion(3, 1);
    public static final ProtocolVersion TLS_1_1 = new ProtocolVersion(3, 2);
    private final int major;
    private final int minor;

    private ProtocolVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public static ProtocolVersion read(InputStream in) throws IOException {
        int major = in.read() & 0xFF;
        int minor = in.read() & 0xFF;
        return ProtocolVersion.getInstance(major, minor);
    }

    public static ProtocolVersion forName(String name) {
        if (name.equalsIgnoreCase("SSLv3")) {
            return SSL_3;
        }
        if (name.equalsIgnoreCase("TLSv1")) {
            return TLS_1;
        }
        if (name.equalsIgnoreCase("TLSv1.1")) {
            return TLS_1_1;
        }
        throw new IllegalArgumentException("unknown protocol name: " + name);
    }

    public static ProtocolVersion getInstance(int major, int minor) {
        if (major == 3) {
            switch (minor) {
                case 0: {
                    return SSL_3;
                }
                case 1: {
                    return TLS_1;
                }
                case 2: {
                    return TLS_1_1;
                }
            }
        }
        return new ProtocolVersion(major, minor);
    }

    public static ProtocolVersion getInstance(short raw_value) {
        int major = raw_value >>> 8 & 0xFF;
        int minor = raw_value & 0xFF;
        return ProtocolVersion.getInstance(major, minor);
    }

    @Override
    public int length() {
        return 2;
    }

    public byte[] getEncoded() {
        return new byte[]{(byte)this.major, (byte)this.minor};
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int rawValue() {
        return this.major << 8 | this.minor;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProtocolVersion)) {
            return false;
        }
        return ((ProtocolVersion)o).major == this.major && ((ProtocolVersion)o).minor == this.minor;
    }

    public int hashCode() {
        return this.major << 8 | this.minor;
    }

    @Override
    public int compareTo(ProtocolVersion that) {
        if (this.major > that.major) {
            return 1;
        }
        if (this.major < that.major) {
            return -1;
        }
        if (this.minor > that.minor) {
            return 1;
        }
        if (this.minor < that.minor) {
            return -1;
        }
        return 0;
    }

    @Override
    public String toString(String prefix) {
        return this.toString();
    }

    public String toString() {
        if (this == SSL_3) {
            return "SSLv3";
        }
        if (this == TLS_1) {
            return "TLSv1";
        }
        if (this == TLS_1_1) {
            return "TLSv1.1";
        }
        return "Unsupported; major=" + this.major + " minor=" + this.minor;
    }
}

