/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.srp;

import gnu.javax.crypto.sasl.srp.SecurityContext;
import gnu.javax.crypto.sasl.srp.StoreEntry;
import java.util.HashMap;

public class ServerStore {
    private static ServerStore singleton = null;
    private static final HashMap sid2ssc = new HashMap();
    private static final HashMap sid2ttl = new HashMap();
    private static final Object lock = new Object();
    private static int counter = 0;

    private ServerStore() {
    }

    static final synchronized ServerStore instance() {
        if (singleton == null) {
            singleton = new ServerStore();
        }
        return singleton;
    }

    static final synchronized byte[] getNewSessionID() {
        String sid = String.valueOf(++counter);
        return new StringBuffer("SID-").append("0000000000".substring(0, 10 - sid.length())).append(sid).toString().getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAlive(byte[] sid) {
        boolean result = false;
        if (sid != null && sid.length != 0) {
            Object object = lock;
            synchronized (object) {
                String key = new String(sid);
                StoreEntry ctx = (StoreEntry)sid2ttl.get(key);
                if (ctx != null && !(result = ctx.isAlive())) {
                    sid2ssc.remove(key);
                    sid2ttl.remove(key);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheSession(int ttl, SecurityContext ctx) {
        Object object = lock;
        synchronized (object) {
            String key = new String(ctx.getSID());
            sid2ssc.put(key, ctx);
            sid2ttl.put(key, new StoreEntry(ttl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SecurityContext restoreSession(byte[] sid) {
        SecurityContext result;
        String key = new String(sid);
        Object object = lock;
        synchronized (object) {
            result = (SecurityContext)sid2ssc.remove(key);
            sid2ttl.remove(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateSession(byte[] sid) {
        String key = new String(sid);
        Object object = lock;
        synchronized (object) {
            sid2ssc.remove(key);
            sid2ttl.remove(key);
        }
    }
}

