/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jarsigner;

import gnu.classpath.Configuration;
import gnu.classpath.tools.jarsigner.HashUtils;
import gnu.classpath.tools.jarsigner.Main;
import gnu.classpath.tools.jarsigner.Messages;
import gnu.java.security.OID;
import gnu.java.security.pkcs.PKCS7SignedData;
import gnu.java.security.pkcs.SignerInfo;
import gnu.java.security.sig.dss.DSSSignature;
import gnu.java.security.sig.dss.DSSSignatureX509Codec;
import gnu.java.security.sig.rsa.RSAPKCS1V1_5Signature;
import gnu.java.security.sig.rsa.RSAPKCS1V1_5SignatureX509Codec;
import gnu.java.security.util.Util;
import gnu.java.util.jar.JarUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipException;

public class JarVerifier {
    private static final Logger log = Logger.getLogger(JarVerifier.class.getName());
    private Main main;
    private HashUtils util = new HashUtils();
    private JarFile jarFile;
    private Map<String, String> entryHashes = new HashMap<String, String>();

    JarVerifier(Main main) {
        this.main = main;
    }

    void start() throws Exception {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        String jarFileName = this.main.getJarFileName();
        this.jarFile = new JarFile(jarFileName);
        ArrayList<String> sfFiles = new ArrayList<String>();
        Enumeration<JarEntry> e = this.jarFile.entries();
        while (e.hasMoreElements()) {
            String[] jeNameParts;
            JarEntry je = e.nextElement();
            String jeName = je.getName();
            if (!jeName.startsWith("META-INF/") || !jeName.endsWith(".SF") || (jeNameParts = jeName.split("/")).length != 2) continue;
            String sfName = jeNameParts[1];
            String sigFileName = sfName.substring(0, sfName.length() - 3);
            sfFiles.add(sigFileName);
        }
        if (sfFiles.isEmpty()) {
            System.out.println(Messages.getString("JarVerifier.2"));
        } else {
            int limit = sfFiles.size();
            int count = 0;
            for (String alias : sfFiles) {
                if (!this.verifySF(alias) || !this.verifySFEntries(alias)) continue;
                ++count;
            }
            if (count == 0) {
                System.out.println(Messages.getString("JarVerifier.3"));
            } else if (count != limit) {
                System.out.println(Messages.getFormattedString("JarVerifier.4", new Integer[]{count, limit}));
            } else {
                System.out.println(Messages.getFormattedString("JarVerifier.7", limit));
            }
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    private boolean verifySF(String sigFileName) throws CRLException, CertificateException, ZipException, IOException {
        int n;
        DSSSignatureX509Codec signatureCodec;
        DSSSignature signatureAlgorithm;
        OID digestEncryptionAlgorithmOID;
        JarEntry dsaEntry;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "verifySF");
            log.fine("About to verify signature of " + sigFileName + "...");
        }
        if ((dsaEntry = this.jarFile.getJarEntry("META-INF/" + sigFileName + ".DSA")) == null) {
            throw new SecurityException(Messages.getFormattedString("JarVerifier.13", sigFileName));
        }
        InputStream in = this.jarFile.getInputStream(dsaEntry);
        PKCS7SignedData pkcs7SignedData = new PKCS7SignedData(in);
        Set signerInfos = pkcs7SignedData.getSignerInfos();
        if (signerInfos == null || signerInfos.isEmpty()) {
            throw new SecurityException(Messages.getString("JarVerifier.14"));
        }
        SignerInfo signerInfo = (SignerInfo)signerInfos.iterator().next();
        byte[] encryptedDigest = signerInfo.getEncryptedDigest();
        if (encryptedDigest == null) {
            throw new SecurityException(Messages.getString("JarVerifier.16"));
        }
        if (Configuration.DEBUG) {
            log.fine("\n" + Util.dumpString((byte[])encryptedDigest, (String)"--- signedSFBytes "));
        }
        Certificate cert = pkcs7SignedData.getCertificates()[0];
        PublicKey verifierKey = cert.getPublicKey();
        if (Configuration.DEBUG) {
            log.fine("--- verifier public key = " + verifierKey);
        }
        if ((digestEncryptionAlgorithmOID = signerInfo.getDigestEncryptionAlgorithmId()).equals((Object)Main.DSA_SIGNATURE_OID)) {
            signatureAlgorithm = new DSSSignature();
            signatureCodec = new DSSSignatureX509Codec();
        } else {
            signatureAlgorithm = new RSAPKCS1V1_5Signature("md5");
            signatureCodec = new RSAPKCS1V1_5SignatureX509Codec();
        }
        HashMap<String, PublicKey> signatureAttributes = new HashMap<String, PublicKey>();
        signatureAttributes.put("gnu.crypto.sig.public.key", verifierKey);
        signatureAlgorithm.setupVerify(signatureAttributes);
        Object herSignature = signatureCodec.decodeSignature(encryptedDigest);
        JarEntry sfEntry = this.jarFile.getJarEntry("META-INF/" + sigFileName + ".SF");
        in = this.jarFile.getInputStream(sfEntry);
        byte[] buffer = new byte[2048];
        while ((n = in.read(buffer)) != -1) {
            if (n <= 0) continue;
            signatureAlgorithm.update(buffer, 0, n);
        }
        boolean result = signatureAlgorithm.verify(herSignature);
        if (Configuration.DEBUG) {
            log.fine("Signature block [" + sigFileName + "] is " + (result ? "" : "NOT ") + "OK");
            log.exiting(this.getClass().getName(), "verifySF", result);
        }
        return result;
    }

    private boolean verifySFEntries(String alias) throws IOException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "verifySFEntries");
        }
        JarEntry jarEntry = this.jarFile.getJarEntry("META-INF/" + alias + ".SF");
        InputStream in = this.jarFile.getInputStream(jarEntry);
        Attributes attr = new Attributes();
        HashMap entries = new HashMap();
        JarUtils.readSFManifest((Attributes)attr, entries, (InputStream)in);
        boolean result = false;
        String hash = attr.getValue(Main.DIGEST_MANIFEST_ATTR);
        if (hash != null) {
            result = this.verifyManifest(hash);
        }
        if (!result) {
            for (Map.Entry me : entries.entrySet()) {
                String name = (String)me.getKey();
                result = this.verifySFEntry(name, hash = (attr = (Attributes)me.getValue()).getValue(Main.DIGEST_ATTR));
                if (!result) break;
            }
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "verifySFEntries", result);
        }
        return result;
    }

    private boolean verifyManifest(String hash) throws IOException {
        return this.verifySFEntry("META-INF/MANIFEST.MF", hash);
    }

    private boolean verifySFEntry(String name, String hash) throws IOException {
        String expectedValue = this.getEntryHash("META-INF/MANIFEST.MF");
        boolean result = expectedValue.equalsIgnoreCase(hash);
        if (Configuration.DEBUG) {
            log.fine("Is " + name + " OK? " + result);
        }
        return result;
    }

    private String getEntryHash(String entryName) throws IOException {
        String result = this.entryHashes.get(entryName);
        if (result == null) {
            JarEntry manifest = this.jarFile.getJarEntry(entryName);
            InputStream in = this.jarFile.getInputStream(manifest);
            result = this.util.hashStream(in);
            this.entryHashes.put(entryName, result);
        }
        return result;
    }
}

