/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGAnimatedEnumeration.h"

#include <wtf/GetPtr.h>


#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGAnimatedEnumeration)

/* Hash table */

static const HashTableValue JSSVGAnimatedEnumerationTableValues[3] =
{
    { "baseVal", DontDelete, (intptr_t)jsSVGAnimatedEnumerationBaseVal, (intptr_t)setJSSVGAnimatedEnumerationBaseVal },
    { "animVal", DontDelete|ReadOnly, (intptr_t)jsSVGAnimatedEnumerationAnimVal, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGAnimatedEnumerationTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1, JSSVGAnimatedEnumerationTableValues, 0 };
#else
    { 4, 3, JSSVGAnimatedEnumerationTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedEnumerationPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGAnimatedEnumerationPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGAnimatedEnumerationPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGAnimatedEnumerationPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGAnimatedEnumerationPrototype::s_info = { "SVGAnimatedEnumerationPrototype", 0, &JSSVGAnimatedEnumerationPrototypeTable, 0 };

JSObject* JSSVGAnimatedEnumerationPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGAnimatedEnumeration>(exec);
}

const ClassInfo JSSVGAnimatedEnumeration::s_info = { "SVGAnimatedEnumeration", 0, &JSSVGAnimatedEnumerationTable, 0 };

JSSVGAnimatedEnumeration::JSSVGAnimatedEnumeration(PassRefPtr<Structure> structure, PassRefPtr<SVGAnimatedEnumeration> impl, SVGElement* context)
    : DOMObject(structure)
    , m_context(context)
    , m_impl(impl)
{
}

JSSVGAnimatedEnumeration::~JSSVGAnimatedEnumeration()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSSVGAnimatedEnumeration::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGAnimatedEnumerationPrototype(JSSVGAnimatedEnumerationPrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSSVGAnimatedEnumeration::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedEnumeration, Base>(exec, &JSSVGAnimatedEnumerationTable, this, propertyName, slot);
}

JSValuePtr jsSVGAnimatedEnumerationBaseVal(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGAnimatedEnumeration* imp = static_cast<SVGAnimatedEnumeration*>(static_cast<JSSVGAnimatedEnumeration*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->baseVal());
}

JSValuePtr jsSVGAnimatedEnumerationAnimVal(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGAnimatedEnumeration* imp = static_cast<SVGAnimatedEnumeration*>(static_cast<JSSVGAnimatedEnumeration*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->animVal());
}

void JSSVGAnimatedEnumeration::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSSVGAnimatedEnumeration, Base>(exec, propertyName, value, &JSSVGAnimatedEnumerationTable, this, slot);
}

void setJSSVGAnimatedEnumerationBaseVal(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    SVGAnimatedEnumeration* imp = static_cast<SVGAnimatedEnumeration*>(static_cast<JSSVGAnimatedEnumeration*>(thisObject)->impl());
    imp->setBaseVal(value->toInt32(exec));
    if (static_cast<JSSVGAnimatedEnumeration*>(thisObject)->context())
        static_cast<JSSVGAnimatedEnumeration*>(thisObject)->context()->svgAttributeChanged(static_cast<JSSVGAnimatedEnumeration*>(thisObject)->impl()->associatedAttributeName());
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, SVGAnimatedEnumeration* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGAnimatedEnumeration>(exec, object, context);
}
SVGAnimatedEnumeration* toSVGAnimatedEnumeration(JSC::JSValuePtr value)
{
    return value->isObject(&JSSVGAnimatedEnumeration::s_info) ? static_cast<JSSVGAnimatedEnumeration*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
