#!/bin/bash
# v 0.1 
# set -x
#
/bin/grep "/opt/kde/lib" /etc/ld.so.conf > /dev/null
if [ $? -ne 0 ]; then
	echo "/opt/kde/lib" >> /etc/ld.so.conf
fi

for target_dir in "etc/dbus-1/system.d" "share/PolicyKit/policy" "share/dbus-1/interfaces" "share/dbus-1/services" "share/dbus-1/system-services"
do
	if [ -d /opt/kde/$target_dir ]; then
		cd /opt/kde/$target_dir
		target_files=`echo *`

		if [ X"$target_files" = X ]; then
			continue
		fi

		if [ X"${target_dir#etc}" = X"$target_dir" ]; then
			cd /usr/$target_dir
			relative_path="../../../.."
		else
			cd /$target_dir
			relative_path="../../.."
		fi

		for i in $target_files
		do
			if [ -f $relative_path/opt/kde/$target_dir/$i ]; then
				/bin/ln -sf $relative_path/opt/kde/$target_dir/$i $i
#				echo "$relative_path/opt/kde/$target_dir/$i => $i"
			fi 
		done
	fi
done

export XDG_DATA_DIRS=/opt/kde/share:/usr/share:/usr/local/share
for target_dir in "/opt/kde/share" "/usr/share" "/usr/local/share"
do
	if [ ! -d $target_dir/mime ]; then
		continue
	fi
	cd $target_dir
	/usr/bin/update-mime-database ./mime > /dev/null 2>&1
done

if [ -f /opt/kde/bin/startkde ]; then
	/bin/grep "# PLAMO UPDATE BEGIN:" /opt/kde/bin/startkde > /dev/null
	if [ $? -ne 0 ]; then
	    strigi_plugin_path='$STRIGI_PLUGIN_PATH'
	    rm -f /tmp/plamo_startkde
	    /bin/cat << EOF >> /tmp/plamo_startkde
#!/bin/sh
# PLAMO UPDATE BEGIN: Automatically added by plamo_update_kde.sh
export QT_NO_GLIB=1
export LIBXCB_ALLOW_SLOPPY_LOCK=1
export STRIGI_PLUGIN_PATH="/usr/lib/strigi:/opt/kde/lib/strigi:$strigi_plugin_path"
# PLAMO UPDATE END:
EOF
	    /bin/cat /opt/kde/bin/startkde >> /tmp/plamo_startkde
	    /bin/cp /tmp/plamo_startkde /opt/kde/bin/startkde
	fi
fi
