#%% begin initialize drupal-6.13-noname-P1
###################################################################
export LANG=C
export PATH=/bin:/usr/bin:/sbin:/usr/sbin

if [ -r /tmp/SeTT_PX ]; then
    ROOT="`cat /tmp/SeTT_PX`"
fi

APACI_DIR=$ROOT/opt/httpd
PG_DIR=$ROOT/opt/pgsql
WWW=$ROOT/home/www
export PGLIB=$PG_DIR/lib
export PGDATA=$PG_DIR/data

if [ -f $ROOT/opt/htdocs/drupal6 ]; then
    /bin/mv  $ROOT/opt/htdocs/drupal6  $ROOT/opt/htdocs/drupal6.bak
fi

if [ -f $ROOT/opt/htdocs/drupal6.bak/sites/default/settings.php ]; then
    # update for minor release(security fix and so on)
    /bin/cp $ROOT/opt/htdocs/drupal6.bak/sites/default/settings.php \
	    $ROOT/opt/htdocs/drupal-6.13/sites/default/settings.php
    (cd $ROOT/opt/htdocs/drupal6.bak/;
	for i in `find sites/all/themes/ -mindepth 1 -maxdepth 1 -type d`; do \
	    if [ ! -d $ROOT/opt/htdocs/drupal-6.13/$i ]; then
		echo "copying $i ..."
		/bin/cp -a $i $ROOT/opt/htdocs/drupal-6.13/$i
	    fi
	done
	for i in `find sites/all/modules/ -mindepth 1 -maxdepth 1 -type d`; do \
	    if [ ! -d $ROOT/opt/htdocs/drupal-6.13/$i ]; then
		echo "copying $i ..."
		/bin/cp -a $i $ROOT/opt/htdocs/drupal-6.13/$i
	    fi
	done
	)
    /usr/bin/tar cf - -C $ROOT/opt/htdocs/drupal6.bak/ files | /usr/bin/tar xf - -C $ROOT/opt/htdocs/drupal-6.13/
    /bin/rm -f $ROOT/opt/htdocs/drupal-6.13/install.php
    /bin/chmod go-w  /opt/htdocs/drupal-6.13/sites/default/
else
    # newly install
    FQDN=`hostname -f`
    if [ ".$FQDN" = "." ]; then
	FQDN=localhost
    fi
    
    if [ -f $ROOT/opt/htdocs/drupal-6.13/sites/default/settings.php ]; then
	/bin/mv $ROOT/opt/htdocs/drupal-6.13/sites/default/settings.php \
	        $ROOT/opt/htdocs/drupal-6.13/sites/default/settings.php.bak
    fi
    /usr/bin/sed -e "s%^\$db_url = 'mysql://username:password@localhost/databasename';%\$db_url = 'pgsql://www:pass@localhost/drupal6';%" \
	-e "s%^\$base_url = 'http://localhost';%\$base_url = 'http://$FQDN/drupal6';%" \
	$ROOT/opt/htdocs/drupal-6.13/sites/default/default.settings.php \
	> $ROOT/opt/htdocs/drupal-6.13/sites/default/settings.php
    
    /bin/mkdir -p $ROOT/opt/htdocs/drupal-6.13/files
fi
/bin/chown www.apache $ROOT/opt/htdocs/drupal-6.13/files
(cd $ROOT/opt/htdocs; /bin/rm -f drupal6; /bin/ln -sf drupal-6.13 drupal6 )

# this script check db existance itself.
/bin/su - postgres -c "sh $ROOT/opt/htdocs/drupal6/custom/create_drupal6_db84"

if [ -f $PG_DIR/data/postgresql.conf ]; then
  if ! egrep "^default_text_search_config = 'pg_catalog.japanese'" $PG_DIR/data/postgresql.conf 1>/dev/null 2>&1; then
    /bin/mv $PG_DIR/data/postgresql.conf $PG_DIR/data/postgresql.conf.bak
    /usr/bin/sed -e "/^default_text_search_config/a default_text_search_config = \'pg_catalog.japanese\'" \
              -e 's/^\(default_text_search_config.*\)/;\1/' \
    $PG_DIR/data/postgresql.conf.bak >  $PG_DIR/data/postgresql.conf
    /bin/chown -R www.apache  $PG_DIR/data/postgresql.conf
  fi
fi

if [ ! -f $WWW/.postgresql/postgresql.crt ]; then
    /bin/mkdir -p $WWW/.postgresql
    /bin/cp $PG_DIR/data/server.crt $WWW/.postgresql/postgresql.crt
    /bin/cp $PG_DIR/data/server.key $WWW/.postgresql/postgresql.key
    /bin/chown -R www.apache  $WWW/.postgresql
fi

/bin/mkdir -p            $ROOT/opt/htdocs/drupal6/files
/bin/chown -R www.apache $ROOT/opt/htdocs/drupal6/files \
	                 $ROOT/opt/htdocs/drupal6/themes
/bin/chgrp -R apache     $ROOT/opt/htdocs/drupal6

if ! fgrep "drupal6/cron.php" $ROOT/var/spool/cron/crontabs/www 1>/dev/null 2>&1; then
    echo "0  *  *  *  *	/usr/bin/wget -O - -q http://$FQDN/drupal6/cron.php" >> $ROOT/var/spool/cron/crontabs/www
fi

#echo "To install japanese package drupal see:"      
#echo "        http://drupal.jp/drupal6/guide/install-step1" 

#%% end
