<?php
// $Id: tb.inc.php,v 1.21 2005/06/15 15:57:11 henoheno Exp $
/*
 * PukiWiki/TrackBack: TrackBack Ping receiver and viewer
 * (C) 2003-2005 PukiWiki Developers Team
 * (C) 2003 Katsumi Saito <katsumi@jo1upk.ymt.prug.or.jp>
 * License: GPL
 *
 * plugin_tb_action()    action
 * plugin_tb_save($url, $tb_id)          Save or update TrackBack Ping data
 * plugin_tb_output_response($rc, $msg)  Show a response code of the ping via HTTP/XML (then exit)
 * plugin_tb_output_rsslist($tb_id)      Show pings for the page via RSS
 * plugin_tb_output_htmllist($tb_id)     Show pings for the page via XHTML
 */

switch(LANG){
case 'ja': define('PLUGIN_TB_LANGUAGE', 'ja-jp'); break;
default  : define('PLUGIN_TB_LANGUAGE', 'en-us'); break;
}

// ----

define('PLUGIN_TB_ERROR',   1);
define('PLUGIN_TB_NOERROR', 0);


/*
	TrackBackプラグインのスパム対策
	originaly was "スパム対策済コメントプラグイン Ver1.20 by sue445"
*/
// 設定
// スパムリストを定義したページ(InterWikiNameみたいなもの)
// これをコメントアウトすると後述のNG_WORDが有効になります
//define('SPAMLIST_PAGE', 'SpamList');

// NGワード(コンマで区切る)
define('NG_WORD', '[url],adult,casino,pharmacy,republika,sex,siski.net,insurance,cloud.prohosting.com,white.prohosting.com,pluto.no,narod.ru,loan,viagra,2www.org,cialis,gatech.edu,digmun.info,homepage,hamburg.de,mortgage,bitdom.com,ac.be,onenight-in-paris,diet,poker,naked,nude,ripway.com,planetsti.info,porn,ewqe-r.info,diazepam,buddyprofile.com,href,xyevdrom.org,nrg-search.net,blogspot.com,forumforfree.com,adsenseru.info');

// 投稿されたメッセージに対してNGチェックを行うかどうか(0:無効 1:有効)
define('NOSPAM_MSG', 1);

// 投稿された名前に対してNGチェックを行うかどうか(0:無効 1:有効)
define('NOSPAM_NAME', 1);

// URLを許容する個数(1〜。0で無効)
// コメント中のURLがこの数値を超えるとエラーになります
define('NOSPAM_URL', 50);

// NGワードが含まれていた場合のエラー表示
define('NG_WARNING', 'NGワードが含まれています');

// URLが規定個数以上含まれていた時のエラー表示
define('URL_WARNING', 'URLは' . NOSPAM_URL . '個以内にしてください');

// ブラウザの言語設定がおかしかったらエラー
define('LNG_WARNING', 'ブラウザの言語設定がおかしいです');

function plugin_tb_spamcheck()
{
  global $vars, $trackback;
  static $spamlist;
  static $filetime1, $filetime2;
  static $fields = array( /* UTIME, */ 'url', 'title', 'excerpt', 'blog_name');
syslog(LOG_DEBUG,"pukiwiki: tb_spamcheck");
	
  // スパムリスト(SPAMLIST_PAGE or 自分自身)のタイムスタンプを取得
  if(SPAMLIST_PAGE && is_page(SPAMLIST_PAGE)){
    // SPAMLIST_PAGEに記述されているNGリストを使用
    $filetime1 = get_filetime(SPAMLIST_PAGE);
  }else{
    // このプラグイン内で定義されているNGリストを使用
    $filetime1 = filemtime(PLUGIN_DIR . 'tb_nospam.inc.php') - LOCALZONE;
  }

  // スパムリストが初期化されてないか、ファイルが更新されていれば初期化
  // ※タイムスタンプを調べても挙動が怪しいので毎回リストを初期化します(汗
  if(!isset($spamlist) || $filetime1 != $filetime2){
    $filetime2 = $filetime1;	// タイムスタンプを保存
    $spamlist = $matches = array();
    if(SPAMLIST_PAGE!='' && is_page(SPAMLIST_PAGE)){
      // SPAMLIST_PAGEに記述されているNGリストを使用
      foreach(get_source(SPAMLIST_PAGE) as $line){
	if(preg_match('/^-{1,3}(.+)$/', $line, $matches)){
	  array_push($spamlist, $matches[1]);
	}
      }
    }else{
      // このプラグイン内で定義されているNGリストを使用
      foreach(split(',', NG_WORD) as $word){
	array_push($spamlist, $word);
      }
    }
  }
  
  foreach ($fields as $key) {
    $value = isset($vars[$key]) ? $vars[$key] : '';
    
    // URLが規定個数以上含まれていればエラー
    if(NOSPAM_URL > 0 && preg_match_all("/http/", $value, $matches) && count($matches[0])>=NOSPAM_URL){
      return array('msg'=>URL_WARNING);
    }

    // スパムチェック
    foreach($spamlist as $word){
      if(NOSPAM_MSG && isset($value) && strpos($value,$word)!==false){
	return array('msg'=>NG_WARNING.": $word");
      }
    }
  }
}

function plugin_tb_action()
{
	global $trackback, $vars;
syslog(LOG_DEBUG,"pukiwiki: tb_action");

	// SPAM Check
	$ret = plugin_tb_spamcheck();
	if (isset($ret['msg']) ) {
	  syslog(LOG_DEBUG,"pukiwiki: trackback spam: {$ret['msg']}");
	  return $ret;
	}

	if ($trackback && isset($vars['url'])) {
		// Receive and save a TrackBack Ping (both GET and POST)
		$url   = $vars['url'];
		$tb_id = isset($vars['tb_id']) ? $vars['tb_id'] : '';
		list($error, $message) = plugin_tb_save($url, $tb_id);

		// Output the response
		plugin_tb_output_response($error, $message);
		exit;

	} else {
		if ($trackback && isset($vars['__mode']) && isset($vars['tb_id'])) {
			// Show TrackBacks received (and exit)
			switch ($vars['__mode']) {
			case 'rss' : plugin_tb_output_rsslist($vars['tb_id']);  break;
			case 'view': plugin_tb_output_htmllist($vars['tb_id']); break;
			}
			exit;

		} else {
			// Show List of pages that TrackBacks reached
			$pages = get_existpages(TRACKBACK_DIR, '.txt');
			if (! empty($pages)) {
				return array('msg'=>'Trackback list',
					'body'=>page_list($pages, 'read', FALSE));
			} else {
				return array('msg'=>'', 'body'=>'');
			}
		}
	}
}

// Save or update TrackBack Ping data
function plugin_tb_save($url, $tb_id)
{
	global $vars, $trackback;
	static $fields = array( /* UTIME, */ 'url', 'title', 'excerpt', 'blog_name');
syslog(LOG_DEBUG,"pukiwiki: tb_save($url, $tb_id)");

	$die = '';
	if (! $trackback) $die .= 'TrackBack feature disabled. ';
	if ($url   == '') $die .= 'URL parameter is not set. ';
	if ($tb_id == '') $die .= 'TrackBack Ping ID is not set. ';
	if ($die != '') return array(PLUGIN_TB_ERROR, $die);

	if (! file_exists(TRACKBACK_DIR)) return array(PLUGIN_TB_ERROR, 'No such directory: TRACKBACK_DIR');
	if (! is_writable(TRACKBACK_DIR)) return array(PLUGIN_TB_ERROR, 'Permission denied: TRACKBACK_DIR');

	$page = tb_id2page($tb_id);
	if ($page === FALSE) return array(PLUGIN_TB_ERROR, 'TrackBack ID is invalid.');

	// URL validation (maybe worse of processing time limit)
	$result = http_request($url, 'HEAD');
	if ($result['rc'] !== 200) return array(PLUGIN_TB_ERROR, 'URL is fictitious.');

	// Update TrackBack Ping data
	$filename = tb_get_filename($page);
	$data     = tb_get($filename);

	$items = array(UTIME);
	foreach ($fields as $key) {
		$value = isset($vars[$key]) ? $vars[$key] : '';
		if ( $key== 'excerpt')
		  if (! empty($value))
		    $value = substr($value, 0, 25);
		if (preg_match('/[,"' . "\n\r" . ']/', $value))
			$value = '"' . str_replace('"', '""', $value) . '"';
		$items[$key] = $value;
	}
	$data[rawurldecode($items['url'])] = $items;

	$fp = fopen($filename, 'w');
	set_file_buffer($fp, 0);
	flock($fp, LOCK_EX);
	rewind($fp);
	foreach ($data as $line) {
		$line = preg_replace('/[\r\n]/s', '', $line); // One line, one ping
		foreach ($line as $k => $v) {
		  if (preg_match('/[,"' . "\n\r" . ']/', $v)) {
			$v = '"' . str_replace('"', '""', $v) . '"';
			$line[$k] = str_replace('"""', '"', $v);
		    }
syslog(LOG_DEBUG,"pukiwiki: tb_save($k => $v)");
		}
		fwrite($fp, join(',', $line) . "\n");
	}
	flock($fp, LOCK_UN);
	fclose($fp);

	return array(PLUGIN_TB_NOERROR, '');
}

// Show a response code of the ping via HTTP/XML (then exit)
function plugin_tb_output_response($rc, $msg = '')
{
syslog(LOG_DEBUG,"pukiwiki: tb_output_response");
	if ($rc == PLUGIN_TB_NOERROR) {
		$rc = 0; // for PLUGIN_TB_NOERROR
	} else {
		$rc = 1; // for PLUGIN_TB_ERROR
	}

	pkwk_common_headers();
	header('Content-Type: text/xml');
	echo '<?xml version="1.0" encoding="iso-8859-1"?>';
	echo '<response>';
	echo ' <error>' . $rc . '</error>';
	if ($rc) echo '<message>' . $msg . '</message>';
	echo '</response>';
	exit;
}

// Show pings for the page via RSS
function plugin_tb_output_rsslist($tb_id)
{
	global $script, $vars, $entity_pattern;
syslog(LOG_DEBUG,"pukiwiki: tb_output_rsslist");

	$page = tb_id2page($tb_id);
	if ($page === FALSE) return FALSE;

	$items = '';
	foreach (tb_get(tb_get_filename($page)) as $arr) {
		// _utime_, title, excerpt, _blog_name_
		array_shift($arr); // Cut utime
		list ($url, $title, $excerpt) = array_map(
			create_function('$a', 'return htmlspecialchars($a);'), $arr);
		$items .= <<<EOD

   <item>
    <title>$title</title>
    <link>$url</link>
    <description>$excerpt</description>
   </item>
EOD;
	}

	$title = htmlspecialchars($page);
	$link  = $script . anchor_replace(rawurlencode($page)) . '/';
	$vars['page'] = $page;
	$excerpt = strip_htmltag(convert_html(get_source($page)));
	$excerpt = preg_replace("/&$entity_pattern;/", '', $excerpt);
	$excerpt = mb_strimwidth(preg_replace("/[\r\n]/", ' ', $excerpt), 0, 255, '...');
	$lang    = PLUGIN_TB_LANGUAGE;

	$rc = <<<EOD
<?xml version="1.0" encoding="utf-8" ?>
<response>
 <error>0</error>
 <rss version="0.91">
  <channel>
   <title>$title</title>
   <link>$link</link>
   <description>$excerpt</description>
   <language>$lang</language>$items
  </channel>
 </rss>
</response>
EOD;

	pkwk_common_headers();
	header('Content-Type: text/xml');
	echo mb_convert_encoding($rc, 'UTF-8', SOURCE_ENCODING);
	exit;
}

// Show pings for the page via XHTML
function plugin_tb_output_htmllist($tb_id)
{
syslog(LOG_DEBUG,"pukiwiki: tb_output_htmllist");
	pkwk_common_headers();
	echo 'This function had been removed now. It will be created soon.<br />' . "\n";
	echo 'Sorry for your inconvenience.';
	exit;

	// ----
	// Skeleton Logic

	global $script;
	global $_tb_date;

	$page = tb_id2page($tb_id);
	if ($page === FALSE) return FALSE;

	$data = tb_get(tb_get_filename($page));

	// Sort: The first is the latest
	usort($data, create_function('$a,$b', 'return $b[0] - $a[0];'));

	$tb_body = '';
	foreach ($data as $x) {
		if (count($x) != 5) continue; // Ignore incorrect record

		list ($time, $url, $title, $excerpt, $blog_name) = $x;
		if ($title == '') $title = 'no title';

		$time = date($_tb_date, $time + LOCALZONE); // May 2, 2003 11:25 AM
		$tb_body .= <<<EOD
EOD;
	}

	// Output start
	pkwk_common_headers();

	// BugTrack/466 Care for MSIE trouble
	// Logically correct, but MSIE will treat the data like 'file downloading'
	//header('Content-type: application/xhtml+xml; charset=UTF-8');
	header('Content-type: text/html; charset=UTF-8'); // Works well

	$meta_content_type = pkwk_output_dtd(PKWK_DTD_XHTML_1_0_TRANSITIONAL, 'UTF-8');
	$msg = <<<EOD
<head>
 $meta_content_type
</head>
<body>
 $script?tb_id=$tb_id<br /><br />
 $tb_body
</body>
</html>
EOD;
	echo mb_convert_encoding($msg, 'UTF-8', SOURCE_ENCODING);
	exit;
}

function plugin_tb_convert()
{
	global $script, $page_title;
	global $_tb_title, $_tb_header, $_tb_entry, $_tb_refer, $_tb_date;
	global $_tb_header_Excerpt, $_tb_header_Weblog, $_tb_header_Tracked;
	global $vars;
syslog(LOG_DEBUG,"pukiwiki: tb_convert");
	
	$page=$vars['page'];
	$tb_id=tb_get_id($page);
	
	$r_page = rawurlencode($page);

	$tb_title = sprintf($_tb_title, $page);
	$tb_refer = sprintf($_tb_refer, '<a href="' . $script . '?' . $r_page .
		'">\'' . $page . '\'</a>', '<a href="' . $script . '">' . $page_title . '</a>');

	$data = tb_get(tb_get_filename(tb_id2page($tb_id)));

	// Sort: The first is the latest
	usort($data, create_function('$a,$b', 'return $b[0] - $a[0];'));
	
	$tb_body ="<tr><th><div class=\"trackback-url\">$tb_refer</div></th></tr>";
	foreach ($data as $x) {
		if (count($x) != 5) continue; // Ignore incorrect record

		list ($time, $url, $title, $excerpt, $blog_name) = $x;
		if ($title == '') $title = 'no title';

		$time = date($_tb_date, $time + LOCALZONE); // May 2, 2003 11:25 AM
		$tb_body .= <<<EOD
	<tr><td>
	<div>
		<a href="$url" target="new" rel="nofollow">$title ($url) </a> <br />
		<span class="trackback-body">
		  <strong>$_tb_header_Excerpt</strong> $excerpt<br /></span>
		<span class="blog">  
		  <strong>$_tb_header_Weblog</strong> $blog_name<br /></span>
		<span class="trackback-post">
		  <strong>$_tb_header_Tracked</strong> $time</span>

	</div>
	</td></tr>
EOD;
	}
	return "<table class=\"style_table\">" . $tb_body . "</table>";
}
?>
