#!/bin/bash
# Slony1
VERSION=2.0.1
PAC_NAME=slony1-$VERSION
#
#	BuildScript for Plamo Linux 4.6
#			by Jun Kuwamura <juk@linet.gr.jp> on 2009-03-19
#
# require:
PGVERSION=8.3.7
POSTGRESQL=postgresql-$PGVERSION

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
BLD_DIR=$PLAMO/slony1
CUSTOM_DIR=$BLD_DIR/Custom
PAC_DIR=$PLAMO/Packages/4.5.1a/09_webdb/01_PostgreSQL.tgz
SRC_DIR=$PLAMO/Archive/Archive/dbms/pgsql/8.3/
mkdir -p $SRC_DIR/

if [ ! -f $SRC_DIR/slony1-${VERSION}.tar.bz2 ]; then
   (cd $SRC_DIR; wget -N http://main.slony.info/downloads/2.0/source/slony1-${VERSION}.tar.bz2 )
fi
if [ ! -f $SRC_DIR/slony1-${VERSION}-docs.tar.bz2 ]; then
   (cd $SRC_DIR; wget -N http://main.slony.info/downloads/2.0/source/slony1-${VERSION}-docs.tar.bz2 )
fi

umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin

tar xvfj $SRC_DIR/$PAC_NAME.tar.bz2
cd $PAC_NAME
JADE=jade NSGMLS=onsgmls SGMLSPL=sgmlspl \
PS2PDF=ps2pdf DJPEG=djpeg GROFF=groff PNMTOPS=pnmtops CONVERT=convert \
./configure --prefix=/opt/pgsql --with-pgconfigdir=/opt/pgsql/bin
make
make install DESTDIR=$WORK


# Make Documents
cat >>Makefile.global<<_EOF_
#JADE=                   jade
#NSGMLS=                 onsgmls
#SGMLSPL=                sgmlspl
#PS2PDF=                 ps2pdf
#DJPEG=                  djpeg
#GROFF=                  groff
#PNMTOPS=                pnmtops
#CONVERT=                convert
_EOF_
#vi Makefile.global

cd doc
for i in concept/ howto/ implementation/; do \
  cd $i
  make
  make install DESTDIR=$WORK
  cd ..
done


cd $WORK
mkdir -p ./usr/share/doc
tar xvfj $SRC_DIR/$PAC_NAME-docs.tar.bz2 -C ./usr/share/doc
tar cf - -C ./opt/pgsql . | tar xvf - -C ./opt/$POSTGRESQL
rm -rf ./opt/pgsql
mkdir ./opt/$POSTGRESQL/man/
mv ./usr/share/doc/$PAC_NAME/doc/adminguide/man* ./opt/$POSTGRESQL/man/
mv ./opt/$POSTGRESQL/share/doc ./opt/$POSTGRESQL/share/slony

DOC_DIR=usr/share/doc/$PAC_NAME/
mkdir -p  $DOC_DIR
cp -p $BLD_DIR/`basename $0`  $DOC_DIR/

 mkdir -p install
 cat >> install/doinst.sh<<_EOF_
#%% begin initialize ${PAC_NAME}-${VERSION}-${SYS_NAME}
/bin/chown -R postgres:pgsql $ROOT/opt/$POSTGRESQL/share/slony/
( cd  /$DOC_DIR; \
  for i in concept/ howto/ implementation/; do \
    /bin/ln -sf /opt/$POSTGRESQL/share/slony/\$i
  done
)
#%% end
_EOF_

chown -R root:root $DOC_DIR
chown -R postgres:pgsql ./opt/$POSTGRESQL

tar cvfz ../$PAC_NAME-$SYS_NAME.tgz ./opt/$POSTGRESQL/bin/slon* ./opt/$POSTGRESQL/lib/* ./opt/$POSTGRESQL/share/* ./usr/share/doc/$PAC_NAME/ ./install/doinst.sh

cd $CWD
mv -v ${PAC_NAME}-${SYS_NAME}.tgz $PAC_DIR/${PAC_NAME}_${PGVERSION}-${SYS_NAME}.tgz 
