#!/bin/bash
# QuantumGIS	(http://qgis.org/)
#	BuildScript for Plamo Linux 4.6
#			by Jun Kuwamura <juk@linet.gr.jp> on 2008-11-08
# require:
#	qt4
#	proj
#	geos
#	gdal
#	grass
#	postgis
#	sqlite3
#
SRC_URI=http://download.osgeo.org/qgis/src/qgis_1.1.0.tar.gz
SRC_FILE=${SRC_URI##*/}
SRC_NAME=${SRC_FILE%%.tar.gz}
VERSION=${SRC_NAME##*_}
PAC_NAME=${SRC_NAME%%_$VERSION}-$VERSION

REL=P2
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/gis
PAC_DIR=$PLAMO/Packages/4.6/10_gis
BUILD_DIR=$PLAMO/qgis
CUSTOM_DIR=$BUILD_DIR/Custom
PAT_FILE=


echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


tar xvfz $SRC_DIR/$SRC_FILE
#mv qgis_${VERSION} ${PAC_NAME}
cd $PAC_NAME

#if [ ! -f configure ]; then
# ./autogen.sh --prefix=/usr \
#	--with-sqlite3dir=/usr \
#	--with-postgresql=/opt/pgsql/bin \
#	--with-qtdir=/opt/Trolltech/Qt-4.3.4 \
#	--with-grass=/usr/grass-6.2.1 \
#	--with-python
#else
# ./configure --prefix=/usr \
#	--with-sqlite3dir=/usr --with-postgresql=/opt/pgsql/bin \
#	--with-qtdir=/opt/Trolltech/Qt-4.3.4 --with-grass=/usr/grass-6.2.1 \
#	--with-python
#fi

cmake -D CMAKE_INSTALL_PREFIX=/usr/ \
      -D GRASS_INCLUDE_DIR=/usr/grass/include \
      -D GRASS_PREFIX=/usr/grass \
      -D POSTGRESQL_PREFIX=/opt/pgsql \
      -D POSTGRES_CONFIG=/opt/pgsql/bin/pg_config \
      -D CMAKE_BUILD_TYPE=Release \
      .

make
make install DESTDIR=$WORK

cd $WORK
cp -p $BUILD_DIR/`basename $0` usr/share/qgis/doc/ 
mkdir -p usr/share/doc || exit
(cd usr/share/doc/; ln -sf ../qgis/doc qgis-$VERSION)

mkdir -p install || exit
cat >install/doinst.sh<<EOF
#%% begin ${PAC_NAME}-${SYS_NAME}
(rm -f usr/share/doc/qgis-$VERSION; cd usr/share/doc/; ln -sf ../qgis/doc qgis-$VERSION)
(cd usr/lib; ln -sf libqgis_core.so.0.11 libqgis_core.so)
(cd usr/lib; ln -sf libqgis_gui.so.0.11 libqgis_gui.so)
(cd usr/lib; ln -sf libqgisgrass.so.0.11 libqgisgrass.so)
#%% end
EOF

tar cvfz ../${PAC_NAME}-${SYS_NAME}.tgz  usr/bin/qgis* usr/bin/msexport usr/include/qgis usr/lib/lib* usr/lib/qgis/ usr/share/aclocal/qgis.m4 usr/share/man/man1/qgis.1.gz usr/share/qgis/ usr/share/doc/$PAC_NAME/ install/doinst.sh 

mv -v  ../${PAC_NAME}-${SYS_NAME}.tgz  $PAC_DIR
