# -*- coding: EUC-JP -*-
# Tamito KAJIYAMA <17 June 2001>
# $Id: sakura.py,v 1.97.2.3 2004/03/15 04:37:41 shy Exp $

import os
import re
import socket
import select
import string
import sys
import time
import urlparse
import whrandom
import StringIO
import codecs
import gc

if os.environ.has_key("DISPLAY"):
    import gtk
    import pango

import ninix.main
import ninix.makoto
import ninix.script
import ninix.update
import ninix.seriko
import ninix.mayuna
import ninix.communicate

import pix

import locale

locale_charset = locale.nl_langinfo(locale.CODESET)

def layout_set_text(layout, text):
    try:
        layout.set_text(text)
    except:
        layout.set_text(text, -1) # pygtk <= 1.99.14

# left mouse button
BUTTON1_CLOSE = "close"
BUTTON1_RAISE = "raise"
BUTTON1_LOWER = "lower"

# right mouse button
BUTTON3_CLOSE = "close"
BUTTON3_RAISE = "raise"
BUTTON3_LOWER = "lower"

# default browser
DEFAULT_BROWSER = "netscape -remote 'openURL(%s,new-window)'"

class Sakura:
    BALLOON_LIFE   = 10  # sec (0: never closed automatically)
    SELECT_TIMEOUT = 15  # sec
    PAUSE_TIMEOUT  = 30  # sec
    SILENT_TIME    = 15  # sec
    # script modes
    BROWSE_MODE = 1
    SELECT_MODE = 2
    PAUSE_MODE  = 3
    # script origins
    FROM_SSTP_CLIENT = 1
    FROM_GHOST       = 2
    # HTML entity definitions
    from ninix.htmllib import entitydefs
    # keyval/name mapping
    if os.environ.has_key("DISPLAY"):
        from ninix.keymap import keymap_old, keymap_new
    else:
        keymap_old = {}
        keymap_new = {}
    def __init__(self, debug):
        self.debug = debug
        self.sstp_servers = []
        self.sstp_handle = None
        self.sstp_entry_db = None
        self.sstp_request_handler = None
        if self.debug & 16384:
            self.script_parser = ninix.script.Parser(error="strict")
        else:
            self.script_parser = ninix.script.Parser(error="loose")
        self.directsstp_path = None
        self.script_queue = []
        self.script_mode = self.BROWSE_MODE
        self.script_post_proc = None
        self.balloon_life = 0
        self.surface_life = 0
        self.surface_mouse_motion = None
        self.time_critical_session = 0
        self.user_interaction = 0
        self.mikire = 0
        self.kasanari = 0
        self.lock_repaint = 0
        self.passivemode = 0
        self.running = 0
        self.event_queue = []
        self.anchor = None
        self.clock = (0, 0)
        self.surface_scale = 100 # %
        self.balloon_scale = 100 # %
        self.set_script_speed(3)
        self.set_event_kill_list([])
        self.set_mouse_button1(BUTTON1_RAISE)
        self.set_mouse_button3(BUTTON3_CLOSE)
        self.set_browser(DEFAULT_BROWSER)
        self.set_helpers([])
        self.set_ghost_time(0)
        self.set_ghost_vanished_count(0)
        self.keep_silence(0)
        self.communicate = ninix.communicate.Communicate()
        self.old_otherghostname = None
        self.cantalk = 1
        self.charset = 'Shift_JIS'
        self.top_margin = 0
        self.bottom_margin = 0
    def set_ghost(self, ghost):
        self.ghost = ghost
    def set_surface(self, surface):
        self.surface = surface
    def set_balloon(self, balloon):
        self.balloon = balloon
    def set_top_margin(self, value):
        self.top_margin = value
        self.align_current()
    def set_bottom_margin(self, value):
        self.bottom_margin = value
        self.align_current()
    def add_sstp_server(self, server):
        self.sstp_servers.append(server)
    def add_directsstp_server(self, server, path):
        self.sstp_servers.append(server)
        self.directsstp_path = path
    def get_directsstp_path(self):
        return self.directsstp_path
    def finalize(self):
        self.save_history()
        self.communicate.rebuild_ghostdb(None)
        self.ghost.finalize()
        for server in self.sstp_servers:
            server.close()
    def hide_all(self):
        self.surface.hide(0)
        self.surface.hide(1)
        self.balloon.hide(0)
        self.balloon.hide(1)
    def raise_all(self):
        self.surface.raise_(0)
        self.surface.raise_(1)
        self.balloon.raise_(0)
        self.balloon.raise_(1)
    def lower_all(self):
        self.surface.lower(0)
        self.surface.lower(1)
        self.balloon.lower(0)
        self.balloon.lower(1)
    def is_URL(self, s):
        return s[:7] == "http://" or s[:6] == "ftp://" or s[:6] == "file:/"
    def is_anchor(self, id):
        if len(id) == 2 and id[0] == 'anchor':
            return 1
        else:
            return 0
    def launch_browser(self, url):
        command = self.get_browser()
        self.execute_command(command, url)
    def execute_command(self, command, arg):
        pos = string.find(command, "%s")
        if pos < 0:
            sys.stderr.write("cannot execute command (%s missing)\n")
            return
        os.system(command[:pos] + arg + command[pos+2:] + " &")
    ###   CALLBACK   ###
    def reset_idle_time(self):
        self.idle_start = time.time()
    def notify_link_selection(self, id, text, number):
        if self.script_origin == self.FROM_SSTP_CLIENT and \
           self.sstp_request_handler is not None:
            self.sstp_request_handler.send_answer(text)
            self.sstp_request_handler = None
        if self.is_anchor(id):
            self.notify_event("OnAnchorSelect", id[1])
        elif self.is_URL(id):
            self.launch_browser(id)
            self.reset_script(1)
            self.stand_by(0)
        elif self.sstp_entry_db:
            # leave the previous sstp message as it is
            self.start_script(self.sstp_entry_db.get(id, r"\e"))
            self.sstp_entry_db = None
        elif not self.notify_event("OnChoiceSelect", id, text, number):
            self.reset_script(1)
            self.stand_by(0)
    def busy(self):
        return self.time_critical_session or \
               self.user_interaction or \
               self.ghost.updateman.is_active() or \
               self.event_queue or \
               self.passivemode
    def notify_surface_drag(self, side, x_delta, y_delta):
        if self.passivemode:
            return
        x, y = self.surface.get_position(side)
        x = x + x_delta
        if self.surface.get_alignment(side) == 2:
            y = y + y_delta
        self.surface.set_position(side, x, y)
        # reset balloon positions
        self.position_balloons()
    def check_mikire_kasanari(self):
        scrn_w = gtk.gdk.screen_width()
        scrn_h = gtk.gdk.screen_height()
        x0, y0 = self.surface.get_position(0)
        x1, y1 = self.surface.get_position(1)
        s0w, s0h = self.surface.get_surface_size(0)
        s1w, s1h = self.surface.get_surface_size(1)
        if x0 + s0w/4 < 0 or x0 + s0w*3/4 > scrn_w or \
           y0 + s0h/4 < 0 or y0 + s0h*3/4 > scrn_h:
            self.mikire = 1
        else:
            self.mikire = 0
        if (x1 + s1w/2 > x0 and x1 + s1w/2 < x0 + s0w and \
            y1 + s1h/2 > y0 and y1 + s1h/2 < y0 + s0h) or \
           (x0 + s0w/2 > x1 and x0 + s0w/2 < x1 + s1w and \
            y0 + s0h/2 > y1 and y0 + s0h/2 < y1 + s1h):
            self.kasanari = 1
        else:
            self.kasanari = 0
    def notify_surface_drop(self):
        # update mikire and kasanari flags
        self.check_mikire_kasanari()
    def notify_surface_click(self, button, click, side, x, y):
        if button == 1 and self.mouse_button1 == BUTTON1_RAISE or \
           button == 3 and self.mouse_button3 == BUTTON3_RAISE:
            self.raise_all()
        elif button == 1 and self.mouse_button1 == BUTTON1_LOWER or \
             button == 3 and self.mouse_button3 == BUTTON3_LOWER:
            self.lower_all()
        if self.vanished:
            if side == 0 and button == 1:
                if self.sstp_request_handler:
                    self.sstp_request_handler.send_sstp_break()
                    self.sstp_request_handler = None
                self.reset_script(1)
                self.notify_event("OnVanishButtonHold", default=r"\e")
                self.vanished = 0
            return
        if self.ghost.updateman.is_active():
            if button == 1 and click == 2:
                self.ghost.updateman.interrupt()
            return
        if self.time_critical_session:
            return
        elif button == 1 and click == 1:
            if self.passivemode and self.processed_script != None:
                return
            part = self.surface.get_touched_region(side, x, y)
            self.notify_event("OnMouseClick", x, y, "", side, part)
        elif self.passivemode:
            return
        elif button == 3:
            if self.sstp_request_handler:
                self.sstp_request_handler.send_sstp_break()
                self.sstp_request_handler = None
                self.reset_script(1)
                self.stand_by(0)
            self.ghost.open_popup_menu(button, side)
        elif button == 1 and click == 2:
            if self.sstp_request_handler:
                self.sstp_request_handler.send_sstp_break()
                self.sstp_request_handler = None
            part = self.surface.get_touched_region(side, x, y)
            self.notify_event("OnMouseDoubleClick", x, y, "", side, part)
    def notify_surface_mouse_motion(self, side, x, y):
        if self.surface_mouse_motion is not None:
            return
        part = self.surface.get_touched_region(side, x, y)
        if part:
            self.surface_mouse_motion = (side, x, y, part)
        else:
            self.surface_mouse_motion = None
    def notify_surface_mouse_scroll(self, side, x, y, direction):
        if direction == 'up':
            part = self.surface.get_touched_region(side, x, y)
            self.notify_event("OnMouseWheel", x, y, 1, side, part)
        elif direction == 'down':
            part = self.surface.get_touched_region(side, x, y)
            self.notify_event("OnMouseWheel", x, y, -1, side, part)
    def notify_key_press(self, keyval, string):
        name = self.keymap_old.get(keyval, string)
        keycode = self.keymap_new.get(keyval, string)
        if name or keycode:
            self.notify_event("OnKeyPress", name, keycode)
    def notify_balloon_click(self, button, click, side):
        if self.script_mode == self.PAUSE_MODE:
            self.script_mode = self.BROWSE_MODE
            self.balloon.window[self.script_side].redraw() # erase down arrow
        elif button == 1 and self.mouse_button1 == BUTTON1_RAISE or \
             button == 3 and self.mouse_button3 == BUTTON3_RAISE:
            self.raise_all()
        elif button == 1 and self.mouse_button1 == BUTTON1_LOWER or \
             button == 3 and self.mouse_button3 == BUTTON3_LOWER:
            self.lower_all()
        if self.vanished:
            return
        if self.ghost.updateman.is_active():
            if button == 1 and click == 2:
                self.ghost.updateman.interrupt()
            return
        if self.time_critical_session:
            self.time_critical_session = not self.time_critical_session
            return
        elif self.passivemode:
            return
        elif button == 1 and click == 2:
            if self.sstp_request_handler:
                self.sstp_request_handler.send_sstp_break()
                self.sstp_request_handler = None
            self.notify_event("OnMouseDoubleClick", "", "", "", side, "")
        elif button == 1 and self.mouse_button1 == BUTTON1_CLOSE or \
             button == 3 and self.mouse_button3 == BUTTON3_CLOSE:
            if self.sstp_request_handler:
                self.sstp_request_handler.send_sstp_break()
                self.sstp_request_handler = None
            self.reset_script(1)
            self.stand_by(0)
    def notify_file_drop(self, list, side):
        event = None
        for path in list:
            if os.path.isdir(path) and event is None:
                event = "OnDirectoryDrop"
            elif os.path.isfile(path):
                for regex, command in self.helpers:
                    if regex.search(path):
                        event = "OnFileDropping"
                        self.execute_command(command, path)
                        break
        if event is None:
            event = "OnFileDropped"
        self.enqueue_event(event, path, side)
    def notify_user_communicate(self, data):
        if data is not None:
            self.notify_event("OnCommunicate", "user", data)
    def notify_user_teach(self, data):
        if data is not None:
            script = self.ghost.teach(data)
            if script:
                self.start_script(script)
                self.balloon.hide_sstp_message()
        self.user_interaction = 0
    def notify_user_input(self, symbol, data):
        if data is None:
            data = ''
        ## CHECK: symbol
        if symbol == "OnUserInput" and self.notify_event("OnUserInput", data):
            pass
        elif self.notify_event("OnUserInput", symbol, data):
            pass
        elif self.notify_event(symbol, data):
            pass
        self.user_interaction = 0
    month_names = ["Jan", "Feb", "Mar", "Apr", "May", "Jun",
                   "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
    def notify_event(self, event,
                     ref0=None, ref1=None, ref2=None, ref3=None,
                     ref4=None, ref5=None, ref6=None, ref7=None,
                     ref_ext=[], type='GET',
                     default=None):
        #if self.time_critical_session:
        #    return 0
        if event in self.event_kill_list:
            return 0
        script = self.ghost.get_event_response(
            event, ref0, ref1, ref2, ref3, ref4, ref5, ref6, ref7, ref_ext, type) or default
        if self.debug & 1 and script or \
           self.debug & 2 and not script and event != "OnSecondChange":
            t = time.localtime(time.time())
            m = self.month_names[t[1]-1]
            print "\n[%02d/%s/%d:%02d:%02d:%02d %+05d]" % (
                t[2], m, t[0], t[3], t[4], t[5], -time.timezone/36)
            print "Event:", event
            n = 0
            for value in [ref0, ref1, ref2, ref3, ref4, ref5, ref6, ref7]:
                if value is not None:
                    print "Reference%d:" % n, '%s' % str(value).encode(locale_charset, 'ignore')
                n = n + 1
        if not script: # an empty script is ignored
            return 0
        if self.debug & 1:
            print '=> "%s"' % script.encode(locale_charset, 'ignore')
        if self.passivemode and \
           (event == "OnSecondChange" or event == "OnMinuteChange"):
            return 0
        self.start_script(script)
        self.balloon.hide_sstp_message()
        return 1
    def get_event_response(self, event,
                           ref0=None, ref1=None, ref2=None, ref3=None,
                           ref4=None, ref5=None, ref6=None, ref7=None,
                           type='GET'):
        return self.ghost.get_event_response(
            event, ref0, ref1, ref2, ref3, ref4, ref5, ref6, ref7, type)
    def enqueue_script(self, script, sender, handle,
                       host, show_sstp_marker, use_translator,
                       db=None, request_handler=None):
        if not self.script_queue and not self.time_critical_session and not self.passivemode:
            if self.sstp_request_handler:
                self.sstp_request_handler.send_sstp_break()
                self.sstp_request_handler = None
            self.reset_script(1)
        self.script_queue.append((script, sender, handle, host,
                                  show_sstp_marker, use_translator,
                                  db, request_handler))
    def enqueue_event(self, event,
                      ref0=None, ref1=None, ref2=None, ref3=None,
                      ref4=None, ref5=None, ref6=None, ref7=None,
                      proc=None):
        self.event_queue.append(
            (event, ref0, ref1, ref2, ref3, ref4, ref5, ref6, ref7, proc))
    EVENT_SCRIPTS = {
        "OnUpdateBegin":    r"\t\h\s[0]" + unicode(_("Network Update has begun."), 'utf-8') + r"\e",
        "OnUpdateComplete": r"\t\h\s[5]" + unicode(_("Network Update completed successfully."), 'utf-8') + r"\e",
        "OnUpdateFailure":  r"\t\h\s[4]" + unicode(_("Network Update failed."), 'utf-8') + r"\e",
        }
    def handle_event(self):
        while self.event_queue:
            event, ref0, ref1, ref2, ref3, ref4, ref5, ref6, ref7, proc = \
                self.event_queue.pop(0)
            if self.notify_event(event,
                                 ref0, ref1, ref2, ref3,
                                 ref4, ref5, ref6, ref7,
                                 default=self.EVENT_SCRIPTS.get(event)):
                self.script_post_proc = proc
                return 1
            elif proc is not None:
                proc()
                return 1
        return 0
    def set_surface_scale(self, scale, scale_balloon):
        self.surface_scale = scale # %
        if scale_balloon:
            self.balloon_scale = scale # %
        else:
            self.balloon_scale = 100 # %
        if self.running:
            self.surface.reset_surface(0)
            self.surface.reset_surface(1)
            self.position_all()
    def get_surface_scale(self):
        return self.surface_scale
    def set_script_speed(self, speed):
        self.script_speed = speed  # ordinal (-1: no wait)
    def get_script_speed(self):
        return self.script_speed
    def set_event_kill_list(self, list):
        ##print "Sakura.set_event_kill_list:", list
        self.event_kill_list = list
    def get_event_kill_list(self):
        return self.event_kill_list
    def set_mouse_button1(self, name):
        ##print "Sakura.set_mouse_button1:", name
        self.mouse_button1 = name
    def get_mouse_button1(self):
        return self.mouse_button1
    def set_mouse_button3(self, name):
        ##print "Sakura.set_mouse_button3:", name
        self.mouse_button3 = name
    def get_mouse_button3(self):
        return self.mouse_button3
    def set_browser(self, command):
        self.browser = command
    def get_browser(self):
        return self.browser
    def set_helpers(self, list):
        ##print "Sakura.set_helpers:", list
        self.helpers = []
        for pattern, command in list:
            try:
                regex = re.compile(pattern)
            except re.error:
                continue
            self.helpers.append((regex, command))
    def get_helpers(self):
        buffer = []
        for regex, command in self.helpers:
            buffer.append((regex.pattern, command))
        return buffer
    def get_ghost_time(self):
        return self.ghost_time
    def set_ghost_time(self, clock):
        self.ghost_time = clock
    def get_ghost_vanished_count(self):
        return self.ghost_vanished_count
    def set_ghost_vanished_count(self, count):
        self.ghost_vanished_count = count
    def get_username(self):
        return self.ghost.getstring("username") or self.surface.get_username() or self.ghost.get_username()
    def get_selfname(self):
        return self.surface.get_selfname() or self.ghost.get_selfname()
    def get_selfname2(self):
        return self.surface.get_selfname2() or self.ghost.get_selfname2()
    def get_keroname(self):
        return self.surface.get_keroname() or self.ghost.get_keroname()
    def get_friendname(self):
        return self.surface.get_friendname() or self.ghost.get_friendname()
    def get_sstp_port(self):
        if not self.sstp_servers:
            return None
        return self.sstp_servers[0].server_address[1]
    def keep_silence(self, quiet):
        if quiet:
            self.silent_time = time.time()
        else:
            self.silent_time = 0
            self.reset_idle_time()
    def reload(self):
        self.ghost.reload()
    def get_uptime(self):
        uptime = int(time.time() - self.start_time) / 3600
        if uptime < 0:
            self.start_time = time.time()
            return 0
        return uptime
    ###   STARTER   ###
    def stand_by(self, reset_surface):
        self.balloon.hide(0)
        self.balloon.hide(1)
        self.balloon.hide_sstp_message()
        if reset_surface:
            self.surface.set_surface(0, "0")
            self.surface.set_surface(1, "10")
            self.notify_event("OnSurfaceChange",
                              self.surface.get_surface(0),
                              self.surface.get_surface(1))
            self.balloon.set_balloon(0, 0)
            self.balloon.set_balloon(1, 0)
        elif self.surface.get_surface(0) != "0" or \
             self.surface.get_surface(1) != "10":
            self.surface_life = whrandom.randint(20, 30)
            ##print "surface_life =", self.surface_life
    def align_top(self, side):
        sx, sy = self.surface.get_position(side)
        sy = 0 + self.top_margin
        self.surface.set_position(side, sx, sy)
        self.surface.set_alignment(side, 1)
        self.position_balloons()
    def align_bottom(self, side):
        scrn_h = gtk.gdk.screen_height() - self.bottom_margin
        sw, sh = self.surface.get_surface_size(side)
        sx, sy = self.surface.get_position(side)
        sy = scrn_h - sh
        self.surface.set_position(side, sx, sy)
        self.surface.set_alignment(side, 0)
        self.position_balloons()
    def align_current(self):
        if len(self.surface.window) <= 0:
            return
        if self.surface.get_alignment(0) == 1: # top
            self.align_top(0)
        else:
            self.align_bottom(0)
        if self.surface.get_alignment(1) == 1: # top
            self.align_top(1)
        else:
            self.align_bottom(1)
    def position_all(self):
        scrn_w = gtk.gdk.screen_width()
        scrn_h = gtk.gdk.screen_height() - self.bottom_margin
        s0w, s0h = self.surface.get_surface_size(0)
        s1w, s1h = self.surface.get_surface_size(1)
        b0w, b0h = self.balloon.get_balloon_size(0)
        b1w, b1h = self.balloon.get_balloon_size(1)
        o0x, o0y = self.surface.get_balloon_offset(0)
        o1x, o1y = self.surface.get_balloon_offset(1)
        # sakura
        s0x = scrn_w - s0w
        if self.surface.get_alignment(0) == 1: # top
            s0y = 0 + self.top_margin
        else:
            s0y = scrn_h - s0h
        # unyuu
        offset = max(0, b1w - (b0w - o0x))
        if (s0x + o0x - b0w) - offset - s1w + o1x < 0:
            s1x = 0
        else:
            s1x = (s0x + o0x - b0w) - offset - s1w + o1x
        if self.surface.get_alignment(1) == 1: # top
            s1y = 0 + self.top_margin
        else:
            s1y = scrn_h - s1h
        # position all windows
        self.surface.set_position(0, s0x, s0y)
        self.surface.set_position(1, s1x, s1y)
        self.position_balloons()
        # reset position-related flags
        self.check_mikire_kasanari()
    def position_balloons(self):
        scrn_w = gtk.gdk.screen_width()
        scrn_h = gtk.gdk.screen_height() - self.bottom_margin
        s0x, s0y = self.surface.get_position(0)
        o0x, o0y = self.surface.get_surface_offset(0)
        s0x = s0x + o0x
        s0y = s0y + o0y
        s1x, s1y = self.surface.get_position(1)
        o1x, o1y = self.surface.get_surface_offset(1)
        s1x = s1x + o1x
        s1y = s1y + o1y
        s0w, s0h = self.surface.get_surface_size(0)
        s1w, s1h = self.surface.get_surface_size(1)
        b0w, b0h = self.balloon.get_balloon_size(0)
        b1w, b1h = self.balloon.get_balloon_size(1)
        o0x, o0y = self.surface.get_balloon_offset(0)
        o1x, o1y = self.surface.get_balloon_offset(1)
        # sakura's balloon
        if s0x + s0w / 2 > s1x + s1w / 2:
            l_space = s0x - (s1x + s1w)
            r_space = scrn_w - (s0x + s0w)
        else:
            l_space = s0x
            r_space = s1x - (s0x + s0w)
        if s0x + s0w / 2 < s1x + s1w / 2:
            b0side = 1
        else:
            b0side = 0
        if b0side == 1 and b0w - o0x > r_space and b0w + o0x <= l_space:
            b0side = 0
        elif b0side == 0 and b0w + o0x > l_space and b0w - o0x <= r_space:
            b0side = 1
        if b0side == 0: # left
            b0x = max(s0x - b0w + o0x, 0)
        else:
            b0x = min(s0x + s0w - o0x, scrn_w - b0w)
        align = self.surface.get_alignment(0)
        if align == 0:
            b0y = min(s0y + o0y, scrn_h - b0h)
        elif align == 1:
            b0y = max(s0y + o0y, 0 + self.top_margin)
        else:
            if s0y < scrn_h/2:
                b0y = max(s0y + o0y, 0 + self.top_margin)
            else:
                b0y = min(s0y + o0y, scrn_h - b0h)
        # unyuu's balloon
        if s0x + s0w / 2 > s1x + s1w / 2:
            l_space = s1x
            r_space = s0x - (s1x + s1w)
        else:
            l_space = s1x - (s0x + s0w)
            r_space = scrn_w - (s1x + s1w)
        if s0x + s0w / 2 > s1x + s1w / 2:
            b1side = 1
        else:
            b1side = 0
        if b1side == 1 and b1w - o1x > r_space and b1w + o1x <= l_space:
            b1side = 0
        elif b1side == 0 and b1w + o1x > l_space and b1w - o1x <= r_space:
            b1side = 1
        if b1side == 0: # left
            b1x = max(s1x - b1w + o1x, 0)
        else:
            b1x = min(s1x + s1w - o1x, scrn_w - b1w)
        align = self.surface.get_alignment(1)
        if align == 0:
            b1y = min(s1y + o1y, scrn_h - b0h)
        elif align == 1:
            b1y = max(s1y + o1y, 0 + self.top_margin)
        else:
            if s0y < scrn_h/2:
                b1y = max(s1y + o1y, 0 + self.top_margin)
            else:
                b1y = min(s1y + o1y, scrn_h - b0h)
        # move balloons if overlapped
        if b0x <= b1x and b0x + b0w >= b1x or \
            b1x <= b0x and b1x + b1w >= b0x:
            if b0y <= b1y:
                overlap = (b0y + b0h) - b1y
                if overlap > 0:
                    space = scrn_h - (b1y + b1h)
                    if space > 0:
                        b1y = b1y + min(space, overlap)
                overlap = (b0y + b0h) - b1y
                if overlap > 0:
                    b0y = max(b0y - overlap, 0 + self.top_margin)
            else:
                overlap = (b1y + b1h) - b0y
                if overlap > 0:
                    space = scrn_h - (b0y + b0h)
                    if space > 0:
                        b0y = b0y + min(space, overlap)
                overlap = (b1y + b1h) - b0y
                if overlap > 0:
                    b1y = max(b1y - overlap, 0 + self.top_margin)
        # position balloon windows
        self.balloon.set_position(0, b0x, b0y)
        self.balloon.set_position(1, b1x, b1y)
        self.surface.set_direction(0, b0side)
        self.surface.set_direction(1, b1side)
        self.balloon.set_direction(0, b0side)
        self.balloon.set_direction(1, b1side)
    def start(self):
        self.start_time = time.time()
        self.restart()
        if self.ghost_time == 0:
            if not self.notify_event("OnFirstBoot", self.ghost_vanished_count):
                self.notify_event("OnBoot", default=ninix.main.VERSION_INFO)
        else:
            self.notify_event("OnBoot", default=ninix.main.VERSION_INFO)
        self.enqueue_event("OnDisplayChange", gtk.gdk.visual_get_best_depth(), gtk.gdk.screen_width(), gtk.gdk.screen_height())
    def save_history(self):
        path = os.path.join(self.ghost.get_prefix(), 'HISTORY')
        try:
            file = open(path, "w")
        except IOError, (code, message):
            sys.stderr.write("cannot write %s\n" % path)
        else:
            time = self.get_ghost_time()
            vanished_count = self.get_ghost_vanished_count()
            file.write('time, %s\n' % time)
            file.write('vanished_count, %s\n' % vanished_count)
            file.close()
    def restart(self):
        path = os.path.join(self.ghost.get_prefix(), 'HISTORY')
        if os.path.exists(path):
            ghost_time = 0
            ghost_vanished_count = 0
            try:
                file = open(path, "r")
            except IOError, (code, message):
                sys.stderr.write("cannot read %s\n" % path)
            else:
                while 1:
                    line = file.readline()
                    if not line:
                        break # EOF
                    comma = string.find(line, ',')
                    if comma >= 0:
                        key = string.strip(line[:comma])
                        value = string.strip(line[comma+1:])
                    if key == 'time':
                        try:
                            ghost_time = int(value)
                        except:
                            pass
                    elif key == 'vanished_count':
                        try:
                            ghost_vanished_count = int(value)
                        except:
                            pass
                file.close()
            self.set_ghost_time(ghost_time)
            self.set_ghost_vanished_count(ghost_vanished_count)
        else:
            self.set_ghost_time(0)
            self.set_ghost_vanished_count(0)
        self.vanished = 0
        self.reset_script(1)
        self.surface.reset_alignment()
        self.stand_by(1)
        self.position_all()
        self.reset_idle_time()
        self.running = 1
        self.charset = 'Shift_JIS' # default
        charset = self.get_event_response("charset")
        if charset:
            try:
                codecs.lookup(charset)
            except:
                sys.stderr.write("Unsupported charset %s" % repr(charset))
            else:
                self.charset = charset
        else:
            pass
    def stop(self):
        self.running = 0
        self.save_history()
        self.communicate.rebuild_ghostdb(None)
        self.hide_all()
    def notify_close(self, proc):
        self.reset_script(1)
        self.enqueue_event("OnClose", proc=proc)
    def notify_ghost_changing(self, name, method, proc):
        self.reset_script(1)
        self.enqueue_event("OnGhostChanging", name, method, proc=proc)
    def notify_shell_changing(self, name, proc):
        self.reset_script(1)
        self.enqueue_event("OnShellChanging", name, proc=proc)
    def notify_vanish_selecting(self):
        self.reset_script(1)
        self.notify_event("OnVanishSelecting")
    def notify_vanish_selected(self, proc):
        self.reset_script(1)
        self.enqueue_event("OnVanishSelected", proc=proc)
        self.vanished = 1
    def notify_vanish_cancel(self):
        self.reset_script(1)
        self.notify_event("OnVanishCancel")
    def notify_ghost_changed(self, name, vanished=0):
        if self.ghost_time == 0:
            if self.notify_event("OnFirstBoot", self.ghost_vanished_count):
                return 
        elif vanished:
            if self.notify_event("OnVanished", name):
                return
        else:
            if self.notify_event("OnGhostChanged", name):
                return
        self.notify_event("OnBoot", default=ninix.main.VERSION_INFO)
    def notify_shell_changed(self, name):
        self.notify_event("OnShellChanged", name)
    def notify_ninix_reloading(self, proc):
        self.reset_script(1)
        self.enqueue_event("OnNinixReloading", proc=proc)
    def notify_ninix_reloaded(self):
        self.notify_event("OnNinixReloaded")
        self.notify_event("OnBoot", default=ninix.main.VERSION_INFO)
    def notify_about(self):
        self.start_script(ninix.main.VERSION_INFO)
    def update_surface(self):
        if self.running:
            self.surface.update()
    def receive_sstp_request(self): # enqueue scripts
        try:
            for sstp_server in self.sstp_servers:
                sstp_server.handle_request()
        except socket.error, (code, message):
            sys.stderr.write("socket.error: %s (%d)\n" % (message, code))
        except ValueError: # may happen when ninix is terminated
            return
    def process_script(self):
        self.surface.window_get_pointer()
        now = time.time()
        idle = now - self.idle_start
        minute, second = time.localtime(now)[4:6]
        if self.clock[0] != second:
            self.ghost_time = self.ghost_time + 1
            current_ghost = (self.get_selfname(),
                             self.surface.get_surface(0),
                             self.surface.get_surface(1))
            self.communicate.rebuild_ghostdb(current_ghost)
            otherghostname = self.communicate.get_otherghostname()
            if otherghostname != self.old_otherghostname:
                args = []
                args.extend(otherghostname[:8])
                if len(otherghostname) > 8:
                    ext = otherghostname[8:]
                    args = otherghostname[:8]
                    args.append(ext)
                args.insert(0, 'otherghostname')
                args = tuple(args)
                keyword = {'type': 'NOTIFY'}
                apply(self.notify_event, args, keyword)
            self.old_otherghostname = otherghostname
        if not self.running:
            pass
        elif self.script_mode == self.PAUSE_MODE:
            ##if idle > self.PAUSE_TIMEOUT:
            ##    self.script_mode = self.BROWSE_MODE
            pass
        elif self.processed_script or self.processed_text:
            self.interpret_script()
        elif self.script_post_proc is not None:
            self.script_post_proc()
            self.script_post_proc = None
        elif self.script_mode == self.SELECT_MODE:
            if self.passivemode:
                pass
            elif idle > self.SELECT_TIMEOUT:
                self.script_mode = self.BROWSE_MODE
                if self.sstp_request_handler:
                    self.sstp_request_handler.send_timeout()
                    self.sstp_request_handler = None
                if not self.notify_event("OnChoiceTimeout"):
                    self.stand_by(0)
        elif self.sstp_handle is not None:
            self.close_sstp_handle()
        elif self.user_interaction:
            pass
        elif idle > self.balloon_life > 0 and not self.passivemode:
            self.balloon_life = 0
            self.stand_by(0)
        elif self.event_queue and self.handle_event():
            pass
        elif self.script_queue and not self.passivemode:
            if self.silent_time > 0:
                self.keep_silence(1) # extend silent time
            script, sender, self.sstp_handle, \
                    host, show_sstp_marker, use_translator, \
                    self.sstp_entry_db, self.sstp_request_handler = \
                    self.script_queue.pop(0)
            if show_sstp_marker:
                self.balloon.show_sstp_message(sender, host)
            else:
                self.balloon.hide_sstp_message()
            # XXX: how about the use_translator flag?
            self.start_script(script, self.FROM_SSTP_CLIENT)
        elif self.silent_time > 0:
            if now - self.silent_time > self.SILENT_TIME:
                self.keep_silence(0)
        elif self.clock[0] != second and \
             self.notify_event("OnSecondChange", self.get_uptime(),
                               self.mikire, self.kasanari, not self.passivemode and self.cantalk):
            pass
        elif self.clock[1] != minute and \
             self.notify_event("OnMinuteChange", self.get_uptime(),
                               self.mikire, self.kasanari, not self.passivemode and self.cantalk):
            pass
        elif self.surface_mouse_motion is not None:
            side, x, y, part = self.surface_mouse_motion
            self.notify_event("OnMouseMove", x, y, "", side, part)
            self.surface_mouse_motion = None
        elif idle > self.surface_life > 0 and not self.passivemode:
            self.surface_life = 0
            self.notify_event("OnSurfaceRestore",
                              self.surface.get_surface(0),
                              self.surface.get_surface(1))
        self.clock = (second, minute)
    ###   SCRIPT PLAYER   ###
    def start_script(self, script, origin=None):
        if not script:
            return
        self.script_origin = origin or self.FROM_GHOST
        self.reset_script(1)
        if string.rstrip(script)[-2:] != r"\e":
            script = script + r"\e"
        self.processed_script = []
        while 1:
            try:
                self.processed_script.extend(self.script_parser.parse(script))
            except ninix.script.ParserError, e:
                sys.stderr.write("-" * 50 + "\n")
                sys.stderr.write(("%s\n" % e).encode(locale_charset, 'ignore'))
                done, script = e
                self.processed_script.extend(done)
            else:
                break
        self.script_mode = self.BROWSE_MODE
        self.script_wait = None
        self.script_side = 0
        self.time_critical_session = 0
        self.quick_session = 0
        self.synchronized_session = 0
        self.text_count = [0, 0]
        self.balloon.synchronize(0)
        self.balloon.hide(0)
        self.balloon.hide(1)
        self.balloon.clear_text(0)
        self.balloon.clear_text(1)
        self.balloon.set_balloon(0, 0)
        self.balloon.set_balloon(1, 0)
        self.current_time = time.localtime(time.time())
        self.reset_idle_time()
    def interpret_script(self):
        if self.script_wait is not None:
            if time.time() < self.script_wait:
                return
            self.script_wait = None
        if self.processed_text:
            self.balloon.show(self.script_side)
            self.balloon.append_text(self.script_side, self.processed_text[0])
            self.processed_text = self.processed_text[1:]
            self.text_count[self.script_side] = self.text_count[self.script_side] + 1
            win = self.surface.window[self.script_side]
            id = self.surface.get_surface(self.script_side)
            count = None
            for actor in win.seriko[id]:
                interval = actor.get_interval()
                if interval[:4] == "talk":
                    count = int(interval[5])
                    actor_id = actor.get_id()
                    break
            if count != None and self.text_count[self.script_side] >= count:
                self.surface.invoke(self.script_side, actor_id)
                self.text_count[self.script_side] = 0
            if self.script_speed > 0:
                self.script_wait = time.time() + self.script_speed * 0.02
            return
        node = self.processed_script.pop(0)
        if node[0] == ninix.script.SCRIPT_TAG:
            name, args = node[1], node[2:]
            if name == r"\e":
                win = self.surface.window[self.script_side]
                id = self.surface.get_surface(self.script_side)
                for actor in win.seriko[id]:
                    if actor.get_interval() == "yen-e":
                        actor_id = actor.get_id()
                        self.surface.invoke(self.script_side, actor_id)
                        break
                self.reset_script()
                self.balloon_life = self.BALLOON_LIFE
            elif name in [r"\0", r"\h"]:
                ##self.balloon.show(0)
                self.script_side = 0
            elif name in [r"\1", r"\u"]:
                ##self.balloon.show(1)
                self.script_side = 1
            elif name == r"\4":
                if self.script_side == 0:
                    sw, sh = self.surface.get_surface_size(1)
                    sx, sy = self.surface.get_position(1)
                else:
                    sw, sh = self.surface.get_surface_size(0)
                    sx, sy = self.surface.get_position(0)
                w, h = self.surface.get_surface_size(self.script_side)
                x, y = self.surface.get_position(self.script_side)
                scrn_w = gtk.gdk.screen_width()
                scrn_h = gtk.gdk.screen_height() - self.bottom_margin
                if sx + sw / 2 > scrn_w / 2:
                    new_x = sx - w - int(scrn_w/20)
                else:
                    new_x = sx + sw + int(scrn_w/20)
                new_x = max(new_x, 0)
                new_x = min(new_x, scrn_w - w)
                if x > new_x:
                    step = -10
                else:
                    step = 10
                if abs(sx - new_x) < abs(sx - x):
                    return
                for current_x in range(x, new_x, step):
                    self.surface.set_position(self.script_side, current_x, y)
                    self.notify_surface_drop()
                    self.balloon.reset_balloon(0)
                    self.balloon.reset_balloon(1)
                self.surface.set_position(self.script_side, new_x, y)
                self.notify_surface_drop()
                self.balloon.reset_balloon(0)
                self.balloon.reset_balloon(1)
            elif name == r"\5":
                if self.script_side == 0:
                    sw, sh = self.surface.get_surface_size(1)
                    sx, sy = self.surface.get_position(1)
                else:
                    sw, sh = self.surface.get_surface_size(0)
                    sx, sy = self.surface.get_position(0)
                w, h = self.surface.get_surface_size(self.script_side)
                x, y = self.surface.get_position(self.script_side)
                scrn_w = gtk.gdk.screen_width()
                scrn_h = gtk.gdk.screen_height() - self.bottom_margin
                if sx + sw/2 > x and sx + sw/2 < x + w or \
                   x + w/2 > sx and x + w/2 < sx + sw:
                    return
                if sx + sw / 2 > x + w / 2:
                    new_x = sx - w / 2 + 1
                else:
                    new_x = sx + sw - w / 2 - 1
                new_x = max(new_x, 0)
                new_x = min(new_x, scrn_w - w)
                if x > new_x:
                    step = -10
                else:
                    step = 10
                for current_x in range(x, new_x, step):
                    self.surface.set_position(self.script_side, current_x, y)
                    self.notify_surface_drop()
                    self.balloon.reset_balloon(0)
                    self.balloon.reset_balloon(1)
                self.surface.set_position(self.script_side, new_x, y)
                self.notify_surface_drop()
                self.balloon.reset_balloon(0)
                self.balloon.reset_balloon(1)
            elif name == r"\s":
                id = args[0]
                if id == "-1":
                    self.surface.hide(self.script_side)
                else:
                    self.surface.set_surface(self.script_side, id)
                    self.surface.show(self.script_side)
                    self.surface.raise_(self.script_side)
                    self.balloon.raise_(self.script_side)
                    self.notify_event("OnSurfaceChange",
                                      self.surface.get_surface(0),
                                      self.surface.get_surface(1))
                    self.position_balloons()
            elif name == r"\b":
                if args[0] == "-1":
                    self.balloon.hide(self.script_side)
                else:
                    try:
                        id = int(args[0]) / 2
                    except ValueError:
                        id = 0
                    else:
                        self.balloon.set_balloon(self.script_side, id)
            elif name == r"\_b":
                filename, x, y = string.split(self.expand_meta(args[0]), ',')
                filename = string.lower(filename)
                path = os.path.join(self.ghost.get_prefix(), 'ghost/master',
                                    string.replace(filename, '\\', '/'))
                if os.path.isfile(path):
                    self.balloon.append_image(self.script_side, path, x, y)
            elif name == r"\n":
                if len(args) > 0 and self.expand_meta(args[0]) == 'half':
                    self.balloon.append_text(self.script_side, u"\n[half]")
                else:
                    self.balloon.append_text(self.script_side, u"\n")
            elif name == r"\c":
                self.balloon.clear_text(self.script_side)
            elif name in [r"\w", r"\_w"]:
                if not self.quick_session and self.script_speed >= 0:
                    if name == r"\w":
                        unit = 0.05  # 50ms
                    else:
                        unit = 0.001  # 1ms
                    try:
                        amount = int(args[0]) * unit - 0.01
                    except ValueError:
                        amount = 0
                    if amount > 0:
                        self.script_wait = time.time() + amount
            elif name == r"\t":
                self.time_critical_session = not self.time_critical_session
            elif name == r"\_q":
                self.quick_session = not self.quick_session
            elif name == r"\_s":
                self.synchronized_session = not self.synchronized_session
                self.balloon.synchronize(self.synchronized_session)
            elif name == r"\_e":
                self.balloon.hide(self.script_side)
                self.balloon.clear_text(self.script_side)
            elif name == r"\q":
                newline_required = 0
                if len(args) == 3: # traditional syntax
                    num, id, text = args
                    newline_required = 1
                else: # new syntax
                    text, id = args
                text = self.expand_meta(text)
                self.balloon.append_link(self.script_side, id, text, newline_required)
                self.script_mode = self.SELECT_MODE
            elif name == r"\URL":
                text = self.expand_meta(args[0])
                if len(args) == 1:
                    link = text
                else:
                    link = "#cancel"
                self.balloon.append_link(self.script_side, link, text)
                for i in range(1, len(args), 2):
                    link = self.expand_meta(args[i])
                    text = self.expand_meta(args[i+1])
                    self.balloon.append_link(self.script_side, link, text)
                self.script_mode = self.SELECT_MODE
            elif name == r"\_a":
                if self.anchor:
                    id = self.anchor[0]
                    text = self.anchor[1]
                    self.balloon.append_link(self.script_side, id, text)
                    self.anchor = None
                else:
                    id = args[0]
                    self.anchor = [('anchor', id), '']
            elif name == r"\x":
                if self.script_mode == self.BROWSE_MODE:
                    self.script_mode = self.PAUSE_MODE
                    self.balloon.window[self.script_side].redraw()
                    self.balloon.append_text(self.script_side, u"\n")
            elif name == r"\a": # obsolete # only for old SHIORI
                self.start_script(self.ghost.getaistringrandom())
            elif name == r"\i":
                try:
                    id = int(args[0])
                except ValueError:
                    pass
                else:
                    self.surface.invoke(self.script_side, id)
            elif name == r"\j":
                id = args[0]
                if self.is_URL(id):
                    self.launch_browser(id)
            elif name == r"\-":
                self.ghost.quit()
            elif name == r"\+":
                self.ghost.select_ghost(1)
            elif name == r"\_+":
                self.ghost.select_ghost(0)
            elif name == r"\m":
                self.write_sstp_handle(self.expand_meta(args[0]))
            elif name == r"\&":
                text = self.entitydefs.get(args[0])
                if text is None:
                    text = "?"
                self.balloon.append_text(self.script_side, text)
            elif name == r"\_m":
                try:
                    num = string.atoi(args[0], 16)
                except ValueError:
                    num = 0
                if num >= 0x20 and num <= 0x7e:
                    text = chr(num)
                else:
                    text = "?"
                self.balloon.append_text(self.script_side, text)
            elif name == r"\_u":
                self.balloon.append_text(self.script_side, u"?")
            elif name == r"\_v":
                filename = self.expand_meta(args[0])
                filename = string.lower(filename)
                path = os.path.join(self.ghost.get_prefix(), 'ghost/master', filename)
                if os.path.isfile(path):
                    for regex, command in self.helpers:
                        if regex.search(path):
                            self.execute_command(command, path)
                            break
            elif name == r"\!" and len(args) > 0:
                argc = len(args)
                args = map(self.expand_meta, args)
                if args[0] == "raise" and argc >= 2:
                    apply(self.notify_event, tuple(args[1:10]))
                elif args[0:2] == ["open", "browser"] and argc > 2:
                    self.launch_browser(args[2])
                elif args[0:2] == ["open", "communicatebox"]:
                    if not self.passivemode:
                        self.open_communicatebox()
                elif args[0:2] == ["open", "teachbox"]:
                    if not self.passivemode:
                        self.open_teachbox()
                elif args[0:2] == ["open", "inputbox"] and argc > 2:
                    if not self.passivemode:
                        if argc > 4:
                            self.open_inputbox(args[2], args[3], args[4])
                        elif argc == 4:
                            self.open_inputbox(args[2], args[3])
                        else:
                            self.open_inputbox(args[2])
                elif args[0:2] == ["open", "configurationdialog"]:
                    self.ghost.edit_preferences()
                elif args[0:2] == ["change", "ghost"] and argc > 2:
                    if args[2] == "random":
                        self.ghost.select_ghost(0, 0)
                    else:
                        self.ghost.select_ghost_by_name(args[2], 0)
                elif args[0:1] == ["updatebymyself"]:
                    if not self.busy():
                        self.ghost.update()
                elif args[0:1] == ["vanishbymyself"]:
                    self.vanished = 1
                    count = self.get_ghost_vanished_count()
                    self.set_ghost_vanished_count(count + 1)
                    self.set_ghost_time(0)
                    self.ghost.app.stop_sakura(self.ghost.app.vanish_sakura)
                elif args[1:2] == ["repaint"]:
                    if args[0:1] == ["lock"]:
                        self.lock_repaint = 1
                    elif args[0:1] == ["unlock"]:
                        self.lock_repaint = 0
                elif args[1:2] == ["passivemode"]:
                    if args[0:1] == ["enter"]:
                        self.passivemode = 1
                    elif args[0:1] == ["leave"]:
                        self.passivemode = 0
                elif args[0:2] == ["set", "alignmentondesktop"]:
                    if args[2] == "bottom":
                        if self.synchronized_session:
                            self.align_bottom(0)
                            self.align_bottom(1)
                        else:
                            self.align_bottom(self.script_side)
                    elif args[2] == "top":
                        if self.synchronized_session:
                            self.align_top(0)
                            self.align_top(1)
                        else:
                            self.align_top(self.script_side)
                    self.position_balloons()
                elif args[0:2] == ["set", "alignmenttodesktop"]:
                    if args[2] == "free":
                        if self.synchronized_session:
                            self.surface.set_alignment(0, 2)
                            self.surface.set_alignment(1, 2)
                        else:
                            self.surface.set_alignment(self.script_side, 2)
                    self.position_balloons()
                elif args[0] == '*':
                    self.balloon.append_sstp_marker(self.script_side)
            elif name == r"\__c":
                self.open_communicatebox()
            elif name == r"\__t":
                self.open_teachbox()
        elif node[0] == ninix.script.SCRIPT_TEXT:
            text = self.expand_meta(node[1])
            if self.anchor:
                self.anchor[1] = self.anchor[1] + text
            elif not self.quick_session and self.script_speed >= 0:
                self.processed_text = text
            else:
                self.balloon.append_text(self.script_side, text)
    def open_communicatebox(self):
        if self.user_interaction:
            return
        self.balloon.show_communicatebox()
        self.user_interaction = 1
    def open_teachbox(self):
        if self.user_interaction:
            return
        self.notify_event("OnTeachStart")
        self.balloon.show_teachbox()
        self.user_interaction = 1
    def open_inputbox(self, symbol, limittime=-1, default=None):
        if self.user_interaction:
            return
        self.balloon.show_inputbox(symbol, limittime, default)
        self.user_interaction = 1
    def reset_script(self, reset_all=0):
        if reset_all:
            self.script_mode = self.BROWSE_MODE
            self.script_post_proc = None
        self.processed_script = None
        self.processed_text = ""
        self.time_critical_session = 0
        self.quick_session = 0
        self.synchronized_session = 0
        self.balloon.synchronize(0)
        self.reset_idle_time()
    def expand_meta(self, text_node):
        buffer = []
        for chunk in text_node:
            if chunk[0] == ninix.script.TEXT_STRING:
                buffer.append(chunk[1])
            elif chunk[1] == "%month":
                buffer.append(str(self.current_time[1]))
            elif chunk[1] == "%day":
                buffer.append(str(self.current_time[2]))
            elif chunk[1] == "%hour":
                buffer.append(str(self.current_time[3]))
            elif chunk[1] == "%minute":
                buffer.append(str(self.current_time[4]))
            elif chunk[1] == "%second":
                buffer.append(str(self.current_time[5]))
            elif chunk[1] in ["%username", "%c"]:
                buffer.append(self.get_username())
            elif chunk[1] == "%selfname":
                buffer.append(self.get_selfname())
            elif chunk[1] == "%selfname2":
                buffer.append(self.get_selfname2())
            elif chunk[1] == "%keroname":
                buffer.append(self.get_keroname())
            elif chunk[1] == "%friendname":
                buffer.append(self.get_friendname())
            elif chunk[1] == "%screenwidth":
                buffer.append(str(gtk.gdk.screen_width()))
            elif chunk[1] == "%screenheight":
                buffer.append(str(gtk.gdk.screen_height()))
            elif chunk[1] == "%et":
                buffer.append(unicode("%dǯ" % self.current_time[7], 'EUC-JP'))
            elif chunk[1] == "%exh":
                buffer.append(str(self.get_uptime()))
            elif chunk[1] in ["%ms", "%mz", "%ml", "%mc", "%mh", \
                              "%mt", "%me", "%mp", "%m?"]:
                buffer.append(self.ghost.getword(chunk[1][1:]))
            elif chunk[1] == "%dms":
                buffer.append(self.ghost.getdms())
            else: # %c, %songname
                buffer.append(chunk[1])
        return string.join(buffer, '')
    ###   SEND SSTP/1.3   ###
    def open_sstp_handle(self, path):
        handle = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
        try:
            handle.connect(path)
        except socket.error:
            handle = None # discard socket object
            sys.stderr.write("cannot open Unix socket: %s\n" % path)
        return handle
    def _send_sstp_handle(self, data):
        r, w, e = select.select([], [self.sstp_handle], [], 0)
        if not w:
            return
        try:
            self.sstp_handle.send(data + "\n")
        except socket.error:
            pass
    def write_sstp_handle(self, data):
        if self.sstp_handle is None:
            return
        self._send_sstp_handle("+" + data)
        ##print "write_sstp_handle(%s)" % repr(data)
    def close_sstp_handle(self):
        if self.sstp_handle is None:
            return
        self._send_sstp_handle("-")
        ##print "close_sstp_handle()"
        try:
            self.sstp_handle.close()
        except socket.error:
            pass
        self.sstp_handle = None

class Ghost:
    def __init__(self, app, sakura, shiori_lib, debug=0):
        self.app = app
        self.sakura = sakura
        self.debug = debug
        self.dll = shiori_lib
    def new(self, desc, shiori_dir, use_makoto, prefix, shiori_dll, shiori_name):
        self.shiori = None
        self.desc = desc
        name = (shiori_dll, shiori_name)
        self.shiori = self.dll.request(name)
        if self.shiori and self.shiori.load(shiori_dir):
            if getattr(self.shiori, 'show_description', None):
                self.shiori.show_description()
        else:
            sys.stderr.write("cannot load SHIORI(%s) (abort)\n" % shiori_name)
            sys.exit(1)
        self.use_makoto = use_makoto
        self.prefix = prefix
        self.updateman = ninix.update.NetworkUpdate(self.sakura)
        icon = self.desc.get("icon", None)
        if icon != None:
            icon_path = os.path.join(shiori_dir, icon)
            if not os.path.exists(icon_path):
                icon_path = None
        else:
            icon_path = None
        self.sakura.surface.set_icon(icon_path)        
    def start(self):
        self.sakura.start()
        self.set_timeout()
    def finalize(self):
        self.shiori.unload()
    def get_prefix(self):
        return self.prefix
    def translate(self, s):
        if s is not None:
            if self.use_makoto:
                s = ninix.makoto.execute(s)
            else:
                r = self.get_event_response("OnTranslate", s, translate=0)
                if r:
                    s = r
        return s
    def getaistringrandom(self): # obsolete
        result = self.get_event_response("OnAITalk")
        return self.translate(result)
    def getdms(self):
        result = self.get_event_response('dms')
        return self.translate(result)
    def getword(self, type):
        result = self.get_event_response('%s' % type)
        return self.translate(result)
    def getstring(self, name):
        return self.get_event_response(name)
    def get_name(self):
        return self.desc.get("name", unicode(_("Sakura&Unyuu"), 'utf-8'))
    def get_username(self):
        return self.desc.get("user.defaultname", unicode(_("User"), 'utf-8'))
    def get_selfname(self):
        return self.desc.get("sakura.name", unicode(_("Sakura"), 'utf-8'))
    def get_selfname2(self):
        return self.desc.get("sakura.name2", unicode(_("Sakura"), 'utf-8'))
    def get_keroname(self):
        return self.desc.get("kero.name", unicode(_("Unyuu"), 'utf-8'))
    def get_friendname(self):
        return self.desc.get("sakura.friend.name", unicode(_("Tomoyo"), 'utf-8'))
    def get_event_response(self, event,
                           ref0=None, ref1=None, ref2=None, ref3=None,
                           ref4=None, ref5=None, ref6=None, ref7=None,
                           ref_ext=[], type='GET', translate=1):
        ref = [ref0, ref1, ref2, ref3, ref4, ref5, ref6, ref7]
        ref.extend(ref_ext)
        header = '%s SHIORI/3.0\r\n' % type + \
                 'ID: %s\r\n' % event + \
                 'Sender: ninix-aya\r\n' \
                 'SecurityLevel: local\r\n'
        for i in range(len(ref)):
            if ref[i] != None:
                header = header + \
                         'Reference' + str(i) + ': ' + \
                         str(ref[i]) + '\r\n'
        header = header + '\r\n'
        header = header.encode(self.sakura.charset, 'ignore')
        response = self.shiori.request(header)
        if self.sakura.cantalk:
            result, to = self.get_value(response)
            if translate:
                result = self.translate(result)
        else:
            result, to = '', None
        if result == None:
            result = ''
        if to and result:
            header = 'COMMUNICATE SSTP/1.1\r\n' + \
                     'Sender: %s\r\n' % self.sakura.get_selfname() + \
                     'Sentence: %s\r\n' % result + \
                     'Charset: %s\r\n\r\n' % self.sakura.charset
            header = header.encode(self.sakura.charset, 'ignore')
            self.sakura.communicate.send_message(to, header)
        return result
    def get_value(self, response):
        header = StringIO.StringIO(response)
        result = {}
        to = None
        while 1:
            line = header.readline()
            if not line:
                break # EOF
            if line[-1] == '\n':
                line = line[:-1]
            line = string.strip(line)
            if not line:
                continue
            colon = string.find(line, ':')
            if colon >= 0:
                key = string.strip(line[:colon])
                result[key] = string.strip(line[colon+1:])
            else:
                continue
        for key in result.keys():
            result[key] = unicode(result[key], self.sakura.charset, 'ignore')
        if result.has_key('Reference0'):
            to = result['Reference0']
        if result.has_key('Value'):
            return result['Value'], to
        else:
            return None, to
    def teach(self, word):
        result = self.get_event_response('OnTeach', word)
        return self.translate(result)
    def update(self):
        if self.updateman.is_active():
            return
        homeurl = self.getstring("homeurl")
        if not homeurl:
            self.sakura.start_script(r"\t\h\s[0]" + unicode(_("I'm afraid I don't have Network Update yet."), 'utf-8') + r"\e")
            self.sakura.balloon.hide_sstp_message()
            return
        ghostdir = self.get_prefix()
        print "homeurl =", homeurl
        print "ghostdir =", ghostdir
        self.updateman.start(homeurl, ghostdir)
    re_shortcut = re.compile(r'&(?=[\x21-\x7e])')
    def modify_shortcut(self, caption):
        return self.re_shortcut.sub('_', caption)
    re_accel = re.compile(r'\(_.\)|_')
    def cut_accel(self, caption):
        return self.re_accel.sub('', caption)
    def update_ui(self, side):
        # update button
        caption = self.getstring("updatebuttoncaption") or \
                  self.getstring("updatebutton.caption")
        if caption:
            caption = self.modify_shortcut(caption)
            if caption == self.cut_accel(caption):
                caption = caption + '(_U)'
        else:
            caption = unicode(_("Network Update(_U)"), 'utf-8')
        item = self.sakura.surface.menuitem['update']
        children = item.get_children()
        label = children[0] # GtkMenuItem's only child is a GtkLabel
        label.set_text_with_mnemonic(caption)
        # vanish button
        visible = self.getstring("vanishbuttonvisible") or \
                  self.getstring("vanishbutton.visible")
        item = self.sakura.surface.menuitem['vanish']
        if visible == "0":
            item.hide()
        else:
            item.show()
            if len(self.app.ghosts) < 2:
                item.set_sensitive(0)
            caption = self.getstring("vanishbuttoncaption") or \
                      self.getstring("vanishbutton.caption")
            if caption:
                caption = self.modify_shortcut(caption)
                dialog_caption = self.cut_accel(caption)
                if caption == dialog_caption:
                    caption = caption + '(_F)'
            else:
                caption = dialog_caption = unicode(_("Vanish(_F)"), 'utf-8')
            # menu item label
            children = item.get_children()
            label = children[0] # GtkMenuItem's only child is a GtkLabel
            label.set_text_with_mnemonic(caption)
            # dialog message
            self.app.vanish_dialog.set_message(dialog_caption)
        # portal button
        item = self.sakura.surface.menuitem['portal']
        if side == 0:
            caption = self.getstring("sakura.portalbuttoncaption") or \
                      self.getstring("portalrootbutton.caption")
            if caption:
                caption = self.modify_shortcut(caption)
                if caption == self.cut_accel(caption):
                    caption = caption + '(_P)'
            else:
                caption = unicode(_("Portal sites(_P)"), 'utf-8')
            children = item.get_children()
            label = children[0] # GtkMenuItem's only child is a GtkLabel
            label.set_text_with_mnemonic(caption)
            item.show()
        else:
            item.hide()
        # recommend button
        if side == 0:
            caption = self.getstring("sakura.recommendbuttoncaption") or \
                      self.getstring("recommendrootbutton.caption")
        else:
            caption = self.getstring("kero.recommendbuttoncaption")
        if caption:
            caption = self.modify_shortcut(caption)
            if caption == self.cut_accel(caption):
                caption = caption + '(_R)'
        else:
            caption = unicode(_("Recommend sites(_R)"), 'utf-8')
        item = self.sakura.surface.menuitem['recommend']
        children = item.get_children()
        label = children[0] # GtkMenuItem's only child is a GtkLabel
        label.set_text_with_mnemonic(caption)
    def open_popup_menu(self, button, side):
        self.update_ui(side)
        self.sakura.surface.set_portal_menu(side)
        self.sakura.surface.set_recommend_menu(side)
        self.sakura.surface.set_ghost_menu()
        self.sakura.surface.set_shell_menu()
        self.sakura.surface.set_balloon_menu()
        self.sakura.surface.set_plugin_menu()
        self.sakura.surface.set_scale_menu()
        self.sakura.surface.set_speed_menu()
        self.sakura.surface.set_mayuna_menu(side)
        try:
            self.sakura.surface.popup_menu.popup(None, None, None, button, gtk.get_current_event_time())
        except: # pygtk <= 2.0.0
            self.sakura.surface.popup_menu.popup(None, None, None, button, 0)
    def quit(self):
        self.app.quit()
    def edit_preferences(self):
        self.app.edit_preferences(None)
    def reload(self):
        self.app.reload()
    def select_ghost(self, sequential, event=1):
        self.app.select_ghost(sequential, event)
    def select_ghost_by_name(self, name, event=1):
        self.app.select_ghost_by_name(name, event)
    ###   TIMEOUT   ###
    def set_timeout(self):
        gtk.timeout_add(10, self.do_idle_tasks) # 10ms
    reload_event = None
    def do_idle_tasks(self):
        if self.reload_event and not self.sakura.busy() and \
           not (self.sakura.processed_script or self.sakura.processed_text):
            self.sakura.hide_all()
            sys.stdout.write('reloading....\n')
            self.finalize()
            self.app.reload_current_sakura()
            self.sakura.restart()
            sys.stdout.write('done.\n')
            apply(self.sakura.enqueue_event, self.reload_event)
            self.reload_event = None
        self.sakura.update_surface()
        self.sakura.receive_sstp_request()
        # continue network update (enqueue events)
        if self.updateman.is_active():
            self.updateman.run()
            while 1:
                event = self.updateman.get_event()
                if not event:
                    break
                if event[0] == 'OnUpdateComplete' and event[1] == 'changed':
                    self.reload_event = event
                else:
                    apply(self.sakura.enqueue_event, event)
        self.sakura.process_script()
        self.set_timeout()

class Surface:
    def __init__(self, sakura, debug=0):
        self.sakura = sakura
        self.debug = debug
        self.gtk_window = []
        self.accelgroup = gtk.AccelGroup()
        for name in ["sakura", "unyuu"]:
            window = gtk.Window()
            window.set_title('surface.'+name)
            window.set_decorated(gtk.FALSE)
            window.set_resizable(gtk.FALSE)
            window.connect("delete_event", self.delete)
            window.connect("key_press_event", self.key_press)
            window.connect("window_state_event", self.window_state)
            window.set_events(gtk.gdk.KEY_PRESS_MASK)
            window.realize()
            window.add_accel_group(self.accelgroup)
            self.gtk_window.append(window)
        self.window = []
    def window_state(self, window, event):
        if event.new_window_state == 2:
            if window == self.gtk_window[0]:
                self.sakura.cantalk = 0
                if not self.sakura.passivemode:
                    self.sakura.reset_script(1)
                    self.sakura.stand_by(1)
                    self.sakura.notify_event("OnWindowStateMinimize")
            for gtk_window in self.gtk_window:
                if gtk_window != window and gtk_window.window.get_state() != 2:
                    gtk_window.iconify()
        else:
            for gtk_window in self.gtk_window:
                if gtk_window != window and gtk_window.window.get_state() == 2:
                    gtk_window.deiconify()
            if window == self.gtk_window[0] and self.sakura.cantalk == 0:
                self.sakura.cantalk = 1
                if not self.sakura.passivemode:
                    self.sakura.notify_event("OnWindowStateRestore")
        return gtk.TRUE
    def delete(self, window, event):
        self.sakura.finalize()
        gtk.mainquit()
        return gtk.FALSE
    def key_press(self, window, event):
        self.sakura.notify_key_press(event.keyval, event.string)
        return gtk.TRUE
    def launch_browser(self, event, args):
        title, url = args
        if self.sakura.is_URL(url):
            self.sakura.launch_browser(url)
        self.sakura.enqueue_event("OnRecommandedSiteChoice", title, url)
    def set_portal_menu(self, side):
        if side == 1:
            self.menuitem['portal'].hide()
        else:
            portal = self.sakura.ghost.getstring("sakura.portalsites")
            if portal:
                menu = gtk.Menu()
                list = string.split(portal, chr(2))
                for site in list:
                    entry = string.split(site, chr(1))
                    if len(entry) < 1:
                        continue
                    title = entry[0]
                    if title == '-':
                        item = gtk.SeparatorMenuItem()
                    else:
                        if len(entry) < 2:
                            continue
                        url = entry[1]
                        if len(entry) > 2:
                            bannar = entry[2] ## FIXME
                        else:
                            bannar = None
                        item = gtk.MenuItem(title)
                        item.connect("activate", self.launch_browser, (title, url))
                    menu.add(item)
                    item.show()
                self.menuitem['portal'].set_submenu(menu)
                menu.show()
                self.menuitem['portal'].show()
            else:
                self.menuitem['portal'].hide()
    def set_recommend_menu(self, side):
        recommend = self.sakura.ghost.getstring(["sakura.recommendsites", "kero.recommendsites"][side])
        if recommend:
            menu = gtk.Menu()
            list = string.split(recommend, chr(2))
            for site in list:
                entry = string.split(site, chr(1))
                if len(entry) < 1:
                    continue
                title = entry[0]
                if title == '-':
                    item = gtk.SeparatorMenuItem()
                else:
                    if len(entry) < 2:
                        continue
                    url = entry[1]
                    if len(entry) > 2:
                        bannar = entry[2] ## FIXME
                    else:
                        bannar = None
                    item = gtk.MenuItem(title)
                    item.connect("activate", self.launch_browser, (title, url))
                menu.add(item)
                item.show()
            self.menuitem['recommend'].set_submenu(menu)
            menu.show()
            self.menuitem['recommend'].show()
        else:
            self.menuitem['recommend'].hide()
    def set_ghost_menu(self):
        self.sakura.ghost.app.set_ghost_menu(self.menuitem['ghost'])
    def set_shell_menu(self):
        self.sakura.ghost.app.set_shell_menu(self.menuitem['shell'])
    def set_balloon_menu(self):
        self.sakura.ghost.app.set_balloon_menu(self.menuitem['balloon'])
    def set_plugin_menu(self):
        self.sakura.ghost.app.set_plugin_menu(self.menuitem['plugin'])
    def set_scale_menu(self):
        self.sakura.ghost.app.set_scale_menu(self.menuitem['scale'])
    def set_speed_menu(self):
        self.sakura.ghost.app.set_speed_menu(self.menuitem['speed'])
    def close(self, action, widget):
        self.sakura.ghost.app.close(None)
    def about(self, action, widget):
        if self.sakura.busy():
            gtk.gdk.beep()
            return
        self.sakura.notify_about()
    def network_update(self, action, widget):
        if self.sakura.busy():
            gtk.gdk.beep()
            return
        self.sakura.ghost.update()
    def window_stick(self, action, widget):
        for window in self.gtk_window:
            item = self.menuitem['stick']
            if item.get_active():
                window.stick()
            else:
                window.unstick()
    def edit_preferences(self, action, widget):
        self.sakura.ghost.app.edit_preferences(None)
    def reload(self, action, widget):
        self.sakura.ghost.app.reload()
    def show_usage(self, action, widget):
        self.sakura.ghost.app.show_usage(widget)
    def vanish(self, action, widget):
        self.sakura.ghost.app.vanish(None)
    def set_mayuna_menu(self, side):
        if self.mayuna_menu[side] != None:
            self.menuitem['mayuna'].set_submenu(self.mayuna_menu[side])
            self.menuitem['mayuna'].show()
        else:
            self.menuitem['mayuna'].hide()
    def create_mayuna_menu(self):
        mayuna_menu = self.get_mayuna_menu()
        self.mayuna_menu = []
        for side, index in [('sakura', 0), ('kero', 1)]:
            if mayuna_menu[side]:
                self.mayuna_menu.append(gtk.Menu())
                item = gtk.TearoffMenuItem()
                item.show()
                self.mayuna_menu[index].append(item)
                for j in range(len(mayuna_menu[side])):
                    key, name, state = mayuna_menu[side][j]
                    if key != '-':
                        item = gtk.CheckMenuItem(name)
                        item.set_name("popup menu item")
                        if state:
                            item.set_active(gtk.TRUE)
                        else:
                            item.set_active(gtk.FALSE)
                        item.connect("activate", self.toggle_bind, (index, key))
                    else:
                        item = gtk.SeparatorMenuItem()
                    item.show()
                    self.mayuna_menu[index].append(item)
            else:
                self.mayuna_menu.append(None)
    re_surface_id = re.compile("^surface([0-9]+)$")
    def new(self, desc, alias, surface, name):
        menu_items = (
            (_('/Portal sites(_P)'), None, None, 0, '<Branch>' ),
            (_('/Recommend sites(_R)'), None, None, 0, '<Branch>' ),
            ('/Separator', None, None, 0, '<Separator>'),
            (_('/File(_F)'), None, None, 0, '<Branch>' ),
            (_('/File(F)/Network Update(_U)'), None, self.network_update, 0, ''),
            (_('/File(F)/Vanish(_F)'), None, self.vanish, 0, ''),
            (_('/File(F)/Reload(_L)'), None, self.reload, 0, ''),
            (_('/File(F)/Settings...(_O)'), None, self.edit_preferences, 0, ''),
            (_('/File(F)/Usage graph(_A)'), None, self.show_usage, 0, ''),
            (_('/File(F)/Version(_V)'), None, self.about, 0, ''),
            (_('/File(F)/Exit(_Q)'), None, self.close, 0, ''),
            (_('/Ghost(_G)'), None, None, 0, '<Branch>' ),
            (_('/Shell(_S)'), None, None, 0, '<Branch>' ),
            (_('/Balloon(_B)'), None, None, 0, '<Branch>' ),
            (_('/Surface Scaling(_S)'), None, None, 0, '<Branch>' ),
            (_('/Costume(_C)'), None, None, 0, '<Branch>' ),
            (_('/Stick(_Y)'), None, self.window_stick, 0, '<CheckItem>' ),
            (_('/Script Wait(_W)'), None, None, 0, '<Branch>' ),
            ('/Separator', None, None, 0, '<Separator>'),
            (_('/Nekodorifu(_N)'), None, None, 0, '<Branch>' ), ## FIXME
            (_('/Kinoko(_K)'), None, None, 0, '<Branch>' ), ## FIXME
            (_('/Plugin(_P)'), None, None, 0, '<Branch>' ),
            )
        self.desc = desc
        self.name = name
        if alias is None:
            alias0 = alias1 = None
        else:
            alias0 = alias.get("sakura.surface.alias")
            alias1 = alias.get("kero.surface.alias")
        # load pixmap
        pixbufs = {}
        elements = {}
        for basename in surface.keys():
            path, config = surface[basename]
            if path is None:
                continue
            if not os.path.exists(path):
                name, suffix = os.path.splitext(path)
                dgp_path = name + '.dgp'
                if not os.path.exists(dgp_path):
                    print "%s: file not found (ignored)" % path
                    continue
                else:
                    path = dgp_path
            elements[basename] = [[path], None, None]
            match = self.re_surface_id.match(basename)
            if not match:
                continue
            key = match.group(1)
            pixbufs[key] = elements[basename]
        # compose surface elements
        composite_pixbuf = {}
        for basename in surface.keys():
            match = self.re_surface_id.match(basename)
            if not match:
                continue
            key = match.group(1)
            path, config = surface[basename]
            if config.has_key("element0"):
                if self.debug & 8192:
                    print "surface", key
                composite_pixbuf[key] = self.compose_elements(elements, config)
        pixbufs.update(composite_pixbuf)
        # check if necessary surfaces have been loaded
        for key in ["0", "10"]:
            if not pixbufs.has_key(key):
                sys.stderr.write("cannot load surface #%s (abort)\n" % key)
                sys.exit(1)
        # arrange surface configurations
        seriko = {}
        region = {}
        for basename in surface.keys():
            match = self.re_surface_id.match(basename)
            if not match:
                continue
            key = match.group(1)
            path, config = surface[basename]
            # define animation patterns
            seriko[key] = ninix.seriko.get_actors(config)
            # define collision areas
            buffer = []
            for n in range(256):
                rect = config.get("collision" + str(n)) # "redo" syntax
                if rect is None:
                    continue
                values = string.split(rect, ",")
                if len(values) != 5:
                    continue
                try:
                    x1, y1, x2, y2 = map(string.atoi, values[:4])
                except ValueError:
                    continue
                buffer.append((string.strip(values[4]), x1, y1, x2, y2))
            for part in ["head", "face", "bust"]:
                rect = config.get("collision." + part) # "inverse" syntax
                if not rect:
                    continue
                try:
                    x1, y1, x2, y2 = map(string.atoi, string.split(rect, ","))
                except ValueError:
                    pass
                buffer.append((string.capitalize(part), x1, y1, x2, y2))
            region[key] = buffer
        # MAYUNA
        mayuna = {}
        for basename in surface.keys():
            match = self.re_surface_id.match(basename)
            if not match:
                continue
            key = match.group(1)
            path, config = surface[basename]
            # define animation patterns
            mayuna[key] = ninix.mayuna.get_mayuna(config)
        bind = {}
        for side in ["sakura", "kero"]:
            bind[side] = {}
            for index in range(128):
                name = self.desc.get('%s.bindgroup%d.name' % (side, index), None)
                default = self.desc.get('%s.bindgroup%d.default' % (side, index), 0)
                if name != None:
                    bind[side][index] = [name, default]
        self.mayuna = {}
        for side in ["sakura", "kero"]:
            self.mayuna[side] = []
            for index in range(128):
                key = self.desc.get('%s.menuitem%d' % (side, index), None)
                if key == '-':
                    self.mayuna[side].append([key, None, 0])
                else:
                    try:
                        key = int(key)
                    except:
                        pass
                    else:
                        if bind[side].has_key(key):
                            name = string.split(bind[side][key][0], ',')
                            self.mayuna[side].append([key, name[1], bind[side][key][1]])
        # create surface windows
        for surface_window in self.window:
            surface_window.destroy()
        self.window = []
        self.window.append(SurfaceWindow(
            self.gtk_window[0], 0,
            self.sakura, desc, alias0, surface, pixbufs, seriko, region, mayuna, bind["sakura"],
            "0",self.debug))
        self.window.append(SurfaceWindow(
            self.gtk_window[1], 1,
            self.sakura, desc, alias1, surface, pixbufs, seriko, region, mayuna, bind["kero"],
            "10", self.debug))
        item_factory = gtk.ItemFactory(gtk.Menu, '<main>', self.accelgroup)
        item_factory.create_items(menu_items)
        self.item_factory = item_factory
        self.popup_menu = item_factory.get_widget('<main>')
        self.menuitem = {}
        self.menuitem['portal'] = item_factory.get_item(_('/Portal sites(P)'))
        self.menuitem['recommend'] = item_factory.get_item(_('/Recommend sites(R)'))
        self.menuitem['ghost'] = item_factory.get_item(_('/Ghost(G)'))
        self.menuitem['shell'] = item_factory.get_item(_('/Shell(S)'))
        self.menuitem['balloon'] = item_factory.get_item(_('/Balloon(B)'))
        self.menuitem['plugin'] = self.sakura.surface.item_factory.get_item(_('/Plugin(P)'))
        self.menuitem['scale'] = self.sakura.surface.item_factory.get_item(_('/Surface Scaling(S)'))
        self.menuitem['speed'] = self.sakura.surface.item_factory.get_item(_('/Script Wait(W)'))
        self.menuitem['mayuna'] = self.item_factory.get_item(_('/Costume(C)'))
        self.menuitem['stick'] = self.item_factory.get_item(_('/Stick(Y)'))
        self.menuitem['vanish'] = self.item_factory.get_item(_('/File(F)/Vanish(F)'))
        self.menuitem['update'] = self.item_factory.get_item(_('/File(F)/Network Update(U)'))
        self.create_mayuna_menu()
    def get_mayuna_menu(self):
        for side, index in [('sakura', 0), ('kero', 1)]:
            for menu in self.mayuna[side]:
                if menu[0] != '-':
                    menu[2] = self.window[index].bind[menu[0]][1]
        return self.mayuna
    def compose_elements(self, elements, config):
        error = None
        for n in range(256):
            key = "element" + str(n)
            if not config.has_key(key):
                break
            spec = map(string.strip, string.split(config[key], ","))
            try:
                method, filename, x, y = spec
                x = int(x)
                y = int(y)
            except ValueError:
                error = "invalid element spec for %s: %s" % (key, config[key])
                break
            basename, suffix = os.path.splitext(filename)
            if string.lower(suffix) != ".png":
                error = "unsupported file format for %s: %s" % (key, filename)
                break
            basename = string.lower(basename)
            if not elements.has_key(basename):
                error = "%s file not found: %s" % (key, filename)
                break
            pixbuf = elements[basename][0][0]
            if n == 0: # base surface
                pixbuf_list = [pixbuf]
            elif method == "overlay":
                pixbuf_list.append((pixbuf, x, y))
            else:
                error = "unknown method for %s: %s" % (key, method)
                break
            if self.debug & 8192:
                print "%s: %s %s, x=%d, y=%d, w=%d, h=%d" % (
                    key, method, filename, x, y, w, h)
        if error is not None:
            print error
            pixbuf_list = []
        return [pixbuf_list, None, None]
    def reset_surface(self, side):
        self.window[side].reset_surface()
    def set_surface(self, side, id):
        self.window[side].set_surface(id)
    def get_surface(self, side):
        return self.window[side].get_surface()
    def get_surface_size(self, side):
        return self.window[side].get_surface_size()
    def get_surface_offset(self, side):
        return self.window[side].get_surface_offset()
    def get_touched_region(self, side, x, y):
        return self.window[side].get_touched_region(x, y)
    def set_direction(self, side, dir):
        self.window[side].set_direction(dir)
    def set_position(self, side, x, y):
        self.window[side].set_position(x, y)
    def get_position(self, side):
        return self.window[side].get_position()
    def set_alignment(self, side, align):
        self.window[side].set_alignment(align)
    def get_alignment(self, side):
        return self.window[side].get_alignment()
    def reset_alignment(self):
        if self.desc.get('seriko.alignmenttodesktop') == 'free':
            align = 2
        else:
            align = 0
        self.set_alignment(0, align)
        self.set_alignment(1, align)
    def show(self, side):
        self.window[side].show()
    def hide(self, side):
        self.window[side].hide()
    def raise_(self, side):
        self.window[side].raise_()
    def lower(self, side):
        self.window[side].lower()
    def invoke(self, side, id):
        self.window[side].invoke(id)
    def update(self):
        for surface_window in self.window:
            surface_window.update()
    def set_icon(self, path):
        if path != None:
            pixbuf = ninix.pix.create_pixbuf_from_file(path, 'ico')
        else:
            pixbuf = None
        for window in self.gtk_window:
            try: # bug in pygtk (<= 1.99.16)
                window.set_icon(pixbuf)
            except:
                pass
    def get_name(self):
        return self.name
    def get_username(self):
        return self.desc.get("user.defaultname")
    def get_selfname(self):
        return self.desc.get("sakura.name")
    def get_selfname2(self):
        return self.desc.get("sakura.name2")
    def get_keroname(self):
        return self.desc.get("kero.name")
    def get_friendname(self):
        return self.desc.get("sakura.friend.name")
    def get_balloon_offset(self, side):
        if side == 0:
            x, y = self.window[side].get_balloon_offset()
            if x == None:
                x = self.desc.getint("sakura.balloon.offsetx", 0)
            if y == None:
                y = self.desc.getint("sakura.balloon.offsety", 0)
        else:
            x, y = self.window[side].get_balloon_offset()
            if x == None:
                x = self.desc.getint("kero.balloon.offsetx", 0)
            if y == None:
                y = self.desc.getint("kero.balloon.offsety", 0)
        if self.sakura.surface_scale != 100:
            x = x * self.sakura.surface_scale / 100
            y = y * self.sakura.surface_scale / 100
        return x, y
    def window_get_pointer(self):
        self.window[0].get_pointer()
        self.window[1].get_pointer()
    def toggle_bind(self, event, args):
        side, id = args
        self.window[side].toggle_bind(id)

class SurfaceWindow:
    # DnD data types
    dnd_targets = [
        ("text/plain", 0, 0),
        ]
    def __init__(self, window, side, sakura, desc, alias, surface,
                 pixbuf, seriko, region, mayuna, bind, default_id, debug):
        self.window = window
        self.side = side
        self.sakura = sakura
        self.desc = desc
        self.alias = alias
        self.align = 0
        if self.alias is not None:
            default_id = self.alias.get(default_id, [default_id])[0]
        self.surface = surface
        self.surface_id = default_id
        self.base_id = default_id
        self.exclusive_actor = None
        self.pixbuf = pixbuf
        self.seriko = seriko
        self.region = region
        self.mayuna = mayuna
        self.bind = bind
        self.surface_cache = {}
        self.default_id = default_id
        self.debug = debug
        self.shown = 0
        self.dragged = 0
        self.set_position(0, 0)
        self.set_direction(side)
        self.x_root = None
        self.y_root = None
        self.reset_overlays()
        # create drawing area
        self.darea = gtk.DrawingArea()
        self.darea.show()
        self.darea.set_events(gtk.gdk.EXPOSURE_MASK|
                              gtk.gdk.BUTTON_PRESS_MASK|
                              gtk.gdk.BUTTON_RELEASE_MASK|
                              gtk.gdk.POINTER_MOTION_MASK|
                              gtk.gdk.POINTER_MOTION_HINT_MASK|
                              gtk.gdk.SCROLL_MASK)
        self.callbacks = []
        for signal, func in [("button_press_event",   self.button_press),
                             ("button_release_event", self.button_release),
                             ("motion_notify_event",  self.motion_notify),
                             ("drag_data_received",   self.drag_data_received),
                             ("scroll_event",         self.scroll),
                             ]:
            self.callbacks.append(self.darea.connect(signal, func))
        self.darea.drag_dest_set(gtk.DEST_DEFAULT_ALL, self.dnd_targets,
                                 gtk.gdk.ACTION_COPY)
        self.window.add(self.darea)
        self.darea.realize()
        self.set_surface(None)
    def drag_data_received(self, widget, context, x, y, data, info, time):
        if self.debug & 8192:
            print "Content-type:", data.type
            print "Content-length:", data.length
            print repr(data.data)
        if str(data.type) == "text/plain":
            list = []
            for line in string.split(data.data, "\r\n"):
                scheme, host, path, params, query, fragment = \
                        urlparse.urlparse(line)
                if scheme == "file" and os.path.exists(path):
                    list.append(path)
            if list:
                self.sakura.notify_file_drop(list, self.side)
        return gtk.TRUE
    def invoke(self, id):
        for actor in self.seriko[self.base_id]:
            if id == actor.get_id():
                actor.invoke()
                if actor.exclusive:
                    self.exclusive_actor = actor
                    break
    def update(self):
        if self.exclusive_actor:
            self.reset_overlays()
            self.exclusive_actor.update(self)
            self.draw_overlays()
            if self.exclusive_actor == None or \
               self.exclusive_actor.wait == -1:
                self.exclusive_actor = None
        else:
            last_overlays = self.overlays.copy()
            for actor in self.seriko[self.base_id]:
                if actor.exclusive and actor.wait == 1:
                    self.reset_overlays()
                    actor.update(self)
                    self.draw_overlays()
                    if self.exclusive_actor != None and \
                       self.exclusive_actor.wait != -1:
                        self.exclusive_actor = actor
                    else:
                        self.exclusive_actor = None
                    return
                else:
                    actor.update(self)
            if self.overlays != last_overlays:
                self.draw_overlays()
    def terminate(self):
        for actor in self.seriko[self.base_id]:
            actor.terminate()
        self.reset_overlays()
    def reset_surface(self):
        id = self.get_surface()
        self.set_surface(id, force=1)
    def set_surface(self, id, reset=1, force=0):
        if self.alias is not None and self.alias.has_key(id):
            aliases = self.alias.get(id)
            if len(aliases) > 0:
                id = whrandom.choice(aliases)
        if not force and self.surface_id == id and self.shown:
            return
        if id == "-2" or reset:
            self.terminate()
        if id in ["-1", "-2"]:
            pass
        elif not self.pixbuf.has_key(id):
            self.surface_id = self.default_id
        else:
            self.surface_id = id
        if reset:
            if self.seriko.has_key(id):
                self.base_id = id
            else:
                self.base_id = self.surface_id
            self.exclusive_actor = None
            for actor in self.seriko[self.base_id]:
                if actor.get_interval() == "runonce":
                    actor.invoke()
                    if actor.exclusive:
                        self.exclusive_actor = actor
                        break
        # define collision areas
        self.collisions = self.region[self.surface_id]
        self.draw_surface()
        self.show_surface()
        # resize window
        w, h = self.get_surface_size(self.surface_id)
        self.darea.set_size_request(w, h)
        # relocate window
        x, y = self.get_position()
        dw, dh = self.get_surface_size(self.default_id) # default surface size
        xoffset = (dw - w)/2
        if self.get_alignment() == 0:
            yoffset = dh - h
            scrn_h = gtk.gdk.screen_height() - self.sakura.bottom_margin
            y = scrn_h - dh
        elif self.get_alignment() == 1:
            yoffset = 0
        else:
            yoffset = (dh - h)/2
        self.window_offset = (xoffset, yoffset)
        self.set_position(x, y)
    def compose_surface(self, surface_pixbuf, mayuna, done):
        for pattern in mayuna.patterns:
            surface, method, args = pattern
            if method in ['bind', 'add']:
                if self.pixbuf.has_key(surface):
                    x, y = args
                    pixbuf = self.get_pixbuf(surface)
                    w = pixbuf.get_width()
                    h = pixbuf.get_height()
                    # overlay surface pixbuf
                    sw = surface_pixbuf.get_width()
                    sh = surface_pixbuf.get_height()
                    if x + w > sw:
                        w = sw - x
                    if y + h > sh:
                        h = sh - y
                    if x < 0:
                        dest_x = 0
                        w = w + x
                    else:
                        dest_x = x
                    if y < 0:
                        dest_y = 0
                        h = h + y
                    else:
                        dest_y = y
                    pixbuf.composite(surface_pixbuf, dest_x, dest_y, w, h, x, y, 1.0, 1.0, gtk.gdk.INTERP_BILINEAR, 255)
                ##if method == 'bind':
                ##    break
            elif method == 'reduce':
                if self.pixbuf.has_key(surface):
                    x, y = args
                    pixbuf = self.get_pixbuf(surface)
                    w = pixbuf.get_width()
                    h = pixbuf.get_height()
                    surface_pixbuf = pix.reduce_pixbuf(surface_pixbuf, pixbuf, x, y)
            elif method == 'insert':
                index = args[0]
                for actor in self.mayuna[self.surface_id]:
                    id = actor.get_id()
                    if id == index:
                        if self.bind.has_key(id) and self.bind[id][1] and \
                           id not in done:
                            done.append(id)
                            sueface_pixbuf = self.compose_surface(surface_pixbuf, actor, done)
                        else:
                            break
            else:
                raise RuntimeError, "should not reach here"
        return surface_pixbuf
    def get_pixbuf(self, id):
        if not self.pixbuf.has_key(id):
            return pix.create_blank_pixbuf(8, 8)
        if self.pixbuf[id][1] != None:
            pixbuf = self.pixbuf[id][1]
        else:
            if len(self.pixbuf[id][0]) == 0:
                pixbuf = pix.create_blank_pixbuf(8, 8)
            else:
                pixbuf = ninix.pix.create_pixbuf_from_file(self.pixbuf[id][0][0])
                for element, x, y in self.pixbuf[id][0][1:]:
                    overlay = ninix.pix.create_pixbuf_from_file(element)
                    w = overlay.get_width()
                    h = overlay.get_height()
                    sw = pixbuf.get_width()
                    sh = pixbuf.get_height()
                    if x + w > sw:
                        w = sw - x
                    if y + h > sh:
                        h = sh - y
                    if x < 0:
                        dest_x = 0
                        w = w + x
                    else:
                        dest_x = x
                    if y < 0:
                        dest_y = 0
                        h = h + y
                    else:
                        dest_y = y
                    overlay.composite(pixbuf, dest_x, dest_y, w, h, x, y, 1.0, 1.0, gtk.gdk.INTERP_BILINEAR, 255)
            self.pixbuf[id][1] = pixbuf
            deleted = 0
            for key in self.pixbuf.keys():
                if key not in [id, '0', '10'] and self.pixbuf[key][2] != None:
                    self.pixbuf[key][2] = self.pixbuf[key][2] - 1
                    if self.pixbuf[key][2] < 0:
                        self.pixbuf[key][1] = None
                        self.pixbuf[id][2] = None 
                        deleted = 1
            if deleted:
                gc.collect() ## FIXME
        self.pixbuf[id][2] = 15
        return pixbuf
    def draw_surface(self):
        pixbuf = self.get_pixbuf(self.surface_id)
        w = pixbuf.get_width()
        h = pixbuf.get_height()
        if self.surface_cache.has_key(self.surface_id):
            surface_pixbuf =  self.surface_cache[self.surface_id].copy()
        else:
            surface_pixbuf = pixbuf.copy()
            if self.mayuna.has_key(self.surface_id):
                done = []
                for actor in self.mayuna[self.surface_id]:
                    id = actor.get_id()
                    if self.bind.has_key(id) and self.bind[id][1] and \
                       id not in done:
                        done.append(id)
                        sueface_pixbuf = self.compose_surface(surface_pixbuf, actor, done)
                self.surface_cache[self.surface_id] = surface_pixbuf
        if self.sakura.surface_scale != 100:
            w = w * self.sakura.surface_scale / 100
            h = h * self.sakura.surface_scale / 100
            surface_pixbuf = surface_pixbuf.scale_simple(w, h, gtk.gdk.INTERP_BILINEAR)
        self.surface_pixmap, self.mask_pixmap = surface_pixbuf.render_pixmap_and_mask(255)
        if self.debug & 4096:
            self.draw_region()
    def draw_region(self):
        gc = self.surface_pixmap.new_gc()
        gc.function = gtk.gdk.INVERT
        for part, x1, y1, x2, y2 in self.collisions:
            if self.sakura.surface_scale != 100:
                x1 = x1 * self.sakura.surface_scale / 100
                x2 = x2 * self.sakura.surface_scale / 100
                y1 = y1 * self.sakura.surface_scale / 100
                y2 = y2 * self.sakura.surface_scale / 100
            self.surface_pixmap.draw_rectangle(gc, 0, x1, y1, x2 - x1, y2 - y1)
    def show_surface(self):
        self.darea.window.set_back_pixmap(self.surface_pixmap, gtk.FALSE)
        self.window.shape_combine_mask(self.mask_pixmap, 0, 0)
        w, h = self.get_surface_size(self.surface_id)
        self.darea.queue_draw_area(0, 0, w, h)
    def reset_overlays(self):
        self.overlays = {}
    def remove_overlay(self, actor):
        try:
            del self.overlays[actor]
        except KeyError:
            pass
    def add_overlay(self, actor, id, x, y):
        if id == "-2":
            self.terminate()
        if id in ["-1", "-2"]:
            self.remove_overlay(actor)
            return
        self.overlays[actor] = (id, x, y)
    def draw_overlays(self):
        ##print "draw_overlays()"
        pixbuf = self.get_pixbuf(self.surface_id)
        w = pixbuf.get_width()
        h = pixbuf.get_height()
        if self.surface_cache.has_key(self.surface_id):
            surface_pixbuf =  self.surface_cache[self.surface_id].copy()
        else:
            surface_pixbuf = pixbuf.copy()
            if self.mayuna.has_key(self.surface_id):
                done = []
                for actor in self.mayuna[self.surface_id]:
                    id = actor.get_id()
                    if self.bind.has_key(id) and self.bind[id][1] and \
                       id not in done:
                        done.append(id)
                        sueface_pixbuf = self.compose_surface(surface_pixbuf, actor, done)
                self.surface_cache[self.surface_id] = surface_pixbuf.copy()
        actors = self.overlays.keys()
        actors.sort(lambda a1, a2: cmp(a1.get_id(), a2.get_id()))
        for actor in actors:
            id, x, y = self.overlays[actor]
            ##print "actor=%d, id=%s, x=%d, y=%d" % (actor.get_id(), id, x, y)
            try:
                pixbuf = self.get_pixbuf(id)
                w = pixbuf.get_width()
                h = pixbuf.get_height()
            except KeyError:
                continue
            # overlay surface pixbuf
            sw = surface_pixbuf.get_width()
            sh = surface_pixbuf.get_height()
            if x + w > sw:
                w = sw - x
            if y + h > sh:
                h = sh - y
            if x < 0:
                dest_x = 0
                w = w + x
            else:
                dest_x = x
            if y < 0:
                dest_y = 0
                h = h + y
            else:
                dest_y = y
            pixbuf.composite(surface_pixbuf, dest_x, dest_y, w, h, x, y, 1.0, 1.0, gtk.gdk.INTERP_BILINEAR, 255)
        if self.sakura.surface_scale != 100:
            w = surface_pixbuf.get_width() * self.sakura.surface_scale / 100
            h = surface_pixbuf.get_height() * self.sakura.surface_scale / 100
            surface_pixbuf = surface_pixbuf.scale_simple(w, h, gtk.gdk.INTERP_BILINEAR)
        self.surface_pixmap, self.mask_pixmap = surface_pixbuf.render_pixmap_and_mask(255)
        if self.debug & 4096:
            self.draw_region()
        self.show_surface()
    def move_surface(self, xoffset, yoffset):
        x, y = self.get_position()
        p, q = self.window_offset
        self.window.move(x + p + xoffset, y + q + yoffset)
    def get_balloon_offset(self):
        path, config = self.surface['surface' + self.surface_id]
        if self.side == 0:
            x = config.get("sakura.balloon.offsetx", None)
            y = config.get("sakura.balloon.offsety", None)
        else:
            x = config.get("kero.balloon.offsetx", None)
            y = config.get("kero.balloon.offsety", None)
        try:
            x = int(x)
        except:
            x = None
        try:
            y = int(y)
        except:
            y = None
        return x, y
    def get_surface(self):
        return self.surface_id
    def get_surface_size(self, id=None):
        if id == None:
            pixbuf = self.get_pixbuf(self.surface_id)
        else:
            pixbuf = self.get_pixbuf(id)
        w = pixbuf.get_width()
        h = pixbuf.get_height()
        if self.sakura.surface_scale != 100:
            w = int(w * self.sakura.surface_scale / 100)
            h = int(h * self.sakura.surface_scale / 100)
        return w, h
    def get_surface_offset(self):
        if getattr(self, 'window_offset', None):
            return self.window_offset
        else:
            return (0, 0)
    def get_touched_region(self, x, y):
        for part, x1, y1, x2, y2 in self.collisions:
            if x1 <= x <= x2 and y1 <= y <= y2:
                ##print part, "touched"
                return part
        return ""
    def set_direction(self, dir):
        self.direction = dir # 0: left, 1: right
    def set_position(self, x, y):
        if getattr(self, 'window_offset', None):
            p, q = self.window_offset
        else:
            p, q = (0, 0)
        self.window.parse_geometry("+%d+%d" % (x + p, y + q))
        self.position = (x, y)
    def get_position(self):
        return self.position
    def set_alignment(self, align):
        if align in [0, 1, 2]:
            self.align = align
    def get_alignment(self):
        return self.align
    def destroy(self):
        self.surface_cache = {}
        for tag in self.callbacks:
            self.darea.disconnect(tag)
        self.window.remove(self.darea)
        self.darea.destroy()
    def show(self):
        if not self.shown:
            self.window.show()
            self.show_surface()
            self.raise_()
            self.shown = 1
    def hide(self):
        if self.shown:
            self.window.hide()
            self.shown = 0
    def raise_(self):
        self.window.window.raise_()
    def lower(self):
        self.window.window.lower()
    def button_press(self, window, event):
        self.sakura.reset_idle_time()
        x = int(event.x)
        y = int(event.y)
        if self.sakura.surface_scale != 100:
            x = int(x * 100 / self.sakura.surface_scale)
            y = int(y * 100 / self.sakura.surface_scale)
        self.x_root = event.x_root
        self.y_root = event.y_root
        if event.type == gtk.gdk.BUTTON_PRESS:
            click = 1
        else:
            click = 2
        self.sakura.notify_surface_click(event.button, click, self.side, x, y)
        return gtk.TRUE
    def button_release(self, window, event):
        if self.dragged:
            self.sakura.notify_surface_drop()
            self.dragged = 0
        self.x_root = None
        self.y_root = None
        return gtk.TRUE
    def motion_notify(self, darea, event):
        if not self.sakura.busy():
            if event.state & gtk.gdk.BUTTON2_MASK:
                if self.x_root is not None and \
                   self.y_root is not None:
                    x_delta = int(event.x_root - self.x_root)
                    y_delta = int(event.y_root - self.y_root)
                    self.dragged = 1
                    self.raise_()
                    self.sakura.notify_surface_drag(self.side, x_delta, y_delta)
                    self.x_root = event.x_root
                    self.y_root = event.y_root
            elif event.state & gtk.gdk.BUTTON1_MASK or \
                 event.state & gtk.gdk.BUTTON3_MASK:
                pass
            else:
                x = int(event.x)
                y = int(event.y)
                if self.sakura.surface_scale != 100:
                    x = int(x * 100 / self.sakura.surface_scale)
                    y = int(y * 100 / self.sakura.surface_scale)
                part = self.get_touched_region(x, y)
                if part:
                    cursor = gtk.gdk.Cursor(gtk.gdk.HAND1)
                    self.darea.window.set_cursor(cursor)
                else:
                    self.darea.window.set_cursor(None)
                self.sakura.notify_surface_mouse_motion(self.side, x, y)
        return gtk.TRUE
    def scroll(self, darea, event):
        x = int(event.x)
        y = int(event.y)
        if self.sakura.surface_scale != 100:
            x = int(x * 100 / self.sakura.surface_scale)
            y = int(y * 100 / self.sakura.surface_scale)
        if event.direction == gtk.gdk.SCROLL_UP:
            direction = 'up'
        elif event.direction == gtk.gdk.SCROLL_DOWN:
            direction = 'down'
        else:
            direction = ''
        self.sakura.notify_surface_mouse_scroll(self.side, x, y, direction)
        return gtk.TRUE
    def get_pointer(self):
        self.darea.window.get_pointer()
    def toggle_bind(self, id):
        if self.bind.has_key(id):
            current = self.bind[id][1]
            self.bind[id][1] = not current
            self.surface_cache = {}
            self.reset_surface()

class Balloon:
    def __init__(self, sakura, debug=0):
        self.sakura = sakura
        self.debug = debug
        self.synchronized = 0
        self.gtk_window = []
        self.font_name = 'Sans 12'
        # read pango_fontrc
        rc = ninix.home.get_pango_fontrc()
        if os.path.exists(rc):
            # read lines except comments
            data = filter(lambda line: line[0] != '#' and string.strip(line), open(rc).readlines())
            if len(data) > 0:
                # use the last line as a font name
                name = data[-1]
                if name:
                    self.font_name = name
        # create windows
        for name in ["sakura", "unyuu"]:
            window = gtk.Window(type=gtk.WINDOW_POPUP)
            window.set_title('balloon.'+name)
            window.set_decorated(gtk.FALSE)
            window.set_resizable(gtk.FALSE)
            ##window.set_skip_pager_hint(gtk.FALSE) # GTK+ 2.2 API
            ##window.set_skip_taskbar_hint(gtk.FALSE) # GTK+ 2.2 API
            window.font_name = self.font_name
            window.connect("delete_event", self.delete)
            window.realize()
            self.gtk_window.append(window)
        self.window = []
        # create communicatebox
        self.communicatebox = CommunicateBox(sakura, debug)
        # create teachbox
        self.teachbox = TeachBox(sakura, debug)
        # create inputbox
        self.inputbox = InputBox(sakura, debug)
    def delete(self, window, event):
        self.sakura.finalize()
        gtk.mainquit()
        return gtk.FALSE
    def new(self, desc, balloon):
        self.desc = desc
        balloon0 = {}
        balloon1 = {}
        communicate0 = None
        communicate1 = None
        communicate2 = None
        communicate3 = None
        for key, value in balloon.items():
            if key in ["arrow0", "arrow1"]:
                balloon0[key] = value
                balloon1[key] = value
            elif key == "sstp":
                balloon0[key] = value  # sstp marker
            elif key[0] == "s":
                balloon0[key] = value  # Sakura
            elif key[0] == "k":
                balloon1[key] = value  # Unyuu
            elif key == "c0":
                communicate0 = value # send box
            elif key == "c1":
                communicate1 = value # communicate box
            elif key == "c2":
                communicate2 = value # teach box
            elif key == "c3":
                communicate3 = value # input box
        # create balloon windows
        for balloon_window in self.window:
            balloon_window.destroy()
        self.window = []
        self.window.append(BalloonWindow(self.gtk_window[0], 0,
                                         self.sakura, desc, balloon0, "s%d",
                                         self.debug))
        self.window.append(BalloonWindow(self.gtk_window[1], 1,
                                         self.sakura, desc, balloon1, "k%d",
                                         self.debug))
        # configure communicatebox
        self.communicatebox.new(desc, communicate1)
        # configure teachbox
        self.teachbox.new(desc, communicate2)
        # configure inputbox
        self.inputbox.new(desc, communicate3)
    def get_balloon_fonts(self):
        return self.font_name
    def set_balloon_fonts(self, font_name):
        if self.font_name == font_name:
            return
        self.font_name = font_name
        for window in self.gtk_window:
            window.font_name = font_name
        for window in self.window:
            window.update_gc()
        path = ninix.home.get_pango_fontrc()
        try:
            os.makedirs(os.path.dirname(path))
        except OSError:
            pass
        try:
            file = open(path, "w")
            file.write("# pango fontrc for ninix\n%s" % font_name)
            file.close()
        except IOError, (code, message):
            sys.stderr.write("cannot write %s\n" % ninix.home.get_pango_fontrc())
        for window in self.window:
            window.redraw()
    def get_balloon_name(self):
        return self.desc.get("name", "")
    def get_balloon_size(self, side):
        return self.window[side].get_balloon_size()
    def reset_balloon(self, side):
        self.window[side].reset_balloon()
    def set_balloon(self, side, num):
        self.window[side].set_balloon(num)
    def set_direction(self, side, dir):
        self.window[side].set_direction(dir)
    def set_position(self, side, x, y):
        self.window[side].set_position(x, y)
    def get_position(self, side):
        return self.window[side].get_position()
    def show(self, side):
        self.window[side].show()
    def hide(self, side):
        self.window[side].hide()
    def raise_(self, side):
        self.window[side].raise_()
    def lower(self, side):
        self.window[side].lower()
    def synchronize(self, value):
        self.synchronized = value
    def clear_text(self, side):
        if self.synchronized:
            self.window[0].clear_text()
            self.window[1].clear_text()
        else:
            self.window[side].clear_text()
    def append_text(self, side, text):
        if self.synchronized:
            self.window[0].append_text(text)
            self.window[1].append_text(text)
        else:
            self.window[side].append_text(text)
    def append_sstp_marker(self, side):
        self.window[side].append_sstp_marker()
    def append_link(self, side, label, value, newline_required=0):
        if self.synchronized:
            self.window[0].append_link(label, value, newline_required)
            self.window[1].append_link(label, value, newline_required)
        else:
            self.window[side].append_link(label, value, newline_required)
    def append_image(self, side, path, x, y):
        self.window[side].append_image(path, x, y)
    def show_sstp_message(self, message, sender):
        self.window[0].show_sstp_message(message, sender)
    def hide_sstp_message(self):
        self.window[0].hide_sstp_message()
    def show_communicatebox(self):
        self.communicatebox.show()
    def show_teachbox(self):
        self.teachbox.show()
    def show_inputbox(self, symbol, limittime, default):
        self.inputbox.show(symbol, limittime, default)

class BalloonWindow:
    def __init__(self, window, side, sakura, desc, balloon, id_format, debug):
        self.window = window
        self.side = side
        self.sakura = sakura
        self.desc = desc
        self.balloon = balloon
        self.balloon_id = None
        self.id_format = id_format
        self.num = 0
        self.debug = debug
        self.shown = 0
        self.sstp_marker = []
        self.sstp_region = None
        self.sstp_message = None
        self.images = []
        self.width = 0
        self.height = 0
        self.busy = 0
        # load files
        self.pixbuf = {}
        for key in balloon.keys():
            path, config = balloon[key]
            pixbuf = pix.create_pixbuf_from_file(path)
            self.pixbuf[key] = (pixbuf, (pixbuf.get_width(), pixbuf.get_height()))
        # create drawing area
        self.darea = gtk.DrawingArea()
        self.darea.show()
        self.darea.set_events(gtk.gdk.EXPOSURE_MASK|
                              gtk.gdk.BUTTON_PRESS_MASK|
                              gtk.gdk.POINTER_MOTION_MASK|
                              gtk.gdk.SCROLL_MASK)
        self.callbacks = []
        for signal, func in [("expose_event",        self.redraw),
                             ("button_press_event",  self.button_press),
                             ("motion_notify_event", self.motion_notify),
                             ("scroll_event",        self.scroll)]:
            self.callbacks.append(self.darea.connect(signal, func))
        self.window.add(self.darea)
        mask_r = desc.getint("maskcolor.r", 128)
        mask_g = desc.getint("maskcolor.g", 128)
        mask_b = desc.getint("maskcolor.b", 128)
        self.cursor_color = "#%02x%02x%02x" % (mask_r, mask_g, mask_b)
        text_r = desc.getint(["font.color.r", "fontcolor.r"], 0)
        text_g = desc.getint(["font.color.g", "fontcolor.g"], 0)
        text_b = desc.getint(["font.color.b", "fontcolor.b"], 0)
        self.text_normal_color = "#%02x%02x%02x" % (text_r, text_g, text_b)
        if desc.getint("maskmethod") == 1:
            text_r = 255 - text_r
            text_g = 255 - text_g
            text_b = 255 - text_b
        self.text_active_color = "#%02x%02x%02x" % (text_r, text_g, text_b)
        # initialize
        self.direction = side
        self.set_position(0, 0)
        self.clear_text()
    def update_gc(self):
        self.busy = 1
        # colors
        cmap = self.darea.get_colormap()
        self.cursor_gc = self.darea.window.new_gc()
        self.cursor_gc.foreground = cmap.alloc_color(self.cursor_color)
        normal_gc = self.darea.window.new_gc()
        normal_gc.foreground = cmap.alloc_color(self.text_normal_color)
        active_gc = self.darea.window.new_gc()
        active_gc.foreground = cmap.alloc_color(self.text_active_color)
        self.text_gc = {}
        self.text_gc[gtk.STATE_NORMAL] = normal_gc
        self.text_gc[gtk.STATE_ACTIVE] = active_gc
        # arrow positions
        self.arrow = []
        w, h = self.pixbuf[self.balloon_id][1]
        x = self.config_adjust("arrow0.x", w, -10)
        y = self.config_adjust("arrow0.y", h,  10)
        self.arrow.append((x, y))
        x = self.config_adjust("arrow1.x", w, -10)
        y = self.config_adjust("arrow1.y", h, -20)
        self.arrow.append((x, y))
        # sstp marker position
        if self.side == 0:
            self.sstp = []
            x = self.config_adjust("sstpmarker.x", w,  30)
            y = self.config_adjust("sstpmarker.y", h, -20)
            self.sstp.append((x, y)) # sstp marker
            x = self.config_adjust("sstpmessage.x", w,  50)
            y = self.config_adjust("sstpmessage.y", h, -20)
            self.sstp.append((x, y)) # sstp message
        # arrow pixmaps and masks
        x, y = self.arrow[0]
        pixbuf = self.pixbuf["arrow0"][0]
        w = int(pixbuf.get_width() * self.sakura.balloon_scale / 100)
        h = int(pixbuf.get_height() * self.sakura.balloon_scale / 100)
        pixmap, mask = pixbuf.scale_simple(w, h, gtk.gdk.INTERP_BILINEAR).render_pixmap_and_mask(255)
        self.arrow0_pixmap = pixmap, mask, (w, h)
        self.arrow0_gc = self.new_mask_gc(mask, x, y)
        x, y = self.arrow[1]
        pixbuf = self.pixbuf["arrow1"][0]
        w = int(pixbuf.get_width() * self.sakura.balloon_scale / 100)
        h = int(pixbuf.get_height() * self.sakura.balloon_scale / 100)
        pixmap, mask = pixbuf.scale_simple(w, h, gtk.gdk.INTERP_BILINEAR).render_pixmap_and_mask(255)
        self.arrow1_pixmap = pixmap, mask, (w, h)
        self.arrow1_gc = self.new_mask_gc(mask, x, y)
        # sstp marker pixmap and mask
        if self.side == 0 and self.pixbuf.has_key("sstp"):
            x, y = self.sstp[0]
            pixbuf = self.pixbuf["sstp"][0]
            w = int(pixbuf.get_width() * self.sakura.balloon_scale / 100)
            h = int(pixbuf.get_height() * self.sakura.balloon_scale / 100)
            pixmap, mask = pixbuf.scale_simple(w, h, gtk.gdk.INTERP_BILINEAR).render_pixmap_and_mask(255)
            self.sstp_pixmap = pixmap, mask, (w, h)
            self.sstp_gc = self.new_mask_gc(mask, x, y)
        # font
        default_size = 12
        size = self.desc.getint(["font.height", "font.size"], default_size)
        self.layout = pango.Layout(self.darea.get_pango_context())
        self.font_desc = pango.FontDescription(self.window.font_name)
        size = size * self.font_desc.get_size() * 3 / 4 / default_size
        self.font_desc.set_size(size * self.sakura.balloon_scale / 100)
        self.layout.set_font_description(self.font_desc)
        self.layout.set_wrap(pango.WRAP_CHAR)
        w, h = self.layout.get_pixel_size()
        self.font_height = h
        self.line_space = 1
        self.layout.set_spacing(self.line_space)
        # font for sstp message
        if self.side == 0:
            default_size = 10
            size = self.desc.getint("sstpmessage.font.height", default_size)
            self.sstp_layout = pango.Layout(self.darea.get_pango_context())
            self.sstp_font_desc = pango.FontDescription(self.window.font_name)
            size = size * self.sstp_font_desc.get_size() * 3 / 4 / default_size
            self.sstp_font_desc.set_size(size * self.sakura.balloon_scale / 100)
            self.sstp_layout.set_font_description(self.sstp_font_desc)
            self.sstp_layout.set_wrap(pango.WRAP_CHAR)
            w, h = self.sstp_layout.get_pixel_size()
            sstp_font_height = h
        else:
            sstp_font_height = 0
        # font metrics
        origin_x = self.config_getint(
            "origin.x",
            self.config_getint("zeropoint.x",
                               self.config_getint("validrect.left", 14)))
        origin_y = self.config_getint(
            "origin.y",
            self.config_getint("zeropoint.y",
                               self.config_getint("validrect.top", 14)))
        wpx = self.config_getint(
            "wordwrappoint.x",
            self.config_getint("validrect.right", -14))
        if wpx > 0:
            line_width = wpx - origin_x
        elif wpx < 0:
            line_width = self.width - origin_x + wpx
        else:
            line_width = self.width - origin_x * 2
        wpy = self.config_getint("validrect.bottom", -14)
        if wpy > 0:
            text_height = min(wpy, self.height) - origin_y
        elif wpy < 0:
            text_height = self.height - origin_y + wpy
        else:
            text_height = self.height - origin_y * 2
        line_height = self.font_height + self.line_space
        self.lines = text_height / line_height
        self.line_regions = []
        y = origin_y
        for i in range(self.lines + 1):
            self.line_regions.append((origin_x, y, line_width, line_height))
            y = y + line_height
        self.line_width = line_width
        # sstp message region
        if self.side == 0:
            x, y = self.sstp[1]
            w = line_width + origin_x - x
            h = sstp_font_height
            self.sstp_region = (x, y, w, h)
        self.busy = 0
    def update_line_regions(self, offset, new_y):
        self.busy = 1
        origin_y = self.config_getint(
            "origin.y",
            self.config_getint("zeropoint.y",
                               self.config_getint("validrect.top", 14)))
        wpy = self.config_getint("validrect.bottom", -14)
        if wpy > 0:
            text_height = min(wpy, self.height) - origin_y
        elif wpy < 0:
            text_height = self.height - origin_y + wpy
        else:
            text_height = self.height - origin_y * 2
        line_height = self.font_height + self.line_space
        origin_x, y, line_width, line_height = self.line_regions[offset]
        self.lines = offset + (text_height - new_y) / line_height
        y = new_y
        for i in range(offset, len(self.line_regions)):
            self.line_regions[i] = (origin_x, y, line_width, line_height)
            y = y + line_height
        for i in range(len(self.line_regions), self.lines+1):
            self.line_regions.append((origin_x, y, line_width, line_height))
            y = y + line_height
        self.busy = 0
    def new_mask_gc(self, mask, x, y):
        mask_gc = self.darea.window.new_gc()
        mask_gc.set_clip_mask(mask)
        mask_gc.set_clip_origin(x, y)
        return mask_gc
    def get_balloon_size(self):
        return (self.width, self.height)
    def reset_balloon(self, reset_position=1):
        self.set_balloon(self.num, reset_position)
    def set_balloon(self, num, reset_position=1):
        self.num = num
        id = self.id_format % (num * 2 + self.direction)
        if not self.pixbuf.has_key(id):
            id = self.id_format % (0 + self.direction)
        self.balloon_id = id
        # change pixmap and window position
        x, y = self.position
        pixbuf, (w, h) = self.pixbuf[id]
        self.width  = int(w * self.sakura.balloon_scale / 100)
        self.height = int(h * self.sakura.balloon_scale / 100)
        self.darea.set_size_request(self.width, self.height)
        pixmap, mask = pixbuf.scale_simple(self.width, self.height, gtk.gdk.INTERP_BILINEAR).render_pixmap_and_mask(255)
        self.window.shape_combine_mask(mask, 0, 0)
        self.darea.window.set_back_pixmap(pixmap, gtk.FALSE)
        if self.shown:
            self.update_gc()
        if reset_position:
            self.sakura.position_balloons()
    def set_direction(self, dir):
        if self.direction != dir:
            self.direction = dir # 0: left, 1: right
            self.reset_balloon(reset_position=0)
    def config_adjust(self, name, base, default_value):
        path, config = self.balloon[self.balloon_id]
        value = config.adjust(name, base)
        if value is None:
            value = self.desc.adjust(name, base)
            if value is None:
                if default_value < 0:
                    value = base + default_value
                else:
                    value = default_value
        return int(value * self.sakura.balloon_scale / 100)
    def config_getint(self, name, default_value):
        path, config = self.balloon[self.balloon_id]
        value = config.getint(name)
        if value is None:
            value = self.desc.getint(name)
            if value is None:
                value = default_value
        return int(value * self.sakura.balloon_scale / 100)
    def set_position(self, x, y):
        self.window.parse_geometry("+%d+%d" % (x, y))
        self.position = (x, y)
    def get_position(self):
        return self.position
    def destroy(self):
        for tag in self.callbacks:
            self.darea.disconnect(tag)
        self.window.remove(self.darea)
        self.darea.destroy()
    def show(self):
        if not self.shown:
            self.window.show()
            # make sure window is in its position
            x, y = self.get_position()
            self.window.move(x, y)
            self.update_gc()
            self.raise_()
            self.shown = 1
    def hide(self):
        if self.shown:
            self.window.hide()
            self.shown = 0
            self.images = []
    def raise_(self):
        if self.shown:
            self.window.window.raise_()
    def lower(self):
        if self.shown:
            self.window.window.lower()
    def show_sstp_message(self, message, sender):
        if self.sstp_region is None:
            self.show()
        self.sstp_message = "%s (%s)" % (message, sender)
        x, y, w, h = self.sstp_region
        layout_set_text(self.sstp_layout, self.sstp_message)
        message_width, message_height = self.sstp_layout.get_pixel_size()
        if message_width > w:
            self.sstp_message = u"... (%s)" % sender
            i = 0
            while 1:
                i = i + 1
                s = "%s... (%s)" % (message[:i], sender)
                layout_set_text(self.sstp_layout, s)
                message_width, message_height = self.sstp_layout.get_pixel_size()
                if message_width > w:
                    break
                self.sstp_message = s
        self.redraw_sstp_message()
    def hide_sstp_message(self):
        self.sstp_message = None
        self.redraw_sstp_message()
    def redraw_sstp_message(self):
        if not self.shown:
            return
        # draw/erase sstp marker
        if self.pixbuf.has_key("sstp"):
            x, y = self.sstp[0]
            w, h = self.sstp_pixmap[2]
            if self.sstp_message:
                pixmap = self.sstp_pixmap[0]
                self.darea.window.draw_drawable(self.sstp_gc, pixmap, 0, 0, x, y, w, h)
            else:
                self.darea.window.clear_area(x, y, w, h)
        # draw/erase sstp message
        x, y, w, h = self.sstp_region
        self.darea.window.clear_area(x, y, w, h)
        ##black_gc = self.darea.get_style().black_gc
        ##self.darea.draw_rectangle(black_gc, 0, x, y, w, h)
        if self.sstp_message is None:
            return
        layout_set_text(self.sstp_layout, self.sstp_message)
        self.darea.window.draw_layout(self.text_gc[gtk.STATE_NORMAL],
                                      x, y, self.sstp_layout)
    def redraw_arrow0(self):
        x, y = self.arrow[0]
        pixmap, mask, (w, h) = self.arrow0_pixmap
        self.darea.window.draw_drawable(self.arrow0_gc, pixmap, 0, 0, x, y, w, h)
    def redraw_arrow1(self):
        x, y = self.arrow[1]
        pixmap, mask, (w, h) = self.arrow1_pixmap
        self.darea.window.draw_drawable(self.arrow1_gc, pixmap, 0, 0, x, y, w, h)
    def redraw(self, darea=None, event=None):
        if not self.shown:
            return gtk.TRUE
        if darea is None:
            darea = self.darea
        self.update_gc()
        darea.window.clear()
        # draw foreground pixmap
        for i in range(len(self.images)):
            pixbuf, (w, h), (x, y) = self.images[i]
            w = int(w * self.sakura.balloon_scale / 100)
            h = int(h * self.sakura.balloon_scale / 100)
            if x == 'centerx':
                bw, bh = self.get_balloon_size()
                x = (bw - w) / 2
            else:
                try:
                    x = int(x)
                except:
                    continue
            if y == 'centery':
                bw, bh = self.get_balloon_size()
                y = (bh - h) / 2
            else:
                try:
                    y = int(y)
                except:
                    continue
            pixmap, mask = pixbuf.scale_simple(w, h, gtk.gdk.INTERP_BILINEAR).render_pixmap_and_mask(255)
            gc = pixmap.new_gc()
            gc.set_clip_mask(mask)
            gc.set_clip_origin(x, y)
            darea.window.draw_drawable(gc, pixmap, 0, 0, x, y, w, h)
        # draw text
        i = self.lineno
        j = len(self.text_buffer)
        line = 0
        while line < self.lines:
            if i >= j:
                break
            x, y, w, h = self.line_regions[line]
            if self.text_buffer[i][-7:] == "\n[half]":
                new_y = int(y + (self.font_height + self.line_space) / 2)
                self.update_line_regions(line+1, new_y)
                layout_set_text(self.layout, self.text_buffer[i][:-7])
                darea.window.draw_layout(self.text_gc[gtk.STATE_NORMAL],
                                         x, y, self.layout)
            else:
                layout_set_text(self.layout, self.text_buffer[i])
                darea.window.draw_layout(self.text_gc[gtk.STATE_NORMAL],
                                         x, y, self.layout)
            for l, c in self.sstp_marker:
                if l == i:
                    pixmap, mask, (mw, mh) = self.sstp_pixmap
                    layout_set_text(self.layout, self.text_buffer[i][:c])
                    text_w, text_h = self.layout.get_pixel_size()
                    mx = x + text_w
                    my = y + (self.font_height + self.line_space) / 2
                    my = my - mh / 2
                    gc = self.new_mask_gc(mask, mx, my)
                    self.darea.window.draw_drawable(gc, pixmap, 0, 0, mx, my, mw, mh)
            i = i + 1
            line = line + 1
        if self.side == 0 and self.sstp_message:
            self.redraw_sstp_message()
        if self.selection is not None:
            self.update_link_region(darea, self.selection)
        if self.lineno > 0:
            self.redraw_arrow0()
        if self.lineno + self.lines < len(self.text_buffer) or \
           self.sakura.script_mode == self.sakura.PAUSE_MODE:
            self.redraw_arrow1()
    def update_link_region(self, darea, index):
        sl = self.link_buffer[index][0]
        el = self.link_buffer[index][2]
        if sl >= self.lineno and sl <= self.lineno + self.lines:
            sn = self.link_buffer[index][1]
            en = self.link_buffer[index][3]
            for n in range(sl, el+1):
                if n - self.lineno >= len(self.line_regions):
                    break
                x, y, w, h = self.line_regions[n - self.lineno]
                if sl == el:
                    layout_set_text(self.layout, self.text_buffer[n][:sn])
                    text_w, text_h =  self.layout.get_pixel_size()
                    x = x + text_w
                    layout_set_text(self.layout, self.text_buffer[n][sn:en])
                    text_w, text_h =  self.layout.get_pixel_size()
                    w = text_w
                    start = sn
                    end = en
                elif n == sl:
                    layout_set_text(self.layout, self.text_buffer[n][:sn])
                    text_w, text_h =  self.layout.get_pixel_size()
                    x = x + text_w
                    layout_set_text(self.layout, self.text_buffer[n][sn:])
                    text_w, text_h =  self.layout.get_pixel_size()
                    w = text_w
                    start = sn
                    end = len(self.text_buffer[n])
                elif n == el:
                    layout_set_text(self.layout, self.text_buffer[n][:en])
                    text_w, text_h =  self.layout.get_pixel_size()
                    w = text_w
                    start = 0
                    end = en
                else:
                    layout_set_text(self.layout, self.text_buffer[n])
                    text_w, text_h =  self.layout.get_pixel_size()
                    w = text_w
                    start = 0
                    end = len(self.text_buffer[n])
                layout_set_text(self.layout, self.text_buffer[n][start:end])
                darea.window.clear_area(x, y, w, h)
                darea.window.draw_rectangle(self.cursor_gc, gtk.TRUE,
                                            x, y, w, h)
                darea.window.draw_layout(self.text_gc[gtk.STATE_ACTIVE],
                                         x, y, self.layout)
    def check_link_region(self, px, py):
        new_selection = None
        for i in range(len(self.link_buffer)):
            sl = self.link_buffer[i][0]
            el = self.link_buffer[i][2]
            if sl >= self.lineno and sl <= self.lineno + self.lines:
                sn = self.link_buffer[i][1]
                en = self.link_buffer[i][3]
                for n in range(sl,el+1):
                    if n - self.lineno >= len(self.line_regions):
                        break
                    x, y, w, h = self.line_regions[n - self.lineno]
                    if n == sl:
                        layout_set_text(self.layout, self.text_buffer[n][:sn])
                        text_w, text_h =  self.layout.get_pixel_size()
                        x = x + text_w
                    if n == sl and n == el:
                        layout_set_text(self.layout, self.text_buffer[n][sn:en])
                    elif n == el:
                        layout_set_text(self.layout, self.text_buffer[n][:en])
                    else:
                        layout_set_text(self.layout, self.text_buffer[n])
                    text_w, text_h =  self.layout.get_pixel_size()
                    w = text_w
                    if x <= px < x+w and y <= py < y+h:
                        new_selection = i
                        break
        if new_selection is not None:
            if self.selection != new_selection:
                sl, sn, el, en, id, raw_text, text = self.link_buffer[new_selection]
                self.sakura.notify_event("OnChoiceEnter", raw_text, id, self.selection)
        else:
            if self.selection != None:
                self.sakura.notify_event("OnChoiceEnter")
        if new_selection == self.selection:
            return 0
        else:
            self.selection = new_selection
            return 1
    def motion_notify(self, darea, event):
        if not self.link_buffer or self.busy:
            return gtk.TRUE
        px = int(event.x)
        py = int(event.y)
        if not self.check_link_region(px, py):
            return gtk.TRUE
        self.redraw()
        if self.side == 0 and self.sstp_message:
            self.redraw_sstp_message()
        if self.lineno > 0:
            self.redraw_arrow0()
        if self.lineno + self.lines < len(self.text_buffer) or \
           self.sakura.script_mode == self.sakura.PAUSE_MODE:
            self.redraw_arrow1()
        return gtk.TRUE
    def scroll(self, darea, event):
        px = int(event.x)
        py = int(event.y)
        if event.direction == gtk.gdk.SCROLL_UP:
            if self.lineno > 0:
                self.lineno = max(self.lineno - 2, 0)
                self.check_link_region(px, py)
                self.redraw()
        elif event.direction == gtk.gdk.SCROLL_DOWN:
            if self.lineno + self.lines < len(self.text_buffer):
                self.lineno = min(self.lineno + 2,
                                  len(self.text_buffer) - self.lines)
                self.check_link_region(px, py)
                self.redraw()
        return gtk.TRUE
    def button_press(self, darea, event):
        self.sakura.reset_idle_time()
        if event.type == gtk.gdk.BUTTON_PRESS:
            click = 1
        else:
            click = 2
        if self.sakura.script_mode == self.sakura.PAUSE_MODE:
            self.sakura.notify_balloon_click(event.button, click, self.side)
            return gtk.TRUE
        # arrows
        px = int(event.x)
        py = int(event.y)
        # up arrow
        w, h = self.arrow0_pixmap[2]
        x, y = self.arrow[0]
        if x <= px <= x+w and y <= py <= y+h:
            if self.lineno > 0:
                self.lineno = max(self.lineno - 2, 0)
                self.redraw()
            return gtk.TRUE
        # down arrow
        w, h = self.arrow1_pixmap[2]
        x, y = self.arrow[1]
        if x <= px <= x+w and y <= py <= y+h:
            if self.lineno + self.lines < len(self.text_buffer):
                self.lineno = min(self.lineno + 2,
                                  len(self.text_buffer) - self.lines)
                self.redraw()
            return gtk.TRUE
        # links
        if self.selection is not None:
            sl, sn, el, en, id, raw_text, text = self.link_buffer[self.selection]
            self.sakura.notify_link_selection(id, raw_text, self.selection)
            return gtk.TRUE
        # balloon's background
        self.sakura.notify_balloon_click(event.button, click, self.side)
        return gtk.TRUE
    def clear_text(self):
        self.selection = None
        self.lineno = 0
        self.text_buffer = []
        self.link_buffer = []
        self.newline_required = 0
        self.images = []
        self.sstp_marker = []
        self.redraw()
    def append_text(self, text):
        if not self.text_buffer or self.newline_required:
            s = ""
            column = 0
            self.newline_required = 0
        else:
            s = self.text_buffer[-1]
            del self.text_buffer[-1]
            column = len(s)
        i = len(s)
        text = s + text
        j = len(text)
        p = 0
        while 1:
            if i >= j:
                self.text_buffer.append(text[p:i])
                self.draw_last_line(column)
                break
            if text[i] == "\n":
                if j >= i+7 and text[i:i+7] == "\n[half]":
                    self.text_buffer.append(text[p:i] + "\n[half]")
                    p = i = i + 7
                else:
                    self.text_buffer.append(text[p:i])
                    p = i = i + 1
                self.draw_last_line(column)
                column = 0
                continue
            n = i + 1
            if not self.shown:
                self.show()
            layout_set_text(self.layout, text[p:n])
            text_width, text_height =  self.layout.get_pixel_size()
            if text_width > self.line_width:
                self.text_buffer.append(text[p:i])
                self.draw_last_line(column)
                column = 0
                p = i
            i = n
    def append_sstp_marker(self):
        if not self.pixbuf.has_key("sstp"):
            return
        if not self.text_buffer:
            line = 0
            offset = 0
        else:
            line = len(self.text_buffer) - 1
            offset = len(self.text_buffer[-1])
        if self.newline_required:
            line = line + 1
            offset = 0
        self.sstp_marker.append((line, offset))
        w, h = self.pixbuf["sstp"][1]
        i = 1
        while 1:
            layout_set_text(self.layout, u' ' * i)
            text_w, text_h = self.layout.get_pixel_size()
            if text_w > w:
                break
            else:
                i = i + 1
        self.append_text(u' ' * i)
        self.draw_last_line(offset)
    def append_link(self, id, text, newline_required=0):
        if not text:
            return
        self.show()
        raw_text = text
        if not self.text_buffer or newline_required:
            offset = ''
            sl = len(self.text_buffer)
            sn = 0
        else:
            offset = self.text_buffer[-1]
            sl = len(self.text_buffer) - 1
            sn = len(self.text_buffer[-1])
        start = i = 0
        line_number = 0
        while 1:
            n = i + 1
            layout_set_text(self.layout, text[start:n]+offset)
            text_w, text_h = self.layout.get_pixel_size()
            if text_w > self.line_width:
                if line_number == 0 and not newline_required and self.text_buffer:
                    self.text_buffer[-1] = self.text_buffer[-1] + text[start:i]
                    self.draw_last_line()
                else:
                    self.text_buffer.append(text[start:i])
                line_number = line_number + 1
                start = i
                offset = ''
            i = n
            if i >= len(text):
                if line_number == 0 and not newline_required and self.text_buffer:
                    self.text_buffer[-1] = self.text_buffer[-1] + text[start:i]
                else:
                    self.text_buffer.append(text[start:i])
                break
        el = sl + line_number
        en = len(self.text_buffer[-1])
        self.link_buffer.append((sl, sn, el, en, id, raw_text, text))
        self.draw_last_line()
        self.newline_required = newline_required
    def append_image(self, path, x, y):
        self.show()
        pixbuf = pix.create_pixbuf_from_file(path)
        w = pixbuf.get_width()
        h = pixbuf.get_height()
        self.images.append((pixbuf, (w, h), (x, y)))
        self.redraw()
    def draw_last_line(self, column=0):
        if not self.shown:
            return
        line = len(self.text_buffer) - 1
        if self.lineno <= line < self.lineno + self.lines:
            x, y, w, h = self.line_regions[line - self.lineno]
            if self.text_buffer[line][-7:] == "\n[half]":
                offset = line - self.lineno + 1
                new_y = int(y + (self.font_height + self.line_space) / 2)
                self.update_line_regions(offset, new_y)
            else:
                self.darea.queue_draw_area(x, y, w, h)
            for l, c in self.sstp_marker:
                if l == line:
                    pixmap, mask, (mw, mh) = self.sstp_pixmap
                    layout_set_text(self.layout, self.text_buffer[l][:c])
                    text_w, text_h = self.layout.get_pixel_size()
                    mx = x + text_w
                    my = y + (self.font_height + self.line_space) / 2
                    my = my - mh / 2
                    gc = self.new_mask_gc(mask, mx, my)
                    self.darea.window.draw_drawable(gc, pixmap, 0, 0, mx, my, mw, mh)
        else:
            self.redraw()
            while line >= self.lineno + self.lines:
                self.lineno = self.lineno + 1
                self.redraw()

class CommunicateWindow:
    NAME = ""
    ENTRY = ""
    def __init__(self, sakura, debug):
        self.sakura = sakura
        self.debug = debug
        self.window = None
        self.dragged = 0
    def new(self, desc, balloon):
        if self.window:
            self.window.destroy()
        self.window = gtk.Window()
        self.window.set_title('communicate')
        self.window.set_decorated(gtk.FALSE)
        self.window.set_resizable(gtk.FALSE)
        self.window.connect("delete_event",         self.delete)
        self.window.connect("key_press_event",      self.key_press)
        self.window.connect("button_press_event",   self.button_press)
        self.window.set_events(gtk.gdk.BUTTON_PRESS_MASK)
        self.window.set_modal(gtk.TRUE)
        self.window.set_position(gtk.WIN_POS_CENTER)
        self.window.realize()
        w = desc.getint("communicatebox.width", 250)
        h = desc.getint("communicatebox.height", -1)
        self.entry = gtk.Entry()
        self.entry.connect("activate", self.activate)
        self.entry.set_size_request(w, h)
        self.entry.show()
        if balloon:
            path, config = balloon
            # load pixmap
            image, mask = pix.create_pixmap_from_file(path)
            gtk_image = gtk.Image()
            gtk_image.set_alignment(0, 0)
            gtk_image.set_padding(0, 0)
            gtk_image.set_from_pixmap(image, mask)
            gtk_image.show()
            x = desc.getint("communicatebox.x", 10)
            y = desc.getint("communicatebox.y", 20)
            fixed = gtk.Fixed()
            fixed.put(gtk_image, 0, 0)
            fixed.put(self.entry, x, y)
            fixed.show()
            self.window.add(fixed)
            self.window.shape_combine_mask(mask, 0, 0)
        else:
            box = gtk.HBox(spacing=10)
            box.set_border_width(10)
            if self.ENTRY:
                label = gtk.Label(self.ENTRY)
                box.pack_start(label, gtk.FALSE)
                label.show()
            box.pack_start(self.entry)
            self.window.add(box)
            box.show()
    def delete(self, widget, event):
        self.window.hide()
        self.cancel()
        return gtk.TRUE
    def key_press(self, widget, event):
        if event.keyval == gtk.keysyms.Escape:
            self.window.hide()
            self.cancel()
            return gtk.TRUE
        return gtk.FALSE
    def button_press(self, widget, event):
        if event.button in [1, 2]:
            self.window.begin_move_drag(event.button, int(event.x_root), int(event.y_root), gtk.get_current_event_time())
        return gtk.TRUE
    def activate(self, widget):
        self.window.hide()
        self.enter()
        return gtk.TRUE
    def show(self, default=""):
        self.entry.set_text(default)
        self.window.show()
    def enter(self):
        pass
    def cancel(self):
        pass

class CommunicateBox(CommunicateWindow):
    NAME = "communicatebox"
    ENTRY = "Communicate"
    def new(self, desc, balloon):
        CommunicateWindow.new(self, desc, balloon)
        self.window.set_modal(gtk.FALSE)
    def delete(self, widget, event):
        self.window.hide()
        self.cancel()
        self.sakura.user_interaction = 0
        return gtk.TRUE
    def key_press(self, widget, event):
        if event.keyval == gtk.keysyms.Escape:
            self.window.hide()
            self.cancel()
            self.sakura.user_interaction = 0
            return gtk.TRUE
        return gtk.FALSE
    def activate(self, widget):
        self.enter()
        self.entry.set_text('')
        return gtk.TRUE
    def enter(self):
        self.send(self.entry.get_text())
    def cancel(self):
        self.send(None)
    def send(self, data):
        if data:
            data = unicode(data, 'utf-8')
        self.sakura.notify_user_communicate(data)

class TeachBox(CommunicateWindow):
    NAME = "teachbox"
    ENTRY = "Teach"
    def enter(self):
        self.send(self.entry.get_text())
    def cancel(self):
        self.send(None)
    def send(self, data):
        if data:
            data = unicode(data, 'utf-8')
        self.sakura.notify_user_teach(data)

class InputBox(CommunicateWindow):
    NAME = "inputbox"
    ENTRY = "Input"
    def show(self, symbol, limittime, default):
        self.symbol = symbol
        if default is not None:
            try:
                text = unicode(default).encode('utf-8')
            except:
                text = ""
        else:
            text = ""
        try:
            limittime = int(limittime)
        except ValueError:
            limittime = -1
        if int(limittime) < 0:
            self.timeout_id = None
        else:
            self.timeout_id = gtk.timeout_add(limittime, self.timeout)
        CommunicateWindow.show(self, text)
    def timeout(self):
        self.window.hide()
        self.send("timeout")
    def enter(self):
        self.send(self.entry.get_text())
    def cancel(self):
        self.send(None)
    def send(self, data):
        if self.timeout_id is not None:
            gtk.timeout_remove(self.timeout_id)
        if data:
            data = unicode(data, 'utf-8')
        self.sakura.notify_user_input(self.symbol, data)

def test():
    pass

if __name__ == "__main__":
    test()
