# Tamito KAJIYAMA <6 October 2001>
# $Id: httplib.py,v 1.1.1.1 2003/04/11 05:54:31 shy Exp $

import errno
import mimetools
import socket
import select
import string
import StringIO
import sys
import time
import urllib
import urlparse

import ninix.main
import ninix.netlib

class HTTP:
    def __init__(self, host, port=80):
        self.sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        self.sock.setblocking(0)
        self.resolver = ninix.netlib.Resolver()
        self.host = host
        self.port = port
        self.proxy = self.get_proxy()
        self.addr = None
        self.data = ""
        self.response = ""
    def get_proxy(self):
        proxy = urllib.getproxies().get("http")
        if not proxy:
            return None
        url = urlparse.urlparse(proxy)
        if url[0] != "http":
            sys.stderr.write("invalid http_proxy (ignored)\n")
            return None
        pos = string.find(url[1], ":")
        if pos < 0:
            host = url[1]
            port = 80
        else:
            host = url[1][:pos]
            try:
                port = int(url[1][pos+1:])
            except ValueError:
                sys.stderr.write("invalid http_proxy (ignored)\n")
                return None
        return (host, port)
    def lookup(self):
        if self.proxy is None:
            host, port = self.host, self.port
        else:
            host, port = self.proxy
        data = self.resolver.lookup(host)
        if data is None:
            return 1
        elif data < 0:
            return -1
        self.addr = (data, port)
        return 0
    def connect(self):
        try:
            code = self.sock.connect_ex(self.addr)
        except socket.error:
            return -1
        if code == 0:
            return 0
        elif code == errno.EISCONN:
            return 0
        elif code == errno.EINPROGRESS:
            return 1
        elif code == errno.EALREADY:
            return 1
        return -1
    def send(self, data, flag=0):
        r, w, e = select.select([], [self.sock], [], 0)
        if not w:
            return None
        try:
            return self.sock.send(data, flag)
        except socket.error:
            return -1
    def recv(self, hint, flag=0):
        if self.data:
            if len(self.data) > hint:
                data, self.data = self.data[:hint], self.data[hint:]
            else:
                data, self.data = self.data, ""
            return data
        r, w, e = select.select([self.sock], [], [], 0)
        if not r:
            return None
        try:
            return self.sock.recv(hint, flag)
        except socket.error:
            return -1
    def put_request(self, request, locator):
        if self.port == 80:
            host = self.host
        else:
            host = self.host + ":" + str(self.port)
        if self.proxy is None:
            url = locator
        else:
            url = "http://" + host + locator
        self.request = [
            "%s %s HTTP/1.0\r\n" % (request, url),
            "Host: %s\r\n" % host,
            "User-Agent: ninix/%s\r\n" % ninix.main.VERSION,
            "Accept: */*\r\n",
            "\r\n"]
    def send_request(self):
        data = self.request[0]
        code = self.send(data)
        if code is None:
            return 1
        elif code < 0:
            return -1
        elif code < len(data):
            self.request[0] = data[code:]
        else:
            del self.request[0]
            if not self.request:
                return 0
        return 1
    def wait_response(self):
        data = self.recv(1024)
        if data is None:
            return 1
        if data < 0:
            return -1
        self.response = self.response + data
        header_end = string.find(self.response, "\r\n\r\n")
        if header_end < 0:
            return 1
        status_end = string.find(self.response, "\r\n")
        status = self.response[:status_end]
        header = self.response[status_end+2:header_end+4]
        self.data = self.response[header_end+4:]
        try:
            version, code, self.message = string.split(status, None, 2)
        except ValueError:
            return -1
        if version not in ["HTTP/1.0", "HTTP/1.1"]:
            return -1
        try:
            self.code = int(code)
        except ValueError:
            return -1
        self.headers = mimetools.Message(StringIO.StringIO(header))
        return 0
    def get_reply(self):
        return self.code, self.message, self.headers
    def close(self):
        try:
            self.sock.close()
        except socket.error:
            return -1
        return 0

def test():
    import sys
    import string
    import time
    if len(sys.argv) != 3:
        sys.stderr.write("Usage: httplib.py host[:port] locator\n")
        sys.exit(1)
    try:
        host, port = string.split(sys.argv[1], ":")
    except ValueError:
        host = sys.argv[1]
        port = 80
    http = HTTP(host, int(port))
    while 1:
        code = http.lookup()
        if code == 0:
            break
        if code < 0:
            sys.stderr.write("lookup failed\n")
            sys.exit(1)
        time.sleep(0.1)
    sys.stderr.write("resolved\n")
    while 1:
        code = http.connect()
        if code == 0:
            break
        if code < 0:
            sys.stderr.write("connection failed\n")
            sys.exit(1)
        time.sleep(0.1)
    sys.stderr.write("connected\n")
    http.put_request("GET", sys.argv[2])
    while 1:
        code = http.send_request()
        if code == 0:
            break
        if code < 0:
            sys.stderr.write("request failed\n")
            sys.exit(1)
        time.sleep(0.1)
    sys.stderr.write("request sent\n")
    while 1:
        code = http.wait_response()
        if code == 0:
            break
        if code < 0:
            sys.stderr.write("request failed\n")
            sys.exit(1)
        time.sleep(0.1)
    code, message, headers = http.get_reply()
    sys.stderr.write("%d %s\n" % (code, message))
    if code != 200:
        sys.stderr.write("%s\n" % str(headers))
        sys.exit(1)
    size = headers.get("content-length", None)
    if size is not None:
        size = int(size)
        nbytes = 0
    while 1:
        data = http.recv(1024)
        if data is None:
            continue
        if data < 0:
            sys.stderr.write("retrieval failed\n")
            sys.exit(1)
        sys.stdout.write(data)
        if size is None:
            if not data:
                break
        else:
            nbytes = nbytes + len(data)
            if nbytes == size:
                break
    http.close()

if __name__ == "__main__":
    test()
