#
#  textcopy.py - a TEXTCOPY compatible Saori module for ninix
#  Copyright (C) 2002, 2003 by Shyouzou Sugitani <shy@debian.or.jp>
#  Copyright (C) 2002, 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
#  $Id: textcopy.py,v 1.4 2003/07/21 11:43:52 shy Exp $
#

import os
import string
import StringIO
import codecs

if os.environ.has_key('DISPLAY'):
    import gtk
else:
    gtk = None

class Saori:
    def __init__(self):
	self.loaded = 0
        self.window = None
        self.entry = None
    def load(self, dir=os.curdir):
        self.dir = dir
        result = 0
        if self.loaded:
	    result = 2
        elif gtk != None:
            self.window = gtk.Window()
            self.entry = gtk.Entry()
            self.window.add(self.entry)
            self.entry.realize()
            self.loaded = 1
            result = 1
	return result
    def unload(self):
        self.entry = None
        self.window = None
        self.loaded = 0
        return 1
    def request(self, req):
        type, argument, charset = self.evaluate_request(req)
        if not type:
            return 'SAORI/1.0 400 Bad Request\r\n\r\n'
        elif type == 'GET Version':
            return 'SAORI/1.0 204 No Content\r\n\r\n'
        elif type == 'EXECUTE':
            if len(argument) == 0 or self.entry == None:
                return 'SAORI/1.0 400 Bad Request\r\n\r\n'
            text = unicode(argument[0], charset, 'replace').encode('utf-8')
            self.entry.set_text(text)
            self.entry.select_region(0, len(text))
            if len(argument) >= 2 and argument[1] != 0:
                return 'SAORI/1.0 200 OK\r\nResult: %s\r\n\r\n' % argument[0]
            else:
                return 'SAORI/1.0 204 No Content\r\n\r\n'
    def evaluate_request(self, req):
        type = None
        argument = []
        charset = 'Shift_JIS' # default
        header = StringIO.StringIO(req)
        line = header.readline()
        if not line:
            return type, argument
        if line[-1] == '\n':
            line = line[:-1]
        line = string.strip(line)
        if not line:
            return type, argument
        for request in ['EXECUTE', 'GET Version']:
            if line[:len(request)] == request:
                type = request
                break
        while 1:
            line = header.readline()
            if not line:
                break # EOF
            if line[-1] == '\n':
                line = line[:-1]
            line = string.strip(line)
            if not line:
                continue
            colon = string.find(line, ':')
            if colon >= 0:
                key = string.strip(line[:colon])
                value = string.strip(line[colon+1:])
                if key == 'Charset':
                    charset = value
                    try:
                        codecs.lookup(charset)
                    except:
                        sys.stderr.write("Unsupported charset %s" % repr(charset))
                if key[:8] == 'Argument':
                    argument.append(value)
                else:
                    continue
        return type, argument, charset
